/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.network.CircuitExternalMapNode;
import cerent.cms.ui.network.CircuitMapLinkCookie;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import com.cisco.ctc.util.map.DetailedMapLinkStyle;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Image;
import java.util.List;

public class CircuitMapLink
extends NetMapLink {
    private static final SDebug db = new SDebug("CircuitMapLink");
    private static TDMTerminology tdmTerm;
    private INetLinkSpan netLinkSpan;
    private INetCircuitSpan netCircuitSpan;
    private INetLink netLink;
    private INetCircuit netCircuit;
    private List preExistingCktEndsList;
    public static final int HEADING_TO_NEITHER = -1;
    public static final int HEADING_TO_SOURCE = 0;
    public static final int HEADING_TO_TARGET = 1;
    private static int heading;
    protected static final String ANNOTATION_TYPE = "1";
    protected static final String ANNOTATION_PROT = "2";
    private int srcUpsrSpanState = 3;
    private int dstUpsrSpanState = 3;
    public static final int NEITHER = 0;
    public static final int TRANSMIT_ONLY = 1;
    public static final int EXPECT_ONLY = 2;
    public static final int BOTH = 3;

    public CircuitMapLink(MapToolkit mapToolkit, MapNode mapNode, MapNode mapNode2, String string) {
        super(mapToolkit, mapNode, mapNode2, string);
    }

    public synchronized void init(Object object, Object object2) {
        super.init(object, object2);
        if (this.getUserObject() instanceof INetLink) {
            this.netLink = (INetLink)this.getUserObject();
            if (this.netLink.isLOTunnel()) {
                this.addAnnotation(ANNOTATION_TYPE, CircuitMapUtil.TUNNEL_TERM);
            } else if (this.netLink.isLAP()) {
                this.addAnnotation(ANNOTATION_TYPE, CircuitMapUtil.LAP_TERM);
            } else if (this.netLink instanceof CompositeNetLink) {
                this.addAnnotation(ANNOTATION_TYPE, "WDM");
            } else if (this.netLink instanceof OchTrailTunnelNetLink) {
                this.addAnnotation(ANNOTATION_TYPE, "OCHTRAIL");
            }
            if (this.netLink.isPca()) {
                this.addAnnotation(ANNOTATION_PROT, "PCA");
            }
        }
        if (this.getUserCookie() instanceof CircuitMapLinkCookie) {
            CircuitMapLinkCookie circuitMapLinkCookie = (CircuitMapLinkCookie)this.getUserCookie();
            this.netCircuit = circuitMapLinkCookie.getCircuit();
            this.netLinkSpan = circuitMapLinkCookie.getLinkSpan();
            this.netCircuitSpan = circuitMapLinkCookie.getCircuitSpan();
            this.preExistingCktEndsList = circuitMapLinkCookie.getPreExistingCircuitEndsList();
        }
    }

    public INetLink getNetLink() {
        return this.netLink;
    }

    public INetLinkSpan getNetLinkSpan() {
        return this.netLinkSpan;
    }

    public INetCircuitSpan getNetCircuitSpan() {
        return this.netCircuitSpan;
    }

    public INetCircuit getNetCircuit() {
        return this.netCircuit;
    }

    public List getPreExistingCircuitEndsList() {
        return this.preExistingCktEndsList;
    }

    public void setSourcePort(MapPort mapPort) {
        String string;
        super.setSourcePort(mapPort);
        if (mapPort != null && mapPort instanceof CircuitMapPort && (string = mapPort.getInfoString()) != null && string.length() > 0) {
            this.setSrcLabel(string);
        }
    }

    public void setTargetPort(MapPort mapPort) {
        String string;
        super.setTargetPort(mapPort);
        if (mapPort != null && mapPort instanceof CircuitMapPort && (string = mapPort.getInfoString()) != null && string.length() > 0) {
            this.setTargetLabel(string);
        }
    }

    public String getToolTipText() {
        return super.getToolTipText();
    }

    public static INetLink findReverseLink(INetLink iNetLink) {
        return Network.instance().findReverseLink(iNetLink);
    }

    public int getTransmitExpect(MapPort mapPort) {
        MapNode mapNode;
        if (this.getSourcePort() != null && this.getSourcePort() == mapPort) {
            mapNode = this.getTargetNode();
        } else if (this.getTargetPort() != null && this.getTargetPort() == mapPort) {
            mapNode = this.getSourceNode();
        } else {
            db.println("Transmit/Expect Problem:");
            db.println("\tPort=" + mapPort);
            db.println("\tSource Port=" + this.getSourcePort());
            db.println("\tTarget Port=" + this.getTargetPort());
            return 0;
        }
        if (mapNode == null) {
            return 0;
        }
        int n = 2;
        boolean bl = false;
        boolean bl2 = false;
        if (mapNode instanceof CircuitExternalMapNode) {
            CircuitExternalMapNode circuitExternalMapNode = (CircuitExternalMapNode)mapNode;
            bl = circuitExternalMapNode.isExternalSource();
            bl2 = circuitExternalMapNode.isExternalDest();
        }
        if ((bl || bl2) && this.isBiDirectionalExternal()) {
            n = 3;
        } else if (bl) {
            for (int i = 0; i < this.styleList.size(); ++i) {
                DetailedMapLinkStyle detailedMapLinkStyle = (DetailedMapLinkStyle)this.styleList.get(i);
                if (detailedMapLinkStyle.getDirection() == 3) continue;
                n = 1;
            }
        }
        return n;
    }

    public void setStateUsingUpsrSpanState(int n, int n2, boolean bl) {
        this.srcUpsrSpanState = n;
        this.dstUpsrSpanState = n2;
        int n3 = 1;
        DetailedMapLinkStyle detailedMapLinkStyle = new DetailedMapLinkStyle();
        DetailedMapLinkStyle detailedMapLinkStyle2 = new DetailedMapLinkStyle();
        if (n == 0) {
            detailedMapLinkStyle.setColor(NetMapLink.LINK_ACTIVE_COLOR);
            detailedMapLinkStyle.setDirection(2);
            if (n2 == 0) {
                n3 = 1;
                detailedMapLinkStyle.setDirection(3);
            } else if (n2 == 1) {
                n3 = 2;
                detailedMapLinkStyle.setDirection(2);
                detailedMapLinkStyle2.setDirection(1);
                detailedMapLinkStyle2.setColor(NetMapLink.LINK_STANDBY_COLOR);
            } else if (n2 == 2) {
                n3 = 2;
                detailedMapLinkStyle.setDirection(3);
                detailedMapLinkStyle2.setDirection(1);
                detailedMapLinkStyle2.setColor(NetMapLink.LINK_STANDBY_COLOR);
            }
        } else if (n == 1) {
            detailedMapLinkStyle.setColor(NetMapLink.LINK_STANDBY_COLOR);
            detailedMapLinkStyle.setDirection(2);
            if (n2 == 0) {
                n3 = 2;
                detailedMapLinkStyle.setDirection(2);
                detailedMapLinkStyle2.setDirection(1);
                detailedMapLinkStyle2.setColor(NetMapLink.LINK_ACTIVE_COLOR);
            } else if (n2 == 1) {
                n3 = 1;
                detailedMapLinkStyle.setDirection(3);
            } else if (n2 == 2) {
                n3 = 2;
                detailedMapLinkStyle.setDirection(3);
                detailedMapLinkStyle2.setDirection(1);
                detailedMapLinkStyle2.setColor(NetMapLink.LINK_ACTIVE_COLOR);
            }
        } else if (n == 2) {
            n3 = 2;
            detailedMapLinkStyle.setColor(NetMapLink.LINK_ACTIVE_COLOR);
            detailedMapLinkStyle2.setColor(NetMapLink.LINK_STANDBY_COLOR);
            detailedMapLinkStyle.setDirection(2);
            detailedMapLinkStyle2.setDirection(2);
            if (n2 == 0) {
                detailedMapLinkStyle.setDirection(3);
                detailedMapLinkStyle2.setDirection(2);
            } else if (n2 == 1) {
                detailedMapLinkStyle.setDirection(2);
                detailedMapLinkStyle2.setDirection(3);
            } else if (n2 == 2) {
                detailedMapLinkStyle.setDirection(3);
                detailedMapLinkStyle2.setDirection(3);
            }
        } else if (n2 == 0) {
            n3 = 1;
            detailedMapLinkStyle.setColor(NetMapLink.LINK_ACTIVE_COLOR);
            detailedMapLinkStyle.setDirection(1);
        } else if (n2 == 1) {
            n3 = 1;
            detailedMapLinkStyle.setColor(NetMapLink.LINK_STANDBY_COLOR);
            detailedMapLinkStyle.setDirection(1);
        } else if (n2 == 2) {
            n3 = 2;
            detailedMapLinkStyle.setColor(NetMapLink.LINK_ACTIVE_COLOR);
            detailedMapLinkStyle.setDirection(1);
            detailedMapLinkStyle2.setColor(NetMapLink.LINK_STANDBY_COLOR);
            detailedMapLinkStyle2.setDirection(1);
        }
        if (bl) {
            detailedMapLinkStyle.setColor(NetMapLink.LINK_ROLL_COLOR);
            detailedMapLinkStyle2.setColor(NetMapLink.LINK_ROLL_COLOR);
        }
        this.clearStyles();
        this.addStyle(detailedMapLinkStyle);
        if (n3 > 1) {
            this.addStyle(detailedMapLinkStyle2);
        }
    }

    public int getSrcUpsrSpanState() {
        return this.srcUpsrSpanState;
    }

    public int getDstUpsrSpanState() {
        return this.dstUpsrSpanState;
    }

    protected Image getLinkIcon(String string) {
        if (this.mtk.isDetailed()) {
            return null;
        }
        return super.getLinkIcon(string);
    }

    public void setSrcArrow() {
        heading = 0;
        super.setSrcArrow();
    }

    public void setTargetArrow() {
        heading = 1;
        super.setTargetArrow();
    }

    public int getLastHeading() {
        return heading;
    }

    static {
        heading = -1;
    }
}

