/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.CircuitEnd;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.circuits.AbstractProtectedCircuitMapNode;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.InternalPGFactory;
import cerent.cms.ui.network.CircuitExternalMapLink;
import cerent.cms.ui.network.CircuitExternalMapLinkCookie;
import cerent.cms.ui.network.CircuitMapLine;
import cerent.cms.ui.network.CircuitMapLink;
import cerent.cms.ui.network.CircuitMapLinkCookie;
import cerent.cms.ui.network.CircuitMapNodeCookie;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.cms.ui.network.CircuitMapPortCookie;
import cerent.cms.ui.network.CircuitMapSelector;
import cerent.cms.ui.network.NetMapLink;
import cerent.cms.ui.network.NetMapNode;
import cerent.util.HoLoNum;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.AbstractInternalPG;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.IMapLineEndpoint;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLine;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapSelector;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircuitMapNode
extends NetMapNode {
    private static final SDebug db = new SDebug("CircuitMapNode");
    private ICircuitType circuitType;
    private INetCircuit netCircuit;
    private List otsMapPortList = new ArrayList();

    public CircuitMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    @Override
    public void init(Object object, double d, double d2, Object object2) {
        super.init(object, d, d2, object2);
        if (object2 instanceof CircuitMapNodeCookie) {
            CircuitMapNodeCookie circuitMapNodeCookie = (CircuitMapNodeCookie)object2;
            this.setNetCircuit(circuitMapNodeCookie.getCircuit());
        }
    }

    public int getType() {
        Object object = this.getUserCookie();
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public void setCircuitType(ICircuitType iCircuitType) {
        this.circuitType = iCircuitType;
    }

    private boolean isEthernetCircuitType() {
        return this.circuitType != null ? this.circuitType.isEthernetCircuitType() : false;
    }

    private boolean isTunnelCircuitType() {
        return this.circuitType != null ? this.circuitType.isTunnelCircuitType() : false;
    }

    public INetCircuit getNetCircuit() {
        return this.netCircuit;
    }

    private void setNetCircuit(INetCircuit iNetCircuit) {
        this.netCircuit = iNetCircuit;
    }

    public INetCircuitNode getNetCircuitNode() {
        if (this.netCircuit == null) {
            if (db.on()) {
                db.println("can't get a netcircuitnode; " + this + " did not have a set INetCircuit.");
            }
            return null;
        }
        Object object = this.getUserObject();
        if (!(object instanceof INodeModel)) {
            if (db.on()) {
                db.println("can't get a netcircuitnode; " + this + " did not have a set INodeModel.");
            }
            return null;
        }
        INodeModel iNodeModel = (INodeModel)object;
        INetElement iNetElement = Network.instance().findNetElem(iNodeModel.getNodeId());
        INetCircuitNode iNetCircuitNode = null;
        List list = this.netCircuit.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            if (list.size() > 1) {
                if (db.on()) {
                    db.println("Error !! MXPN in UPSR selector NE");
                }
            } else {
                iNetCircuitNode = (INetCircuitNode)list.get(0);
            }
        }
        return iNetCircuitNode;
    }

    @Override
    protected void drawDetailed(Graphics2D graphics2D, MapTransformer mapTransformer) {
        super.drawDetailed(graphics2D, mapTransformer);
        char c = ' ';
        if (this.isEthernetCircuitType()) {
            c = 'E';
        } else if (this.isTunnelCircuitType()) {
            c = 'T';
        }
        if (c != ' ') {
            Color color = graphics2D.getColor();
            Rectangle2D rectangle2D = this.getBounds(mapTransformer);
            double d = rectangle2D.getWidth();
            double d2 = rectangle2D.getHeight();
            int n = (int)(rectangle2D.getX() + 0.4 * d);
            int n2 = (int)(rectangle2D.getY() + 0.4 * d2);
            int n3 = (int)(0.2 * d);
            int n4 = (int)(0.2 * d2);
            graphics2D.setColor(NetMapNode.OK_COLOR);
            graphics2D.fillOval(n, n2, n3, n4);
            graphics2D.setColor(Color.black);
            graphics2D.drawOval(n, n2, n3, n4);
            MapGraphicsUtil.drawLetter(graphics2D, n, n2, n3, n4, c, false);
            graphics2D.setColor(color);
        }
    }

    protected void receivedAlarmUpdate() {
        MapPort[] mapPortArray = this.getPorts();
        for (int i = 0; i < mapPortArray.length; ++i) {
            CircuitMapPort circuitMapPort = (CircuitMapPort)mapPortArray[i];
            if (!circuitMapPort.supportsHoModel() && !circuitMapPort.supportsLoModel() && !circuitMapPort.supportsOptModel()) continue;
            circuitMapPort.updateColor();
        }
        this.mtk.updateView();
    }

    @Override
    public String getToolTipText() {
        String string = super.getToolTipText();
        if (this.isEthernetCircuitType()) {
            string = string + " (Ether Bridge)";
        } else if (this.isTunnelCircuitType()) {
            string = string + " (Tunnel)";
        }
        return string;
    }

    @Override
    protected MapPort createMapPort(DetailedMapNode detailedMapNode, MapLink mapLink, MapLinkConnector mapLinkConnector) {
        Object object;
        Object object2;
        ActionListener actionListener;
        INetCircuitEnd iNetCircuitEnd = null;
        INetCircuit iNetCircuit = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (mapLink != null && mapLink instanceof CircuitMapLink) {
            try {
                int n;
                Object object3;
                INetLink iNetLink;
                List list;
                actionListener = (CircuitMapLink)mapLink;
                object2 = (CircuitMapLinkCookie)((Link)actionListener).getUserCookie();
                object = ((CircuitMapLinkCookie)object2).getCircuitSpan().getLink();
                iNetCircuit = ((CircuitMapLink)actionListener).getNetCircuit();
                if (db.on()) {
                    db.println("Attaching LINK " + actionListener + " to NODE " + this);
                }
                if ((list = ((CircuitMapLink)actionListener).getPreExistingCircuitEndsList()) != null) {
                    for (int i = 0; iNetCircuitEnd == null && i < list.size(); ++i) {
                        iNetLink = list.get(i);
                        if (!(iNetLink instanceof NetCircuitEnd) || ((NetCircuitEnd)(object3 = (NetCircuitEnd)((Object)iNetLink))).getNodeModel() != this.getUserObject()) continue;
                        n = 0;
                        if (object.getSrc().getNodeModel().equals(this.getUserObject())) {
                            n = object.getSrcEntityIndex() == ((NetCircuitEnd)object3).getEntityIndex() ? 1 : 0;
                        } else {
                            int n2 = n = object.getDstEntityIndex() == ((NetCircuitEnd)object3).getEntityIndex() ? 1 : 0;
                        }
                        if (n == 0) continue;
                        iNetCircuitEnd = new NetCircuitEnd((INetCircuitEnd)object3);
                        if (!db.on()) continue;
                        db.println("\tusing preexisting circuit end: " + iNetCircuitEnd);
                    }
                }
                if (iNetCircuitEnd == null) {
                    INetCircuitSpan iNetCircuitSpan = ((CircuitMapLink)actionListener).getNetCircuitSpan();
                    iNetLink = iNetCircuitSpan.getLink();
                    object3 = iNetLink.getLinkModel();
                    n = this.getNodeRoleInNetLink(iNetLink);
                    if (n == 1) {
                        iNetCircuitEnd = CircuitMapUtil.getCircuitEnd(object3.src(), iNetLink.getSrcEntityIndex(), iNetCircuitSpan.getSrcHoNum(), iNetCircuitSpan.getLoNum());
                        bl4 = true;
                    } else if (n == 2) {
                        iNetCircuitEnd = CircuitMapUtil.getCircuitEnd(object3.dst(), iNetLink.getDstEntityIndex(), iNetCircuitSpan.getDstHoNum(), iNetCircuitSpan.getLoNum());
                    } else {
                        db.println("could not find role of " + this.getUserObject() + " in the INetLink " + iNetLink);
                    }
                    bl2 = iNetCircuitSpan.isSrcFabricated();
                    bl3 = iNetCircuitSpan.isDstFabricated();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                exception.printStackTrace();
            }
        } else if (mapLink != null && mapLink instanceof CircuitExternalMapLink) {
            actionListener = (CircuitExternalMapLink)mapLink;
            iNetCircuit = ((CircuitExternalMapLink)actionListener).getCircuit();
            iNetCircuitEnd = ((CircuitExternalMapLink)actionListener).getCircuitEnd();
        } else {
            bl = false;
        }
        actionListener = this.doCreateCircuitMapPort(detailedMapNode, mapLinkConnector, iNetCircuitEnd);
        if (bl) {
            object2 = "";
            if (iNetCircuitEnd != null && iNetCircuitEnd.getEntityIndex() != 0) {
                object2 = bl2 && bl4 ? CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd, null, false, !bl2) : (bl3 && !bl4 ? CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd, null, false, !bl3) : CircuitMapUtil.getSpanLabel(iNetCircuitEnd));
                if (db.isFineEnabled()) {
                    db.println("createMapPort(): creating src = " + bl4 + ", dstFab = " + bl3 + ", srcFab = " + bl2 + ", label = " + (String)object2);
                }
            }
            object = new CircuitMapPortCookie(iNetCircuit, (String)object2);
            ((CircuitMapPort)actionListener).init(iNetCircuitEnd, object);
        }
        return actionListener;
    }

    protected CircuitMapPort doCreateCircuitMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector, INetCircuitEnd iNetCircuitEnd) {
        return new CircuitMapPort(detailedMapNode, mapLinkConnector);
    }

    @Override
    protected MapLine createMapLine(DetailedMapNode detailedMapNode, IMapLineEndpoint iMapLineEndpoint, IMapLineEndpoint iMapLineEndpoint2) {
        return new CircuitMapLine(detailedMapNode, iMapLineEndpoint, iMapLineEndpoint2);
    }

    @Override
    protected MapSelector createMapSelector(DetailedMapNode detailedMapNode) {
        int n = 0;
        MapSelector[] mapSelectorArray = this.getSelectors();
        if (mapSelectorArray != null) {
            n = mapSelectorArray.length;
        }
        CircuitMapSelector circuitMapSelector = new CircuitMapSelector(detailedMapNode);
        circuitMapSelector.init(new Integer(n), null);
        return circuitMapSelector;
    }

    @Override
    protected AbstractInternalPG createInternalPG(Object object) {
        return InternalPGFactory.instance().createInternalPG(this, object);
    }

    @Override
    public final MapPort addPort(MapLink mapLink, MapLinkConnector mapLinkConnector) {
        MapPort mapPort = null;
        if (mapLink != null) {
            mapPort = this.getMapPortForLink(mapLink);
        }
        if (mapPort == null) {
            mapPort = super.addPort(mapLink, mapLinkConnector);
        } else {
            mapPort.addConnector(mapLinkConnector);
        }
        return mapPort;
    }

    private MapPort getMapPortForLink(MapLink mapLink) {
        Object object;
        if (db.on()) {
            db.println("Called getMapPortForLink() on node " + this.getName() + "- link is: " + mapLink);
        }
        if ((object = mapLink.getUserCookie()) != null && (object instanceof CircuitMapLinkCookie || object instanceof CircuitExternalMapLinkCookie)) {
            ICircuitEnd iCircuitEnd = this.getCircuitEnd(mapLink);
            MapPort mapPort = null;
            MapPort[] mapPortArray = this.getPorts();
            for (int i = 0; mapPort == null && i < mapPortArray.length; ++i) {
                MapPort mapPort2 = mapPortArray[i];
                ICircuitEnd iCircuitEnd2 = this.getCircuitEnd(mapPort2);
                if (!this.areEquals(iCircuitEnd, iCircuitEnd2)) continue;
                mapPort = mapPort2;
            }
            if (db.on()) {
                db.println("getMapPortForLink: port = " + mapPort);
            }
            return mapPort;
        }
        return null;
    }

    public int getEntityIndex(MapPort mapPort) {
        int n = -1;
        Object object = mapPort.getUserObject();
        if (object instanceof NetCircuitEnd) {
            n = ((NetCircuitEnd)object).getEntityIndex();
        } else if (object instanceof NetCircuitDropInfo) {
            n = ((NetCircuitDropInfo)object).getNetCktEnd().getEntityIndex();
        }
        return n;
    }

    public ICircuitEnd getCircuitEnd(MapPort mapPort) {
        Object object = mapPort.getUserObject();
        ICircuitEnd iCircuitEnd = null;
        if (object instanceof NetCircuitEnd) {
            iCircuitEnd = ((NetCircuitEnd)object).getCircuitEnd();
        } else if (object instanceof NetCircuitDropInfo) {
            iCircuitEnd = ((NetCircuitDropInfo)object).getNetCktEnd().getCircuitEnd();
        } else {
            db.warning(mapPort + " does not have a NetCircuitEnd/NetCircuitDropInfo key: " + object);
        }
        if (db.on()) {
            db.println("getCircuitEnd: aPort = " + mapPort + ", ce = " + this.toString(iCircuitEnd));
        }
        return iCircuitEnd;
    }

    private ICircuitEnd getCircuitEnd(MapLink mapLink) {
        ICircuitEnd iCircuitEnd = null;
        Object object = mapLink.getUserCookie();
        Object object2 = mapLink.getUserObject();
        if (object2 instanceof INetLink) {
            INetLink iNetLink = (INetLink)object2;
            int n = -1;
            IHoNum iHoNum = null;
            switch (this.getNodeRoleInNetLink(iNetLink)) {
                case 1: {
                    n = iNetLink.getSrcEntityIndex();
                    iHoNum = iNetLink.getSrcHo();
                    break;
                }
                case 2: {
                    n = iNetLink.getDstEntityIndex();
                    iHoNum = iNetLink.getDstHo();
                }
            }
            int n2 = ((INodeModel)this.getUserObject()).getNodeId();
            iCircuitEnd = new CircuitEnd(n2, n, new HoLoNum(iHoNum, null), false, 0);
        } else if (object instanceof CircuitExternalMapLinkCookie) {
            CircuitExternalMapLinkCookie circuitExternalMapLinkCookie = (CircuitExternalMapLinkCookie)object;
            INetCircuitEnd iNetCircuitEnd = circuitExternalMapLinkCookie.getCircuitEnd();
            if (iNetCircuitEnd instanceof NetCircuitEnd) {
                iCircuitEnd = ((NetCircuitEnd)iNetCircuitEnd).getCircuitEnd();
            } else if (iNetCircuitEnd instanceof NetCircuitDropInfo) {
                iCircuitEnd = ((NetCircuitDropInfo)iNetCircuitEnd).getNetCktEnd().getCircuitEnd();
            } else {
                db.warning(mapLink + " does not have a NetCircuitEnd/NetCircuitDropInfo nce: " + iNetCircuitEnd);
            }
            if (iCircuitEnd != null && iCircuitEnd.getPortNum() == 0) {
                try {
                    iCircuitEnd.setPortNum(iNetCircuitEnd.getEntityModel().getEntityIndex());
                }
                catch (ObjNotFound objNotFound) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
        }
        if (db.on()) {
            db.println("getCircuitEnd: aLink = " + mapLink + ", ce = " + this.toString(iCircuitEnd));
        }
        return iCircuitEnd;
    }

    private String toString(ICircuitEnd iCircuitEnd) {
        if (iCircuitEnd != null) {
            return "[" + Integer.toHexString(iCircuitEnd.getNodeId()) + ", " + Integer.toHexString(iCircuitEnd.getPortNum()) + ", " + iCircuitEnd.getHoLoNum().getHoNum() + "-" + iCircuitEnd.getHoLoNum().getLoNum() + "]";
        }
        return "null";
    }

    private boolean areEquals(ICircuitEnd iCircuitEnd, ICircuitEnd iCircuitEnd2) {
        return iCircuitEnd != null && iCircuitEnd2 != null && iCircuitEnd.getNodeId() == iCircuitEnd2.getNodeId() && iCircuitEnd.getPortNum() == iCircuitEnd2.getPortNum() && iCircuitEnd.getHoLoNum().equals(iCircuitEnd2.getHoLoNum());
    }

    public void addInternalOCHPortsForNode(INetCircuit iNetCircuit, List<NetCircuitNode> list, boolean bl) {
        ArrayList<NetCircuitNode> arrayList = new ArrayList<NetCircuitNode>();
        ArrayList<NetCircuitNode> arrayList2 = new ArrayList<NetCircuitNode>();
        for (NetCircuitNode netCircuitNode : list) {
            if (netCircuitNode instanceof OchncCircuitNode) {
                arrayList.add(netCircuitNode);
                continue;
            }
            if (!(netCircuitNode instanceof OchTrailTunnelNode)) continue;
            arrayList2.add(netCircuitNode);
        }
        if (db.on()) {
            db.println("# of OCHNC Xconnects =" + arrayList.size() + "Node -" + this.getName());
            db.println("# of OCH trail tunnel Adits =" + arrayList2.size() + "Node -" + this.getName());
        }
        if (arrayList.size() == 0 || arrayList2.size() == 0) {
            return;
        }
        this.addInternalCrossconnect(iNetCircuit, (NetCircuitNode)arrayList.get(0), (NetCircuitNode)arrayList2.get(0), bl);
        if (arrayList.size() > 1 && arrayList2.size() > 1) {
            this.addInternalCrossconnect(iNetCircuit, (NetCircuitNode)arrayList.get(1), (NetCircuitNode)arrayList2.get(1), bl);
            this.addRegenLine(arrayList2);
        }
    }

    public void addRegenLine(List<NetCircuitNode> list) {
        if (list.size() != 2) {
            return;
        }
        NetCircuitEnd netCircuitEnd = list.get(0).getConnectionPathEnd(0);
        NetCircuitEnd netCircuitEnd2 = list.get(1).getConnectionPathEnd(0);
        CircuitMapPort circuitMapPort = this.getMapPortForCircuitEnd(netCircuitEnd);
        CircuitMapPort circuitMapPort2 = this.getMapPortForCircuitEnd(netCircuitEnd2);
        if (circuitMapPort != null && circuitMapPort2 != null) {
            this.addMapLine(circuitMapPort, circuitMapPort2, null).setToolTipText("Regen Group");
        }
    }

    public void addInternalCrossconnect(INetCircuit iNetCircuit, NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2, boolean bl) {
        if (netCircuitNode.getConnectionType() == 20) {
            return;
        }
        try {
            CircuitMapPort circuitMapPort;
            Object object;
            CircuitMapPort circuitMapPort2;
            NetCircuitEnd netCircuitEnd = netCircuitNode.getConnectionPathEnd(0);
            NetCircuitEnd netCircuitEnd2 = netCircuitNode.getConnectionPathEnd(3);
            CircuitMapPortCookie circuitMapPortCookie = null;
            int n = iNetCircuit.getCircuitOptChannel();
            CircuitMapPort circuitMapPort3 = this.getMapPortForCircuitEnd(netCircuitEnd);
            if (circuitMapPort3 == null) {
                circuitMapPort3 = bl ? (CircuitMapPort)this.addPort(this.doCreateCircuitMapPort(this, null, netCircuitEnd)) : (CircuitMapPort)this.addPort(null, null);
                circuitMapPortCookie = new CircuitMapPortCookie(iNetCircuit, CircuitMapNode.getSpanLabel(netCircuitEnd));
                circuitMapPort3.init(netCircuitEnd, circuitMapPortCookie);
                if (db.on()) {
                    db.println("Added Int.OCH port =" + circuitMapPort3.getToolTipText() + "on node- " + this.getName());
                }
                circuitMapPort3.setSize(6.666666666666667, 6.666666666666667);
                circuitMapPort2 = this.getMapPortForEntityIndex(OchncHelper.getOutLinePort(n, netCircuitEnd2.getEntityModel()).getEntityIndex());
                this.otsMapPortList.add(circuitMapPort2);
            }
            if ((circuitMapPort2 = this.getMapPortForCircuitEnd(netCircuitEnd2)) == null) {
                circuitMapPort2 = bl ? (CircuitMapPort)this.addPort(this.doCreateCircuitMapPort(this, null, netCircuitEnd2)) : (CircuitMapPort)this.addPort(null, null);
                circuitMapPortCookie = new CircuitMapPortCookie(iNetCircuit, CircuitMapNode.getSpanLabel(netCircuitEnd2));
                circuitMapPort2.init(netCircuitEnd2, circuitMapPortCookie);
                if (db.on()) {
                    db.println("Added Int.OCH port =" + circuitMapPort2.getToolTipText() + "on node- " + this.getName());
                }
                circuitMapPort2.setSize(6.666666666666667, 6.666666666666667);
                object = this.getMapPortForEntityIndex(OchncHelper.getInLinePort(n, netCircuitEnd.getEntityModel()).getEntityIndex());
                this.otsMapPortList.add(object);
            }
            if ((circuitMapPort = this.getMapPortForCircuitEnd((INetCircuitEnd)(object = netCircuitNode2.getConnectionPathEnd(0)))) == null) {
                circuitMapPort = bl ? (CircuitMapPort)this.addPort(this.doCreateCircuitMapPort(this, null, (INetCircuitEnd)object)) : (CircuitMapPort)this.addPort(null, null);
                circuitMapPortCookie = new CircuitMapPortCookie(iNetCircuit, CircuitMapNode.getSpanLabel((INetCircuitEnd)object));
                circuitMapPort.init(object, circuitMapPortCookie);
                if (db.on()) {
                    db.println("Added Adit port =" + circuitMapPort.getToolTipText() + "on node- " + this.getName());
                }
                circuitMapPort.setSize(5.0, 5.0);
            }
            if (circuitMapPort != null) {
                this.addInternalSpanMapLine(circuitMapPort, circuitMapPort3, true, bl);
                this.addInternalSpanMapLine(circuitMapPort, circuitMapPort2, true, bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addInternalSpanMapLine(CircuitMapPort circuitMapPort, CircuitMapPort circuitMapPort2, boolean bl, boolean bl2) {
        boolean bl3;
        String string;
        MapLine mapLine;
        block15: {
            mapLine = this.addMapLine(circuitMapPort, circuitMapPort2, null);
            if (mapLine == null) {
                return;
            }
            string = "";
            bl3 = true;
            if (bl && circuitMapPort != null && circuitMapPort2 != null) {
                String string2 = null;
                String string3 = null;
                String string4 = null;
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)circuitMapPort.getCircuitEnd();
                NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)circuitMapPort2.getCircuitEnd();
                try {
                    int n = netCircuitEnd.getEntityModel().getEqType();
                    if (n == 123) {
                        string2 = circuitMapPort.getInfoString();
                        bl3 = OchTrailHelper.isWorkingPort(circuitMapPort.getCircuitEnd().getEntityModel());
                        if (OchPortsHelper.isAddPort(netCircuitEnd2.getEntityModel())) {
                            string3 = circuitMapPort2.getInfoString();
                        } else {
                            string4 = circuitMapPort2.getInfoString();
                        }
                    } else {
                        string2 = circuitMapPort2.getInfoString();
                        bl3 = OchTrailHelper.isWorkingPort(circuitMapPort2.getCircuitEnd().getEntityModel());
                        if (OchPortsHelper.isAddPort(netCircuitEnd.getEntityModel())) {
                            string3 = circuitMapPort.getInfoString();
                        } else {
                            string4 = circuitMapPort.getInfoString();
                        }
                    }
                    if (string3 != null) {
                        string = string2 + "-" + string3;
                    } else if (string4 != null) {
                        string = string4 + "-" + string2;
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block15;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        mapLine.setToolTipText(string + "(Internal Patch Chord)");
        if (!bl3 && bl2) {
            mapLine.setColor(NetMapLink.LINK_STANDBY_COLOR);
        } else {
            mapLine.setColor(NetMapLink.LINK_ACTIVE_COLOR);
        }
    }

    public static String getSpanLabel(INetCircuitEnd iNetCircuitEnd) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd);
    }

    public CircuitMapPort getMapPortForCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        return this.getMapPortForEntityIndex(iNetCircuitEnd.getEntityIndex());
    }

    public CircuitMapPort getMapPortForEntityIndex(int n) {
        MapPort[] mapPortArray = this.getPorts(true);
        for (int i = 0; i < mapPortArray.length; ++i) {
            if (((CircuitMapPort)mapPortArray[i]).getCircuitEnd().getEntityIndex() != n) continue;
            return (CircuitMapPort)mapPortArray[i];
        }
        return null;
    }

    private double getXPos(int n, int n2, int n3) {
        double d = 5.0;
        double d2 = ((MapPort)this.otsMapPortList.get(n)).getCenterX();
        if (n2 == 2) {
            d2 -= d;
        } else if (n2 == -2) {
            d2 += d;
        } else if (n2 == 1) {
            d2 += d * (double)n3;
        } else if (n2 == -1) {
            d2 += d * (double)n3;
        }
        return d2;
    }

    private double getYPos(int n, int n2, int n3) {
        double d = ((MapPort)this.otsMapPortList.get(n)).getCenterY();
        double d2 = 5.0;
        if (n2 == 1) {
            d += d2;
        } else if (n2 == -1) {
            d -= d2;
        } else if (n2 == 2) {
            d += d2 * (double)n3;
        } else if (n2 == -2) {
            d += d2 * (double)n3;
        }
        return d;
    }

    private double getTrunkXPos(int n, int n2) {
        double d = 6.0;
        double d2 = ((MapPort)this.otsMapPortList.get(n)).getCenterX();
        if (n2 == 2) {
            d2 -= d;
        } else if (n2 == -2) {
            d2 += d;
        }
        return d2;
    }

    private double getTrunkYPos(int n, int n2) {
        double d = ((MapPort)this.otsMapPortList.get(n)).getCenterY();
        double d2 = 6.0;
        if (n2 == 1) {
            d += d2;
        } else if (n2 == -1) {
            d -= d2;
        }
        return d;
    }

    private double getSplitterTrunkXPos(int n, int n2) {
        double d = 25.0;
        CircuitMapPort circuitMapPort = (CircuitMapPort)this.otsMapPortList.get(n);
        double d2 = circuitMapPort.getCenterX();
        int n3 = circuitMapPort.getSide();
        if (n3 == 2) {
            d2 -= d;
        } else if (n3 == -2) {
            d2 += d;
        } else if (n3 == 1) {
            d2 += d * (double)n2;
        } else if (n3 == -1) {
            d2 += d * (double)n2;
        }
        return d2;
    }

    private double getSplitterTrunkYPos(int n, int n2) {
        double d = 25.0;
        CircuitMapPort circuitMapPort = (CircuitMapPort)this.otsMapPortList.get(n);
        double d2 = circuitMapPort.getCenterY();
        int n3 = circuitMapPort.getSide();
        if (n3 == 1) {
            d2 += d;
        } else if (n3 == -1) {
            d2 -= d;
        } else if (n3 == 2) {
            d2 += d * (double)n2;
        } else if (n3 == -2) {
            d2 += d * (double)n2;
        }
        return d2;
    }

    private double getAditXpos(int n) {
        double d = this.getCenterX();
        double d2 = 10.0;
        double d3 = d;
        if (n == 2) {
            d3 += d2;
        } else if (n == -2) {
            d3 -= d2;
        }
        return d3;
    }

    private double getAditYpos(int n) {
        double d = this.getCenterY();
        double d2 = 10.0;
        if (n == 1) {
            d -= d2;
        } else if (n == -1) {
            d += d2;
        }
        return d;
    }

    @Override
    protected void updateZeroSelectors() {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = true;
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        MapPort[] mapPortArray = this.getInternalPorts();
        MapPort[] mapPortArray2 = this.getPorts();
        boolean bl3 = false;
        if (this.otsMapPortList != null && this.otsMapPortList.size() >= 2) {
            if (db.on()) {
                db.println("Node: " + this.getName() + "Internal Ports #: " + mapPortArray.length);
                db.println("Node: " + this.getName() + "External Ports #: " + mapPortArray2.length);
            }
            try {
                if (this.otsMapPortList.size() >= 2) {
                    n = ((MapPort)this.otsMapPortList.get(0)).getSide();
                    iEntityModel = ((CircuitMapPort)mapPortArray2[0]).getCircuitEnd().getEntityModel();
                    if (OchPortsHelper.isAddPort(iEntityModel)) {
                        bl = false;
                    }
                }
                if (this.otsMapPortList.size() == 4) {
                    n2 = ((MapPort)this.otsMapPortList.get(2)).getSide();
                    iEntityModel2 = ((CircuitMapPort)mapPortArray2[1]).getCircuitEnd().getEntityModel();
                    if (OchPortsHelper.isAddPort(iEntityModel2)) {
                        bl2 = false;
                    }
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            int n3 = -1;
            if (mapPortArray.length == 2 && this.otsMapPortList.size() == 2) {
                if (db.on()) {
                    db.println(" Drawing internal ports for Src/Dest Node " + this.getName());
                }
                n3 = bl ? 1 : -1;
                mapPortArray[0].setCenter(this.getXPos(0, n, n3), this.getYPos(0, n, n3));
                mapPortArray[1].setCenter(this.getXPos(1, n, -n3), this.getYPos(1, n, -n3));
                bl3 = true;
            }
            if (mapPortArray.length == 3 && mapPortArray2.length == 3) {
                this.otsMapPortList.add(mapPortArray2[2]);
                if (db.on()) {
                    db.println(" Drawing internal ports for Src/Dest Nodes for OCHCC on " + this.getName());
                }
                n3 = bl ? 1 : -1;
                mapPortArray[0].setCenter(this.getXPos(0, n, n3), this.getYPos(0, n, n3));
                mapPortArray[1].setCenter(this.getXPos(1, n, -n3), this.getYPos(1, n, -n3));
                mapPortArray[2].setCenter(this.getTrunkXPos(2, mapPortArray2[2].getSide()), this.getTrunkYPos(2, mapPortArray2[2].getSide()));
                mapPortArray[2].setSize(10.0, 10.0);
                mapPortArray2[2].setSize(6.666666666666667, 6.666666666666667);
                this.otsMapPortList.remove(mapPortArray2[2]);
                bl3 = true;
            }
            if (mapPortArray.length == 6 && this.otsMapPortList.size() == 4) {
                if (db.on()) {
                    db.println(" Drawing internal ports for Regen Node " + this.getName());
                }
                n3 = bl ? 1 : -1;
                mapPortArray[0].setCenter(this.getXPos(0, n, n3), this.getYPos(0, n, n3));
                mapPortArray[1].setCenter(this.getXPos(1, n, -n3), this.getYPos(1, n, -n3));
                mapPortArray[2].setCenter(this.getAditXpos(n), this.getAditYpos(n));
                mapPortArray[2].setSize(6.666666666666667, 6.666666666666667);
                n3 = bl2 ? 1 : -1;
                mapPortArray[3].setCenter(this.getXPos(2, n2, n3), this.getYPos(2, n2, n3));
                mapPortArray[4].setCenter(this.getXPos(3, n2, -n3), this.getYPos(3, n2, -n3));
                mapPortArray[5].setCenter(this.getAditXpos(n2), this.getAditYpos(n2));
                mapPortArray[5].setSize(6.666666666666667, 6.666666666666667);
                bl3 = true;
            }
            if (mapPortArray.length == 6 && mapPortArray2.length == 5) {
                if (db.on()) {
                    db.println(" Drawing internal ports for Splitter Node " + this.getName());
                }
                this.otsMapPortList.add(mapPortArray2[4]);
                n3 = bl ? 1 : -1;
                mapPortArray[0].setCenter(this.getXPos(0, n, n3), this.getYPos(0, n, n3));
                mapPortArray[1].setCenter(this.getXPos(1, n, n3), this.getYPos(1, n, n3));
                mapPortArray[2].setCenter(this.getSplitterTrunkXPos(4, 1), this.getSplitterTrunkYPos(4, 1));
                n3 = bl2 ? 1 : -1;
                mapPortArray[3].setCenter(this.getXPos(2, n2, n3), this.getYPos(2, n2, n3));
                mapPortArray[4].setCenter(this.getXPos(3, n2, n3), this.getYPos(3, n2, n3));
                mapPortArray[5].setCenter(this.getSplitterTrunkXPos(4, -1), this.getSplitterTrunkYPos(4, -1));
                mapPortArray[2].setSize(6.666666666666667, 6.666666666666667);
                mapPortArray[5].setSize(6.666666666666667, 6.666666666666667);
                mapPortArray2[4].setSize(10.0, 10.0);
                this.otsMapPortList.remove(mapPortArray2[4]);
                bl3 = true;
            }
            if (mapPortArray.length == 3 && mapPortArray2.length == 4) {
                if (db.on()) {
                    db.println(" Drawing internal ports for partially non-colocated Splitter Node " + this.getName());
                }
                this.otsMapPortList.add(mapPortArray2[2]);
                this.otsMapPortList.add(mapPortArray2[3]);
                n3 = bl ? 1 : -1;
                mapPortArray[0].setCenter(this.getXPos(0, n, n3), this.getYPos(0, n, n3));
                mapPortArray[1].setCenter(this.getXPos(1, n, n3), this.getYPos(1, n, n3));
                mapPortArray[2].setCenter(this.getSplitterTrunkXPos(3, 1), this.getSplitterTrunkYPos(3, 1));
                mapPortArray[2].setSize(6.666666666666667, 6.666666666666667);
                mapPortArray2[2].setSize(10.0, 10.0);
                mapPortArray2[3].setSize(10.0, 10.0);
                this.otsMapPortList.remove(mapPortArray2[2]);
                this.otsMapPortList.remove(mapPortArray2[3]);
                bl3 = true;
            }
        }
        if (!bl3) {
            super.updateZeroSelectors();
        }
    }

    @Override
    protected void updateOneSelector() {
        MapPort[] mapPortArray = this.getInternalPorts();
        MapPort[] mapPortArray2 = this.getPorts();
        if (this instanceof AbstractProtectedCircuitMapNode) {
            if (mapPortArray.length == 6 && mapPortArray2.length == 5 || mapPortArray.length == 3 && mapPortArray2.length == 4) {
                this.updateZeroSelectors();
            }
        } else {
            super.updateOneSelector();
        }
    }
}

