/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.fv.net.IFvMapPersist;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NoSuchProperty;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.ColorUtil;
import cerent.util.NetworkMapUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import com.cisco.ctc.util.map.Node;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

public class MapPersist
implements IFvMapPersist {
    private static final double LEFT_LONG = -126.0;
    private static final double RIGHT_LONG = -65.0;
    private static final double TOP_LAT = 52.0;
    private static final double BOTTOM_LAT = 22.0;
    public static final String PREFS_MAP_FILE = "map.file";
    public static final String PREFS_MAP_LEFT_LONG = "map.longitude.left";
    public static final String PREFS_MAP_RIGHT_LONG = "map.longitude.right";
    public static final String PREFS_MAP_TOP_LAT = "map.latitude.top";
    public static final String PREFS_MAP_BOTTOM_LAT = "map.latitude.bottom";
    public static final String PREFS_MAP_USE_DEFAULT = "map.usedefault";
    public static final String PREFS_MAP_DEFAULT_SELECTED = "network.defaultmapselected";
    public static final String PREFS_MAP_DEFAULTMAPFILE = "network.defaultmapfile";
    private static final String PREFS_CTC = "ctc";
    private static final String PREFS_MAP = "map";
    private static final String PREFS_LINK_ICON = "map.linkicon.enable";
    private static final String PREFS_LINK_CLASS_BUNDLE_STATE = "map.linkclass.bundle.state";
    private static final String PREFS_LINK_CLASS_DISPLAY_STATE = "map.linkclass.display.state";
    private static final String PREFS_LONG = "longitude";
    private static final String PREFS_LAT = "latitude";
    private static final String PREFS_DOMAIN = "domain";
    private static final String PREFS_BGCOLOR = "bgcolor";
    private static final String PREFS_LEFT = "left";
    private static final String PREFS_RIGHT = "right";
    private static final String PREFS_TOP = "top";
    private static final String PREFS_BOTTOM = "bottom";
    private static final String PREFS_TRANSFORM = "transform";
    private static final String PREFS_X = "x";
    private static final String PREFS_Y = "y";
    private static final String PREFS_FIXED = "fixed";
    private static String imageFile = "/images/maps/usa.gif";
    private static Preferences preferences = Preferences.instance();
    private static final String dpmPropName = "CTC.network.LocalDomainCreationAndViewing";
    private static final int _index = "CTC.network.LocalDomainCreationAndViewing".indexOf(".");
    public static final String dpmPrefix = "CTC.network.LocalDomainCreationAndViewing".substring(0, _index).toLowerCase();
    public static final String dpmSuffix = "CTC.network.LocalDomainCreationAndViewing".substring(_index + 1).toLowerCase();
    private static final String _storeDomainInPrefs = preferences.getProperty(dpmPrefix, dpmSuffix, null);
    private static final boolean storeDomainInPrefs = preferences.getBoolean(dpmPrefix, dpmSuffix, true) || _storeDomainInPrefs != null && _storeDomainInPrefs.equals("1");
    public static final Debug db = new Debug("MapPersist");

    private static Preferences getPreferences() {
        Preferences preferences = Preferences.instance();
        preferences.removeProperty("CTC", "defaults." + dpmPropName.toLowerCase());
        return preferences;
    }

    public static boolean getPersistProperty(Object object, int n) {
        if (object instanceof MapToolkit) {
            return MapPersist.getMapToolkitProperty((MapToolkit)object, n);
        }
        if (object instanceof MapGraph) {
            return MapPersist.getMapGraphProperty((MapGraph)((Object)object), n);
        }
        if (object instanceof MapDomain) {
            return MapPersist.getMapDomainProperty((MapDomain)object, n);
        }
        if (object instanceof MapNode) {
            return MapPersist.getMapNodeProperty((MapNode)object, n);
        }
        return false;
    }

    public static void setPersistProperty(Object object, int n, String string, String string2) {
        if (object instanceof MapToolkit) {
            MapPersist.setMapToolkitProperty((MapToolkit)object, n, string, string2);
        } else if (object instanceof MapGraph) {
            MapPersist.setMapGraphProperty((MapGraph)((Object)object), n, string, string2);
        } else if (object instanceof MapDomain) {
            MapPersist.setMapDomainProperty((MapDomain)object, n, string, string2);
        } else if (object instanceof MapNode) {
            MapPersist.setMapNodeProperty((MapNode)object, n, string, string2);
        }
    }

    private static boolean getMapToolkitProperty(MapToolkit mapToolkit, int n) {
        boolean bl = false;
        switch (n) {
            case 100: {
                bl = MapPersist.getMapCoordinates(mapToolkit);
                break;
            }
            case 109: {
                bl = MapPersist.getLinkClassBundleStates(mapToolkit);
                break;
            }
            case 110: {
                bl = MapPersist.getShowLinkIcon();
                break;
            }
            case 111: {
                bl = MapPersist.getMapTransform(mapToolkit);
            }
        }
        return bl;
    }

    private static boolean getMapGraphProperty(MapGraph mapGraph, int n) {
        boolean bl = false;
        switch (n) {
            case 108: {
                String string = mapGraph.getDomainName();
                if (string.equals("")) {
                    bl = MapPersist.loadMapImage(mapGraph);
                    break;
                }
                String string2 = MapPersist.getBgImage(string);
                if (string2 == null) break;
                mapGraph.setBackgroundImage(string2);
                bl = true;
                break;
            }
            case 107: {
                Color color = MapPersist.getBgColor(mapGraph.getDomainName());
                if (color == null) break;
                mapGraph.setBackgroundColor(color);
                bl = true;
            }
        }
        return bl;
    }

    private static boolean getMapDomainProperty(MapDomain mapDomain, int n) {
        if (n == 101) {
            return MapPersist.getPositionInfoFromPrefs(mapDomain, mapDomain.getName());
        }
        if (n == 112) {
            return MapPersist.getNodeFixedInfo(mapDomain);
        }
        return true;
    }

    private static boolean getMapNodeProperty(MapNode mapNode, int n) {
        if (n == 101) {
            return MapPersist.getPositionInfoFromPrefs(mapNode, mapNode.getDomainName());
        }
        if (n == 112) {
            return MapPersist.getNodeFixedInfo(mapNode);
        }
        return true;
    }

    private static void setMapToolkitProperty(MapToolkit mapToolkit, int n, String string, String string2) {
        if (n == 109) {
            MapPersist.saveLinkClassBundleState(string, string2);
        } else if (n == 110) {
            MapPersist.saveShowLinkIcon(string, string2);
        } else if (n == 111) {
            MapPersist.saveMapTransform(mapToolkit);
        }
    }

    private static void setMapGraphProperty(MapGraph mapGraph, int n, String string, String string2) {
        switch (n) {
            case 108: {
                MapPersist.saveBgImage(mapGraph.getDomainName(), string2);
                break;
            }
            case 107: {
                MapPersist.saveBgColor(mapGraph.getDomainName(), mapGraph.getBackgroundColor());
            }
        }
    }

    private static void setMapDomainProperty(MapDomain mapDomain, int n, String string, String string2) {
        if (n == 101) {
            MapPersist.savePositionInfoToPrefs(mapDomain, mapDomain.getName());
        } else if (n == 106) {
            MapPersist.removeDomain(mapDomain);
        } else if (n == 105) {
            MapPersist.domainNameChanged(mapDomain, string, string2);
        } else if (n == 112) {
            MapPersist.saveNodeFixedInfo(mapDomain);
        }
    }

    private static void setMapNodeProperty(MapNode mapNode, int n, String string, String string2) {
        if (n == 101) {
            MapPersist.savePositionInfoToPrefs(mapNode, mapNode.getDomainName());
        } else if (n == 104) {
            MapPersist.removeNodeFromDomain(mapNode, string);
        } else if (n == 103) {
            MapPersist.nodeDomainNameChanged(mapNode, string, string2);
        } else if (n == 112) {
            MapPersist.saveNodeFixedInfo(mapNode);
        }
    }

    public static Color getBgColor(String string) {
        string = MapPersist.encodeDomain(string);
        String string2 = "map." + string + "." + PREFS_BGCOLOR;
        String string3 = preferences.getProperty(PREFS_CTC, string2, null);
        MapPersist.println("getBgColor: key=" + string2 + " value=" + string3);
        return ColorUtil.getColor(string3);
    }

    public static void saveBgColor(String string, Color color) {
        string = MapPersist.encodeDomain(string);
        String string2 = ColorUtil.getRGBString(color);
        String string3 = "map." + string + "." + PREFS_BGCOLOR;
        preferences.setProperty(PREFS_CTC, string3, string2);
        MapPersist.println("saveBgColor: key=" + string3 + " value=" + string2);
    }

    public static void removeBgColor(String string) {
        string = MapPersist.encodeDomain(string);
        String string2 = "map." + string + "." + PREFS_BGCOLOR;
        preferences.removeProperty(PREFS_CTC, string2);
        MapPersist.println("removeBgColor: key=" + string2);
    }

    public static String getBgImage(String string) {
        String string2 = "";
        string2 = string.equals("") ? PREFS_MAP_FILE : "map.file." + MapPersist.encodeDomain(string);
        String string3 = preferences.getProperty(PREFS_CTC, string2, null);
        MapPersist.println("getBgImage: key=" + string2 + "=" + string3);
        return string3;
    }

    public static void saveBgImage(String string, String string2) {
        if (string.equals("")) {
            if (string2 == null) {
                preferences.removeProperty(PREFS_CTC, PREFS_MAP_FILE);
                MapPersist.println("saveBgImage: domain=" + string + " to null");
            } else {
                preferences.setProperty(PREFS_CTC, PREFS_MAP_FILE, string2);
                MapPersist.println("saveBgImage: domain=" + string + " " + PREFS_MAP_FILE + "=" + string2);
            }
            preferences.setProperty(PREFS_CTC, PREFS_MAP_USE_DEFAULT, "0");
        } else {
            string = MapPersist.encodeDomain(string);
            if (string2 == null) {
                preferences.removeProperty(PREFS_CTC, "map.file." + string);
                MapPersist.println("saveBgImage: domain=" + string + " to null");
            } else {
                preferences.setProperty(PREFS_CTC, "map.file." + string, string2);
                MapPersist.println("saveBgImage: domain=" + string + " " + PREFS_MAP_FILE + "." + string + "=" + string2);
            }
        }
    }

    public static void removeBgImage(String string) {
        if (string.equals("")) {
            return;
        }
        string = MapPersist.encodeDomain(string);
        String string2 = "map.file." + string;
        preferences.removeProperty(PREFS_CTC, string2);
        MapPersist.println("removeBgImage: key=" + string2);
    }

    private static void savePositionInfoToPrefs(Node node, String string) {
        String string2 = MapPersist.getNodeDesc(node, string);
        string = MapPersist.encodeDomain(string);
        int n = MapPersist.toOldX((int)node.getCenterX());
        int n2 = MapPersist.toOldY((int)node.getCenterY());
        String string3 = String.valueOf(n);
        String string4 = String.valueOf(n2);
        String string5 = MapPersist.buildLongitudePrefStr(node, string);
        preferences.setProperty(PREFS_CTC, string5, string3);
        MapPersist.println("savePositionInfoToPrefs: " + string2 + " key=" + string5 + "=" + string3);
        String string6 = MapPersist.buildLatitudePrefStr(node, string);
        preferences.setProperty(PREFS_CTC, string6, string4);
        MapPersist.println("savePositionInfoToPrefs: " + string2 + " key=" + string6 + "=" + string4);
    }

    private static void removePositionInfoFromPrefs(Node node, String string) {
        if (string.equals("")) {
            return;
        }
        String string2 = MapPersist.getNodeDesc(node, string);
        string = MapPersist.encodeDomain(string);
        String string3 = MapPersist.buildLongitudePrefStr(node, string);
        preferences.removeProperty(PREFS_CTC, string3);
        MapPersist.println("removePositionInfoFromPrefs: " + string2 + " key=" + string3);
        String string4 = MapPersist.buildLatitudePrefStr(node, string);
        preferences.removeProperty(PREFS_CTC, string4);
        MapPersist.println("removePositionInfoFromPrefs: " + string2 + " key=" + string4);
    }

    private static boolean getPositionInfoFromPrefs(Node node, String string) {
        String string2 = MapPersist.getNodeDesc(node, string);
        try {
            double d = 0.0;
            double d2 = 0.0;
            String string3 = MapPersist.buildLongitudePrefStr(node, string);
            String string4 = preferences.getProperty(PREFS_CTC, string3, null);
            if (string4 != null) {
                d = Double.parseDouble(string4);
            }
            MapPersist.println("getPositionInfoFromPrefs: " + string2 + " key=" + string3 + "=" + string4);
            String string5 = MapPersist.buildLatitudePrefStr(node, string);
            String string6 = preferences.getProperty(PREFS_CTC, string5, null);
            if (string6 != null) {
                d2 = Double.parseDouble(string6);
            }
            MapPersist.println("getPositionInfoFromPrefs: " + string2 + " key=" + string5 + "=" + string6);
            if (d == 0.0 && d2 == 0.0) {
                return false;
            }
            node.setCoordinates(MapPersist.toNewX((int)d), MapPersist.toNewY((int)d2));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static String buildPositionPrefStr(Node node, String string, String string2) {
        String string3 = PREFS_MAP;
        if (node instanceof MapDomain) {
            string3 = string3 + "." + MapPersist.encodeDomain(string) + "." + string2;
        } else if (node instanceof MapNode) {
            string3 = string3 + "." + MapPersist.encodeDomain(string);
            String string4 = null;
            if (node.getUserObject() instanceof INodeModel) {
                INodeModel iNodeModel = (INodeModel)node.getUserObject();
                if (iNodeModel != null) {
                    string4 = String.valueOf(iNodeModel.getNodeId());
                }
            } else if (node.getUserObject() instanceof IModuleModel) {
                IModuleModel iModuleModel = (IModuleModel)node.getUserObject();
                INodeModel iNodeModel = iModuleModel.getNodeModel();
                string4 = String.valueOf(iNodeModel.getNodeId()) + "." + iModuleModel.getEntityIndex();
            }
            string3 = string3 + "." + string4 + "." + string2;
        }
        return string3;
    }

    private static String getNodeName(MapNode mapNode) {
        INodeModel iNodeModel;
        String string = null;
        if (mapNode.getUserObject() instanceof INodeModel && (iNodeModel = (INodeModel)mapNode.getUserObject()) != null) {
            string = iNodeModel.getName();
        }
        return string;
    }

    public static String buildLatitudePrefStr(Node node) {
        if (node instanceof MapNode) {
            return MapPersist.buildPositionPrefStr(node, ((MapNode)node).getDomainName(), PREFS_Y);
        }
        if (node instanceof MapDomain) {
            return MapPersist.buildPositionPrefStr(node, node.getName(), PREFS_Y);
        }
        return null;
    }

    public static String buildLongitudePrefStr(Node node) {
        if (node instanceof MapNode) {
            return MapPersist.buildPositionPrefStr(node, ((MapNode)node).getDomainName(), PREFS_X);
        }
        if (node instanceof MapDomain) {
            return MapPersist.buildPositionPrefStr(node, node.getName(), PREFS_X);
        }
        return null;
    }

    private static String buildLatitudePrefStr(Node node, String string) {
        return MapPersist.buildPositionPrefStr(node, string, PREFS_Y);
    }

    private static String buildLongitudePrefStr(Node node, String string) {
        return MapPersist.buildPositionPrefStr(node, string, PREFS_X);
    }

    private static String encodeDomain(String string) {
        return string.replace(' ', '_');
    }

    public static boolean getMapTransform(MapToolkit mapToolkit) {
        String string = MapPersist.buildPrefStr(mapToolkit.getCurrentDomainName(), PREFS_TRANSFORM);
        String string2 = preferences.getProperty(PREFS_CTC, string, null);
        MapPersist.println("getMapTransform: key=" + string + " value=" + string2);
        MapTransformer mapTransformer = MapTransformer.getMapTransformer(string2);
        if (mapTransformer != null) {
            mapToolkit.setMapTransformer(mapTransformer);
            return true;
        }
        return false;
    }

    public static void saveMapTransform(MapToolkit mapToolkit) {
        String string = mapToolkit.getMapTransformer().getTransformString();
        String string2 = MapPersist.buildPrefStr(mapToolkit.getCurrentDomainName(), PREFS_TRANSFORM);
        preferences.setProperty(PREFS_CTC, string2, string);
        MapPersist.println("saveMapTransform: key=" + string2 + " value=" + string);
    }

    public static void removeMapTransform(String string) {
        string = MapPersist.encodeDomain(string);
        String string2 = MapPersist.buildPrefStr(string, PREFS_TRANSFORM);
        preferences.removeProperty(PREFS_CTC, string2);
        MapPersist.println("removeMapTransform: key=" + string2);
    }

    public static boolean getShowLinkIcon() {
        return preferences.getBoolean(PREFS_CTC, PREFS_LINK_ICON, true);
    }

    private static boolean getLinkClassBundleStates(MapToolkit mapToolkit) {
        List list = preferences.getMatchingPropertyKeys(PREFS_CTC, PREFS_LINK_CLASS_BUNDLE_STATE);
        for (String string : list) {
            int n = string.lastIndexOf(46);
            if (n == -1) continue;
            String string2 = string.substring(n + 1);
            String string3 = preferences.getProperty(PREFS_CTC, "map.linkclass.bundle.state." + string2, String.valueOf(2));
            try {
                int n2 = Integer.parseInt(string3);
                mapToolkit.setPreferredLinkClassBundleState(string2, n2);
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        }
        return true;
    }

    public static TreeMap getLinkClassDisplayStates(String string) {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        String string2 = "map." + string + "." + PREFS_LINK_CLASS_DISPLAY_STATE;
        List list = preferences.getMatchingPropertyKeys(PREFS_CTC, string2);
        for (String string3 : list) {
            int n = string3.lastIndexOf(46);
            if (n == -1) continue;
            String string4 = string3.substring(n + 1);
            String string5 = preferences.getProperty(PREFS_CTC, string2 + "." + string4, String.valueOf(1));
            try {
                int n2 = Integer.parseInt(string5);
                treeMap.put(string4, new Integer(n2));
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        }
        return treeMap;
    }

    public static void saveShowLinkIcon(String string, String string2) {
        preferences.setBoolean(PREFS_CTC, PREFS_LINK_ICON, Boolean.valueOf(string2).booleanValue());
    }

    private static void saveLinkClassBundleState(String string, String string2) {
        preferences.setProperty(PREFS_CTC, "map.linkclass.bundle.state." + string, string2);
    }

    public static void saveLinkClassDisplayState(String string, String string2, String string3) {
        preferences.setProperty(PREFS_CTC, "map." + string2 + "." + PREFS_LINK_CLASS_DISPLAY_STATE + "." + string, string3);
    }

    private static String buildDomainPrefStr(INodeModel iNodeModel) {
        String string = PREFS_MAP;
        String string2 = iNodeModel != null ? String.valueOf(iNodeModel.getNodeId()) : "null";
        string = string + "." + string2 + "." + PREFS_DOMAIN;
        return string;
    }

    private static void removeDomainMembers(String string) {
        if (string == null) {
            return;
        }
        if (!MapPersist.storeDomainInPrefs()) {
            String string2 = "map.";
            String string3 = ".domain";
            Enumeration enumeration = preferences.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string4;
                String string5 = (String)enumeration.nextElement();
                if (!string5.startsWith(string2) || !string5.endsWith(string3) || !string.equals(string4 = MapPersist.getProperty(preferences, string5))) continue;
                if (db.on()) {
                    db.println("removing domain membership pref: " + string5 + "=" + string);
                }
                MapPersist.removeProperty(preferences, string5);
            }
        } else {
            Collection collection = Network.instance().getAllElements();
            for (INetElement iNetElement : collection) {
                INodeModel iNodeModel = iNetElement.getNodeModel();
                String string6 = null;
                try {
                    string6 = iNodeModel.getProperty(PREFS_DOMAIN);
                }
                catch (NoSuchProperty noSuchProperty) {
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    MapPersist.println("nm.getProperty hits AbstractCmsIOException (delegate possibly absent)");
                }
                if (!string.equals(string6)) continue;
                if (db.on()) {
                    db.println("removing NE " + iNodeModel + " domain membership prop: " + string);
                }
                try {
                    iNodeModel.removeProperty(PREFS_DOMAIN);
                }
                catch (NoSuchProperty noSuchProperty) {
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    MapPersist.println("nm.removeProperty hits AbstractCmsIOException (delegate possibly absent)");
                }
            }
        }
    }

    private static void removeProperty(Preferences preferences, String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        preferences.removeProperty(string2, string3);
    }

    private static String getProperty(Preferences preferences, String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return preferences.getProperty(string2, string3, null);
    }

    private static String buildPrefStr(String string, String string2) {
        return "map." + MapPersist.encodeDomain(string) + "." + string2;
    }

    public static boolean storeDomainInPrefs() {
        return storeDomainInPrefs;
    }

    private static void saveNodeDomain(INodeModel iNodeModel, String string) {
        if (iNodeModel == null) {
            MapPersist.println("saveNodeDomain: nodeModel is null");
            return;
        }
        boolean bl = MapPersist.storeDomainInPrefs();
        MapPersist.println("saveNodeDomain: storeDomainInPrefs=" + bl + " nodeModel=" + iNodeModel.getName() + " domain=" + string);
        string = MapPersist.encodeDomain(string);
        if (bl) {
            if (string.equals("")) {
                preferences.removeProperty(PREFS_CTC, MapPersist.buildDomainPrefStr(iNodeModel));
            } else {
                preferences.setProperty(PREFS_CTC, MapPersist.buildDomainPrefStr(iNodeModel), string);
            }
        } else {
            try {
                if (string.equals("")) {
                    MapPersist.removeNodeDomain(iNodeModel);
                } else {
                    iNodeModel.setProperty(PREFS_DOMAIN, string);
                }
            }
            catch (Exception exception) {
                MapPersist.println("Unable to save domain");
                Debug.printStackTrace((Throwable)exception);
            }
        }
    }

    public static String getNodeDomain(INodeModel iNodeModel) {
        String string = null;
        if (iNodeModel == null) {
            MapPersist.println("getNodeDomain: nodeModel is null");
            return "";
        }
        if (MapPersist.storeDomainInPrefs()) {
            string = preferences.getProperty(PREFS_CTC, MapPersist.buildDomainPrefStr(iNodeModel), "");
            MapPersist.println("getNodeDomain (source=prefs): node=" + iNodeModel.getName() + " domain=" + string.replace('_', ' '));
        } else {
            try {
                string = iNodeModel.getProperty(PREFS_DOMAIN);
                MapPersist.println("getNodeDomain (source=NE): node=" + iNodeModel.getName() + " domain=" + string.replace('_', ' '));
            }
            catch (NoSuchProperty noSuchProperty) {
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                MapPersist.println("getNodeDomain hits AbstractCmsIOException (delegate possibly absent)");
            }
            catch (Exception exception) {
                MapPersist.println("getNodeDomain hits exception");
                Debug.printStackTrace((Throwable)exception);
            }
        }
        if (string == null) {
            return "";
        }
        return string.replace('_', ' ');
    }

    public static String getLocalNodeDomainSetting(INodeModel iNodeModel, String string) {
        String string2 = null;
        if (string != null && !string.equals("")) {
            string2 = "ctc." + MapPersist.buildDomainPrefStr(iNodeModel) + "=" + string;
        }
        return string2;
    }

    private static void removeNodeDomain(INodeModel iNodeModel) {
        block6: {
            if (MapPersist.storeDomainInPrefs()) {
                preferences.removeProperty(PREFS_CTC, MapPersist.buildDomainPrefStr(iNodeModel));
            } else {
                try {
                    if (MapPersist.db.on) {
                        db.println("removeNodeDomain: node=" + iNodeModel.getName());
                    }
                    iNodeModel.removeProperty(PREFS_DOMAIN);
                }
                catch (NoSuchProperty noSuchProperty) {
                }
                catch (Exception exception) {
                    if (!MapPersist.db.on) break block6;
                    Debug.printStackTrace((Throwable)exception);
                    db.println("node does not support removeProperty");
                }
            }
        }
    }

    public static void nodeDomainNameChanged(MapNode mapNode, String string, String string2) {
        if (mapNode.isVirtual()) {
            return;
        }
        MapPersist.println("nodeDomainNameChanged: node=" + mapNode.getName() + " old domain=" + string + " new domain=" + string2);
        if (!string.equals("")) {
            MapPersist.removePositionInfoFromPrefs(mapNode, string);
        }
        if (!string2.equals("")) {
            MapPersist.savePositionInfoToPrefs(mapNode, string2);
        }
        INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
        MapPersist.saveNodeDomain(iNodeModel, string2);
    }

    public static void domainNameChanged(MapDomain mapDomain, String string, String string2) {
        String string3;
        String string4;
        String string5;
        if (string.equals("") || string2.equals("")) {
            return;
        }
        MapPersist.println("domainNameChanged oldDomainName=" + string + " newDomainName=" + string2);
        MapPersist.removePositionInfoFromPrefs(mapDomain, string);
        MapPersist.savePositionInfoToPrefs(mapDomain, string2);
        Color color = MapPersist.getBgColor(string);
        if (color != null) {
            MapPersist.removeBgColor(string);
            MapPersist.saveBgColor(string2, color);
        }
        if ((string5 = MapPersist.getBgImage(string)) != null) {
            MapPersist.removeBgImage(string);
            MapPersist.saveBgImage(string2, string5);
        }
        if ((string4 = preferences.getProperty(PREFS_CTC, string3 = MapPersist.buildPrefStr(string, PREFS_TRANSFORM), null)) != null) {
            preferences.removeProperty(PREFS_CTC, string3);
            MapPersist.println("domainNameChanged: key=" + string3 + " value=" + string4);
            string3 = MapPersist.buildPrefStr(string2, PREFS_TRANSFORM);
            preferences.setProperty(PREFS_CTC, string3, string4);
            MapPersist.println("domainNameChanged: key=" + string3 + " value=" + string4);
        }
    }

    private static void removeDomain(MapDomain mapDomain) {
        String string = mapDomain.getName();
        MapPersist.removeBgColor(string);
        MapPersist.removeBgImage(string);
        MapPersist.removeMapTransform(string);
        MapPersist.removePositionInfoFromPrefs(mapDomain, string);
        MapPersist.removeDomainMembers(string);
    }

    public static void removeNodeFromDomain(MapNode mapNode, String string) {
        if (mapNode.isVirtual()) {
            return;
        }
        INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
        MapPersist.removeNodeDomain(iNodeModel);
    }

    private static boolean getNodeFixedInfo(Node node) {
        String string = MapPersist.buildFixedPrefStr(node);
        String string2 = preferences.getProperty(PREFS_CTC, string, null);
        if (string2 != null) {
            node.setFixed(Boolean.valueOf(string2));
            return true;
        }
        return false;
    }

    private static void saveNodeFixedInfo(Node node) {
        String string = MapPersist.buildFixedPrefStr(node);
        String string2 = new Boolean(node.isFixed()).toString();
        preferences.setProperty(PREFS_CTC, string, string2);
    }

    private static String buildFixedPrefStr(Node node) {
        String string = PREFS_MAP;
        if (node instanceof MapDomain) {
            string = string + "." + MapPersist.encodeDomain(node.getName()) + "." + PREFS_FIXED;
        } else {
            INodeModel iNodeModel;
            String string2 = null;
            if (node.getUserObject() instanceof INodeModel && (iNodeModel = (INodeModel)node.getUserObject()) != null) {
                string2 = String.valueOf(iNodeModel.getNodeId());
            }
            string = string + "." + string2 + "." + PREFS_FIXED;
        }
        return string;
    }

    public static void setUseDefaultMap(String string) {
        preferences.setProperty(PREFS_CTC, PREFS_MAP_USE_DEFAULT, string);
    }

    public static String getUseDefaultMap() {
        String string = preferences.getProperty(PREFS_CTC, PREFS_MAP_USE_DEFAULT, "1");
        MapPersist.println("getUserDefaultMap: map.usedefault=" + string);
        return string;
    }

    public static boolean loadMapImage(MapGraph mapGraph) {
        String string = MapPersist.getUseDefaultMap();
        MapPersist.println("useDefaultMap=" + string);
        if (string.equals("1")) {
            String string2 = MapPersist.getDefaultMapFromNe();
            MapPersist.println("getDefaultMapFromNe=" + string2);
            if (string2 == null) {
                string2 = MapPersist.getDefaultMapFromPrefs();
                MapPersist.println("getDefaultMapFromPrefs=" + string2);
            }
            if (string2 == null) {
                string2 = "United States";
                MapPersist.println("default to " + string2);
            }
            string2 = MapPersist.getDefaultMapFile(string2);
            MapPersist.println("default map path = " + string2);
            if (string2 != null && !string2.equals("-none-")) {
                MapPersist.println("assign default map to root graph");
                URL uRL = MapPersist.class.getResource(string2);
                mapGraph.setBackgroundImage(uRL);
            } else {
                mapGraph.removeBackgroundImage();
            }
        } else {
            String string3 = MapPersist.getBgImage("");
            if (string3 == null) {
                mapGraph.removeBackgroundImage();
            } else {
                mapGraph.setBackgroundImage(string3);
            }
        }
        return true;
    }

    private static void setDefaultMapFile(String string) {
        preferences.setProperty(PREFS_CTC, PREFS_MAP_DEFAULTMAPFILE, string);
    }

    private static String getDefaultMapFile(String string) {
        return NetworkMapUtil.getDefaultNetworkMapFile(string);
    }

    private static void setDefaultMapSelected(String string) {
        preferences.setProperty(PREFS_CTC, PREFS_MAP_DEFAULT_SELECTED, string);
    }

    private static String getDefaultMapFromPrefs() {
        return preferences.getProperty(PREFS_CTC, PREFS_MAP_DEFAULT_SELECTED, null);
    }

    private static String getDefaultMapFromNe() {
        String string = null;
        try {
            if (NetworkModel.instance().getCmsHostModel().getDelegate() == null) {
                MapPersist.println("getDelegate() is null");
                return string;
            }
            string = NetworkModel.instance().getCmsHostModel().getDefaultValue("CTC.network.Map");
        }
        catch (NoSuchDefault noSuchDefault) {
            MapPersist.println("Caught NoSuchDefault exception");
        }
        catch (Exception exception) {
            MapPersist.println("Caught exception in getDefaultMapSelected()");
            MapPersist.println(exception);
        }
        return string;
    }

    private static String getNodeDesc(Node node, String string) {
        String string2 = null;
        if (db.on()) {
            if (node instanceof MapNode) {
                string2 = "node=" + MapPersist.getNodeName((MapNode)node);
            } else if (node instanceof MapDomain) {
                string2 = "domain=" + string;
            }
        }
        return string2;
    }

    public static int toNewX(int n) {
        int n2 = MapToolkit.getCanvasCenterX();
        return n2 + n;
    }

    public static int toNewY(int n) {
        int n2 = MapToolkit.getCanvasCenterY();
        return n2 - n;
    }

    public static int toOldX(int n) {
        int n2 = MapToolkit.getCanvasCenterX();
        return n - n2;
    }

    public static int toOldY(int n) {
        int n2 = MapToolkit.getCanvasCenterY();
        return n2 - n;
    }

    public static boolean getMapCoordinates(MapToolkit mapToolkit) {
        double d = -126.0;
        double d2 = -65.0;
        double d3 = 52.0;
        double d4 = 22.0;
        try {
            String string = preferences.getProperty(PREFS_CTC, PREFS_MAP_LEFT_LONG, null);
            d = new Double(string);
            string = preferences.getProperty(PREFS_CTC, PREFS_MAP_RIGHT_LONG, null);
            d2 = new Double(string);
            string = preferences.getProperty(PREFS_CTC, PREFS_MAP_TOP_LAT, null);
            d3 = new Double(string);
            string = preferences.getProperty(PREFS_CTC, PREFS_MAP_BOTTOM_LAT, null);
            d4 = new Double(string);
            if (d == d2) {
                db.warning("Preference longitudes cannot be equal!");
                double d5 = d2 = d > 0.0 ? d2 + 1.0 : d2 - 1.0;
            }
            if (d3 == d4) {
                db.warning("Preference latitudes cannot be equal!");
                d4 = d3 > 0.0 ? d4 + 1.0 : d4 - 1.0;
            }
        }
        catch (Exception exception) {
            d = -126.0;
            d2 = -65.0;
            d3 = 52.0;
            d4 = 22.0;
            preferences.setProperty(PREFS_CTC, PREFS_MAP_LEFT_LONG, String.valueOf(d));
            preferences.setProperty(PREFS_CTC, PREFS_MAP_RIGHT_LONG, String.valueOf(d2));
            preferences.setProperty(PREFS_CTC, PREFS_MAP_TOP_LAT, String.valueOf(d3));
            preferences.setProperty(PREFS_CTC, PREFS_MAP_BOTTOM_LAT, String.valueOf(d4));
        }
        if (MapPersist.db.on) {
            db.println("readMapCoordinates: leftLong=" + d + " topLat=" + d3 + " rightLong=" + d2 + " bootmLat=" + d4);
        }
        mapToolkit.setMapCoordinates(new Rectangle2D.Double(d, d3, d2, d4));
        return true;
    }

    private static void println(String string) {
        if (db.on()) {
            db.println(string);
        }
    }

    private static void println(Exception exception) {
        if (db.on()) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public boolean getThePersistProperty(Object object, int n) {
        return MapPersist.getPersistProperty(object, n);
    }

    public void setThePersistProperty(Object object, int n, String string, String string2) {
        MapPersist.setPersistProperty(object, n, string, string2);
    }

    public static class Debug
    extends SDebug {
        public Debug(String string) {
            super(string);
        }

        public final void dumpDomainMembership() {
            TreeMap<Object, TreeSet<Long>> treeMap = new TreeMap<Object, TreeSet<Long>>();
            int n = "ctc.map.".length();
            Enumeration enumeration = preferences.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("ctc.map") || !string.endsWith(".domain")) continue;
                int n2 = string.indexOf(".", n + 1);
                String string2 = string.substring(n, n2);
                Object object = preferences.getProperty(string.substring(0, 3), string.substring(4), null);
                long l = 0L;
                try {
                    l = Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.println("bad node-id in key of: " + string + "=" + (String)object);
                    Debug.printStackTrace((Throwable)numberFormatException);
                    continue;
                }
                TreeSet<Long> treeSet = (TreeSet<Long>)treeMap.get(object);
                if (treeSet == null) {
                    treeSet = new TreeSet<Long>();
                }
                treeSet.add(new Long(l));
                treeMap.put(object, treeSet);
            }
            for (String string : treeMap.keySet()) {
                this.println("");
                this.println(string);
                TreeSet treeSet = (TreeSet)treeMap.get(string);
                for (Object object : treeSet) {
                    this.println("  " + (Long)object);
                }
            }
        }

        public final void dump() {
            boolean bl = MapPersist.storeDomainInPrefs();
            this.println("persist storage mode: " + (bl ? "local" : "global"));
        }

        public final void domains() {
            Serializable serializable;
            Object object;
            Object object2;
            NodeModelComparator nodeModelComparator = NodeModelComparator.instance;
            Collection collection = Network.instance().getAllElements();
            TreeMap<String, TreeSet<NodeModel>> treeMap = new TreeMap<String, TreeSet<NodeModel>>();
            this.println("persisted domains for " + collection.size() + " nodes");
            for (Object object3 : collection) {
                object2 = object3.getNodeModel();
                object = MapPersist.getNodeDomain((INodeModel)object2);
                if (object == null || ((String)object).length() == 0) {
                    object = "root";
                }
                if ((serializable = (TreeSet<NodeModel>)treeMap.get(object)) == null) {
                    serializable = new TreeSet<NodeModel>(nodeModelComparator);
                    treeMap.put((String)object, (TreeSet<NodeModel>)serializable);
                }
                serializable.add((NodeModel)object2);
            }
            for (Object object3 : treeMap.keySet()) {
                object2 = (TreeSet)treeMap.get(object3);
                this.println("domain: " + (String)object3 + " with: " + ((TreeSet)object2).size() + " members");
                object = ((TreeSet)object2).iterator();
                while (object.hasNext()) {
                    serializable = (NodeModel)object.next();
                    this.println("  node: " + serializable.getName());
                }
            }
        }

        public final void localDomainSettings() {
            NodeModelComparator nodeModelComparator = NodeModelComparator.instance;
            Collection collection = Network.instance().getAllElements();
            for (INetElement iNetElement : collection) {
                String string;
                INodeModel iNodeModel = iNetElement.getNodeModel();
                String string2 = MapPersist.getLocalNodeDomainSetting(iNodeModel, string = MapPersist.getNodeDomain(iNodeModel));
                if (string2 == null) continue;
                this.println(string2);
            }
        }

        public final void neDomain(String string) throws NoSuchProperty {
            INetElement iNetElement = Network.instance().findNetElemByIp(string);
            if (iNetElement != null) {
                this.println("NE: " + string + " domain property: " + iNetElement.getNodeModel().getProperty(MapPersist.PREFS_DOMAIN));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class NodeModelComparator
        implements Comparator<NodeModel> {
            public static NodeModelComparator instance = new NodeModelComparator();

            private NodeModelComparator() {
            }

            @Override
            public int compare(NodeModel nodeModel, NodeModel nodeModel2) {
                return nodeModel.getName().compareTo(nodeModel2.getName());
            }
        }
    }
}

