/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.ppc.CombosCellRenderer;
import cerent.util.ComparisonUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RamanCardSelection
extends JPanel
implements ActionListener {
    public static final String CARD_ON_NODE = "Card on Node:  ";
    private DefaultComboBoxModel shelfModel;
    private DefaultComboBoxModel slotModel;
    private DefaultComboBoxModel portModel;
    private JComboBox shelfCB;
    private JComboBox slotCB;
    private JComboBox portCB;
    private TreeMap<Integer, TreeMap<IModuleModel, LinkedList<IEntityModel>>> portsMap = new TreeMap();
    private boolean isMS;
    protected GridBagConstraints gc;
    private JLabel nodeNameLabel;
    private static final Integer DUMMY_SHELF_ID = new Integer(0);

    public RamanCardSelection(String string, GridBagLayout gridBagLayout, boolean bl) {
        super(gridBagLayout);
        this.isMS = bl;
        this.gc = new GridBagConstraints();
        this.gc.fill = 1;
        this.gc.insets = new Insets(5, 5, 0, 0);
        this.gc.anchor = 18;
        this.gc.insets.bottom = 15;
        this.gc.insets.bottom = 0;
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.add(new JLabel(CARD_ON_NODE));
        this.gc.gridx = 1;
        this.nodeNameLabel = new JLabel(string);
        this.add(this.nodeNameLabel);
        this.gc.gridx = 0;
        ++this.gc.gridy;
        this.add((Component)new JLabel("Shelf: "), this.gc);
        this.gc.gridx = 1;
        this.shelfModel = new DefaultComboBoxModel();
        this.shelfCB = this.addCB(this.shelfModel, this.gc, false, this);
        if (!bl) {
            this.shelfCB.setVisible(false);
        }
        this.gc.gridx = 0;
        ++this.gc.gridy;
        this.add((Component)new JLabel("Slot: "), this.gc);
        this.gc.gridx = 1;
        this.slotModel = new DefaultComboBoxModel();
        this.slotCB = this.addCB(this.slotModel, this.gc, false, this);
        this.gc.gridx = 0;
        ++this.gc.gridy;
        this.add((Component)new JLabel("Port: "), this.gc);
        this.gc.gridx = 1;
        this.portModel = new DefaultComboBoxModel();
        this.portCB = this.addCB(this.portModel, this.gc, false, this);
    }

    public void getStatusComponent(ArrayList arrayList) {
        if (this.isMS) {
            arrayList.add(new String[]{"Shelf: ", this.getSelectedShelf().toString()});
        }
        arrayList.add(new String[]{"Slot: ", CombosCellRenderer.toString(this.getSelectedModuleModel())});
        arrayList.add(new String[]{"Port: ", CombosCellRenderer.toString(this.getSelectedPort(), false)});
    }

    public Integer getSelectedShelf() {
        return (Integer)this.shelfCB.getSelectedItem();
    }

    public IEntityModel getSelectedPort() {
        return (IEntityModel)this.portCB.getSelectedItem();
    }

    public IModuleModel getSelectedModuleModel() {
        return ((IEntityModel)this.portCB.getSelectedItem()).getModuleModel();
    }

    private JComboBox addCB(DefaultComboBoxModel defaultComboBoxModel, GridBagConstraints gridBagConstraints, boolean bl, JPanel jPanel) {
        JComboBox jComboBox = new JComboBox(defaultComboBoxModel){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 160;
                return dimension;
            }
        };
        jComboBox.setRenderer(new CombosCellRenderer(bl));
        jComboBox.addActionListener(this);
        jPanel.add((Component)jComboBox, gridBagConstraints);
        return jComboBox;
    }

    public void initModel(ArrayList<IEntityModel[]> arrayList, boolean bl) {
        int n = arrayList.size();
        ArrayList<IEntityModel> arrayList2 = new ArrayList<IEntityModel>();
        for (IEntityModel[] iEntityModelArray : arrayList) {
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                arrayList2.add(iEntityModelArray[i]);
            }
        }
        Iterator<Object> iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            this.initModel((IEntityModel)iterator.next(), bl);
        }
        if (!bl) {
            this.shelfCB.setEnabled(false);
        }
        if (arrayList2.size() > 0) {
            this.loadShelf(this.getShelfId((IEntityModel)arrayList2.get(0)));
        }
    }

    public void initModel(IEntityModel[] iEntityModelArray, boolean bl) {
        this.portsMap.clear();
        this.isMS = bl;
        this.shelfModel.removeAllElements();
        if (bl) {
            this.shelfCB.setVisible(true);
        }
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            IEntityModel iEntityModel = iEntityModelArray[i];
            this.initModel(iEntityModel, bl);
        }
        if (!bl) {
            this.shelfCB.setEnabled(false);
        }
        if (iEntityModelArray.length > 0) {
            this.loadShelf(this.getShelfId(iEntityModelArray[0]));
        }
    }

    private void initModel(IEntityModel iEntityModel, boolean bl) {
        LinkedList<Object> linkedList;
        Integer n = this.getShelfId(iEntityModel);
        if (bl && this.shelfModel.getIndexOf(n) == -1) {
            this.shelfModel.addElement(n);
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        TreeMap<IModuleModel, LinkedList<Object>> treeMap = this.portsMap.get(n);
        if (treeMap == null) {
            treeMap = new TreeMap(new CardComparator());
            this.portsMap.put(n, treeMap);
        }
        if ((linkedList = treeMap.get(iModuleModel)) == null) {
            linkedList = new LinkedList();
            treeMap.put(iModuleModel, linkedList);
        }
        linkedList.add(iEntityModel);
    }

    private void loadShelf(Integer n) {
        this.slotModel.removeAllElements();
        this.portModel.removeAllElements();
        if (n != null) {
            TreeMap<IModuleModel, LinkedList<IEntityModel>> treeMap = this.portsMap.get(n);
            if (treeMap == null) {
                return;
            }
            Object[] objectArray = treeMap.keySet().toArray(new IModuleModel[0]);
            this.loadModel(this.slotModel, objectArray);
            this.slotCB.setEnabled(true);
            if (objectArray.length > 0) {
                this.loadSlot((IModuleModel)objectArray[0]);
            }
        } else {
            this.slotCB.setEnabled(false);
            this.portCB.setEnabled(false);
        }
    }

    private void loadModel(DefaultComboBoxModel defaultComboBoxModel, Object[] objectArray) {
        defaultComboBoxModel.removeAllElements();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultComboBoxModel.addElement(objectArray[i]);
        }
    }

    private void loadSlot(IModuleModel iModuleModel) {
        if (iModuleModel != null) {
            Integer n = this.getShelfId((IEntityModel)iModuleModel);
            TreeMap<IModuleModel, LinkedList<IEntityModel>> treeMap = this.portsMap.get(n);
            Object[] objectArray = treeMap.get(iModuleModel).toArray(new IEntityModel[0]);
            this.loadModel(this.portModel, objectArray);
            this.portCB.setEnabled(true);
        } else {
            this.portModel.removeAllElements();
            this.portCB.setEnabled(false);
        }
    }

    private Integer getShelfId(IEntityModel iEntityModel) {
        if (this.isMS) {
            return iEntityModel.getShelfId();
        }
        return DUMMY_SHELF_ID;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.shelfCB) {
            this.loadShelf((Integer)this.shelfCB.getSelectedItem());
        } else if (object == this.slotCB) {
            this.loadSlot((IModuleModel)this.slotCB.getSelectedItem());
        }
    }

    public static boolean isMultishelf(INodeModel iNodeModel) {
        return iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf();
    }

    public void setEnableAll(boolean bl) {
        if (!this.isMS) {
            this.shelfCB.setEnabled(bl);
        }
        this.slotCB.setEnabled(bl);
        this.portCB.setEnabled(bl);
    }

    public String getNodeName() {
        return this.nodeNameLabel.getText();
    }

    public void setNodeStr(String string) {
        this.nodeNameLabel.setText(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CardComparator
    implements Comparator<IModuleModel> {
        CardComparator() {
        }

        @Override
        public int compare(IModuleModel iModuleModel, IModuleModel iModuleModel2) {
            return ComparisonUtil.compare((int)iModuleModel.getSlot(), (int)iModuleModel2.getSlot());
        }
    }
}

