/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRamanDayZeroOperation;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.network.raman.RamanAttribute;
import cerent.cms.ui.network.raman.RamanCardSelection;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.network.raman.RamanDayZeroInfo;
import cerent.cms.ui.network.raman.RamanDayZeroWzPane;
import cerent.cms.ui.ppc.PPCHelper;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RamanDayZeroSrcPane
extends RamanDayZeroWzPane {
    private final String[] label = new String[]{"Start Node: ", "End Node: "};
    private UComboBox nodeListStart;
    private UComboBox nodeListEnd;
    private IntLambdaPane lambdaAttr = null;
    private TxpPane txpContainer;
    private String nextPage = "Calibrate Raman";
    private JCheckBox biDirectional;
    private JCheckBox dmuxPresent;
    private JCheckBox autoRun;
    private JCheckBox autoSkip;
    private JCheckBox evenSelection;
    private final String hintsStr = "Before starting:\n1) Verify that ANS has been launched on all NEs.\n2) Ensure that the selected TXP is tuned in \"First Tunable Wavelength\".\n3) In a single source NE ensure that it is correctly connected to the Booster.\n   In a double source NE ensure that both the select TXP are well connected \n   to the MUX/DMUX .\n\n";
    private GridBagConstraints nodePresentationGc;
    private JPanel nodePresentationPane;
    private boolean alreadySkip;
    private boolean clearedHistory = false;

    public RamanDayZeroSrcPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string, RamanDayZeroInfo ramanDayZeroInfo) {
        super(wzDialog, wzDiagDebug, string, ramanDayZeroInfo);
    }

    public void validatePage() throws Exception {
        if (this.info.isAutoSkip() && !this.info.getEndNode().lineNeedToBeTuned(this.info)) {
            try {
                if (!this.alreadySkip) {
                    while (!this.info.setNextCurrentNode(0)) {
                        this.alreadySkip = true;
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.nextPage = this.goOn();
            }
        }
        if (((RamanDayZeroDialog)this.parent).startedFromLink()) {
            this.info.setStartNode((RamanAttribute)this.nodeListStart.getSelectedItem());
            this.info.setEndNode((RamanAttribute)this.nodeListEnd.getSelectedItem());
        }
        if (this.info.getTestIndex() == 0) {
            if (this.info.isInReturn()) {
                this.info.setNeedReturn(false);
            } else {
                this.info.setNeedReturn(this.biDirectional.isSelected());
            }
            this.info.setDmuxPresent(this.dmuxPresent.isSelected());
        }
        this.txpContainer.setTrunkCurrentTest();
        ((RamanDayZeroDialog)this.parent).setAutoRun(this.autoRun.isSelected());
    }

    private String goOn() {
        if (this.info.allNodesCalibrated()) {
            if (this.biDirectional.isSelected()) {
                return this.info.prepareBackPath((IRamanDayZeroOperation)this.parent, true);
            }
            ((RamanDayZeroDialog)this.parent).setFinishEnabled(true);
            ((RamanDayZeroDialog)this.parent).nextButtonEnable(false);
            return "Accept Result";
        }
        return "Setting Parameters";
    }

    protected String getNextPaneName() {
        return this.nextPage;
    }

    public boolean handleBack() {
        boolean bl = super.handleBack();
        this.info.decTest();
        Map map = RamanDayZeroSrcPane.setPortService(this.info.getTrunkCurrentTest(), 1);
        if (map.size() > 0) {
            this.nextPage = "Error Page";
            this.info.setErrorPane(this.getName(), 12);
        }
        return bl;
    }

    protected void initPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.nodesPane();
        this.setNodeModelList();
        if (((RamanDayZeroDialog)this.parent).startedFromLink()) {
            this.info.setStartNode((RamanAttribute)this.nodeListStart.getSelectedItem());
            this.info.setEndNode((RamanAttribute)this.nodeListEnd.getSelectedItem());
        }
        this.add(this.labelButtonResultPane("Before starting:\n1) Verify that ANS has been launched on all NEs.\n2) Ensure that the selected TXP is tuned in \"First Tunable Wavelength\".\n3) In a single source NE ensure that it is correctly connected to the Booster.\n   In a double source NE ensure that both the select TXP are well connected \n   to the MUX/DMUX .\n\n"));
        this.buttonPane();
        this.txpPane(this.evenSelection.isSelected(), false);
    }

    private void buttonPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.biDirectional = new JCheckBox("Bidirectional Path");
        this.biDirectional.setMnemonic('R');
        jPanel.add((Component)this.biDirectional, gridBagConstraints);
        this.biDirectional.addActionListener(this);
        ++gridBagConstraints.gridx;
        this.dmuxPresent = new JCheckBox("MUX/DMUX Present");
        this.dmuxPresent.setMnemonic('P');
        jPanel.add((Component)this.dmuxPresent, gridBagConstraints);
        this.dmuxPresent.addActionListener(this);
        ++gridBagConstraints.gridx;
        this.evenSelection = new JCheckBox("Even Band");
        this.evenSelection.setMnemonic('E');
        jPanel.add((Component)this.evenSelection, gridBagConstraints);
        this.evenSelection.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.autoRun = new JCheckBox("AutoRun wizard");
        this.autoRun.setMnemonic('A');
        jPanel.add((Component)this.autoRun, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        this.autoSkip = new JCheckBox("Auto Skip Tune Path");
        this.autoSkip.setMnemonic('S');
        jPanel.add((Component)this.autoSkip, gridBagConstraints);
        this.autoSkip.addActionListener(this);
        if (this.info != null) {
            this.autoSkip.setSelected(this.info.isAutoSkip());
        }
        this.add(jPanel);
    }

    private void txpPane(boolean bl, boolean bl2) {
        this.txpContainer = new TxpPane(new GridBagLayout(), bl);
        this.add(this.txpContainer);
        this.txpContainer.init(bl2);
    }

    private void nodesPane() {
        this.nodePresentationPane = new JPanel(new GridBagLayout());
        this.nodePresentationGc = new GridBagConstraints();
        this.nodePresentationGc.gridx = 0;
        this.nodePresentationGc.gridy = 0;
        this.nodePresentationGc.fill = 1;
        this.nodePresentationGc.insets = new Insets(5, 5, 0, 0);
        this.nodePresentationGc.anchor = 18;
        this.nodePresentationPane.add((Component)new JLabel(this.label[0]), this.nodePresentationGc);
        this.nodePresentationGc.gridx = 1;
        this.nodeListStart = new UComboBox();
        this.nodePresentationPane.add((Component)this.nodeListStart, this.nodePresentationGc);
        this.nodePresentationGc.gridx = 0;
        this.nodePresentationGc.gridy += 2;
        this.nodePresentationPane.add((Component)new JLabel(this.label[1]), this.nodePresentationGc);
        this.nodePresentationGc.gridx = 1;
        this.nodeListEnd = new UComboBox();
        this.nodePresentationPane.add((Component)this.nodeListEnd, this.nodePresentationGc);
        this.nodePresentationGc.gridx = 0;
        this.nodePresentationGc.gridy += 2;
        this.nodeListEnd.setEnabled(false);
        if (!((RamanDayZeroDialog)this.parent).startedFromLink()) {
            this.nodeListStart.setEnabled(false);
        } else {
            this.nodeListStart.addActionListener((ActionListener)this);
        }
        this.add(this.nodePresentationPane);
    }

    public void enteringPane() {
        super.enteringPane();
        this.alreadySkip = false;
        this.setNodeModelList();
        this.lambdaAttr.setLambdaTest(this.info.getTestIndex());
        this.info.setTxpLambdaCurrentTest(this.lambdaAttr.getSelectedLambda());
        if (this.info.needTxpSelection() && !this.info.isInReturn()) {
            if (this.info.getTestIndex() == 0) {
                this.hintVisible(true);
                this.initTxpPane(this.evenSelection.isSelected(), false);
                if (this.dmuxPresent.isSelected()) {
                    this.txpContainer.setVisible(true, 2);
                }
            }
            if (this.info.getTestIndex() > 0) {
                this.txpContainer.setVisible(false, 0);
                this.biDirectional.setEnabled(false);
                this.dmuxPresent.setEnabled(false);
                this.evenSelection.setEnabled(false);
                this.hintVisible(false);
                this.autoSkip.setEnabled(false);
            }
        } else {
            this.txpContainer.setVisible(false, 0);
            if (this.info.getTestIndex() == 0) {
                this.autoSkip.setEnabled(true);
                if (this.info.isInReturn() && !this.clearedHistory) {
                    ((RamanDayZeroDialog)this.parent).clearStatusHistory();
                    this.clearedHistory = true;
                }
            }
        }
        ((RamanDayZeroDialog)this.parent).nextButtonEnable(true, this.autoRun.isSelected());
    }

    private void initTxpPane(boolean bl, boolean bl2) {
        this.remove(this.txpContainer);
        this.txpPane(bl, bl2);
    }

    private void setNodeModelList() {
        RamanAttribute[] ramanAttributeArray = ((RamanDayZeroDialog)this.parent).getNodeList();
        boolean bl = ((RamanDayZeroDialog)this.parent).startedFromLink();
        if (this.info.getTestIndex() < 1) {
            if (ramanAttributeArray.length == 2) {
                RamanAttribute[] ramanAttributeArray2 = new RamanAttribute[]{ramanAttributeArray[1], ramanAttributeArray[0]};
                this.nodeListStart.setModel(new DefaultComboBoxModel<RamanAttribute>(ramanAttributeArray));
                this.nodeListEnd.setModel(new DefaultComboBoxModel<RamanAttribute>(ramanAttributeArray2));
            } else {
                this.nodeListStart.setModel(new DefaultComboBoxModel<RamanAttribute>(((RamanDayZeroDialog)this.parent).getNodeList()));
                this.nodeListEnd.setModel(new DefaultComboBoxModel<RamanAttribute>(((RamanDayZeroDialog)this.parent).getNodeList()));
            }
            if (!bl) {
                this.nodeListStart.setEnabled(false);
                this.nodeListEnd.setEnabled(false);
            }
        } else {
            this.nodeListStart.setEnabled(false);
            this.nodeListEnd.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.dmuxPresent) {
            if (this.dmuxPresent.isSelected()) {
                this.txpContainer.setVisible(true, 2);
            } else {
                this.txpContainer.setVisible(false, 2);
            }
        } else if (object == this.biDirectional) {
            if (this.biDirectional.isSelected()) {
                this.txpContainer.setVisible(true, 4);
            } else {
                this.txpContainer.setVisible(false, 3);
            }
        } else if (object == this.nodeListStart) {
            int n = this.nodeListStart.getSelectedIndex();
            this.nodeListEnd.setSelectedIndex(n);
            RamanAttribute ramanAttribute = this.info.getStartNode();
            this.info.setStartNode(this.info.getEndNode());
            this.info.setEndNode(ramanAttribute);
            this.initTxpPane(this.evenSelection.isSelected(), false);
        } else if (object == this.autoSkip) {
            this.info.setAutoSkip(this.autoSkip.isSelected());
        } else if (object == this.evenSelection) {
            this.initTxpPane(this.evenSelection.isSelected(), true);
            if (this.dmuxPresent.isSelected()) {
                this.txpContainer.setVisible(true, 2);
            } else {
                this.txpContainer.setVisible(false, 2);
            }
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.RamanDay0InstallationConfigDlg;
    }

    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{this.label[0], this.info.getStartNode().getName()});
        arrayList.add(new String[]{this.label[1], this.info.getEndNode().getName()});
        String string = this.biDirectional.isSelected() ? "Doing the back Path" : "End of Wizard";
        arrayList.add(new String[]{string, ""});
        this.txpContainer.getStatusComponent(arrayList);
        if (this.nextPage.equals("Calibrate Raman")) {
            arrayList.add(new String[]{"Selected Lambda: ", Wavelength.getWavelengthStringFromWavelength(this.info.getTxpLambdaCurrentTest())});
            return RamanDayZeroSrcPane.getGridPanel(arrayList);
        }
        return super.getStatusComponent();
    }

    public static Map setPortService(IEntityModel iEntityModel, int n) {
        if (iEntityModel == null) {
            return new HashMap();
        }
        IPortModel[] iPortModelArray = new IPortModel[]{(IPortModel)iEntityModel};
        HashMap hashMap = new HashMap();
        NetCircuitModel.setUnusedPortsState(iPortModelArray, n, hashMap);
        return hashMap;
    }

    public void recovery() {
        if (!this.alreadyRecovered) {
            this.alreadyRecovered = true;
            if (this.txpContainer != null) {
                RamanDayZeroDialog.restoreRaman(this.info, (IRamanDayZeroOperation)this.parent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TxpPane
    extends JPanel {
        private static final int ALL = 0;
        private static final int AMPLI = 1;
        private static final int MUXD_MUX = 2;
        private static final int ONE_GO = 3;
        private static final int BIDI = 4;
        private RamanCardSelection txpSingleGoPane;
        private RamanCardSelection txpSingleBackPane;
        private RamanCardSelection txpDwdmGoPane;
        private RamanCardSelection txpDwdmBackPane;
        private RamanCardSelection selected;
        private RamanAttribute endNode;
        private RamanAttribute startNode;
        private int band;

        public TxpPane(GridBagLayout gridBagLayout, boolean bl) {
            super(gridBagLayout);
            this.band = bl ? 1 : 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.startNode = RamanDayZeroSrcPane.this.info.getStartNode();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.anchor = 18;
            boolean bl2 = RamanCardSelection.isMultishelf(this.startNode.getNode());
            this.txpSingleGoPane = new RamanCardSelection(this.startNode.getName(), new GridBagLayout(), bl2);
            this.txpDwdmGoPane = new RamanCardSelection(this.startNode.getName(), new GridBagLayout(), bl2);
            ArrayList<RamanAttribute> arrayList = RamanDayZeroSrcPane.this.info.getAllMiddleNodes();
            this.endNode = arrayList.size() > 0 ? arrayList.get(arrayList.size() - 1) : RamanDayZeroSrcPane.this.info.getEndNode();
            bl2 = RamanCardSelection.isMultishelf(this.endNode.getNode());
            this.txpSingleBackPane = new RamanCardSelection(this.endNode.getName(), new GridBagLayout(), bl2);
            this.txpDwdmBackPane = new RamanCardSelection(this.endNode.getName(), new GridBagLayout(), bl2);
            this.add((Component)this.txpSingleGoPane, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add((Component)this.txpDwdmGoPane, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            this.add((Component)this.txpSingleBackPane, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.add((Component)this.txpDwdmBackPane, gridBagConstraints);
            this.txpDwdmGoPane.setVisible(false);
            this.txpSingleBackPane.setVisible(false);
            this.txpDwdmBackPane.setVisible(false);
        }

        private void getStatusComponent(ArrayList<String[]> arrayList) {
            String string = RamanDayZeroSrcPane.this.dmuxPresent.isSelected() ? "Mux/Dmux present" : "Mux/Dmux not present";
            this.selected.getStatusComponent(arrayList);
            arrayList.add(new String[]{string, ""});
        }

        private void setTrunkCurrentTest() {
            IEntityModel iEntityModel;
            this.selected = !RamanDayZeroSrcPane.this.info.isInReturn() ? this.txpSingleGoPane : this.txpSingleBackPane;
            if (RamanDayZeroSrcPane.this.info.isDmuxPresent() && RamanDayZeroSrcPane.this.info.getTestIndex() > 0) {
                this.selected = !RamanDayZeroSrcPane.this.info.isInReturn() ? this.txpDwdmGoPane : this.txpDwdmBackPane;
            }
            if ((iEntityModel = this.selected.getSelectedPort()) == null) {
                RamanDayZeroSrcPane.this.nextPage = "Error Page";
                RamanDayZeroSrcPane.this.info.setErrorPane(this.getName(), 13);
                return;
            }
            RamanDayZeroSrcPane.this.info.setTrunkCurrentTest(iEntityModel);
        }

        private void setVisible(boolean bl, int n) {
            switch (n) {
                case 0: {
                    this.txpSingleGoPane.setVisible(bl);
                    this.txpDwdmGoPane.setVisible(bl);
                    this.txpSingleBackPane.setVisible(bl);
                    this.txpDwdmBackPane.setVisible(bl);
                    break;
                }
                case 2: {
                    this.txpDwdmGoPane.setVisible(bl);
                    if (!RamanDayZeroSrcPane.this.biDirectional.isSelected()) break;
                    this.txpDwdmBackPane.setVisible(bl);
                    break;
                }
                case 1: {
                    this.txpSingleGoPane.setVisible(bl);
                    break;
                }
                case 3: 
                case 4: {
                    this.txpSingleBackPane.setVisible(bl);
                    if (!RamanDayZeroSrcPane.this.dmuxPresent.isSelected()) break;
                    this.txpDwdmBackPane.setVisible(bl);
                }
            }
        }

        private void init(boolean bl) {
            ArrayList<IEntityModel[]> arrayList = new ArrayList<IEntityModel[]>();
            ArrayList<IEntityModel[]> arrayList2 = new ArrayList<IEntityModel[]>();
            if (RamanDayZeroSrcPane.this.lambdaAttr == null) {
                RamanDayZeroSrcPane.this.lambdaAttr = new IntLambdaPane();
            }
            if (bl) {
                this.band = 0;
                if (RamanDayZeroSrcPane.this.evenSelection.isSelected()) {
                    this.band = 1;
                }
                RamanDayZeroSrcPane.this.lambdaAttr.changeLambdaCombo(this.band);
            }
            RamanDayZeroSrcPane.this.lambdaAttr.setLambdaTest(RamanDayZeroSrcPane.this.info.getTestIndex());
            RamanDayZeroSrcPane.this.info.setTxpLambdaCurrentTest(RamanDayZeroSrcPane.this.lambdaAttr.getSelectedLambda());
            boolean bl2 = RamanCardSelection.isMultishelf(this.startNode.getNode());
            boolean bl3 = RamanCardSelection.isMultishelf(this.endNode.getNode());
            arrayList.add(PPCHelper.getBidiPorts(this.startNode.getNode(), RamanDayZeroInfo.lambdas[this.band][0].getIntValue()));
            arrayList.add(PPCHelper.getBidiPorts(this.startNode.getNode(), RamanDayZeroInfo.lambdas[this.band][1].getIntValue()));
            this.txpSingleGoPane.initModel(arrayList, bl2);
            this.txpDwdmGoPane.initModel(arrayList, bl2);
            arrayList2.add(PPCHelper.getBidiPorts(this.endNode.getNode(), RamanDayZeroInfo.lambdas[this.band][0].getIntValue()));
            arrayList2.add(PPCHelper.getBidiPorts(this.endNode.getNode(), RamanDayZeroInfo.lambdas[this.band][1].getIntValue()));
            this.txpSingleBackPane.initModel(arrayList2, bl3);
            this.txpDwdmBackPane.initModel(arrayList2, bl3);
        }
    }

    class IntLambdaPane {
        private JPanel p;
        private UComboBox lambdaList;

        public IntLambdaPane() {
            RamanDayZeroSrcPane.this.nodePresentationPane.add((Component)new JLabel("Wavelength:"), RamanDayZeroSrcPane.this.nodePresentationGc);
            ((RamanDayZeroSrcPane)RamanDayZeroSrcPane.this).nodePresentationGc.gridx = 1;
            int n = 0;
            if (RamanDayZeroSrcPane.this.evenSelection.isSelected()) {
                n = 1;
            }
            this.lambdaList = new UComboBox(RamanDayZeroInfo.lambdas[n]);
            this.lambdaList.setEnabled(false);
            RamanDayZeroSrcPane.this.nodePresentationPane.add((Component)this.lambdaList, RamanDayZeroSrcPane.this.nodePresentationGc);
            ((RamanDayZeroSrcPane)RamanDayZeroSrcPane.this).nodePresentationGc.gridx = 0;
            ((RamanDayZeroSrcPane)RamanDayZeroSrcPane.this).nodePresentationGc.gridy += 2;
        }

        public void setLambdaTest(int n) {
            this.lambdaList.setSelectedIndex(n);
        }

        public int getSelectedLambda() {
            return ((Attribute)this.lambdaList.getSelectedItem()).getIntValue();
        }

        public void changeLambdaCombo(int n) {
            this.lambdaList.removeAll();
            for (int i = 0; i < 2; ++i) {
                this.lambdaList.insertItemAt((Object)RamanDayZeroInfo.lambdas[n][i], i);
            }
        }

        JPanel getUI() {
            return this.p;
        }
    }
}

