/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.network.MapLinkRenderer;
import cerent.cms.ui.network.NetMapLink;
import cerent.cms.ui.network.RamanNetworkMap;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.network.raman.RamanDayZeroInfo;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.gui.OrderedListListener;
import cerent.util.gui.OrderedListModel;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public abstract class RamanPathPane
extends WzPane
implements OrderedListListener {
    private static final String INCLUDE = "Include";
    private static final String INCLUDED_SPAN = "Included span: ";
    protected RamanDayZeroInfo info;
    private JButton includeButton;
    private JSplitPane constraintsSp;
    protected OrderedListModelOrganizer nodesModelOrg;
    private MapLink linkSelected;
    private boolean advised = false;
    protected RamanNetworkMap circuitMap;
    protected JPanel bottomPanel;
    protected JSplitPane mainSplitPane;
    protected AbstractButton removeButton;
    protected JPanel topPanel;
    private JCheckBox autoSkip;

    public abstract void validatePage() throws Exception;

    protected abstract void initPane();

    protected abstract String getNextPaneName();

    public RamanPathPane(RamanDayZeroDialog ramanDayZeroDialog, WzDiagDebug wzDiagDebug, String string) {
        super(ramanDayZeroDialog, wzDiagDebug, string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.includeButton) {
            this.includePath();
        } else if (object == this.autoSkip) {
            this.info.setAutoSkip(this.autoSkip.isSelected());
        }
    }

    public void includePath() {
        INetLink iNetLink;
        INetLink iNetLink2 = this.getNetElement(this.linkSelected);
        if (iNetLink2 instanceof VirtualNetLink) {
            VirtualNetLink virtualNetLink = (VirtualNetLink)iNetLink2;
            iNetLink = this.isLinked(virtualNetLink, 0);
        } else {
            iNetLink = this.isLinked(iNetLink2);
        }
        if (iNetLink != null && !this.nodesModelOrg.contains(iNetLink)) {
            this.nodesModelOrg.addIncluded(iNetLink);
        }
    }

    private INetLink isLinked(VirtualNetLink virtualNetLink, int n) {
        if (n > 1) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_WRONG_LINKED_PATH, (Object)this.info.getStartNode().getNode().getName());
            return null;
        }
        INetLink iNetLink = virtualNetLink.getReverseLink();
        INetLink iNetLink2 = this.nodesModelOrg.getLastIncluded();
        INodeModel iNodeModel = this.info.getStartNode().getNode();
        if (iNetLink2 == null) {
            if (iNodeModel == virtualNetLink.getSrc().getNodeModel()) {
                return virtualNetLink;
            }
            return this.isLinked((VirtualNetLink)iNetLink, ++n);
        }
        if (iNetLink2.getDst() == virtualNetLink.getSrc()) {
            return virtualNetLink;
        }
        return this.isLinked((VirtualNetLink)iNetLink, ++n);
    }

    private INetLink isLinked(INetLink iNetLink) {
        boolean bl;
        INetLink iNetLink2 = this.nodesModelOrg.getLastIncluded();
        INodeModel iNodeModel = this.info.getStartNode().getNode();
        if (iNetLink2 == null) {
            if (iNodeModel == iNetLink.getSrc().getNodeModel()) {
                return iNetLink;
            }
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_WRONG_FIRST_PATH, (Object)this.info.getStartNode().getNode().getName());
            return null;
        }
        boolean bl2 = iNetLink2.getDst() == iNetLink.getSrc();
        boolean bl3 = bl = bl2 && iNetLink2.getSrc() == iNetLink.getDst();
        if (bl2 && !bl) {
            return iNetLink;
        }
        ErrorMsg.displayError((Component)this, (EID)NEMC.EID_WRONG_LINKED_PATH, (Object)this.info.getStartNode().getNode().getName());
        return null;
    }

    private INetLink getNetElement(MapLink mapLink) {
        if (mapLink instanceof NetMapLink) {
            NetMapLink netMapLink = (NetMapLink)mapLink;
            return (INetLink)netMapLink.getUserObject();
        }
        return null;
    }

    public void linkSelected(MapLink mapLink, boolean bl) {
        this.linkSelected = bl ? mapLink : null;
        this.includeButton.setEnabled(this.linkSelected != null);
    }

    public void nodeSelected(MapNode mapNode, boolean bl) {
        if (bl && !this.advised) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NODE_NOT_ALLOWED, (Object)"Only the Span between the nodes are selectable");
            this.advised = true;
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.RamanDay0InstallationRouteConfigConfigDlg;
    }

    public void selectionChanged(Object object, Object object2) {
    }

    public void orderSwapped(Object object, Object object2) {
    }

    public void entryRemoved(Object object) {
    }

    protected void setupPanels() {
        this.setLayout(new BorderLayout(1, 1));
        this.mainSplitPane = new JSplitPane(0);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.bottomPanel = this.getBottomPanel();
        this.mainSplitPane.setBottomComponent(this.bottomPanel);
    }

    protected JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getButtonPanel(), "East");
        jPanel.add((Component)this.getNodesPanel(), "Center");
        return jPanel;
    }

    private JPanel getNodesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.constraintsSp = new JSplitPane(1);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(INCLUDED_SPAN));
        jPanel2.add((Component)new JScrollPane(this.nodesModelOrg.getIncludedList()), "Center");
        this.constraintsSp.setLeftComponent(jPanel2);
        jPanel.add((Component)this.constraintsSp, "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 25, 0, 25, 0, 0, 0, 25, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0E-4};
        String string = "Starting from:" + this.info.getStartNode().getNode().getName();
        this.addAndSetButton(jPanel, new JLabel(string), null, 1, true);
        this.includeButton = new JButton(INCLUDE);
        this.addAndSetButton(jPanel, this.includeButton, null, 4, false);
        this.nodesModelOrg = new OrderedListModelOrganizer(this);
        this.removeButton = this.nodesModelOrg.getButton("Remove");
        this.addAndSetButton(jPanel, this.removeButton, null, 6, false);
        return jPanel;
    }

    private void addAndSetButton(JPanel jPanel, JComponent jComponent, String string, int n, boolean bl) {
        if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).setHorizontalAlignment(0);
            jComponent.setEnabled(bl);
            ((AbstractButton)jComponent).addActionListener(this);
        } else {
            ((JLabel)jComponent).setHorizontalAlignment(0);
            jComponent.setEnabled(bl);
        }
        if (string != null) {
            jComponent.setToolTipText(string);
        }
        jPanel.add((Component)jComponent, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    public void enteringPane() {
        super.enteringPane();
        if (this.circuitMap == null) {
            this.circuitMap = new RamanNetworkMap((RamanDayZeroDialog)this.parent, this);
        }
        this.circuitMap.reInitMap();
        this.circuitMap.showCircuitObjects();
        JComponent jComponent = this.circuitMap.getGraphWindow();
        jComponent.setBorder(BorderFactory.createLoweredBevelBorder());
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.add((Component)jComponent, "Center");
        this.mainSplitPane.setTopComponent(this.topPanel);
        this.add((Component)this.mainSplitPane, "Center");
    }

    private static class SidesConstraintsHolder {
        private ISideModel sideIn;
        private ISideModel sideOut;

        SidesConstraintsHolder(ISideModel iSideModel, ISideModel iSideModel2) {
            this.sideIn = iSideModel;
            this.sideOut = iSideModel2;
        }

        public ISideModel getSideIn() {
            return this.sideIn;
        }

        public ISideModel getSideOut() {
            return this.sideOut;
        }

        public boolean equals(Object object) {
            if (object instanceof SidesConstraintsHolder) {
                SidesConstraintsHolder sidesConstraintsHolder = (SidesConstraintsHolder)object;
                return sidesConstraintsHolder.sideIn.equals(this.sideIn) && sidesConstraintsHolder.sideOut.equals(this.sideOut);
            }
            return false;
        }
    }

    protected class OrderedListModelOrganizer
    implements OrderedListListener,
    ActionListener {
        private OrderedListModel includedModel;
        private INetLink[] savedIncludedLinks;
        private OrderedListListener listener;

        public OrderedListModelOrganizer(OrderedListListener orderedListListener) {
            this.listener = orderedListListener;
            this.includedModel = new OrderedListModel(this, true);
            this.savedIncludedLinks = new INetLink[0];
            this.initButton("Up");
            this.initButton("Down");
            this.initButton("Remove");
        }

        public void saveLists() {
            this.savedIncludedLinks = this.getIncludedLinks();
        }

        void restoreLists() {
            this.includedModel.clearAll();
            for (int i = 0; i < this.savedIncludedLinks.length; ++i) {
                this.addIncluded(this.savedIncludedLinks[i]);
            }
            ((RamanDayZeroDialog)RamanPathPane.this.parent).nextButtonEnable(false);
        }

        boolean anyChange() {
            INetLink[] iNetLinkArray = this.getIncludedLinks();
            if (iNetLinkArray.length != this.savedIncludedLinks.length) {
                return true;
            }
            for (int i = 0; i < iNetLinkArray.length; ++i) {
                if (iNetLinkArray[i].getLinkModel().getIndex() == this.savedIncludedLinks[i].getLinkModel().getIndex()) continue;
                return true;
            }
            return false;
        }

        private void initButton(String string) {
            AbstractButton abstractButton = this.getButton(string);
            if (abstractButton != null) {
                ActionListener[] actionListenerArray = abstractButton.getActionListeners();
                for (int i = 0; i < actionListenerArray.length; ++i) {
                    abstractButton.removeActionListener(actionListenerArray[i]);
                }
                abstractButton.addActionListener(this);
            }
        }

        public int getSelectedIndex() {
            return this.getIncludedList().getSelectedIndex();
        }

        public INetLink getLastIncluded() {
            this.savedIncludedLinks = this.getIncludedLinks();
            if (this.savedIncludedLinks.length == 0) {
                return null;
            }
            return this.savedIncludedLinks[this.includedModel.getSize() - 1];
        }

        public INetLink getFirstIncluded() {
            this.savedIncludedLinks = this.getIncludedLinks();
            if (this.savedIncludedLinks.length == 0) {
                return null;
            }
            return this.savedIncludedLinks[0];
        }

        public void syncButtons() {
            int n = this.getSelectedIndex();
            this.getButton("Remove").setEnabled(n >= 0);
            this.getButton("Up").setEnabled(n > 0);
            this.getButton("Down").setEnabled(n >= 0 && n < this.getSizeOfSelectedList() - 1);
        }

        JList getIncludedList() {
            return this.includedModel.getJList();
        }

        public String getLinkName(INetLink iNetLink) {
            if (!(iNetLink instanceof INetLink)) {
                return "";
            }
            return MapLinkRenderer.getLinkName(iNetLink);
        }

        public String getVLinkName(INetLink iNetLink) {
            String string = "";
            if (iNetLink instanceof VirtualNetLink) {
                VirtualNetLink virtualNetLink = (VirtualNetLink)iNetLink;
                string = this.parseVirtualNetLink(virtualNetLink);
            }
            return string;
        }

        private String parseVirtualNetLink(VirtualNetLink virtualNetLink) {
            String string;
            block5: {
                Object object;
                string = "unknown";
                Network network = Network.instance();
                ILinkModel iLinkModel = virtualNetLink.getLinkModel();
                ILinkModel iLinkModel2 = null;
                INetLink iNetLink = network.findNetLinkFromLinkModel(iLinkModel);
                if (iNetLink != null) {
                    object = network.findReverseLink(iNetLink);
                    iLinkModel2 = object != null ? object.getLinkModel() : null;
                }
                object = iLinkModel.src();
                INodeModel iNodeModel = iLinkModel.dst();
                int n = iLinkModel.srcEntityIndex();
                int n2 = iLinkModel.dstEntityIndex();
                if (n == 0 && iLinkModel2 != null) {
                    n = iLinkModel2.dstEntityIndex();
                }
                if (n2 == 0 && iLinkModel2 != null) {
                    n2 = iLinkModel2.srcEntityIndex();
                }
                try {
                    IEntityTableModel iEntityTableModel = object.getEntityTable();
                    IEntityTableModel iEntityTableModel2 = iNodeModel.getEntityTable();
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    IEntityModel iEntityModel2 = iEntityTableModel2.getEntityModelByIndex(n2);
                    string = this.formatLinkName((INodeModel)object, iEntityModel, iNodeModel, iEntityModel2);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!RamanPathPane.this.db.on()) break block5;
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            return string;
        }

        private String formatLinkName(INodeModel iNodeModel, IEntityModel iEntityModel, INodeModel iNodeModel2, IEntityModel iEntityModel2) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            if (VirtualLinksDirector.shouldSwap(iEntityModel, iEntityModel2)) {
                object = iNodeModel;
                IEntityModel iEntityModel3 = iEntityModel;
                iNodeModel = iNodeModel2;
                iEntityModel = iEntityModel2;
                iNodeModel2 = object;
                iEntityModel2 = iEntityModel3;
            }
            stringBuffer.append(iNodeModel.getName());
            if (iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
                stringBuffer.append("/sh");
                stringBuffer.append(iEntityModel.getShelfId());
            }
            stringBuffer.append("/s");
            stringBuffer.append(iEntityModel.getSlot());
            stringBuffer.append("/p");
            if (iEntityModel instanceof IPortModel) {
                stringBuffer.append(PortHelper.getPortNumString((IPortModel)((IPortModel)iEntityModel)));
            } else {
                stringBuffer.append(iEntityModel.getPositionInParent());
            }
            stringBuffer.append(OchPortsHelper.getSideString(iEntityModel, OchPortsHelper.SideStringType.SlashSeparated));
            object = MapLinkRenderer.getWavelength(iEntityModel);
            if (object != null && ((String)object).length() > 0) {
                stringBuffer.append(", " + (String)object);
            }
            stringBuffer.append(" - ");
            stringBuffer.append(iNodeModel2.getName());
            if (iNodeModel2.provides(Feature.MULTISHELF) && iNodeModel2.isMultishelf()) {
                stringBuffer.append("/sh");
                stringBuffer.append(iEntityModel2.getShelfId());
            }
            stringBuffer.append("/s");
            stringBuffer.append(iEntityModel2.getSlot());
            stringBuffer.append("/p");
            if (iEntityModel2 instanceof IPortModel) {
                stringBuffer.append(PortHelper.getPortNumString((IPortModel)((IPortModel)iEntityModel2)));
            } else {
                stringBuffer.append(iEntityModel2.getPositionInParent());
            }
            stringBuffer.append(OchPortsHelper.getSideString(iEntityModel2, OchPortsHelper.SideStringType.SlashSeparated));
            object = MapLinkRenderer.getWavelength(iEntityModel2);
            if (object != null && ((String)object).length() > 0) {
                stringBuffer.append(", " + (String)object);
            }
            return stringBuffer.toString();
        }

        String printableString(INetLink iNetLink) {
            String string;
            block11: {
                if (iNetLink instanceof INetLink) {
                    if (iNetLink instanceof DwdmNetLink) {
                        DwdmNetLink dwdmNetLink = (DwdmNetLink)iNetLink;
                        string = this.getLinkName(iNetLink) + dwdmNetLink.getAttrsString();
                    } else if (iNetLink instanceof VirtualNetLink) {
                        VirtualNetLink virtualNetLink = (VirtualNetLink)iNetLink;
                        string = "";
                        try {
                            VirtualLinksDirector.getLinkTerminations(virtualNetLink);
                            if (VirtualLinksDirector.hasSeparateTxRx(virtualNetLink)) {
                                string = string + "TX " + this.getVLinkName(iNetLink) + "RX " + this.getPeerVLinkName(iNetLink) + " (Provisionable Patchcord)";
                                break block11;
                            }
                            string = string + this.getVLinkName(iNetLink) + " (Provisionable Patchcord)";
                        }
                        catch (Exception exception) {
                            if (RamanPathPane.this.db.on()) {
                                RamanPathPane.this.db.println("Cannot make up the complete VL.\n" + exception.getMessage());
                            }
                            INetLink[] iNetLinkArray = VirtualLinksDirector.getCoupledLinkTerminations(virtualNetLink);
                            for (int i = 0; i < iNetLinkArray.length; ++i) {
                                string = string + this.parseVirtualNetLink((VirtualNetLink)iNetLinkArray[i]);
                            }
                            string = string + " Incomplete Provisionable Patchcord";
                        }
                    } else {
                        string = iNetLink instanceof OchTrailTunnelNetLink ? this.getLinkName(iNetLink) + " " + "OCHTRAIL" : MapLinkRenderer.getLinkLabel(iNetLink);
                    }
                } else {
                    string = "External Link";
                }
            }
            return string;
        }

        private String getPeerVLinkName(INetLink iNetLink) {
            String string;
            block5: {
                string = "incomplete";
                try {
                    if (!(iNetLink instanceof VirtualNetLink) || !VirtualLinksDirector.hasSeparateTxRx((VirtualNetLink)iNetLink)) break block5;
                    VirtualNetLink virtualNetLink = (VirtualNetLink)iNetLink;
                    Collection collection = Network.instance().getNetLinks();
                    for (INetLink iNetLink2 : collection) {
                        if (!(iNetLink2 instanceof VirtualNetLink)) continue;
                        VirtualNetLink virtualNetLink2 = (VirtualNetLink)iNetLink2;
                        try {
                            if (!VirtualLinksDirector.arePeers(virtualNetLink, virtualNetLink2)) continue;
                            string = this.parseVirtualNetLink(virtualNetLink2);
                            break;
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!RamanPathPane.this.db.on()) continue;
                            RamanPathPane.this.db.println("Cannot state if myVL[" + virtualNetLink + "] and vl[" + virtualNetLink2 + "] are peers.");
                        }
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!RamanPathPane.this.db.on()) break block5;
                    RamanPathPane.this.db.println("Cannot state if vl[" + (VirtualNetLink)iNetLink + "] has separate Tx/Rx.\n" + abstractCmsNoSuchEntityException.getMessage());
                }
            }
            return string;
        }

        void addIncluded(INetLink iNetLink) {
            this.includedModel.add(iNetLink, this.printableString(iNetLink));
            ((RamanDayZeroDialog)RamanPathPane.this.parent).nextButtonEnable(true, false);
        }

        INetLink getSelectedIncluded() {
            return (INetLink)this.includedModel.getSelectedEntry();
        }

        void setSideConstraint(INetLink iNetLink, ISideModel iSideModel, ISideModel iSideModel2) {
            SidesConstraintsHolder sidesConstraintsHolder = new SidesConstraintsHolder(iSideModel, iSideModel2);
            this.includedModel.replaceText(iNetLink, iNetLink.toString() + this.getSidesString(sidesConstraintsHolder));
        }

        void clearSideConstraint(INetLink iNetLink) {
            this.includedModel.replaceText(iNetLink, iNetLink.toString());
        }

        public INetLink[] getIncludedLinks() {
            return this.includedModel.getContent().toArray(new INetLink[0]);
        }

        void clearAll() {
            this.includedModel.clearAll();
            this.saveLists();
            ((RamanDayZeroDialog)RamanPathPane.this.parent).nextButtonEnable(false);
        }

        String getRankString(INetLink iNetLink) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.includedModel.contains(iNetLink)) {
                int n = this.includedModel.getContent().indexOf(iNetLink) + 1;
                stringBuilder.append("(").append(n).append(")");
            }
            return stringBuilder.toString();
        }

        public boolean contains(Object object) {
            return this.includedModel.contains(object);
        }

        public int getSize() {
            return this.includedModel.getSize();
        }

        private int getSizeOfSelectedList() {
            if (this.includedModel.getSelectedEntry() != null) {
                return this.includedModel.getSize();
            }
            return 0;
        }

        public AbstractButton getButton(String string) {
            return this.includedModel.getButton(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.applyAction(this.includedModel, actionEvent);
        }

        public void applyAction(OrderedListModel orderedListModel, ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = orderedListModel.getJList().getSelectedIndex();
            if (n < 0) {
                return;
            }
            if (string == "Up") {
                orderedListModel.swapEntries(n - 1);
            } else if (string == "Down") {
                orderedListModel.swapEntries(n);
            } else if (string == "Remove") {
                orderedListModel.remove(orderedListModel.getSelectedEntry());
            }
            this.syncButtons();
        }

        private String getSidesString(SidesConstraintsHolder sidesConstraintsHolder) {
            return ", sides " + DwdmSide.getSideFromOffset(sidesConstraintsHolder.getSideIn().getId()) + "-" + DwdmSide.getSideFromOffset(sidesConstraintsHolder.getSideOut().getId());
        }

        public void selectionChanged(Object object, Object object2) {
            if (object2 != null && this.includedModel.getSelectedEntry() != null && !this.includedModel.contains(object2)) {
                this.includedModel.getJList().clearSelection();
            }
            this.syncButtons();
            this.listener.selectionChanged(object, object2);
        }

        public void orderSwapped(Object object, Object object2) {
            this.listener.orderSwapped(object, object2);
        }

        public void entryRemoved(Object object) {
            this.listener.entryRemoved(object);
        }
    }
}

