/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.rpr;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.RPRInfo;
import cerent.cms.ui.network.rpr.RprMapCard;
import cerent.cms.ui.network.rpr.RprMapPort;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.DetailedMapLink;
import com.cisco.ctc.util.map.DetailedMapLinkStyle;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Color;
import javax.swing.SwingUtilities;

public class RprMapCardLink
extends DetailedMapLink {
    private static final SDebug db = new SDebug("RprMapCardLink");
    private String cktSize;
    protected static Color r01LinkColor = Color.yellow;
    protected static Color r0LinkColor = Color.orange;
    protected static Color r1LinkColor = Color.blue;
    protected static DetailedMapLinkStyle r01LinkStyle = new DetailedMapLinkStyle(3, r01LinkColor);
    protected static DetailedMapLinkStyle r0LinkStyle = new DetailedMapLinkStyle(2, r0LinkColor);
    protected static DetailedMapLinkStyle r1LinkStyle = new DetailedMapLinkStyle(1, r1LinkColor);
    public static final int LINK_UP_STATE = 0;
    public static Color LINK_UP_COLOR = Color.green;
    public static Color LINK_UNKNOWN_COLOR = Color.gray;

    public RprMapCardLink(MapToolkit mapToolkit, RprMapCard rprMapCard, RprMapCard rprMapCard2, String string) {
        super(mapToolkit, rprMapCard, rprMapCard2, string);
    }

    public synchronized void init(Object object, Object object2) {
        super.init(object, object2);
    }

    public String getToolTipText() {
        IPortModel iPortModel = this.getSrcEntity();
        int[] nArray = iPortModel.getPortNum();
        String string = null;
        string = Feature.provides((INodeModel)iPortModel.getNodeModel(), (Feature)Feature.POS_ON_MLMR) && iPortModel.getModuleModel().getEqType() == 285 ? (nArray[0] == iPortModel.getModuleModel().getRPRWestPort() ? "W" : "E") : (nArray[0] == 1 ? "W" : "E");
        String string2 = iPortModel.getNodeModel().getName() + "/s" + iPortModel.getSlot() + "/p" + string;
        IPortModel iPortModel2 = this.getDstEntity();
        nArray = iPortModel2.getPortNum();
        string = Feature.provides((INodeModel)iPortModel2.getNodeModel(), (Feature)Feature.POS_ON_MLMR) && iPortModel2.getModuleModel().getEqType() == 285 ? (nArray[0] == iPortModel2.getModuleModel().getRPRWestPort() ? "W" : "E") : (nArray[0] == 1 ? "W" : "E");
        String string3 = iPortModel2.getNodeModel().getName() + "/s" + iPortModel2.getSlot() + "/p" + string;
        return string2 + " - " + string3;
    }

    public IPortModel getSrcEntity() {
        RPRInfo rPRInfo = (RPRInfo)this.getUserObject();
        return rPRInfo.getSelfEntity();
    }

    public IPortModel getDstEntity() {
        RPRInfo rPRInfo = (RPRInfo)this.getUserObject();
        return rPRInfo.getEastEntity();
    }

    public void setState(int n) {
        final int n2 = n;
        super.setState(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RprMapCardLink.this.setLineColor(RprMapCardLink.stateToColor(n2));
            }
        });
        this.clearStyles();
        DetailedMapLinkStyle detailedMapLinkStyle = new DetailedMapLinkStyle(3, RprMapCardLink.stateToColor(n));
        this.addStyle(detailedMapLinkStyle);
    }

    protected boolean hasRprStyle() {
        return this.styleList.indexOf(r01LinkStyle) != -1 || this.styleList.indexOf(r0LinkStyle) != -1 || this.styleList.indexOf(r1LinkStyle) != -1;
    }

    protected boolean hasR0LinkStyle() {
        return this.styleList.indexOf(r0LinkStyle) != -1;
    }

    protected void addR0LinkStyle() {
        this.addStyle(r0LinkStyle);
    }

    protected void addR1LinkStyle() {
        this.addStyle(r1LinkStyle);
    }

    protected void addR01LinkStyle() {
        this.addStyle(r01LinkStyle);
    }

    protected void removeRprStyle() {
        int n = this.styleList.indexOf(r01LinkStyle);
        if (n == -1) {
            n = this.styleList.indexOf(r0LinkStyle);
        }
        if (n == -1) {
            n = this.styleList.indexOf(r1LinkStyle);
        }
        if (n != -1) {
            this.styleList.remove(n);
            this.reDraw();
        }
    }

    public static Color stateToColor(int n) {
        switch (n) {
            case 0: {
                return LINK_UP_COLOR;
            }
        }
        return LINK_UNKNOWN_COLOR;
    }

    protected static int getLinkAggregatedState(MapLink[] mapLinkArray) {
        RprMapCardLink rprMapCardLink;
        int n;
        if (mapLinkArray.length > 1 && db.on()) {
            db.println("RPR topology map only support 1 link");
        }
        if ((n = (rprMapCardLink = (RprMapCardLink)mapLinkArray[0]).getState()) != 0 && db.on()) {
            db.println("RPR topology link only has update.");
        }
        return 0;
    }

    public void setSourcePort(MapPort mapPort) {
        String string;
        super.setSourcePort(mapPort);
        if (mapPort != null && mapPort instanceof RprMapPort && (string = mapPort.getInfoString()) != null && string.length() > 0) {
            this.setSrcLabel(string);
        }
    }

    public void setTargetPort(MapPort mapPort) {
        String string;
        super.setTargetPort(mapPort);
        if (mapPort != null && mapPort instanceof RprMapPort && (string = mapPort.getInfoString()) != null && string.length() > 0) {
            this.setTargetLabel(string);
        }
    }

    protected String getLinkLabelText() {
        RPRInfo rPRInfo = (RPRInfo)this.getUserObject();
        INetCircuit iNetCircuit = rPRInfo.getEastCircuit();
        String string = super.getLinkLabelText();
        if (iNetCircuit == null || string == null || string.length() == 0) {
            return string;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        String string2 = iNetCircuit.getCircuitSizeObj().getCircuitSizeString();
        if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
            int n = iNetCircuit.getConfiguredForwardMemberSize();
            string2 = string2 + "-" + n + "v";
        }
        return c + " (" + string2 + ") " + c2;
    }
}

