/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.rpr;

import cerent.cms.ncp.DataNetworkManager;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.network.rpr.RprMap;
import cerent.cms.ui.network.rpr.RprMapFactory;
import cerent.cms.ui.network.rpr.RprTabbedView;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class RprTopoDialog
extends UDialog
implements ActionListener {
    private static final SDebug db = new SDebug("RprTopoDialog");
    public static final String TITLE = "RPR Topology";
    private RprMap rprMap;
    private RprTabbedView rprTabbedView;
    protected DataNetworkManager rprMgr;
    private JButton okButton;
    private JButton refreshButton;
    private JButton clearRprButton;
    private JSplitPane mainSplitPane;
    private static final String PREF = "ctc.RprTopoDialog";
    private static final String XPOS = "x";
    private static final String YPOS = "y";
    private static final String WIDTH = "w";
    private static final String HEIGHT = "h";
    private static final Dimension INIT_DIM = new Dimension(800, 600);
    private static final String SPLIT_LOC = "split";
    private static final int INIT_SPLIT_LOC = 300;

    public static RprTopoDialog instance(Component component, DataNetworkManager dataNetworkManager) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        RprTopoDialog rprTopoDialog = new RprTopoDialog(frame, dataNetworkManager);
        return rprTopoDialog;
    }

    private RprTopoDialog(Frame frame, DataNetworkManager dataNetworkManager) {
        super(frame, TITLE, false, (Object)dataNetworkManager);
        try {
            Preferences preferences = Preferences.instance();
            int n = preferences.getInt(PREF, XPOS, -1);
            int n2 = preferences.getInt(PREF, YPOS, 0);
            int n3 = preferences.getInt(PREF, WIDTH, RprTopoDialog.INIT_DIM.width);
            int n4 = preferences.getInt(PREF, HEIGHT, RprTopoDialog.INIT_DIM.height);
            if (n == -1) {
                this.setSize(new Dimension(n3, n4));
            } else {
                this.setBounds(n, n2, n3, n4);
            }
        }
        catch (Exception exception) {
            this.setSize(INIT_DIM);
        }
        this.addComponentListener(new MyComponentAdapter(this));
        this.updateSplitPane();
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.rprMgr = (DataNetworkManager)object;
        this.rprMap = new RprMap(RprMapFactory.instance(), this);
        this.rprTabbedView = new RprTabbedView(this.rprMap);
        this.rprTabbedView.showAndCatchException();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)((Object)this.rprTabbedView), "Center");
        this.mainSplitPane = new JSplitPane(0);
        this.mainSplitPane.setDividerSize(2);
        JComponent jComponent = this.getMainPanel();
        this.mainSplitPane.setTopComponent(jComponent);
        this.mainSplitPane.setBottomComponent(jPanel2);
        jComponent.setMinimumSize(new Dimension(100, 200));
        jPanel2.setMinimumSize(new Dimension(100, 100));
        jPanel.add((Component)this.mainSplitPane, "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    private JComponent getMainPanel() {
        this.rprMap.getGraphWindow().setBorder(BorderFactory.createLoweredBevelBorder());
        return this.rprMap.getGraphWindow();
    }

    private JPanel getButtonPanel() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(NetCSHelpConst.RprTopoDialog);
        this.refreshButton = this.makeActionButton("Refresh");
        cSHelpButtonPane.addLeft(this.refreshButton);
        this.clearRprButton = this.makeActionButton("Clear RPR Topology");
        cSHelpButtonPane.addLeft(this.clearRprButton);
        this.okButton = this.makeActionButton("Close");
        cSHelpButtonPane.addRight(this.okButton);
        cSHelpButtonPane.setMinimumSize(new Dimension(100, 100));
        return cSHelpButtonPane;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void reloadRprState() {
        this.rprTabbedView.reloadRprState();
    }

    protected void reloadRprCircuits() {
        this.rprTabbedView.reloadRprCircuits();
    }

    protected void rprTopologyDeleted() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.dispose();
        } else if (object == this.refreshButton) {
            this.rprMap.reloadRPR(false);
            this.reloadRprCircuits();
            this.reloadRprState();
        } else if (object == this.clearRprButton) {
            this.rprMap.clearRprTopo();
            this.reloadRprState();
        }
    }

    public void dispose() {
        Rectangle rectangle = this.getBounds();
        Preferences preferences = Preferences.instance();
        preferences.setProperty(PREF, XPOS, Integer.toString(rectangle.x));
        preferences.setProperty(PREF, YPOS, Integer.toString(rectangle.y));
        preferences.setProperty(PREF, WIDTH, Integer.toString(rectangle.width));
        preferences.setProperty(PREF, HEIGHT, Integer.toString(rectangle.height));
        preferences.setProperty(PREF, SPLIT_LOC, Integer.toString(this.mainSplitPane.getDividerLocation()));
        this.getContentPane().removeAll();
        this.getRootPane().removeAll();
        this.removeAll();
        if (this.rprMap != null) {
            this.rprMap.dispose();
            this.rprMap = null;
        }
        if (this.rprMgr != null) {
            this.rprMgr.dispose();
            this.rprMgr = null;
        }
        super.dispose();
    }

    public void updateSplitPane() {
        Preferences preferences = Preferences.instance();
        int n = preferences.getInt(PREF, SPLIT_LOC, 300);
        this.mainSplitPane.setDividerLocation(n);
    }

    class MyComponentAdapter
    extends ComponentAdapter {
        RprTopoDialog dlg;

        MyComponentAdapter(RprTopoDialog rprTopoDialog2) {
            this.dlg = rprTopoDialog2;
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (this.dlg.getHeight() < 250) {
                this.dlg.setSize(this.dlg.getWidth(), 250);
                this.dlg.mainSplitPane.setDividerLocation(0.5);
            }
        }
    }
}

