/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.OhCircuitInfo;
import cerent.cms.model.OwCircuitInfo;
import cerent.cms.model.PCMCoding;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.ocm.OwCircuit;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.ohcircuits.OhCcdAttrsPane;
import cerent.cms.ui.ohcircuits.OhCcdEndpointsPane;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.omg.CORBA.BAD_PARAM;

public class OhCircuitCreationDialog
extends WizardDialog {
    private OhCircuitManager ocMgr = OhCircuitManager.instance();
    OhCircuit ckt;
    public static final String TITLE = "Overhead Circuit Creation";
    public static final String GET_CKT_ATTRS = "Circuit Attributes";
    public static final String GET_CKT_SOURCE = "Circuit Source";
    public static final String SRC = "Source";
    public static final String GET_CKT_DEST = "Circuit Destination";
    public static final String DEST = "Destination";
    public static final String UNSPECIFIED_NAME = "<auto-assigned>";
    static final String PREF_PATH = "ctc.ohcircuit.creation";
    private static final String PREF_TYPE = "type";
    private static final int STANDARD_WIDTH = 650;
    private static final int STANDARD_HEIGHT = 300;
    private static final UiToolkit uiToolkit = UiToolkit.instance();
    private static final int VIGN_WIDTH = 250;
    private static final int WIDTH = 650;
    static final int SHORT = 320;
    static final int TALL = 600;
    String circuitName;
    OhCircuitInfo circuitInfo = new OhCircuitInfo();
    OhCcdAttrsPane attrPane;
    OhCcdEndpointsPane srcPane;
    OhCcdEndpointsPane destPane;
    Map availPortsMap = new HashMap();
    private static final String FATAL_ICON_STR = "/images/icons/fatal_error32.gif";
    protected static final SDebug db = new SDebug("OhCircuitCreationDialog");

    public static OhCircuitCreationDialog instance(JComponent jComponent) {
        Frame frame = JOptionPane.getFrameForComponent(jComponent);
        return new OhCircuitCreationDialog(frame);
    }

    private OhCircuitCreationDialog(Frame frame) {
        super(frame, TITLE, true, true);
        this.reset(true);
        this.createPanes();
        this.setLocationRelativeTo(frame);
    }

    private void createPanes() {
        this.addStatusPanel(new WizardDialog.StatusPanel("/images/CTC_dialogVignette.gif", new Dimension(250, 320)));
        this.attrPane = new OhCcdAttrsPane(GET_CKT_ATTRS, this);
        this.addPage(this.attrPane);
        this.srcPane = new OhCcdEndpointsPane(GET_CKT_SOURCE, SRC, this);
        this.addPage(this.srcPane);
        this.destPane = new OhCcdEndpointsPane(GET_CKT_DEST, DEST, this);
        this.addPage(this.destPane);
        this.destPane.excludeEndpoints(this.srcPane);
    }

    protected void reset() {
        this.reset(false);
    }

    private void reset(boolean bl) {
        this.setHeight(320);
        this.setFinishEnabled(false);
        if (bl) {
            this.readCircuitPrefs();
            if (this.srcPane != null) {
                this.srcPane.reset();
            }
            if (this.destPane != null) {
                this.destPane.reset();
            }
            this.circuitName = "";
            this.availPortsMap.clear();
        }
        super.reset();
    }

    void setHeight(int n) {
        this.setSize(new Dimension(650, n));
        this.invalidate();
    }

    private void readCircuitPrefs() {
        Preferences preferences = Preferences.instance();
        int n = 0;
        try {
            n = preferences.getInt(PREF_PATH, PREF_TYPE, n);
        }
        catch (BAD_PARAM bAD_PARAM) {
            db.severe("CORBA_BAD_PARAM encountered while trying to retrieve circuit type.");
            SDebug.printStackTrace((Throwable)bAD_PARAM);
        }
        this.circuitInfo = new OhCircuitInfo(null, null, n, "");
    }

    private void writeCircuitPrefs() {
        Preferences preferences = Preferences.instance();
        preferences.setInt(PREF_PATH, PREF_TYPE, this.circuitInfo.getCircuitType());
        try {
            preferences.store();
        }
        catch (FileNotFoundException fileNotFoundException) {
            SDebug.printStackTrace((Throwable)fileNotFoundException);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CANT_STORE_OVERHEAD_CKT_PREFS_PARAM_1, (Object)"File not found.");
        }
        catch (IOException iOException) {
            SDebug.printStackTrace((Throwable)iOException);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CANT_STORE_OVERHEAD_CKT_PREFS_PARAM_1, (Object)"I/O error.");
        }
    }

    public INodeModel getSourceNode() {
        return this.srcPane != null ? this.srcPane.nodeModel : null;
    }

    public void setSourceNode(INodeModel iNodeModel) {
        if (OhCircuitCreationDialog.db.on) {
            db.fine("setSourceNode: srcNode = " + iNodeModel);
        }
        this.getSourcePane().setNode(iNodeModel);
    }

    public INodeModel getDestNode() {
        return this.destPane != null ? this.destPane.nodeModel : null;
    }

    public void setDestNode(INodeModel iNodeModel) {
        if (OhCircuitCreationDialog.db.on) {
            db.fine("setDestNode: destNode = " + iNodeModel);
        }
        this.getDestinationPane().setNode(iNodeModel);
    }

    int getCircuitType() {
        if (this.circuitInfo != null) {
            return this.circuitInfo.getCircuitType();
        }
        return 0;
    }

    String getCircuitName() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.circuitName.length() > 0;
        stringBuffer.append(bl ? this.circuitName : UNSPECIFIED_NAME);
        return stringBuffer.toString();
    }

    void createCircuit() throws AnnotatedException {
        if (db.on()) {
            db.fine("Ready to create ohCircuit. The circuitInfo is:" + this.circuitInfo);
        }
        this.ckt = this.ocMgr.newCircuit(this.circuitInfo);
        if (this.circuitInfo instanceof OwCircuitInfo) {
            int n = ((OwCircuitInfo)this.circuitInfo).getPCMCoding();
            int n2 = ((OwCircuit)this.ckt).getCircuitPCMCoding();
            if (n2 != n) {
                OhCircuitCreationDialog.notifyPCMCodingChange(this, n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply() throws AnnotatedException {
        try {
            uiToolkit.setCursor(3);
            this.createCircuit();
            if (this.circuitName.length() > 0) {
                String string = this.circuitName;
                try {
                    this.ckt.rename(string);
                    if (OhCircuitCreationDialog.db.on) {
                        db.fine("apply: ckt.rename(\"" + string + "\") succeeded ");
                    }
                }
                catch (Exception exception) {
                    String string2 = "The circuit has been created successfully, but could not be renamed to \"" + string + "\"." + "\nPlease edit the circuit to rename it.";
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)this, (EID)NEMC.EID_INVALID_CKT_NAME_PARAM_1, (Object)string2);
                }
            }
            Object var5_4 = null;
            uiToolkit.setCursor(0);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            uiToolkit.setCursor(0);
            throw throwable;
        }
    }

    protected void handleCancel() {
        if (OhCircuitCreationDialog.db.on) {
            db.finer("handleCancel: cleaning up");
        }
        this.close();
    }

    public boolean handleFinishException(Exception exception) {
        final String string = exception.getMessage();
        final ImageIcon imageIcon = new ImageIcon(OhCircuitCreationDialog.class.getResource(FATAL_ICON_STR));
        if (string.startsWith("EID") || string.startsWith("WID")) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (SwingUtilities.isEventDispatchThread()) {
                JOptionPane.showMessageDialog(this, string, "Error", 0, imageIcon);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(OhCircuitCreationDialog.this, string, "Error", 0, imageIcon);
                        }
                    });
                }
                catch (Exception exception2) {
                    SDebug.printStackTrace((Throwable)exception2);
                }
            }
            return true;
        }
        return false;
    }

    private void close() {
        if (this.attrPane != null) {
            this.attrPane.close();
        }
    }

    public void dispose() {
        this.attrPane = null;
        this.circuitInfo = null;
        this.ckt = null;
        super.dispose();
    }

    OhCcdEndpointsPane getSourcePane() {
        return this.srcPane;
    }

    OhCcdEndpointsPane getDestinationPane() {
        return this.destPane;
    }

    static void notifyPCMCodingChange(Component component, int n, int n2) {
        String string = PCMCoding.getPCMCodingObj((int)n).toString();
        String string2 = PCMCoding.getPCMCodingObj((int)n2).toString();
        CerentDialog.infoDialog((Component)component, (String)("The circuit's PCM coding was changed from " + string + " to " + string2 + " because some node does not support " + string + "."), (String)"PCMCoding Changed");
    }
}

