/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppc;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INetProtectionType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.NetProtectionType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.ppc.PPCCreationInfo;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPCHelper {
    private static final SDebug db = new SDebug("PPCHelper");
    private static final VirtualLinksDirector vld = VirtualLinksDirector.instance();

    public static INodeModel[] getNodes() {
        TreeSet<INodeModel> treeSet = new TreeSet<INodeModel>(new NodeComparator());
        INodeModel[] iNodeModelArray = vld.getKnownNodes();
        for (int i = 0; i < iNodeModelArray.length; ++i) {
            treeSet.add(iNodeModelArray[i]);
        }
        return treeSet.toArray(new INodeModel[0]);
    }

    public static IEntityModel[] getProtectedBidiPorts(INodeModel iNodeModel, int n) {
        return PPCHelper.getBidiPorts(iNodeModel, n, true);
    }

    public static IEntityModel[] getL2Ports(INodeModel iNodeModel) {
        IEntityModel[] iEntityModelArray = vld.getVirtualLinkCandidatesForL2(iNodeModel);
        Arrays.sort(iEntityModelArray, new PortComparator());
        return iEntityModelArray;
    }

    public static IEntityModel[] getBidiPorts(INodeModel iNodeModel, int n) {
        return PPCHelper.getBidiPorts(iNodeModel, n, false);
    }

    private static IEntityModel[] getBidiPorts(INodeModel iNodeModel, int n, boolean bl) {
        if (db.isFineEnabled()) {
            db.fine("getBidiPorts(" + iNodeModel.getName() + ", " + Wavelength.getWavelengthStringFromWavelength(n) + ", " + bl + ") called");
        }
        IEntityModel[] iEntityModelArray = vld.getVirtualLinkCandidates(iNodeModel);
        TreeSet<IEntityModel> treeSet = new TreeSet<IEntityModel>(new PortComparator());
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            IEntityModel iEntityModel = iEntityModelArray[i];
            if (db.isFineEnabled()) {
                db.fine("Checking " + iEntityModel);
            }
            if (iEntityModel instanceof IOpticsPortModel || PPCHelper.isOch(iEntityModel) || OchPortsHelper.isOtsPort(iEntityModel)) continue;
            if (n != -1 && iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
                int n2;
                try {
                    n2 = PPCHelper.getWlen(iEntityModel);
                }
                catch (Exception exception) {
                    if (iEntityModel.getModuleModel().isPreProvisioned() && (iEntityModel.getEqType() == 30 || iEntityModel.getEqType() == 61)) {
                        if (db.on()) {
                            db.fine(iEntityModel + " 7.0 OCx card preprovisioned");
                        }
                        n2 = 0;
                    }
                    if (!db.on()) continue;
                    db.fine(iEntityModel + " skipped due to wlen check failure: " + exception.getMessage());
                    continue;
                }
                if (n2 == 0) {
                    db.fine("Added as \"first tunable\"");
                } else if (n2 != n) {
                    if (!db.isFineEnabled()) continue;
                    db.fine("Skipped due to wlen check: " + n2 + " != " + n);
                    continue;
                }
                if (iEntityModel.getModuleModel().getEqType() == 293 && Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.OTU2_XP) && ((IDwdmPortModel)iEntityModel).isClientPort()) continue;
            }
            if (bl) {
                if (vld.isProtected(iEntityModel) == null) continue;
                db.fine("Added as bidi/protected&working");
                treeSet.add(iEntityModel);
                continue;
            }
            db.fine("Added as bidi");
            treeSet.add(iEntityModel);
        }
        return treeSet.toArray(new IEntityModel[0]);
    }

    public static boolean isAvailable(IEntityModel iEntityModel) {
        IEntityModel[] iEntityModelArray = vld.getVirtualLinkCandidates(iEntityModel.getNodeModel());
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            if (iEntityModelArray[i].getEntityIndex() != iEntityModel.getEntityIndex()) continue;
            return true;
        }
        return false;
    }

    public static IEntityModel getProtectPort(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        return vld.isProtected(iEntityModel);
    }

    public static boolean isProtected(IEntityModel iEntityModel) {
        return vld.isProtected(iEntityModel) != null;
    }

    public static boolean isYCableProtected(IEntityModel iEntityModel) {
        return vld.isYCableProtected(iEntityModel) != null;
    }

    public static INetProtectionType getProtType(IEntityModel iEntityModel) {
        if (PPCHelper.isProtected(iEntityModel)) {
            if (vld.isYCableProtected(iEntityModel) != null) {
                return NetProtectionType.YCABLE;
            }
            if (OchTrailHelper.isProtected(iEntityModel)) {
                return NetProtectionType.SPLITTER;
            }
            return NetProtectionType.ONE_PLUS_ONE;
        }
        return NetProtectionType.UNPROTECTED;
    }

    private static ISideModel[] getSideModels(INodeModel iNodeModel) {
        try {
            return iNodeModel.getSideModels().getSides();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            if (db.isFineEnabled()) {
                db.fine("Cannot get Side Models for " + iNodeModel.getName() + ": " + exception.getMessage());
            }
            return new ISideModel[0];
        }
    }

    public static Side[] getSides(INodeModel iNodeModel) {
        if (db.isFineEnabled()) {
            db.fine("getSides(" + iNodeModel.getName() + ") called");
        }
        if (!iNodeModel.provides(Feature.OPTICAL_SIDE)) {
            return new Side[0];
        }
        ISideModel[] iSideModelArray = PPCHelper.getSideModels(iNodeModel);
        LinkedList<Side> linkedList = new LinkedList<Side>();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            IEntityModel iEntityModel;
            IEntityModel iEntityModel2;
            ISideModel iSideModel;
            block11: {
                iSideModel = iSideModelArray[i];
                iEntityModel2 = null;
                iEntityModel = null;
                if (iNodeModel.isInited()) {
                    block10: {
                        if (db.isFineEnabled()) {
                            db.fine("Getting OTS RX at " + Integer.toHexString(iSideModel.getLineIn()));
                        }
                        try {
                            iEntityModel2 = iEntityTableModel.getEntityModelByIndex(iSideModel.getLineIn());
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!db.on()) break block10;
                            db.println("Cannot get line IN for side " + iSideModel.getId() + " on node " + iNodeModel.getName() + ": " + abstractCmsNoSuchEntityException.getMessage());
                        }
                    }
                    if (db.isFineEnabled()) {
                        db.fine("Returning OTS TX at " + Integer.toHexString(iSideModel.getLineOut()));
                    }
                    try {
                        iEntityModel = iEntityTableModel.getEntityModelByIndex(iSideModel.getLineOut());
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) break block11;
                        db.println("Cannot get line OUT for side " + iSideModel.getId() + " on node " + iNodeModel.getName() + ": " + abstractCmsNoSuchEntityException.getMessage());
                    }
                }
            }
            linkedList.add(new Side(iSideModel.getId(), iEntityModel2, iEntityModel));
        }
        return PPCHelper.filterOutPortsInUse(linkedList, iNodeModel);
    }

    private static Side[] filterOutPortsInUse(List<Side> list, INodeModel iNodeModel) {
        IVirtualLinkModel[] iVirtualLinkModelArray = vld.getVirtualLinks(iNodeModel);
        TreeSet<Side> treeSet = new TreeSet<Side>();
        for (int i = 0; i < list.size(); ++i) {
            IVirtualLinkModel iVirtualLinkModel;
            int n;
            int n2;
            Side side = list.get(i);
            boolean bl = false;
            if (side.getRxPort() != null) {
                n2 = side.getRxPort().getEntityIndex();
                for (n = 0; n < iVirtualLinkModelArray.length; ++n) {
                    iVirtualLinkModel = iVirtualLinkModelArray[n];
                    if (iVirtualLinkModel.getOrigEntity() == null || iVirtualLinkModel.getOrigEntity().getEntityIndex() != n2) continue;
                    if (db.isFineEnabled()) {
                        db.fine("Filtered out side " + side + " because RX port " + side.getRxPort() + " is in use");
                    }
                    bl = true;
                    break;
                }
            }
            if (!bl && side.getTxPort() != null) {
                n2 = side.getTxPort().getEntityIndex();
                for (n = 0; n < iVirtualLinkModelArray.length; ++n) {
                    iVirtualLinkModel = iVirtualLinkModelArray[n];
                    if (iVirtualLinkModel.getOrigEntity() == null || iVirtualLinkModel.getOrigEntity().getEntityIndex() != n2) continue;
                    if (db.isFineEnabled()) {
                        db.fine("Filtered out side " + side + " because TX port " + side.getTxPort() + " is in use");
                    }
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            treeSet.add(side);
        }
        return treeSet.toArray(new Side[0]);
    }

    public static IEntityModel[] getOTSPorts(INodeModel iNodeModel, boolean bl) {
        IEntityModel[] iEntityModelArray = vld.getVirtualLinkCandidatesForOTS(iNodeModel, bl);
        Arrays.sort(iEntityModelArray, new PortComparator());
        return iEntityModelArray;
    }

    public static IEntityModel[] getOCHPorts(INodeModel iNodeModel, int n, boolean bl) {
        if (db.isFineEnabled()) {
            db.fine("getOCHPorts(" + iNodeModel.getName() + ", " + Wavelength.getWavelengthStringFromWavelength(n) + ", " + bl + ") called");
        }
        IEntityModel[] iEntityModelArray = vld.getVirtualLinkCandidates(iNodeModel);
        TreeSet<IEntityModel> treeSet = new TreeSet<IEntityModel>(new PortComparator());
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            boolean bl2;
            IEntityModel iEntityModel = iEntityModelArray[i];
            if (db.isFineEnabled()) {
                db.fine("Checking " + iEntityModel);
            }
            if (!PPCHelper.isOch(iEntityModel) || (bl2 = OchPortsHelper.isPortTypeRx(iEntityModel)) != bl) continue;
            if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
                IPortModel iPortModel = (IPortModel)iEntityModel;
                try {
                    int n2 = PPCHelper.getWlen((IEntityModel)iPortModel);
                    if (n2 != n && n2 != 0) continue;
                    if (db.isFineEnabled()) {
                        db.fine("Added as OCH/" + (bl ? "RX" : "TX"));
                    }
                    treeSet.add(iEntityModel);
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Cannot get wlen for " + iEntityModel + ": " + exception.getMessage());
                }
                continue;
            }
            if (db.isFineEnabled()) {
                db.fine("No wavelength check - Added as OCH/" + (bl ? "RX" : "TX"));
            }
            treeSet.add(iEntityModel);
        }
        return treeSet.toArray(new IEntityModel[0]);
    }

    public static IEntityModel[] getReversePorts(IEntityModel iEntityModel) {
        if (db.isFineEnabled()) {
            db.fine("getReversePort(" + iEntityModel + ") called");
        }
        IPortModel iPortModel = (IPortModel)iEntityModel;
        try {
            Object object;
            if (iPortModel instanceof IOpticsPortModel && (object = ((IOpticsPortModel)iPortModel).getReversePortModels()) != null && ((IEntityModel[])object).length > 0) {
                return object;
            }
            int n = PPCHelper.getWlen((IEntityModel)iPortModel);
            object = OchncHelper.getReversePorts(n, iEntityModel);
            return object.toArray(new IEntityModel[0]);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Cannot get wlen for " + iEntityModel + ": " + exception.getMessage());
            }
            return new IEntityModel[0];
        }
    }

    public static int getFirstID(INodeModel iNodeModel, PPCCreationInfo pPCCreationInfo, int n) {
        List<Integer> list = pPCCreationInfo.getIDs(iNodeModel);
        list.add(n);
        return PPCHelper.getFirstID(iNodeModel, list);
    }

    public static int getFirstID(INodeModel iNodeModel, PPCCreationInfo pPCCreationInfo) {
        List<Integer> list = pPCCreationInfo.getIDs(iNodeModel);
        return PPCHelper.getFirstID(iNodeModel, list);
    }

    private static int getFirstID(INodeModel iNodeModel, List<Integer> list) {
        IVirtualLinkModel[] iVirtualLinkModelArray;
        if (db.isFineEnabled()) {
            iVirtualLinkModelArray = new StringBuffer();
            for (Integer n : list) {
                iVirtualLinkModelArray.append(" " + n.toString());
            }
            db.fine("getFirstID: added " + list.size() + " new links IDs:" + iVirtualLinkModelArray);
        }
        if ((iVirtualLinkModelArray = vld.getVirtualLinks(iNodeModel)) == null) {
            iVirtualLinkModelArray = new IVirtualLinkModel[]{};
        }
        if (db.isFineEnabled()) {
            db.fine("getFirstID: adding " + iVirtualLinkModelArray.length + " existing links IDs");
        }
        PPCHelper.fillListWithIds(iNodeModel, iVirtualLinkModelArray, list);
        int n = 1;
        while (list.contains(n)) {
            ++n;
        }
        return n;
    }

    private static void fillListWithIds(INodeModel iNodeModel, IVirtualLinkModel[] iVirtualLinkModelArray, List<Integer> list) {
        for (int i = 0; i < iVirtualLinkModelArray.length; ++i) {
            if (db.isFineEnabled()) {
                db.fine(iVirtualLinkModelArray[i].toString());
            }
            int n = -1;
            IIpAddr iIpAddr = null;
            iIpAddr = iNodeModel.isSecureMode() ? iNodeModel.getSecureIpConfig().getIpAddress() : iNodeModel.getIpConfig().getIpAddress();
            if (iVirtualLinkModelArray[i].getOrigNode() != null && iIpAddr.compareTo((Object)iVirtualLinkModelArray[i].getOrigNode()) == 0) {
                n = iVirtualLinkModelArray[i].getOrigVLID();
            } else if (iVirtualLinkModelArray[i].getTermNode() != null && iIpAddr.compareTo((Object)iVirtualLinkModelArray[i].getTermNode()) == 0) {
                n = iVirtualLinkModelArray[i].getTermVLID();
            }
            if (n == -1) continue;
            list.add(n);
            if (!db.isFineEnabled()) continue;
            db.fine("fillListWithInfoIds: added ID " + n);
        }
    }

    private static final int getWlen(IEntityModel iEntityModel) throws NoSuchInterface, WrongInterfaceType, WrongPortType {
        if (db.isFinestEnabled()) {
            db.println("getWlen for " + iEntityModel);
        }
        IPortModel iPortModel = (IPortModel)iEntityModel;
        int n = -1;
        if (iPortModel instanceof IOpticsPortModel) {
            n = ((IOpticsPortModel)iPortModel).getWaveLength();
        } else if (iPortModel.getInterfaceModel() instanceof IOpticsChannelModel) {
            IOpticsChannelModel iOpticsChannelModel = (IOpticsChannelModel)iPortModel.getInterfaceModel();
            n = iOpticsChannelModel.getActualWaveLength();
            if (n == 0) {
                db.finest("Using expected wlen for local port");
                n = iOpticsChannelModel.getExpectedWaveLength();
            } else {
                db.finest("Using actual wlen for local port");
            }
        } else if (db.isFinestEnabled()) {
            db.println("Not a IOpticsChannelModel interface: " + iPortModel.getInterfaceModel());
        }
        if (db.isFinestEnabled()) {
            db.println("wlen = " + n + " [" + Wavelength.getWavelengthStringFromWavelength(n) + "]");
        }
        return n;
    }

    static boolean isOch(IEntityModel iEntityModel) {
        if (iEntityModel instanceof IOpticsPortModel) {
            boolean bl = ((IOpticsPortModel)iEntityModel).isChannelPort();
            if (bl && !((IOpticsPortModel)iEntityModel).isPassivePort()) {
                bl = OchPortsHelper.isOchPort(iEntityModel);
            }
            return bl;
        }
        return OchPortsHelper.isOchPort(iEntityModel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortComparator
    implements Comparator<IEntityModel> {
        PortComparator() {
        }

        @Override
        public int compare(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
            return ComparisonUtil.compare((int)iEntityModel.getEntityIndex(), (int)iEntityModel2.getEntityIndex());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodeComparator
    implements Comparator<INodeModel> {
        NodeComparator() {
        }

        @Override
        public int compare(INodeModel iNodeModel, INodeModel iNodeModel2) {
            return iNodeModel.getName().compareTo(iNodeModel2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Side
    implements Comparable<Object> {
        private int side;
        private IEntityModel rxPort;
        private IEntityModel txPort;

        Side(int n, IEntityModel iEntityModel, IEntityModel iEntityModel2) {
            this.side = n;
            this.rxPort = iEntityModel;
            this.txPort = iEntityModel2;
        }

        public boolean equals(Object object) {
            if (object instanceof Side) {
                return this.side == ((Side)object).side;
            }
            return false;
        }

        public String toString() {
            return DwdmSide.getSideFromOffset(this.side);
        }

        public int getSideID() {
            return this.side;
        }

        public IEntityModel getTxPort() {
            return this.txPort;
        }

        public IEntityModel getRxPort() {
            return this.rxPort;
        }

        @Override
        public int compareTo(Object object) {
            if (object instanceof Side) {
                return ComparisonUtil.compare((int)this.side, (int)((Side)object).side);
            }
            throw new ClassCastException("Found " + object.getClass().getName());
        }
    }
}

