/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppc;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INetProtectionType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.ui.AbstractPortSelectorAttr;
import cerent.cms.ui.network.MapLinkRenderer;
import cerent.cms.ui.ppc.CombosCellRenderer;
import cerent.cms.ui.ppc.PPCCreationInfo;
import cerent.cms.ui.ppc.PPCHelper;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.DigitTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PPCPortSelectorAttr
implements ActionListener {
    private PPCCreationInfo info;
    private boolean isSrc;
    private boolean isProtect;
    private PPCHelper.Side[] sides;
    private boolean loading = false;
    private JPanel p;
    private JComboBox nodesCB;
    private PortSelector portSel;
    private DefaultComboBoxModel secPortModel;
    private JComboBox secPortCB;
    private DigitTextField idTF;
    private DigitTextField secIdTF;
    private JTextField protTypeTF;

    PPCPortSelectorAttr(PPCCreationInfo pPCCreationInfo) {
        this.info = pPCCreationInfo;
        this.p = new JPanel(new GridBagLayout());
    }

    public void init(boolean bl, boolean bl2) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        this.isSrc = bl;
        this.isProtect = bl2;
        this.initUI();
        if (this.isRO()) {
            this.initRO();
        } else if (bl && this.info.hasFixedSrcNode()) {
            this.initFixedNode();
        } else {
            INodeModel[] iNodeModelArray = this.getNodes();
            this.nodesCB.setModel(new DefaultComboBoxModel<INodeModel>(iNodeModelArray));
            this.loadNode(iNodeModelArray.length > 0 ? iNodeModelArray[0] : null);
        }
    }

    private void initRO() throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        this.loading = true;
        this.nodesCB.setEnabled(false);
        this.nodesCB.removeAllItems();
        INodeModel iNodeModel = this.isSrc ? this.info.getTerm().getSrcNode() : this.info.getTerm().getDstNode();
        this.nodesCB.addItem(iNodeModel);
        IEntityModel iEntityModel = this.info.getTerm().getSrcPort();
        IEntityModel iEntityModel2 = this.info.getTerm().getDstPort();
        IEntityModel iEntityModel3 = null;
        iEntityModel3 = this.isSrc ? PPCHelper.getProtectPort(iEntityModel) : iEntityModel2;
        this.portSel.initRO(iEntityModel3);
        this.loading = false;
        this.initProtType();
        this.initSecPort();
        this.initIDs();
    }

    private void initFixedNode() {
        this.nodesCB.setEnabled(false);
        this.nodesCB.addItem(this.info.getSrcNode());
    }

    private IEntityModel[] getSidesPorts() {
        IEntityModel[] iEntityModelArray = new IEntityModel[this.sides.length];
        for (int i = 0; i < this.sides.length; ++i) {
            iEntityModelArray[i] = this.isSrc ? this.sides[i].getRxPort() : this.sides[i].getTxPort();
        }
        return iEntityModelArray;
    }

    private IEntityModel getOtherPortOnSide(int n) {
        for (PPCHelper.Side side : this.sides) {
            if (side.getSideID() != n) continue;
            return this.isSrc ? side.getTxPort() : side.getRxPort();
        }
        return null;
    }

    private boolean isSide2Side() {
        return this.info.isSide2SideOTS();
    }

    private boolean isOts2Ots() {
        return this.info.isOts2Ots();
    }

    private boolean isOTS() {
        return this.isSide2Side() || this.isOts2Ots();
    }

    private boolean isL2() {
        return this.info.isL2();
    }

    private boolean isOCH() {
        return this.info.isBidi2OCH() && !this.isSrc;
    }

    private boolean isRO() {
        if (this.isProtect) {
            if (this.info.isBidi2Bidi()) {
                if (this.isSrc) {
                    return true;
                }
                if (PPCHelper.isYCableProtected(this.info.getTerm().getSrcPort())) {
                    return true;
                }
            } else if (this.info.isBidi2OCH()) {
                return this.isProtect && this.isSrc;
            }
        }
        return false;
    }

    public String getIDLabel() {
        if (this.info.isBidi2Bidi() || this.info.isL2()) {
            return "ID";
        }
        if (this.isOTS()) {
            if (this.isSrc) {
                return "RX ID: ";
            }
            return "TX ID: ";
        }
        if (this.isSrc) {
            return "TX ID: ";
        }
        return "RX ID: ";
    }

    public String getSecIDLabel() {
        if (this.info.isBidi2Bidi()) {
            return "ID";
        }
        if (this.isOTS()) {
            if (this.isSrc) {
                return "TX ID: ";
            }
            return "RX ID: ";
        }
        if (this.isSrc) {
            return "RX ID: ";
        }
        return "TX ID: ";
    }

    public String getSecPortLabel() {
        if (this.isSrc) {
            return "Tx Port";
        }
        if (this.isOTS()) {
            return "Rx Port";
        }
        return "Tx Port";
    }

    public String getPortLabel() {
        if (this.isSrc) {
            if (this.isOTS()) {
                return "Rx Port";
            }
            return "Port";
        }
        if (this.isOCH()) {
            return "Rx Port";
        }
        if (this.isOTS()) {
            return "Tx Port";
        }
        return "Port";
    }

    private void initUI() {
        this.p.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.bottom = 15;
        this.p.add((Component)new JLabel("Node: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.nodesCB = this.addCB(new DefaultComboBoxModel(), gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        this.portSel = new PortSelector(gridBagConstraints);
        gridBagConstraints.gridy = this.portSel.getPortYPos();
        gridBagConstraints.gridx = 2;
        this.p.add((Component)new JLabel(this.getIDLabel()), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.idTF = new DigitTextField(10);
        this.p.add((Component)this.idTF, gridBagConstraints);
        this.idTF.setEditable(false);
        this.idTF.setPreferredSize(this.portSel.getPortSize());
        if (this.hasSecPort()) {
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.p.add((Component)new JLabel(this.getSecPortLabel() + ": "), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.secPortModel = new DefaultComboBoxModel();
            this.secPortCB = this.addCB(this.secPortModel, gridBagConstraints, true);
        }
        if (this.hasSecID()) {
            if (!this.hasSecPort()) {
                ++gridBagConstraints.gridy;
            }
            gridBagConstraints.gridx = 2;
            this.p.add((Component)new JLabel(this.getSecIDLabel()), gridBagConstraints);
            gridBagConstraints.gridx = 3;
            this.secIdTF = new DigitTextField(10);
            this.p.add((Component)this.secIdTF, gridBagConstraints);
            this.secIdTF.setEditable(false);
            this.secIdTF.setPreferredSize(this.portSel.getPortSize());
        }
        if (this.hasProtection()) {
            if (!this.hasSecID()) {
                ++gridBagConstraints.gridy;
            }
            gridBagConstraints.gridx = 0;
            this.p.add((Component)new JLabel("Protection: "), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.protTypeTF = new JTextField();
            this.p.add((Component)this.protTypeTF, gridBagConstraints);
            this.protTypeTF.setEditable(false);
            this.protTypeTF.setPreferredSize(this.portSel.getPortSize());
        }
    }

    public JPanel getUI() {
        return this.p;
    }

    public INodeModel getNode() {
        return (INodeModel)this.nodesCB.getSelectedItem();
    }

    public IEntityModel getPort() {
        return this.portSel.getPort();
    }

    public int getID() throws NumberFormatException {
        return Integer.parseInt(this.idTF.getText());
    }

    public String getIDStr() {
        return this.idTF.getText();
    }

    private void setSecPort(IEntityModel iEntityModel) {
        if (iEntityModel != null) {
            this.setSecPorts(new IEntityModel[]{iEntityModel});
        } else {
            this.setSecPorts(new IEntityModel[0]);
        }
    }

    private void setSecPorts(IEntityModel[] iEntityModelArray) {
        if (this.hasSecPort()) {
            this.secPortCB.setEnabled(iEntityModelArray.length > 1);
            if (iEntityModelArray.length == 0) {
                this.loadModel(this.secPortModel, new Object[0]);
            } else {
                this.loadModel(this.secPortModel, iEntityModelArray);
                this.secPortCB.setSelectedIndex(0);
            }
        }
    }

    public IEntityModel getSecPort() {
        return (IEntityModel)this.secPortCB.getSelectedItem();
    }

    public int getSecID() throws NumberFormatException {
        return Integer.parseInt(this.secIdTF.getText());
    }

    public String getSecIDStr() {
        return this.secIdTF.getText();
    }

    private INodeModel[] getNodes() {
        if (!this.isRO()) {
            return PPCHelper.getNodes();
        }
        return new INodeModel[0];
    }

    private IEntityModel[] getPorts() {
        if (this.isSide2Side()) {
            this.sides = PPCHelper.getSides(this.getNode());
            return this.getSidesPorts();
        }
        if (this.isOts2Ots()) {
            return PPCHelper.getOTSPorts(this.getNode(), true);
        }
        if (this.isOCH()) {
            return PPCHelper.getOCHPorts(this.getNode(), this.info.getWavelength(), true);
        }
        if (this.isL2()) {
            INodeModel iNodeModel = this.getNode();
            IEntityModel[] iEntityModelArray = PPCHelper.getL2Ports(iNodeModel);
            return this.filterExistingVlinks(iEntityModelArray, iNodeModel);
        }
        if (this.info.isProtected() && this.isSrc) {
            return PPCHelper.getProtectedBidiPorts(this.getNode(), this.info.getWavelength());
        }
        INodeModel iNodeModel = this.getNode();
        IEntityModel[] iEntityModelArray = PPCHelper.getBidiPorts(iNodeModel, this.info.getWavelength());
        return this.filterExistingVlinks(iEntityModelArray, iNodeModel);
    }

    private IEntityModel[] filterExistingVlinks(IEntityModel[] iEntityModelArray, INodeModel iNodeModel) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        if (iEntityModelArray != null && iEntityModelArray.length > 0) {
            IVirtualLinkModel[] iVirtualLinkModelArray = iNodeModel.getVirtualLinksManager().getVirtualLinks();
            if (iVirtualLinkModelArray != null && iVirtualLinkModelArray.length > 0) {
                for (int i = 0; i < iEntityModelArray.length; ++i) {
                    IEntityModel iEntityModel = this.findOtherPortModel(iEntityModelArray[i]);
                    boolean bl = false;
                    if (iEntityModel != null) {
                        for (int j = 0; j < iVirtualLinkModelArray.length; ++j) {
                            IEntityModel iEntityModel2 = iVirtualLinkModelArray[j].getOrigEntity();
                            IEntityModel iEntityModel3 = iVirtualLinkModelArray[j].getTermEntity();
                            if (iEntityModel2 != null && iEntityModel2.equals(iEntityModel)) {
                                bl = true;
                                break;
                            }
                            if (iEntityModel3 == null || !iEntityModel3.equals(iEntityModel)) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (bl) continue;
                    arrayList.add(iEntityModelArray[i]);
                }
            } else {
                return iEntityModelArray;
            }
        }
        return arrayList.toArray(new IEntityModel[0]);
    }

    private IEntityModel findOtherPortModel(IEntityModel iEntityModel) {
        IModuleModel iModuleModel;
        if (iEntityModel != null && iEntityModel.getEqType() != 122 && ((iModuleModel = iEntityModel.getModuleModel()).getEqType() == 271 || iModuleModel.getEqType() == 272)) {
            List list = iEntityModel.getParent().getChildren();
            for (IEntityModel iEntityModel2 : list) {
                if (!(this.isL2() ? iEntityModel2.getEqType() == 123 : iEntityModel2.getEqType() != 123)) continue;
                return iEntityModel2;
            }
        }
        return null;
    }

    void loadNode(INodeModel iNodeModel) {
        if (this.hasSecPort()) {
            this.secPortModel.removeAllElements();
        }
        this.portSel.clearAllModels();
        if (iNodeModel != null) {
            this.portSel.loadAllPorts(this.getPorts());
        } else {
            this.setSecPort(null);
        }
        this.initProtType();
        this.initIDs();
    }

    private void initProtType() {
        if (!this.hasProtection()) {
            return;
        }
        if (this.getPort() != null) {
            try {
                INetProtectionType iNetProtectionType = PPCHelper.getProtType(this.getPort());
                TDMTerminology tDMTerminology = this.getPort().getNodeModel().getTDMTerminology();
                this.protTypeTF.setText(MapLinkRenderer.getProtectionTypeString(iNetProtectionType.getEnum(), tDMTerminology));
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                this.protTypeTF.setText("Unknown");
            }
        } else {
            this.protTypeTF.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initSecPort() {
        if (!this.hasSecPort()) return;
        if (this.getPort() == null) return;
        if (this.isOts2Ots()) {
            block11: {
                IEntityModel[] iEntityModelArray = null;
                try {
                    try {
                        if (this.getPort() instanceof IOpticsPortModel) {
                            iEntityModelArray = ((IOpticsPortModel)this.getPort()).getReversePortModels();
                        }
                    }
                    catch (Exception exception) {
                        Object var4_3 = null;
                        if (iEntityModelArray != null && iEntityModelArray.length > 0) {
                            this.setSecPorts(iEntityModelArray);
                            return;
                        }
                        this.setSecPorts(PPCHelper.getOTSPorts(this.getNode(), false));
                        return;
                    }
                    Object var4_2 = null;
                    if (iEntityModelArray == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (iEntityModelArray != null && iEntityModelArray.length > 0) {
                        this.setSecPorts(iEntityModelArray);
                        throw throwable;
                    }
                    this.setSecPorts(PPCHelper.getOTSPorts(this.getNode(), false));
                    throw throwable;
                }
                if (iEntityModelArray.length > 0) {
                    this.setSecPorts(iEntityModelArray);
                    return;
                }
            }
            this.setSecPorts(PPCHelper.getOTSPorts(this.getNode(), false));
            return;
        }
        if (this.getNode().provides(Feature.OCH_TRAIL_PROVISIONING)) {
            this.setSecPorts(PPCHelper.getReversePorts(this.getPort()));
            return;
        }
        if (!this.isOCH()) return;
        this.setSecPorts(PPCHelper.getOCHPorts(this.getNode(), this.info.getWavelength(), false));
    }

    private void initIDs() {
        INodeModel iNodeModel = this.getNode();
        if (iNodeModel != null) {
            int n = PPCHelper.getFirstID(this.getNode(), this.info);
            this.idTF.setText(Integer.toString(n));
            if (this.hasSecID()) {
                int n2 = PPCHelper.getFirstID(this.getNode(), this.info, n);
                this.secIdTF.setText(Integer.toString(n2));
            }
        } else {
            this.idTF.setText("");
            if (this.hasSecID()) {
                this.secIdTF.setText("");
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.loading) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.nodesCB) {
            this.loadNode((INodeModel)this.nodesCB.getSelectedItem());
        }
    }

    private void loadModel(DefaultComboBoxModel defaultComboBoxModel, Object[] objectArray) {
        defaultComboBoxModel.removeAllElements();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultComboBoxModel.addElement(objectArray[i]);
        }
    }

    public boolean hasSecPort() {
        return this.isOTS() || this.isOCH();
    }

    public boolean hasSecID() {
        return this.info.hasSecPort();
    }

    private boolean hasProtection() {
        return this.info.isBidi2Bidi() || this.isSrc && this.info.isBidi2OCH();
    }

    private boolean hasSide() {
        return this.info.isSide2SideOTS();
    }

    private JComboBox addCB(DefaultComboBoxModel defaultComboBoxModel, GridBagConstraints gridBagConstraints) {
        return this.addCB(defaultComboBoxModel, gridBagConstraints, false);
    }

    private JComboBox addCB(DefaultComboBoxModel defaultComboBoxModel, GridBagConstraints gridBagConstraints, boolean bl) {
        JComboBox jComboBox = new JComboBox(defaultComboBoxModel){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 160;
                return dimension;
            }
        };
        jComboBox.setRenderer(new CombosCellRenderer(bl));
        jComboBox.addActionListener(this);
        this.p.add((Component)jComboBox, gridBagConstraints);
        return jComboBox;
    }

    private class PortSelector
    extends AbstractPortSelectorAttr {
        PortSelector(GridBagConstraints gridBagConstraints) {
            super(null, null, false, new CombosCellRenderer(false));
            super.initUI(PPCPortSelectorAttr.this.p, gridBagConstraints, false);
        }

        int getPortYPos() {
            return this.portCB.gridy();
        }

        Dimension getPortSize() {
            return this.portCB.getCB().getPreferredSize();
        }

        protected void initRO(IEntityModel iEntityModel) {
            try {
                super.initRO(iEntityModel);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }

        public String getPortLabel() {
            return PPCPortSelectorAttr.this.getPortLabel();
        }

        protected boolean isCardSelectorNeeded() {
            return PPCPortSelectorAttr.this.isOts2Ots() || PPCPortSelectorAttr.this.isOCH();
        }

        protected boolean isMPOSelectorNeeded() {
            return false;
        }

        protected boolean isPortSelectorNeeded() {
            return true;
        }

        protected boolean isSideSelectorNeeded() {
            return PPCPortSelectorAttr.this.hasSide();
        }

        protected void notifyPortSelected(IEntityModel iEntityModel) {
            if (iEntityModel != null) {
                PPCPortSelectorAttr.this.initSecPort();
                PPCPortSelectorAttr.this.initProtType();
                if (PPCPortSelectorAttr.this.hasSide()) {
                    int n = iEntityModel.getSide();
                    PPCPortSelectorAttr.this.setSecPort(PPCPortSelectorAttr.this.getOtherPortOnSide(n));
                }
            }
        }

        protected void loadAllPorts(IEntityModel[] iEntityModelArray) {
            this.setNodeModel(PPCPortSelectorAttr.this.getNode());
            super.loadAllPorts(iEntityModelArray);
            this.notifyPortSelected(this.getPort());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CardComparator
    implements Comparator<IModuleModel> {
        CardComparator() {
        }

        @Override
        public int compare(IModuleModel iModuleModel, IModuleModel iModuleModel2) {
            return ComparisonUtil.compare((int)iModuleModel.getSlot(), (int)iModuleModel2.getSlot());
        }
    }
}

