/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppc;

import cerent.cms.model.IEntityModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.PPCLinkCreationDialog;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.ppc.CombosCellRenderer;
import cerent.cms.ui.ppc.PPCCreationInfo;
import cerent.cms.ui.ppc.PPCHelper;
import cerent.cms.ui.ppc.PPCPortSelectorAttr;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PPCcdSourcePane
extends WzPane {
    protected PPCPortSelectorAttr portSelectorAttr;
    protected boolean isProtect;
    protected int minPPCIdValue = 1;
    protected int maxPPCIdValue = Short.MAX_VALUE;

    public PPCcdSourcePane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(wzDialog, wzDiagDebug, string);
        this.isProtect = bl;
    }

    public PPCcdSourcePane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        this(wzDialog, wzDiagDebug, string, false);
    }

    protected boolean isSourcePane() {
        return true;
    }

    public void validatePage() throws Exception {
        IEntityModel iEntityModel;
        Object object;
        if (this.getPort() == null) {
            throw new Exception("The port " + this.portSelectorAttr.getPortLabel() + " must be selected.");
        }
        if (!this.validateID(this.portSelectorAttr.getID())) {
            throw new Exception(this.portSelectorAttr.getIDLabel() + " Value must be between " + this.minPPCIdValue + " and " + this.maxPPCIdValue);
        }
        if (this.portSelectorAttr.hasSecID() && !this.validateID(this.portSelectorAttr.getSecID())) {
            throw new Exception(this.portSelectorAttr.getSecIDLabel() + " Value must be between " + this.minPPCIdValue + " and " + this.maxPPCIdValue);
        }
        if (!this.isSourcePane()) {
            IEntityModel iEntityModel2;
            object = this.getTermInfo().getSrcPort();
            if (object.equals(iEntityModel = this.getPort())) {
                throw new Exception("The origination and termination ports must be different.");
            }
            if (this.getInfo().isProtected() && this.isProtect && (iEntityModel2 = this.getInfo().getTerm().getDstPort()).equals(iEntityModel) && !PPCHelper.isYCableProtected((IEntityModel)object)) {
                throw new Exception("The working and protect terminations must be different.");
            }
        }
        if (this.getInfo().isProtected() && this.isSourcePane() && !this.isProtect) {
            object = this.getPort();
            iEntityModel = PPCHelper.getProtectPort((IEntityModel)object);
            if (iEntityModel == null) {
                throw new Exception("A protect entity for the\nselected port " + this.portSelectorAttr.getPortLabel() + " cannot be found.");
            }
            if (!PPCHelper.isAvailable(iEntityModel)) {
                throw new Exception("The following protect port is not available for\nprovisioning a PPC link:\n" + CombosCellRenderer.toString(iEntityModel, true));
            }
        }
        if (!(this.getInfo().isSide2SideOTS() || this.getInfo().isOts2Ots() || this.getInfo().isProtected() || !PPCHelper.isProtected(this.getPort()) || CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_PPC_NON_PROT_PROT_PORT), (String)this.getName()))) {
            this.isOkToPostValidate = false;
            return;
        }
        object = this.getTermInfo();
        if (this.isSourcePane()) {
            ((PPCCreationInfo.TermInfo)object).setSrcPort(this.portSelectorAttr.getPort());
        } else {
            ((PPCCreationInfo.TermInfo)object).setDstPort(this.portSelectorAttr.getPort());
        }
        try {
            if (this.isSourcePane()) {
                ((PPCCreationInfo.TermInfo)object).setSrcID(this.portSelectorAttr.getID());
            } else {
                ((PPCCreationInfo.TermInfo)object).setDstID(this.portSelectorAttr.getID());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("The ID \"" + this.portSelectorAttr.getIDStr() + "\" is invalid.");
        }
        if (this.portSelectorAttr.hasSecPort()) {
            if (this.portSelectorAttr.getSecPort() == null) {
                throw new Exception("The port " + this.portSelectorAttr.getSecPortLabel() + " must be selected.");
            }
            if (this.isSourcePane()) {
                ((PPCCreationInfo.TermInfo)object).setSecSrcPort(this.portSelectorAttr.getSecPort());
            } else {
                ((PPCCreationInfo.TermInfo)object).setSecDstPort(this.portSelectorAttr.getSecPort());
            }
        }
        if (this.portSelectorAttr.hasSecID()) {
            try {
                if (this.isSourcePane()) {
                    ((PPCCreationInfo.TermInfo)object).setSecSrcID(this.portSelectorAttr.getSecID());
                } else {
                    ((PPCCreationInfo.TermInfo)object).setSecDstID(this.portSelectorAttr.getSecID());
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("The ID \"" + this.portSelectorAttr.getSecIDStr() + "\" is invalid.");
            }
        }
    }

    public boolean handleBack() {
        PPCCreationInfo.TermInfo termInfo = this.getTermInfo();
        if (this.isSourcePane()) {
            termInfo.reset();
        } else {
            termInfo.resetDst();
        }
        return super.handleBack();
    }

    public void revalidateData() {
        try {
            this.portSelectorAttr.init(this.isSourcePane(), this.isProtect);
        }
        catch (Exception exception) {
            CerentDialog.errorDialog((Component)this, (Exception)exception, (String)"Cannot init pane");
        }
    }

    protected String getNextPaneName() {
        PPCCreationInfo pPCCreationInfo = this.getInfo();
        if (this.isSourcePane()) {
            if (!this.isProtect) {
                if (pPCCreationInfo.isProtected()) {
                    return "PPC Protect Origination";
                }
                return "PPC Termination";
            }
            return "PPC Termination";
        }
        if (!this.isProtect) {
            if (pPCCreationInfo.isProtected()) {
                return "PPC Protect Termination";
            }
            return "PPC IDs";
        }
        return "PPC IDs";
    }

    protected PPCCreationInfo getInfo() {
        return ((PPCLinkCreationDialog)this.parent).getInfo();
    }

    protected PPCCreationInfo.TermInfo getTermInfo() {
        if (this.isProtect) {
            return this.getInfo().getProtectTerm();
        }
        return this.getInfo().getTerm();
    }

    protected void initPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.portSelectorAttr = new PPCPortSelectorAttr(this.getInfo());
        jPanel.add((Component)this.portSelectorAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.PPCcdSourcePane;
    }

    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Node: ", this.portSelectorAttr.getNode().getName()});
        arrayList.add(new String[]{"Slot: ", CombosCellRenderer.toString(this.getPort().getModuleModel())});
        arrayList.add(new String[]{this.portSelectorAttr.getPortLabel() + ": ", CombosCellRenderer.toString(this.getPort(), false)});
        arrayList.add(new String[]{this.portSelectorAttr.getIDLabel(), Integer.toString(this.portSelectorAttr.getID())});
        if (this.portSelectorAttr.hasSecPort()) {
            arrayList.add(new String[]{this.portSelectorAttr.getSecPortLabel() + ": ", CombosCellRenderer.toString(this.getSecPort(), true)});
        }
        if (this.portSelectorAttr.hasSecID()) {
            arrayList.add(new String[]{this.portSelectorAttr.getSecIDLabel(), Integer.toString(this.portSelectorAttr.getSecID())});
        }
        return PPCcdSourcePane.getGridPanel(arrayList);
    }

    private IEntityModel getPort() {
        return this.portSelectorAttr.getPort();
    }

    private IEntityModel getSecPort() {
        return this.portSelectorAttr.getSecPort();
    }

    protected boolean validateID(int n) {
        return n >= this.minPPCIdValue && n <= this.maxPPCIdValue;
    }
}

