/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.snmp;

import cerent.cms.model.Feature;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.INodeModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class GneSelector
extends UComboBox
implements PopupMenuListener {
    private static SDebug db = new SDebug("GneSelector");
    private static final int GNE_TYPE = 2;
    private ArrayList gneList = new ArrayList();

    public GneSelector() {
        this.setRenderer(new GneCellRenderer());
        this.updateNodeList();
        this.addPopupMenuListener(this);
    }

    public void removeNode(INodeModel iNodeModel) {
        this.removeItem(iNodeModel);
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.updateNodeList();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public synchronized void updateNodeList() {
        block3: {
            this.removeAllItems();
            this.gneList.clear();
            Collection collection = Network.instance().getElements();
            Iterator iterator = collection.iterator();
            try {
                while (iterator.hasNext()) {
                    INetElement iNetElement = (INetElement)iterator.next();
                    INodeModel iNodeModel = iNetElement.getNodeModel();
                    if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SNMPV3) || !iNodeModel.isInited() || iNodeModel.getProxyConfiguration() != 2) continue;
                    this.addItem(iNodeModel);
                    this.gneList.add(iNodeModel);
                }
            }
            catch (Exception exception) {
                if (!GneSelector.db.on) break block3;
                db.println("Error while updating the GNE list");
            }
        }
    }

    public ArrayList getAllGnes() {
        return this.gneList;
    }

    public class GneCellRenderer
    implements ListCellRenderer,
    TableCellRenderer {
        private DefaultListCellRenderer dlcr = new DefaultListCellRenderer();
        private DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.dlcr.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof INodeModel) {
                this.dlcr.setText(this.getHostName((INodeModel)object));
            }
            return this.dlcr;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.dtcr.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof INodeModel) {
                this.dtcr.setText(this.getHostName((INodeModel)object));
            }
            return this.dtcr;
        }

        public String getHostName(INodeModel iNodeModel) {
            String string;
            if (iNodeModel == null) {
                string = "<null node>";
            } else {
                IIpConfig iIpConfig = iNodeModel.getIpConfig();
                String string2 = InetUtil.makeDottedString(iIpConfig.getIpAddress(), false);
                if (iIpConfig.getNodeMode()) {
                    String string3 = InetUtil.makeDottedString(iIpConfig.getIpv6Address(), true);
                    string = string2 + "/" + string3;
                } else {
                    string = string2;
                }
            }
            return string;
        }
    }

    private class GneComparator
    implements Comparator {
        private GneComparator() {
        }

        public int compare(Object object, Object object2) {
            INodeModel iNodeModel = (INodeModel)object;
            INodeModel iNodeModel2 = (INodeModel)object2;
            return iNodeModel.getHostName().compareTo(iNodeModel2.getHostName());
        }
    }
}

