/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.snmp;

import cerent.cms.model.ISnmpModel;
import cerent.cms.model.SnmpV3PassKey;
import cerent.cms.model.SnmpV3ProxyUser;
import cerent.cms.ui.Pane;
import cerent.cms.ui.snmp.SnmpProxyPane;
import cerent.cms.ui.snmp.Snmpv3UserDetailsPanel;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Snmpv3UserEditDialog
extends UDialog
implements ActionListener {
    public static final String EDIT_TITLE = "Edit User";
    public static final int SNMP_USER_MIN_CHARS = 8;
    private JButton okButton;
    private JButton cancelButton;
    protected ISnmpModel snmpModel;
    private SnmpV3ProxyUser sUser = null;
    private Pane parent;
    private Snmpv3UserDetailsPanel userPanel;
    private SnmpProxyPane proxyPane;
    private boolean ok = false;
    private static final SDebug db = new SDebug("Snmpv3UserEditDialog");

    public static Snmpv3UserEditDialog instance(Pane pane, Object object) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new Snmpv3UserEditDialog(frame, EDIT_TITLE, object);
    }

    private Snmpv3UserEditDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        this.proxyPane = (SnmpProxyPane)object;
        this.snmpModel = this.proxyPane.getCurrentGneSnmpModel();
        jPanel.add((Component)this.getCreatePanel(), "Center");
        this.setSize(new Dimension(440, 210));
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.parent = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.ok();
                    this.ok = true;
                    this.dispose();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    protected boolean apply() throws Exception {
        return this.validateFields();
    }

    private void ok() {
        block4: {
            SnmpV3PassKey snmpV3PassKey = this.userPanel.getAuthPassKey();
            SnmpV3PassKey snmpV3PassKey2 = this.userPanel.getPrivPassKey();
            if (null == snmpV3PassKey.getPwd() || snmpV3PassKey.getPwd().length() == 0) {
                snmpV3PassKey = new SnmpV3PassKey(this.sUser.getAuthKey().getKey(), this.sUser.getAuthKey().getKey().length, new String(""), false);
            }
            if (null == snmpV3PassKey2.getPwd() || snmpV3PassKey2.getPwd().length() == 0) {
                snmpV3PassKey2 = new SnmpV3PassKey(this.sUser.getPrivKey().getKey(), this.sUser.getPrivKey().getKey().length, new String(""), false);
            }
            SnmpV3ProxyUser snmpV3ProxyUser = new SnmpV3ProxyUser(snmpV3PassKey, this.userPanel.getAuthProtocol(), "", snmpV3PassKey2, this.userPanel.getPrivProtocol(), this.userPanel.getUserName(), this.sUser.getEngine());
            try {
                this.proxyPane.getCurrentGneSnmpModel().setSnmpV3UserWrapper((Object)snmpV3ProxyUser);
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public String getUserName() {
        return this.userPanel.getUserName();
    }

    public SnmpV3PassKey getAuthPassKey() {
        return this.userPanel.getAuthPassKey();
    }

    public SnmpV3PassKey getPrivPassKey() {
        return this.userPanel.getPrivPassKey();
    }

    public int getAuthProtocol() {
        return this.userPanel.getAuthProtocol();
    }

    public int getPrivProtocol() {
        return this.userPanel.getPrivProtocol();
    }

    private JPanel getCreatePanel() {
        this.userPanel = new Snmpv3UserDetailsPanel("Remote User Details", this.proxyPane, false);
        return this.userPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private boolean validateFields() {
        return this.userPanel.validateEditCriteria(this.sUser);
    }

    public void setSelectedUser(SnmpV3ProxyUser snmpV3ProxyUser) {
        this.setTitle(EDIT_TITLE);
        this.sUser = snmpV3ProxyUser;
        this.userPanel.setSelectedItem(snmpV3ProxyUser, true);
    }
}

