/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.span;

import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.span.SdAbstractPane;
import cerent.cms.ui.span.SpanUpgradeDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;

public class SdOnePlusOnePane
extends SdAbstractPane {
    protected static final int FIRST_PAGE = 1;
    protected static final int LAST_PAGE = 11;

    public SdOnePlusOnePane(String string, SpanUpgradeDialog spanUpgradeDialog, int n) {
        super(string, spanUpgradeDialog, n);
    }

    protected int getFirstPageNum() {
        return 1;
    }

    protected int getLastPageNum() {
        return 11;
    }

    protected String getTopMessage() {
        return "You are about to perform a span upgrade.  At each step,\nalways verify that no unexpected service affecting alarms are\nraised.\n \nTo continue, select the upgrade below:";
    }

    protected String getDesc() {
        String string = "";
        switch (this.step) {
            case 2: {
                string = "The system is about to send a force switch command to one or\nboth end ports to force the traffic onto the working span.\n \nWhen you are ready, click Next.";
                break;
            }
            case 3: {
                string = "The command, FORCE_SWITCH_TO_WORKING, has been sent.\nWait a few seconds for the command to take effect.\n \nWhen you are ready, click Next.";
                break;
            }
            case 4: {
                String string2 = "Remove the";
                String string3 = "from the protect";
                string = this.getEquipmentChangeString(OLD_EQUIPMENT, 2, string2, string3) + " \nWhen you are done, click Next.";
                break;
            }
            case 5: {
                String string4 = "Insert the";
                String string5 = "into the protect";
                string = this.getEquipmentChangeString(NEW_EQUIPMENT, 2, string4, string5) + " \nWhen the cards finish booting, test the optical receive levels\n" + "for the newly installed card and apply attenuation, if needed.\n" + "Refer to the user documentation for minimum/maximum\n" + "optical levels.\n \n" + "When you are ready, reconnect the fibers and click Next.";
                break;
            }
            case 6: {
                string = "The protect slots are upgraded to " + this.parent.getNewEquipmentsString(2) + ".  The system is about\n" + "to send a force switch command to one or both end ports to\n" + "force the traffic onto the protect span.\n \n" + "When you are ready, click Next.";
                break;
            }
            case 7: {
                string = "The command, FORCE_SWITCH_TO_PROTECT, has been sent.\nWait a few seconds for the command to take effect.\n \nWhen you are ready, click Next.";
                break;
            }
            case 8: {
                String string6 = "Then remove the";
                String string7 = "from the working";
                string = "Check that traffic is switched to the protect span and no unexpected\nservice affecting alarms are raised.\n" + (this.parent.needChangeCardInUpgrade() ? this.getEquipmentChangeString(OLD_EQUIPMENT, 1, string6, string7) : "") + " \nWhen you are done, click Next.";
                break;
            }
            case 9: {
                String string8 = "Insert the";
                String string9 = "into the working";
                string = this.getEquipmentChangeString(NEW_EQUIPMENT, 1, string8, string9) + " \nWhen the cards finish booting, test the optical receive levels\n" + "for the newly installed card and apply attenuation, if needed.\n" + "Refer to the user documentation for minimum/maximum\n" + "optical levels.\n \n" + "When you are ready, reconnect the fibers and click Next.";
                break;
            }
            case 10: {
                string = "The system is about to send a clear command to one or both\nend ports to clear the FORCE_SWITCH_TO_PROTECT command.\n \nWhen you are ready, click Next.";
                break;
            }
            case 11: {
                string = "You have completed a span upgrade.  Click the Finish button\nto exit this dialog box.";
            }
        }
        return string;
    }

    private void performStep1() throws Exception {
        this.parent.setEquipmentInfo(this.srcEqTypeCB.getSelectedItem(), this.dstEqTypeCB.getSelectedItem(), this.portRateCB.getSelectedItem());
        this.parent.setStatusText("- Upgrading to " + this.parent.getNewEquipmentsString() + "\n");
    }

    private void performStep2() throws Exception {
        if (!this.linkModel.isOnePlusOneWorkingPortIS()) {
            throw new Exception("The working ports are not in service.");
        }
        if (!this.linkModel.isOnePlusOneClear()) {
            throw new Exception("The span upgrade cannot proceed because a maintenance\ncommand other than CLEAR was applied.");
        }
        try {
            short s = this.linkModel.setOnePlusOneForceSwitchToWorking();
            if (SdOnePlusOnePane.db.on) {
                db.println("FORCE_SWITCH_TO_WORKING sent");
            }
            if (s == -1) {
                throw new Exception("A system or network condition is preventing the span upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n");
            }
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            SDebug.printStackTrace((Throwable)invalidProtectionOp);
        }
        catch (InternalCommError internalCommError) {
            SDebug.printStackTrace((Throwable)internalCommError);
        }
        catch (Exception exception) {
            throw exception;
        }
        this.parent.setStatusText("- FORCE_SWITCH_TO_WORKING sent\n");
    }

    private void performStep3() throws Exception {
        if (!this.linkModel.isOnePlusOneWorkingActive()) {
            throw new Exception("\nThe traffic has not been switched to the working slots yet.\nWait for a couple seconds and try again.");
        }
    }

    private void performStep4() throws Exception {
        this.parent.setStatusText("- Provisioned the slots to " + this.parent.getNewEquipmentsString(2) + "\n" + this.getProtectSlotString(this.parent.srcInfo, "  ") + "\n" + this.getProtectSlotString(this.parent.dstInfo, "  ") + "\n");
        this.checkNodeInitiations();
        this.parent.srcInfo.changeToNewEquipment(2);
        this.parent.dstInfo.changeToNewEquipment(2);
    }

    private void performStep6() throws Exception {
        try {
            try {
                this.parent.setFinishEnabled(false);
                UiToolkit.instance().setCursor(3);
                short s = this.linkModel.setOnePlusOneClear();
                if (SdOnePlusOnePane.db.on) {
                    db.println("CLEAR sent");
                }
                if (s == -1) {
                    throw new Exception("A system or network condition is preventing the span upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n");
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    db.finest("Interrupted Exception caught after sending CLEAR " + interruptedException);
                }
                s = this.linkModel.setOnePlusOneForceSwitchToProtect();
                if (SdOnePlusOnePane.db.on) {
                    db.println("FORCE_SWITCH_TO_PROTECT sent");
                }
                if (s == -1) {
                    throw new Exception("A system or network condition is preventing the span upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n");
                }
                Object var4_6 = null;
                UiToolkit.instance().setCursor(0);
            }
            catch (InvalidProtectionOp invalidProtectionOp) {
                throw invalidProtectionOp;
            }
            catch (InternalCommError internalCommError) {
                throw internalCommError;
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            UiToolkit.instance().setCursor(0);
            this.parent.setFinishEnabled(true);
            throw throwable;
        }
        this.parent.setFinishEnabled(true);
        this.parent.setStatusText("- FORCE_SWITCH_TO_PROTECT sent\n");
    }

    private void performStep7() throws Exception {
        if (!this.linkModel.isOnePlusOneProtectActive()) {
            this.linkModel.setOnePlusOneForceSwitchToProtect();
            throw new Exception("\nThe traffic has not been switched to the protect slots yet.\nWait for a couple seconds and try again.");
        }
    }

    private void performStep8() throws Exception {
        this.parent.setStatusText("- Provisioned the slots to " + this.parent.getNewEquipmentsString(1) + "\n" + this.getWorkingSlotString(this.parent.srcInfo, "  ") + "\n" + this.getWorkingSlotString(this.parent.dstInfo, "  ") + "\n");
        this.checkNodeInitiations();
        this.parent.srcInfo.changeToNewEquipment(1);
        this.parent.dstInfo.changeToNewEquipment(1);
    }

    private void performStep10() throws Exception {
        try {
            short s = this.linkModel.setOnePlusOneClear();
            if (s == -1) {
                throw new Exception("A system or network condition is preventing the span upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n");
            }
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            SDebug.printStackTrace((Throwable)invalidProtectionOp);
        }
        catch (InternalCommError internalCommError) {
            SDebug.printStackTrace((Throwable)internalCommError);
        }
        catch (Exception exception) {
            throw exception;
        }
        this.parent.setStatusText("- CLEAR sent\n");
    }

    public void validatePage() throws Exception {
        try {
            this.parent.setStatusText("");
            switch (this.step) {
                case 1: {
                    this.performStep1();
                    break;
                }
                case 2: {
                    this.performStep2();
                    break;
                }
                case 3: {
                    this.performStep3();
                    break;
                }
                case 4: {
                    this.performStep4();
                    break;
                }
                case 6: {
                    this.performStep6();
                    break;
                }
                case 7: {
                    this.performStep7();
                    break;
                }
                case 8: {
                    this.performStep8();
                    break;
                }
                case 10: {
                    this.performStep10();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            SDebug.printStackTrace((Throwable)nullPointerException);
            throw new Exception("A system or network condition is preventing the span upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n");
        }
    }

    public void handleCancel() {
        if (this.step == 5) {
            if (CerentDialog.yesNoDialog((Component)this.parent, (String)("Would you like to revert the provision for\n" + this.getProtectSlotString(this.parent.srcInfo, "  ") + "\n" + this.getProtectSlotString(this.parent.dstInfo, "  ") + "?"), (String)"Cancel Span Upgrade", (int)0)) {
                try {
                    this.parent.srcInfo.revertToOldEquipment(2);
                    this.parent.dstInfo.revertToOldEquipment(2);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)this.parent, (EID)NEMC.EID_GENERAL_EXCEPTION);
                }
            }
        } else if (this.step == 9 && CerentDialog.yesNoDialog((Component)this.parent, (String)("Would you like to revert the provision for\n" + this.getWorkingSlotString(this.parent.srcInfo, "  ") + "\n" + this.getWorkingSlotString(this.parent.dstInfo, "  ") + "?"), (String)"Cancel Span Upgrade", (int)0)) {
            try {
                this.parent.srcInfo.revertToOldEquipment(1);
                this.parent.dstInfo.revertToOldEquipment(1);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this.parent, (EID)NEMC.EID_GENERAL_EXCEPTION);
            }
        }
        if (this.step == 6 || this.step == 10) {
            boolean bl;
            boolean bl2 = this.parent.getSrcUpgradeType() == SpanUpgradeDialog.PPM_2_PPM_UPGRADE;
            boolean bl3 = bl = this.parent.getDstUpgradeType() == SpanUpgradeDialog.PPM_2_PPM_UPGRADE;
            if (bl2 || bl) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(bl2 ? this.getProtectSlotString(this.parent.srcInfo, "\n  ") : "");
                stringBuffer.append(bl ? this.getProtectSlotString(this.parent.dstInfo, "\n  ") : "");
                if (this.step == 10) {
                    stringBuffer.append(bl2 ? this.getWorkingSlotString(this.parent.srcInfo, "\n  ") : "");
                    stringBuffer.append(bl ? this.getWorkingSlotString(this.parent.dstInfo, "\n  ") : "");
                }
                if (CerentDialog.yesNoDialog((Component)this.parent, (String)("Would you like to revert the provision for" + stringBuffer.toString() + "?"), (String)"Cancel Span Upgrade", (int)0)) {
                    try {
                        if (bl2) {
                            this.parent.srcInfo.revertToOldEquipment(2);
                            if (this.step == 10) {
                                this.parent.srcInfo.revertToOldEquipment(1);
                            }
                        }
                        if (bl) {
                            this.parent.dstInfo.revertToOldEquipment(2);
                            if (this.step == 10) {
                                this.parent.dstInfo.revertToOldEquipment(1);
                            }
                        }
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                        ErrorMsg.displayError((Component)this.parent, (EID)NEMC.EID_GENERAL_EXCEPTION);
                    }
                }
            }
        }
        if (this.step >= 3 && CerentDialog.yesNoDialog((Component)this.parent, (String)"Would you like to clear the protection switch?", (String)"Cancel Span Upgrade", (int)0)) {
            try {
                this.linkModel.setOnePlusOneClear();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this.parent, (EID)NEMC.EID_PROTECTION_SWITCHING_ERROR);
            }
        }
    }

    public int getNextStepNum() throws Exception {
        if (this.step == 3 && !this.parent.needChangeCardInUpgrade()) {
            this.performStep4();
            return 6;
        }
        if (this.step == 8 && !this.parent.needChangeCardInUpgrade()) {
            return 10;
        }
        return super.getNextStepNum();
    }
}

