/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.span;

import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPluggableSlotModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPpmModel;
import cerent.cms.model.ITdmModuleModel;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.span.SdEndpointInfo;
import cerent.cms.ui.span.SdEndpointSide;
import java.util.List;

class SdPpmEndpointSide
extends SdEndpointSide {
    protected int[] ppmSlotNo = this.getPpmSlotModel().getHierarchyNums();

    SdPpmEndpointSide(SdEndpointInfo sdEndpointInfo, int n) throws Exception {
        super(sdEndpointInfo, n);
        IEntityModel iEntityModel;
        IPortModel iPortModel = this.getPortModel();
        if (iPortModel.getParent() instanceof IPpmModel && (iEntityModel = iPortModel.getParent().getParent()) != null && iEntityModel.getModuleModel() != null) {
            this.oldCardType = iEntityModel.getModuleModel().getEqType();
        }
    }

    public IPpmModel getPpmModel() throws Exception {
        return (IPpmModel)this.getPortModel().getParent();
    }

    public IPluggableSlotModel getPpmSlotModel() throws Exception {
        return (IPluggableSlotModel)this.getPpmModel().getParent();
    }

    protected void setNewPortType(int n) throws Exception {
        super.setNewPortType(n);
        IPortModel iPortModel = this.getPortModel();
        IPpmModel iPpmModel = this.getPpmModel();
        this.upgradeType = iPpmModel.supportPortType(iPortModel.getPositionInParent(), n) ? 4 : 3;
        if (db.on()) {
            db.println("upgradeType=" + this.upgradeType);
        }
    }

    public void changeToNewEquipment() throws Exception {
        int[] nArray = this.newPortType == 0 ? new int[]{} : new int[]{150, this.newPortType};
        if (Feature.provides((INodeModel)this.getModuleModel().getNodeModel(), (Feature)Feature.MRC_CHANGE_EQ_TYPE)) {
            ((ITdmModuleModel)this.getModuleModel()).changeCardEqType(this.newCardType, nArray);
        } else {
            this.getPpmModel().changePortType(this.getPortModel(), this.newPortType);
        }
    }

    public void revertToOldEquipment() throws Exception {
        int[] nArray = this.newPortType == 0 ? new int[]{} : new int[]{150, this.newPortType};
        if (Feature.provides((INodeModel)this.getModuleModel().getNodeModel(), (Feature)Feature.MRC_CHANGE_EQ_TYPE)) {
            ((ITdmModuleModel)this.getModuleModel()).changeCardEqType(this.oldCardType, nArray);
        } else if (this.oldCardType > 0) {
            ((ITdmModuleModel)this.getModuleModel()).changeEqType(this.oldCardType);
        } else {
            this.getPpmModel().changePortType(this.getPortModel(), this.oldPortType);
        }
    }

    public List getListOfValidUpgradeType() throws Exception {
        IPluggableSlotModel iPluggableSlotModel = this.getPpmSlotModel();
        return iPluggableSlotModel.getListOfValidUpgradeType(this.oldPortType);
    }

    public String getSlotString() {
        return this.parent.getNodeName() + ", slot " + this.slotNo + ", PPM " + PortHelper.getConcatenatedString((int[])this.ppmSlotNo);
    }

    public boolean isIOCardUpgrade() {
        return false;
    }

    public boolean isPPMCardUpgrade() {
        boolean bl = false;
        try {
            IPluggableSlotModel iPluggableSlotModel = this.getPpmSlotModel();
            bl = iPluggableSlotModel.isPPMCardUpgrade();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.upgradeType == 5 || bl;
    }
}

