/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tl1;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ISecurityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.tl1.HistoryBox;
import cerent.cms.ui.tl1.HistoryItem;
import cerent.cms.ui.tl1.MessageBox;
import cerent.cms.ui.tl1.RequestBox;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.KEMC;
import cerent.util.SDebug;
import cerent.util.terminal.IDataProcessor;
import cerent.util.terminal.IReaderThread;
import cerent.util.terminal.SshReaderThread;
import cerent.util.terminal.TelnetReaderThread;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

public class TL1ClientPanel
extends JPanel
implements IDataProcessor,
WindowListener,
Observer {
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private HistoryBox tl1History;
    private MessageBox tl1Message;
    private RequestBox tl1Request;
    private String host;
    private int port;
    private IReaderThread readerThread;
    private String activeCmd;
    private boolean connected = false;
    private boolean secure;
    private static boolean debug = false;
    private static SDebug db = new SDebug("TL1ClientPanel");
    private final byte IAC = (byte)-1;
    private final byte WILL = (byte)-5;
    private final byte DO = (byte)-4;
    private final byte WONT = (byte)-3;
    private final byte DONT = (byte)-2;
    private INodeModel nm;
    private ISecurityModel sm;

    public TL1ClientPanel(INodeModel iNodeModel) {
        this.nm = iNodeModel;
        this.host = this.nm.getHostName();
        this.port = this.getTl1TcpPort();
        this.secure = this.isSecureMode();
        this.tl1History = new HistoryBox(this);
        this.tl1Message = new MessageBox(this);
        this.tl1Request = new RequestBox(this);
        ISecurityModel iSecurityModel = this.nm.getSecurityModel();
        if (iSecurityModel != null) {
            iSecurityModel.addObserver((Observer)this);
        }
        this.displayComponent();
    }

    private void displayComponent() {
        this.tl1History.display();
        this.tl1Message.display();
        this.tl1Request.display();
        this.setLayout(this.gbl);
        Insets insets = new Insets(0, 3, 0, 3);
        Insets insets2 = new Insets(3, 3, 3, 3);
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.5;
        this.gbc.gridwidth = 10;
        this.gbc.insets = insets;
        this.add((Component)this.tl1History.getClientPanel(), this.gbc);
        this.gbc.fill = 1;
        this.gbc.gridy = 1;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 10;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = insets2;
        this.add((Component)this.tl1Message.getClientPanel(), this.gbc);
        this.gbc.fill = 2;
        this.gbc.anchor = 18;
        this.gbc.gridy = 2;
        this.gbc.gridx = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridwidth = 10;
        this.gbc.insets = insets;
        this.add((Component)this.tl1Request.getClientPanel(), this.gbc);
        this.tl1Request.inputFocus();
    }

    public void update(Observable observable, Object object) {
        db.fine("update( " + object + " ) from " + observable);
        if (observable instanceof ISecurityModel) {
            boolean bl;
            if (object == ModelUpdateType.LOGOUT) {
                db.fine("update(): LOGOUT.");
                if (this.connected) {
                    db.fine("update(): LOGOUT disconnect.");
                    this.disconnect();
                }
            } else if (object == ModelUpdateType.CHANGED && (bl = this.isSecureMode()) != this.secure) {
                this.secure = bl;
                if (this.connected) {
                    db.fine("update(): disconnect.");
                    this.disconnect();
                }
            }
        }
    }

    private void destroy() {
        db.fine("Enter destroy()");
        this.disconnect();
        if (this.sm != null) {
            this.sm.deleteObserver((Observer)this);
        }
    }

    private int getTl1TcpPort() {
        int n = 3083;
        if (this.nm == null) {
            db.fine("getTl1TcpPort(): null nodeModel");
        } else {
            n = this.nm.getTl1TcpPort();
        }
        return n;
    }

    private boolean isSecureMode() {
        boolean bl = false;
        if (this.nm == null) {
            db.fine("isSecureMode(): null nodeModel");
        } else {
            bl = this.nm.doesTl1UseSsh();
        }
        return bl;
    }

    public void setTl1RequestText(HistoryItem historyItem) {
        this.tl1Request.setTl1RequestText(historyItem);
    }

    public void execCommand(String string) {
        this.tl1Request.executeCommand(string);
    }

    public void appendToHistoryLog(String string) {
        this.tl1History.addToHistory(string, true);
    }

    public void appendToMessageLog(String string) {
        this.tl1Message.appendText(string);
    }

    public void loadHistory(File file) {
        this.tl1History.loadHistory(file);
    }

    public void appendToSummaryLog(String string) {
        this.tl1Message.appendSummary(string);
    }

    public synchronized void write(String string) {
        if (!this.connected) {
            this.printlnError("\nTry to connect...");
            try {
                this.connect();
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Exeception: " + exception);
                }
                this.printlnError("\nFailed to connect.");
                return;
            }
        }
        if (this.connected && this.readerThread != null) {
            try {
                String string2 = string + this.tl1Request.getReqEnd();
                if (string.length() > 0) {
                    this.readerThread.write(string2);
                    db.fine("Wrote '" + string2 + "' to readerThread");
                    this.setTl1RequestText(null);
                }
            }
            catch (IOException iOException) {
                this.printlnError("\nError: " + iOException.toString());
                this.disconnect();
            }
        } else {
            this.printlnError("\nNot Connected yet");
            this.disconnect();
        }
    }

    public void printlnError(String string) {
        this.tl1Message.appendText(string + '\n');
    }

    public void incomingData(byte[] byArray, int n, byte[] byArray2, int n2, Object object) {
        String string = new String(byArray, 0, n);
        this.appendToMessageLog(string);
        if (db.isFineEnabled()) {
            db.fine("Read '" + string + "' from readerThread");
        }
    }

    public void terminated(Object object) {
        db.fine("terminated called");
        this.disconnect();
    }

    public synchronized void connect() throws IOException {
        if (this.readerThread == null) {
            try {
                this.secure = this.isSecureMode();
                this.port = this.getTl1TcpPort();
                if (db.isFineEnabled()) {
                    db.fine("Port = " + this.port + " Secure = " + this.secure);
                }
                this.readerThread = this.secure ? new SshReaderThread() : new TelnetReaderThread();
                this.readerThread.connect(this.host, this.port, "", "", (IDataProcessor)this, true);
                this.tl1Request.setConnectButtonEnabled(false);
                this.tl1Request.setDisconnectButtonEnabled(true);
                this.connected = true;
            }
            catch (IOException iOException) {
                this.disconnect();
                if (db.on()) {
                    db.println("Caught: " + iOException + " in connect()");
                    SDebug.printStackTrace((Throwable)iOException);
                }
                throw iOException;
            }
        }
    }

    public synchronized void disconnect() {
        block5: {
            if (this.readerThread != null) {
                try {
                    this.readerThread.disconnect();
                }
                catch (IOException iOException) {
                    ErrorMsg.displayError((Component)this, (EID)KEMC.EID_TERMINAL_DISCONNECT_EXCEPTION, (Object)"TL1");
                    if (db.on()) {
                        db.println("disconnect() exeception: " + iOException);
                        SDebug.printStackTrace((Throwable)iOException);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("disconnect() exeception: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.connected = false;
        this.readerThread = null;
        this.tl1Request.setConnectButtonEnabled(true);
        this.tl1Request.setDisconnectButtonEnabled(false);
    }

    public void windowActivated(WindowEvent windowEvent) {
        db.finest("activated");
        this.tl1Request.inputFocus();
    }

    public void windowClosed(WindowEvent windowEvent) {
        db.finest("closed");
        this.destroy();
    }

    public void windowClosing(WindowEvent windowEvent) {
        db.finest("closing");
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        db.finest("deactivated");
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        db.finest("deiconified");
    }

    public void windowIconified(WindowEvent windowEvent) {
        db.finest("iconified");
    }

    public void windowOpened(WindowEvent windowEvent) {
        db.finest("opened");
    }
}

