/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.Attribute;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.VlanInfo;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.cms.ui.AbstractProvTablePane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.vlan.ProfileVlanDbTableModel;
import cerent.cms.ui.vlan.SvlanDBLoadStoreDialog;
import cerent.cms.ui.vlan.VlanMergeDialog;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedProgressDialog;
import cerent.util.gui.IDetailedProgressController;
import cerent.util.gui.IDetailedProgressDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.ProvAlarmsReader;
import cerent.util.gui.UTable;
import cerent.util.gui.VlanDbWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileVlanDbPane
extends AbstractProvTablePane
implements Observer,
ActionListener,
TableModelListener,
ListSelectionListener {
    private static final int MAX_VLAN_ID = 4093;
    private static final int COLUM_MAXWidth = 45;
    private static final int COLUM_MINWidth = 45;
    static Dimension SELECTIONBOX_DIM = new Dimension(200, 150);
    static Dimension BUTTON0_DIM = new Dimension(75, 25);
    static Dimension BUTTON1_DIM = new Dimension(125, 25);
    private static String PREF_SCOPE_VALUE = "warnVlanDbProfileScope";
    private static String PREF_SCOPE_DESCR = "Scope Change Will Lose Vlan Db Profile Editor Contents";
    private static final SDebug db = new SDebug("ProfileVlanDbPane");
    private INodeModel nm = null;
    private boolean isThisGuestPane = false;
    private JPanel bottomPanel;
    private JPanel bottomLeftPanel;
    private JButton loadButton;
    private JButton storeButton;
    private JButton mergeButton;
    private JButton deleteDBButton;
    private JPanel bottomRightPanel;
    private JTextField rowNumTxt;
    private JButton addRowButton;
    private JButton deleteRowButton;
    private CSHelpButton helpButton;
    private ArrayList<IVlanInfo> importVlanList;

    public ProfileVlanDbPane(String string, TabbedView tabbedView, boolean bl) {
        super(string, tabbedView, new ProfileVlanDbTableModel((Container)tabbedView, false, null), true);
        this.nm = tabbedView.getUiModel().getNodeModel();
        this.isThisGuestPane = bl;
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.setLayout(new BorderLayout());
        this.dataModel = this.dataModel;
        this.table = new UTable((TableModel)this.dataModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getColumn(0).setMinWidth(45);
        this.table.getColumnModel().getColumn(0).setMaxWidth(45);
        this.table.getColumnModel().getColumn(0).setCellRenderer(this.table.getTableHeader().getDefaultRenderer());
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){
            boolean flag = true;

            public void mouseReleased(MouseEvent mouseEvent) {
                ProfileVlanDbPane.this.sortAllRowsBy(ProfileVlanDbPane.this.dataModel, 1, this.flag);
                this.flag = !this.flag;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add(jScrollPane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomLeftPanel = new JPanel();
        this.bottomLeftPanel.setLayout(new FlowLayout(0));
        this.loadButton = new JButton("Load...");
        this.loadButton.addActionListener(this);
        this.storeButton = new JButton("Store...");
        this.storeButton.addActionListener(this);
        this.mergeButton = new JButton("Merge...");
        this.mergeButton.addActionListener(this);
        this.deleteDBButton = new JButton("Delete DB...");
        this.deleteDBButton.addActionListener(this);
        this.enableComponent(this.deleteDBButton, (IModel)this.nm);
        this.bottomLeftPanel.add(this.loadButton);
        this.bottomLeftPanel.add(this.storeButton);
        this.bottomLeftPanel.add(this.mergeButton);
        this.bottomLeftPanel.add(this.deleteDBButton);
        this.mergeButton.setEnabled(false);
        this.bottomRightPanel = new JPanel();
        this.bottomRightPanel.setLayout(new FlowLayout(2));
        Dimension dimension = this.loadButton.getMinimumSize();
        dimension.width = dimension.width / 2 + 5;
        this.rowNumTxt = new JTextField("1");
        this.rowNumTxt.setMinimumSize(dimension);
        this.rowNumTxt.setPreferredSize(dimension);
        this.rowNumTxt.setHorizontalAlignment(0);
        this.enableComponent(this.rowNumTxt, (IModel)this.nm);
        this.addRowButton = new JButton("Add row(s)");
        this.addRowButton.addActionListener(this);
        this.enableComponent(this.addRowButton, (IModel)this.nm);
        this.deleteRowButton = new JButton("Delete Sel. row(s)");
        this.deleteRowButton.addActionListener(this);
        this.bottomRightPanel.add(this.rowNumTxt);
        this.bottomRightPanel.add(this.addRowButton);
        this.bottomRightPanel.add(this.deleteRowButton);
        Dimension dimension2 = new Dimension(75, 25);
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProfileVlanDbPane.this.helpButton.launchHelp(ProfileVlanDbPane.this.getHelpID());
                }
            });
            this.helpButton.setMinimumSize(dimension2);
            this.helpButton.setMaximumSize(dimension2);
            this.bottomRightPanel.add(this.helpButton);
        }
        this.bottomPanel.add((Component)this.bottomLeftPanel, "Center");
        this.bottomPanel.add((Component)this.bottomRightPanel, "East");
        this.add(this.bottomPanel, "South");
    }

    @Override
    public void leavingPage() throws Exception {
        if (((ProfileVlanDbTableModel)this.dataModel).isDirty() && this.isThisGuestPane && this.table.getRowCount() > 0) {
            IgnorableDialog.warningDialog((String)ErrorMsg.getString((EID)NEMC.WID_UNSAVED_PROFILE_EDITOR), (String)PREF_SCOPE_VALUE, (String)PREF_SCOPE_DESCR);
        }
        this.table.getModel().removeTableModelListener(this);
    }

    @Override
    protected int getLeavingPageOption() {
        boolean bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)"The current VLAN database profile has been changed but not stored.\nLeaving this tab will discard these changes.\nIs it OK to continue?", (String)"Changed Profile Not Stored");
        if (bl) {
            return 1;
        }
        return 2;
    }

    @Override
    public void enteringPage() throws Exception {
        this.disableButtons();
        this.table.getModel().addTableModelListener(this);
        super.enteringPage();
    }

    @Override
    public void refresh() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.loadButton) {
            this.loadAction(true);
        } else if (object == this.storeButton) {
            this.storeAction();
            this.disableButtons();
            this.resetDirty();
            ((ProfileVlanDbTableModel)this.dataModel).resetDirty();
        } else if (object == this.mergeButton) {
            this.mergeAction();
        } else if (object == this.addRowButton) {
            this.addRowAction();
        } else if (object == this.deleteRowButton) {
            this.deleteRowAction();
            this.disableButtons();
        } else if (object == this.deleteDBButton) {
            this.deleteDBAction();
        } else if (db.on()) {
            db.println("ProfileVlanDbPane : no ActionPerformed command !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAction(boolean bl) {
        boolean bl2;
        if (bl && this.table.getRowCount() > 0 && !(bl2 = CerentDialog.yesNoDialog((Component)((Object)this), (String)"A SVLAN DB profile already exists.\nLoading a new profile will discard the current SVLAN DB.\nIs it OK to continue?", (String)"Changing SVLAN DB"))) {
            return;
        }
        ArrayList arrayList = this.getNodeInfoList();
        IModel iModel = this.getUiModel();
        IModel iModel2 = iModel instanceof NetworkModel ? null : iModel;
        SvlanDBLoadStoreDialog svlanDBLoadStoreDialog = new SvlanDBLoadStoreDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), arrayList, iModel2, SvlanDBLoadStoreDialog.ActionType.LOAD);
        svlanDBLoadStoreDialog.init();
        try {
            block8: {
                try {
                    svlanDBLoadStoreDialog.setVisible(true);
                    if (svlanDBLoadStoreDialog.isCancelled()) break block8;
                    if (svlanDBLoadStoreDialog.isModelBtnSelected()) {
                        Collection<IModel> collection = svlanDBLoadStoreDialog.getSelectedModels();
                        if (collection.size() > 0) {
                            IEntityModel iEntityModel = (IEntityModel)collection.iterator().next();
                            this.doImportFromCard(iEntityModel, bl);
                        }
                        break block8;
                    }
                    this.doImportFile(svlanDBLoadStoreDialog.getSelectedFile(), bl);
                }
                catch (Exception exception) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    Object var9_11 = null;
                    svlanDBLoadStoreDialog.dispose();
                }
            }
            Object var9_10 = null;
            svlanDBLoadStoreDialog.dispose();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            svlanDBLoadStoreDialog.dispose();
            throw throwable;
        }
    }

    private void deleteDBAction() {
        SvlanDBLoadStoreDialog svlanDBLoadStoreDialog;
        block4: {
            ArrayList arrayList = this.getNodeInfoList();
            IModel iModel = this.getUiModel();
            IModel iModel2 = iModel instanceof NetworkModel ? null : iModel;
            svlanDBLoadStoreDialog = new SvlanDBLoadStoreDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), arrayList, iModel2, SvlanDBLoadStoreDialog.ActionType.DELETE);
            svlanDBLoadStoreDialog.init();
            try {
                svlanDBLoadStoreDialog.setVisible(true);
                if (!svlanDBLoadStoreDialog.isCancelled() && svlanDBLoadStoreDialog.isModelBtnSelected()) {
                    Collection<IModel> collection = svlanDBLoadStoreDialog.getSelectedModels();
                    this.doStoreOnCard(collection, true);
                    if (collection.size() > 0) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "The provisioning SVLAN DB has been deleted.");
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        svlanDBLoadStoreDialog.dispose();
    }

    private void doImportFromCard(IEntityModel iEntityModel, boolean bl) {
        if (iEntityModel instanceof IXPL2ModuleModel) {
            IXPL2ModuleModel iXPL2ModuleModel;
            if (db.on()) {
                db.println("doImportFromCard() from card: ");
                iXPL2ModuleModel = iEntityModel.getNodeModel();
                db.println("  " + iXPL2ModuleModel.getName() + " - " + iEntityModel);
            }
            iXPL2ModuleModel = (IXPL2ModuleModel)iEntityModel;
            ArrayList<IVlanInfo> arrayList = new ArrayList<IVlanInfo>();
            arrayList.addAll(Arrays.asList(iXPL2ModuleModel.getVlanDb()));
            if (bl) {
                ((ProfileVlanDbTableModel)this.dataModel).setVlanCurrentList(new ArrayList<IVlanInfo>(arrayList));
            } else {
                this.importVlanList = arrayList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeAction() {
        if (db.on()) {
            db.println("doStoreAction");
        }
        if (((ProfileVlanDbTableModel)this.dataModel).checkForInvalidVlan()) {
            ErrorMsg.displayWarning((Component)((Object)this), (WID)NEMC.WID_INVALID_SVLAN_STORING_DB);
            return;
        }
        ArrayList arrayList = this.getNodeInfoList();
        IModel iModel = this.getUiModel();
        IModel iModel2 = iModel instanceof NetworkModel ? null : iModel;
        SvlanDBLoadStoreDialog svlanDBLoadStoreDialog = new SvlanDBLoadStoreDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), arrayList, iModel2, SvlanDBLoadStoreDialog.ActionType.STORE);
        svlanDBLoadStoreDialog.init();
        try {
            block9: {
                try {
                    svlanDBLoadStoreDialog.setVisible(true);
                    if (svlanDBLoadStoreDialog.isCancelled()) break block9;
                    if (svlanDBLoadStoreDialog.isModelBtnSelected()) {
                        Collection<IModel> collection = svlanDBLoadStoreDialog.getSelectedModels();
                        this.doStoreOnCard(collection, false);
                    } else {
                        this.doStoreFile(svlanDBLoadStoreDialog.getSelectedFile());
                    }
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "The provisioning SVLAN DB has been saved.");
                }
                catch (Exception exception) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    Object var7_8 = null;
                    svlanDBLoadStoreDialog.dispose();
                }
            }
            Object var7_7 = null;
            svlanDBLoadStoreDialog.dispose();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            svlanDBLoadStoreDialog.dispose();
            throw throwable;
        }
    }

    private void doStoreOnCard(Collection<IModel> collection, boolean bl) throws Exception {
        String string;
        if (collection == null || collection.size() == 0) {
            return;
        }
        if (db.on()) {
            db.println("doStoreOnCard() for cards: ");
            for (IModel iModel : collection) {
                string = iModel.getNodeModel();
                db.println("  " + string.getName() + " - " + iModel);
            }
        }
        ArrayList<Object> arrayList = null;
        arrayList = bl ? new ArrayList() : ((ProfileVlanDbTableModel)this.dataModel).getVlanCurrentList(true);
        boolean bl2 = false;
        string = bl ? "deleted" : "saved";
        int n = arrayList.size() * collection.size();
        DetailedLog detailedLog = new DetailedLog(3, "The SVLAN DB was not " + string);
        for (IModel iModel : collection) {
            bl2 |= this.doStoreOnCard(arrayList, (IEntityModel)iModel, detailedLog, bl);
            if (n <= 5000) continue;
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (bl2) {
            IModel iModel;
            IDetailedProgressController iDetailedProgressController = new IDetailedProgressController(){

                public void start(IDetailedProgressDialog iDetailedProgressDialog) {
                }

                public boolean isCancelSupported() {
                    return false;
                }

                public void cancel() {
                }
            };
            iModel = new DetailedProgressDialog(JOptionPane.getFrameForComponent(this.getParent()), "Error", detailedLog, iDetailedProgressController);
            iModel.setCompleted(true);
            iModel.start();
            throw new Exception();
        }
    }

    private boolean doStoreOnCard(ArrayList<IVlanInfo> arrayList, IEntityModel iEntityModel, DetailedLog detailedLog, boolean bl) {
        boolean bl2 = false;
        if (iEntityModel instanceof IXPL2ModuleModel) {
            IXPL2ModuleModel iXPL2ModuleModel = (IXPL2ModuleModel)iEntityModel;
            try {
                iXPL2ModuleModel.setVlanDb(arrayList.toArray(new IVlanInfo[0]));
            }
            catch (Exception exception) {
                bl2 = true;
                String string = bl ? "deleting" : "storing";
                DetailedLog detailedLog2 = new DetailedLog(3, "an error occurred while " + string + " the SVLAN DB to the card.", exception);
                detailedLog.addChild(detailedLog2);
                detailedLog.updateTime();
            }
        }
        return bl2;
    }

    private void doStoreFile(String string) {
        block4: {
            if (string != null) {
                try {
                    ArrayList<IVlanInfo> arrayList = ((ProfileVlanDbTableModel)this.dataModel).getVlanCurrentList(true);
                    VlanDbWriter vlanDbWriter = new VlanDbWriter(arrayList);
                    if (!vlanDbWriter.writeFile(string)) {
                        ErrorMsg.displayError((Component)JOptionPane.getFrameForComponent((Component)((Object)this)), (EID)NEMC.EID_WRITE_FILE_ERROR_PARAM_1, (Object)string);
                    }
                }
                catch (Exception exception) {
                    ErrorMsg.displayError((Component)JOptionPane.getFrameForComponent((Component)((Object)this)), (EID)NEMC.EID_ERROR_PROVISIONING_VLAN_DB_PROFILE, (Object)string);
                    if (!db.on()) break block4;
                    KDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    protected void mergeAction() {
        IVlanInfo iVlanInfo;
        IVlanInfo iVlanInfo2;
        this.importVlanList = null;
        this.loadAction(false);
        if (this.importVlanList == null) {
            return;
        }
        ArrayList<IVlanInfo> arrayList = ((ProfileVlanDbTableModel)this.dataModel).getVlanCurrentList(true);
        HashMap<Short, IVlanInfo> hashMap = this.loadHash(arrayList);
        HashMap<Short, IVlanInfo> hashMap2 = this.loadHash(this.importVlanList);
        ArrayList<IVlanInfo> arrayList2 = new ArrayList<IVlanInfo>();
        Set<Short> set = hashMap2.keySet();
        Short s2 = null;
        for (Short s2 : set) {
            if (hashMap.containsKey(s2)) {
                iVlanInfo2 = hashMap.get(s2);
                if (!iVlanInfo2.equals(iVlanInfo = hashMap2.get(s2))) continue;
                this.importVlanList.remove(iVlanInfo);
                continue;
            }
            iVlanInfo2 = hashMap2.get(s2);
            arrayList2.add(iVlanInfo2);
            this.importVlanList.remove(iVlanInfo2);
        }
        if (this.importVlanList.size() == 0) {
            arrayList.addAll(arrayList2);
            ((ProfileVlanDbTableModel)this.dataModel).setVlanCurrentList(arrayList);
        } else {
            ArrayList arrayList3 = (ArrayList)arrayList.clone();
            iVlanInfo2 = new ArrayList();
            iVlanInfo = new ArrayList();
            hashMap2 = this.loadHash(this.importVlanList);
            set = hashMap2.keySet();
            IVlanInfo iVlanInfo3 = null;
            for (Short s2 : set) {
                iVlanInfo3 = hashMap.get(s2);
                iVlanInfo2.add(iVlanInfo3);
                arrayList.remove(iVlanInfo3);
                iVlanInfo.add(hashMap2.get(s2));
            }
            Frame frame = JOptionPane.getFrameForComponent((Component)((Object)this));
            VlanMergeDialog vlanMergeDialog = new VlanMergeDialog(frame, "Merge Conflicts", true, (ArrayList<IVlanInfo>)iVlanInfo2, (ArrayList<IVlanInfo>)iVlanInfo);
            vlanMergeDialog.setLocationRelativeTo(frame);
            vlanMergeDialog.setVisible(true);
            if (vlanMergeDialog.pressedOk()) {
                arrayList.addAll(arrayList2);
                arrayList.addAll(vlanMergeDialog.getSelectConflictList());
                ((ProfileVlanDbTableModel)this.dataModel).setVlanCurrentList(arrayList);
            } else {
                ((ProfileVlanDbTableModel)this.dataModel).setVlanCurrentList(arrayList3);
            }
        }
    }

    private HashMap<Short, IVlanInfo> loadHash(ArrayList<IVlanInfo> arrayList) {
        HashMap<Short, IVlanInfo> hashMap = new HashMap<Short, IVlanInfo>(arrayList.size());
        for (IVlanInfo iVlanInfo : arrayList) {
            hashMap.put(iVlanInfo.getVlanId(), iVlanInfo);
        }
        return hashMap;
    }

    protected void addRowAction() {
        int n = 0;
        try {
            n = Integer.parseInt(this.rowNumTxt.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_NUMBER);
            this.rowNumTxt.setText("");
            return;
        }
        if (n + this.dataModel.getRowCount() > 4093) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_MAX_VLAN_DB_PROFILES_PARAM_1, (Object)4093);
            return;
        }
        ((ProfileVlanDbTableModel)this.dataModel).addVlanTableRow(n);
    }

    protected void deleteRowAction() {
        ((ProfileVlanDbTableModel)this.dataModel).removeVlanTableRow(this.table.getSelectedRows());
    }

    private void disableButtons() {
        if (this.table.getRowCount() == 0) {
            this.storeButton.setEnabled(false);
            this.mergeButton.setEnabled(false);
            this.deleteRowButton.setEnabled(false);
        }
    }

    public void doImportFile(String string, boolean bl) {
        Object object;
        Vector vector = null;
        if (string != null) {
            try {
                object = new ProvAlarmsReader(10);
                vector = ((ProvAlarmsReader)object).readFile(string);
                if (vector == null) {
                    ErrorMsg.displayError(null, (EID)NEMC.EID_FILE_NOT_FOUND_OR_IO_EX_PARAM_1, (Object)string);
                    return;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                ErrorMsg.displayError(null, NEMC.EID_FILE_NOT_FOUND_OR_IO_EX_PARAM_1, fileNotFoundException.getMessage(), string);
            }
            catch (UnmappableCharacterException unmappableCharacterException) {
                ErrorMsg.displayError(null, NEMC.EID_PROFILE_DECODE, unmappableCharacterException.getMessage(), string);
            }
            catch (MalformedInputException malformedInputException) {
                ErrorMsg.displayError(null, NEMC.EID_PROFILE_FORMAT, malformedInputException.getMessage(), string);
            }
            catch (IOException iOException) {
                ErrorMsg.displayError(null, NEMC.EID_PROFILE_READ, iOException.getMessage(), string);
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        } else {
            return;
        }
        if (vector == null || vector.size() == 0) {
            return;
        }
        object = new HashMap();
        ArrayList<IVlanInfo> arrayList = new ArrayList<IVlanInfo>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            try {
                String string2 = (String)vector.elementAt(i);
                if (string2.trim().length() == 0) continue;
                IVlanInfo iVlanInfo = VlanInfo.vlanFromImportString(string2);
                if (!iVlanInfo.isValid() || ((HashMap)object).get(iVlanInfo.getVlanId()) != null) {
                    ErrorMsg.displayError(null, NEMC.EID_PROFILE_READ, "", string);
                    return;
                }
                ((HashMap)object).put(iVlanInfo.getVlanId(), iVlanInfo);
                arrayList.add(iVlanInfo);
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error on line " + i + ": " + exception.getMessage());
            }
        }
        if (bl) {
            ((ProfileVlanDbTableModel)this.dataModel).setVlanCurrentList(new ArrayList<IVlanInfo>(arrayList));
        } else {
            this.importVlanList = arrayList;
        }
    }

    public ArrayList getNodeInfoList() {
        IModel iModel;
        if (db.on()) {
            db.println("----getNodeInfoList: begin()");
        }
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        IModel iModel2 = iModel = this.uiModel instanceof NetworkModel ? null : this.uiModel;
        if (iModel != null) {
            INodeModel iNodeModel = iModel.getNodeModel();
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.STS_OVER_MSTP_ADM_ENHANCED)) {
                arrayList.add(iNodeModel);
            }
            return arrayList;
        }
        for (INetElement iNetElement : Network.instance().getElements()) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.STS_OVER_MSTP_ADM_ENHANCED)) continue;
            arrayList.add(iNodeModel);
        }
        if (db.on()) {
            db.println("----getNodeInfoList: end()");
        }
        return arrayList;
    }

    public void sortAllRowsBy(AbstractProvTableModel abstractProvTableModel, int n, boolean bl) {
        ArrayList<IVlanInfo> arrayList = ((ProfileVlanDbTableModel)abstractProvTableModel).getVlanCurrentList(false);
        Collections.sort(arrayList, new ColumnSorter(n, bl));
        abstractProvTableModel.fireTableDataChanged();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.table.getRowCount() > 0) {
            int n;
            this.enableComponent(this.storeButton, (IModel)this.nm);
            this.enableComponent(this.mergeButton, (IModel)this.nm);
            int[] nArray = this.table.getSelectedRows();
            int n2 = n = nArray == null ? 0 : nArray.length;
            if (n > 0) {
                this.enableComponent(this.deleteRowButton, (IModel)this.nm);
            } else if (this.deleteRowButton.isEnabled()) {
                this.deleteRowButton.setEnabled(false);
            }
            ((ProfileVlanDbTableModel)this.dataModel).forceDirty();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (n > 0) {
            this.enableComponent(this.deleteRowButton, (IModel)this.nm);
        } else if (this.deleteRowButton.isEnabled()) {
            this.deleteRowButton.setEnabled(false);
        }
    }

    @Override
    protected Attribute[] getAttributes(String string) {
        return null;
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.ProfileVlanDbPane;
    }

    class ColumnSorter
    implements Comparator {
        int colIndex;
        boolean ascending;

        ColumnSorter(int n, boolean bl) {
            this.colIndex = n;
            this.ascending = bl;
        }

        public int compare(Object object, Object object2) {
            IVlanInfo iVlanInfo = (IVlanInfo)object;
            IVlanInfo iVlanInfo2 = (IVlanInfo)object2;
            if (iVlanInfo == null && iVlanInfo2 == null) {
                return 0;
            }
            if (iVlanInfo == null) {
                return 1;
            }
            if (iVlanInfo2 == null) {
                return -1;
            }
            if (iVlanInfo instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)iVlanInfo).compareTo(iVlanInfo2);
                }
                return ((Comparable)iVlanInfo2).compareTo(iVlanInfo);
            }
            if (this.ascending) {
                return iVlanInfo.toString().compareTo(iVlanInfo2.toString());
            }
            return iVlanInfo2.toString().compareTo(iVlanInfo.toString());
        }
    }
}

