/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.IVlanInfo;
import cerent.cms.model.VlanInfo;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileVlanDbTableModel
extends AbstractProvTableModel {
    private ArrayList<IVlanInfo> vlanCurrentList = new ArrayList();
    private Frame frame;
    private boolean isDirty;
    private static final int MAX_VLAN_ID = 4094;

    public ProfileVlanDbTableModel(Container container, boolean bl, String string) {
        super(null, false, "");
        this.frame = JOptionPane.getFrameForComponent(container);
        this.columnNames = new String[]{"Num", "SVLAN ID", "SVLAN Name", "Protection", "MAC Learning", "IGMP", "IGMP Fast Leave", "IGMP Suppression"};
    }

    @Override
    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Short.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 5: {
                return Boolean.class;
            }
            case 6: {
                return Boolean.class;
            }
        }
        return Boolean.class;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.vlanCurrentList.size();
    }

    protected void addVlanTableRow(int n) {
        for (int i = 0; i < n; ++i) {
            this.vlanCurrentList.add(new VlanInfo());
        }
        this.fireTableDataChanged();
    }

    protected void removeVlanTableRow(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i] - i;
            IVlanInfo iVlanInfo = this.vlanCurrentList.remove(n);
        }
        this.fireTableDataChanged();
    }

    public void applyToModel() throws Exception {
    }

    @Override
    public Object getValueAt(int n, int n2) {
        IVlanInfo iVlanInfo = this.vlanCurrentList.get(n);
        switch (n2) {
            case 0: {
                return new Integer(n + 1);
            }
            case 1: {
                if (iVlanInfo.getVlanId() == -1) {
                    return null;
                }
                return new Short(iVlanInfo.getVlanId());
            }
            case 2: {
                return iVlanInfo.getVlanName();
            }
            case 3: {
                return new Boolean(iVlanInfo.isVlanProtected());
            }
            case 4: {
                return new Boolean(iVlanInfo.isMacLearning());
            }
            case 5: {
                return new Boolean(iVlanInfo.isIgmp());
            }
            case 6: {
                return new Boolean(iVlanInfo.isIgmpFastLeave());
            }
        }
        return new Boolean(iVlanInfo.isIgmpSuppression());
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        IVlanInfo iVlanInfo = this.vlanCurrentList.get(n);
        switch (n2) {
            case 1: {
                Short s = (Short)object;
                if (s != null && s > 0 && s < 4094) {
                    if (this.isVlanIDAvailable(s)) {
                        iVlanInfo.setVlanId(s.shortValue());
                        break;
                    }
                    ErrorMsg.displayError((Component)this.frame, (EID)NEMC.EID_ERROR_PROVISIONING_VLAN_ID_ALREADY_IN_PROFILE);
                    break;
                }
                ErrorMsg.displayError((Component)this.frame, (EID)NEMC.EID_ERROR_PROVISIONING_VLAN_ID);
                break;
            }
            case 2: {
                iVlanInfo.setVlanName((String)object);
                break;
            }
            case 3: {
                iVlanInfo.setVlanProtection(((Boolean)object).booleanValue());
                break;
            }
            case 4: {
                iVlanInfo.setMacLearning(((Boolean)object).booleanValue());
                break;
            }
            case 5: {
                iVlanInfo.setIgmp(((Boolean)object).booleanValue());
                break;
            }
            case 6: {
                iVlanInfo.setIgmpFastLeave(((Boolean)object).booleanValue());
                break;
            }
            case 7: {
                iVlanInfo.setIgmpSuppression(((Boolean)object).booleanValue());
            }
        }
    }

    private boolean isVlanIDAvailable(short s) {
        IVlanInfo iVlanInfo = null;
        for (int i = 0; i < this.vlanCurrentList.size(); ++i) {
            iVlanInfo = this.vlanCurrentList.get(i);
            if (iVlanInfo.getVlanId() != s) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    public boolean isEmpty() {
        ArrayList<IVlanInfo> arrayList = new ArrayList<IVlanInfo>();
        IVlanInfo iVlanInfo = null;
        for (int i = 0; i < this.vlanCurrentList.size(); ++i) {
            iVlanInfo = this.vlanCurrentList.get(i);
            if (!iVlanInfo.isValid()) continue;
            arrayList.add(iVlanInfo);
        }
        return arrayList.size() == 0;
    }

    public ArrayList<IVlanInfo> getVlanCurrentList(boolean bl) {
        if (bl) {
            this.removeNotValidVlan();
        }
        return this.vlanCurrentList;
    }

    private void removeNotValidVlan() {
        ArrayList<IVlanInfo> arrayList = new ArrayList<IVlanInfo>();
        IVlanInfo iVlanInfo = null;
        for (int i = 0; i < this.vlanCurrentList.size(); ++i) {
            iVlanInfo = this.vlanCurrentList.get(i);
            if (!iVlanInfo.isValid()) continue;
            arrayList.add(iVlanInfo);
        }
        this.vlanCurrentList = arrayList;
        this.fireTableDataChanged();
    }

    protected boolean checkForInvalidVlan() {
        boolean bl = false;
        IVlanInfo iVlanInfo = null;
        for (int i = 0; i < this.vlanCurrentList.size(); ++i) {
            iVlanInfo = this.vlanCurrentList.get(i);
            if (iVlanInfo.isValid()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setVlanCurrentList(ArrayList<IVlanInfo> arrayList) {
        this.vlanCurrentList = arrayList;
        for (int i = 0; i < arrayList.size(); ++i) {
            IVlanInfo iVlanInfo = arrayList.get(i);
        }
        this.fireTableDataChanged();
    }

    public void forceDirty() {
        this.isDirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public void resetDirty() {
        this.isDirty = false;
    }

    public void setEmptyTableModel() {
        this.setVlanCurrentList(new ArrayList<IVlanInfo>());
        this.isDirty = false;
    }
}

