/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.vlan.IModelSelector;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvMultiSelector
implements ActionListener,
IModelSelector {
    private Component aComponent;
    private Dimension selectionBoxDim;
    private Dimension allOrNoneBtnDim;
    protected JPanel nodePanel;
    protected JButton allButton;
    protected JButton noneButton;
    protected boolean state;
    protected GridBagLayout gridbag = new GridBagLayout();
    protected GridBagConstraints gbc = new GridBagConstraints();
    protected Map<String, INodeModel> name2Node;
    protected JList nodeList;

    @Override
    public void setEnabled(boolean bl) {
        this.state = bl;
        this.nodePanel.setEnabled(this.state);
        this.nodeList.setEnabled(this.state);
        this.allButton.setEnabled(this.state);
        this.noneButton.setEnabled(this.state);
    }

    public JPanel getPanel() {
        return this.nodePanel;
    }

    @Override
    public Collection<IModel> getSelectedModels() {
        Object[] objectArray = this.getNodeList().getSelectedValues();
        ArrayList<IModel> arrayList = new ArrayList<IModel>(objectArray.length);
        for (Object object : objectArray) {
            INodeModel iNodeModel = this.name2Node.get(object.toString());
            arrayList.add((IModel)iNodeModel);
        }
        return arrayList;
    }

    @Override
    public int getNumSelectedModels() {
        return this.getNodeList().getSelectedValues().length;
    }

    public JList getNodeList() {
        return this.nodeList;
    }

    public ProvMultiSelector(Component component, Dimension dimension, Dimension dimension2) {
        this.aComponent = component;
        this.selectionBoxDim = dimension;
        this.allOrNoneBtnDim = dimension2;
        this.name2Node = new HashMap<String, INodeModel>();
    }

    @Override
    public void setNetScope(Collection<INodeModel> collection) {
        this.init(collection);
    }

    private void init(Collection<INodeModel> collection) {
        Object object;
        this.nodePanel = new JPanel();
        this.gbc.anchor = 18;
        if (this.aComponent != null) {
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.gridbag.setConstraints(this.aComponent, this.gbc);
            this.nodePanel.add(this.aComponent);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object var3_3 = null;
        for (INodeModel object22 : collection) {
            object = object22.getName();
            arrayList.add((String)object);
            this.name2Node.put((String)object, object22);
        }
        var3_3 = null;
        this.nodeList = new JList<Object>(arrayList.toArray());
        this.nodeList.setBorder(BorderFactory.createLoweredBevelBorder());
        UScrollPane uScrollPane = new UScrollPane();
        uScrollPane.getViewport().setView(this.nodeList);
        this.nodePanel.setLayout(this.gridbag);
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gridbag.setConstraints((Component)uScrollPane, this.gbc);
        this.nodePanel.add((Component)uScrollPane);
        uScrollPane.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Node Names"));
        uScrollPane.setPreferredSize(this.selectionBoxDim);
        ButtonGroup buttonGroup = new ButtonGroup();
        object = new JPanel();
        ((Container)object).setLayout(this.gridbag);
        this.allButton = new JButton("Select All");
        this.noneButton = new JButton("Select None");
        this.allButton.setPreferredSize(this.allOrNoneBtnDim);
        this.noneButton.setPreferredSize(this.allOrNoneBtnDim);
        buttonGroup.add(this.allButton);
        buttonGroup.add(this.noneButton);
        this.gbc.insets = new Insets(2, 0, 2, 0);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gridbag.setConstraints(this.allButton, this.gbc);
        ((Container)object).add(this.allButton);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gridbag.setConstraints(this.noneButton, this.gbc);
        ((Container)object).add(this.noneButton);
        this.allButton.addActionListener(this);
        this.noneButton.addActionListener(this);
        this.gbc.anchor = 10;
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.ipadx = 5;
        this.gbc.ipady = 5;
        this.gridbag.setConstraints((Component)object, this.gbc);
        this.nodePanel.add((Component)object);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.allButton) {
            int n = this.nodeList.getModel().getSize();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            this.nodeList.setSelectedIndices(nArray);
        }
        if (actionEvent.getSource() == this.noneButton) {
            this.nodeList.clearSelection();
        }
    }
}

