/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.vlan.NodeCheckBoxTree;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FilePropertyEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvlanDBLoadStoreDialog
extends JDialog
implements ActionListener {
    protected JPanel mainPanel;
    protected JRadioButton modelBtn;
    protected GridBagLayout gridbag = new GridBagLayout();
    protected GridBagConstraints gbc = new GridBagConstraints();
    private NodeCheckBoxTree ms;
    private JRadioButton fileBtn;
    private FilePropertyEditor fpe;
    private ActionListener fromListener;
    private IModel scope;
    private List<INodeModel> nodeList;
    private JButton okButton;
    private JButton cancelButton;
    private Frame parent;
    private boolean isCancelled;
    private ActionType actionType;

    public SvlanDBLoadStoreDialog(Frame frame, List<INodeModel> list, IModel iModel, ActionType actionType) {
        super(frame);
        this.parent = frame;
        this.nodeList = list;
        this.scope = iModel;
        this.actionType = actionType;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SvlanDBLoadStoreDialog.this.confirmCancel();
            }
        });
    }

    public void init() {
        FilePropertyEditor filePropertyEditor;
        JRadioButton jRadioButton;
        this.gridbag = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(this.gridbag);
        this.gbc.anchor = 18;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 0;
        JLabel jLabel = new JLabel("Select where to " + this.actionType.getActionStr());
        this.gridbag.setConstraints(jLabel, this.gbc);
        this.mainPanel.add(jLabel);
        this.gbc.gridwidth = 1;
        this.modelBtn = new JRadioButton(this.actionType.getActionDir() + " " + this.actionType.getModelDesc() + ":");
        this.fileBtn = jRadioButton = new JRadioButton(this.actionType.getActionDir() + " File:   ");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.modelBtn);
        buttonGroup.add(jRadioButton);
        this.gbc.anchor = 18;
        JPanel jPanel = new JPanel();
        this.ms = new NodeCheckBoxTree(this.nodeList, this.scope, this.actionType == ActionType.LOAD);
        JScrollPane jScrollPane = new JScrollPane(this.ms);
        jScrollPane.setPreferredSize(new Dimension(310, 120));
        if (this.actionType != ActionType.DELETE) {
            jPanel.add(this.modelBtn);
        }
        jPanel.add(jScrollPane);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.insets = new Insets(5, 0, 0, 0);
        this.gridbag.setConstraints(jPanel, this.gbc);
        this.mainPanel.add(jPanel);
        this.fpe = filePropertyEditor = new FilePropertyEditor(jRadioButton);
        filePropertyEditor.setFilter(this.actionType.getfileTypeDesc(), this.actionType.getfileSuffix());
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gridbag.setConstraints(filePropertyEditor, this.gbc);
        if (this.actionType != ActionType.DELETE) {
            this.mainPanel.add(filePropertyEditor);
        }
        JPanel jPanel2 = new JPanel();
        this.okButton = new JButton("Ok");
        jPanel2.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        jPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        jPanel2.add(new CSHelpButton(this.actionType.getHelpID()));
        this.gbc.anchor = 10;
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.insets = new Insets(15, 0, 0, 0);
        this.gridbag.setConstraints(jPanel2, this.gbc);
        this.mainPanel.add(jPanel2);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FromListener
        implements ActionListener {
            FromListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == SvlanDBLoadStoreDialog.this.modelBtn) {
                    SvlanDBLoadStoreDialog.this.ms.setEnabled(true);
                    filePropertyEditor.setEnabled(false);
                } else {
                    SvlanDBLoadStoreDialog.this.ms.setEnabled(false);
                    filePropertyEditor.setEnabled(true);
                }
            }
        }
        this.fromListener = new FromListener();
        this.modelBtn.addActionListener(this.fromListener);
        jRadioButton.addActionListener(this.fromListener);
        this.modelBtn.doClick();
        this.getContentPane().add(this.mainPanel);
        this.setModal(true);
        this.setTitle(this.actionType.getDlgTitle());
        Dimension dimension = this.actionType == ActionType.DELETE ? new Dimension(400, 250) : new Dimension(450, 280);
        this.setPreferredSize(dimension);
        this.setResizable(false);
        this.setLocationRelativeTo(this.parent);
        this.pack();
    }

    public boolean isModelBtnSelected() {
        return this.modelBtn.isSelected();
    }

    public Collection<IModel> getSelectedModels() {
        return this.ms.getSelectedModels();
    }

    public String getSelectedFile() {
        return (String)this.fpe.getValue();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void dispose() {
        this.modelBtn.removeActionListener(this.fromListener);
        this.fileBtn.removeActionListener(this.fromListener);
        this.okButton.removeActionListener(this);
        this.cancelButton.removeActionListener(this);
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.confirmOk();
        } else if (object == this.cancelButton) {
            this.confirmCancel();
        }
    }

    protected void confirmOk() {
        if (this.modelBtn.isSelected()) {
            if (this.ms.getNumSelectedModels() == 0) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_INVALID_CARD_SELECTION);
            } else if (this.actionType == ActionType.DELETE) {
                boolean bl = CerentDialog.yesNoDialog((Component)this, (String)"Do you really want to delete SVLAN DB ?\n", (String)"Deleting SVLAN DB");
                if (bl) {
                    this.isCancelled = false;
                    this.confirmExit();
                }
            } else {
                this.isCancelled = false;
                this.confirmExit();
            }
        } else if (this.fpe.onValidate()) {
            if (((String)this.fpe.getValue()).equals("")) {
                ErrorMsg.displayWarning((Component)this, (WID)CEMC.WID_NO_FILE_SPECIFIED);
            } else {
                this.isCancelled = false;
                this.confirmExit();
            }
        }
    }

    protected void confirmCancel() {
        String string = this.getTitle();
        this.isCancelled = CerentDialog.yesNoDialog((Component)this, (String)("Do you really want to cancel " + string + "?"), (String)string);
        if (this.isCancelled) {
            this.confirmExit();
        }
    }

    protected void confirmExit() {
        this.setVisible(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionType {
        LOAD("SVLAN DB Loading", "load the SVLAN DB from:", "From", NetCSHelpConst.SvlanDBLoadDialog),
        STORE("SVLAN DB Storing", "store the SVLAN DB to:", "To", NetCSHelpConst.SvlanDBStoreDialog),
        DELETE("SVLAN DB Deleting", "delete the SVLAN DB:", "", NetCSHelpConst.SvlanDBDeleteDialog);

        private String dlgTitle;
        private String actionStr;
        private String modelDesc;
        private String fileTypeDesc;
        private String fileSuffix;
        private String dir;
        private CSHelpID helpID;

        private ActionType(String string2, String string3, String string4, CSHelpID cSHelpID) {
            this.dlgTitle = string2;
            this.actionStr = string3;
            this.modelDesc = "Card(s)";
            this.fileTypeDesc = "Provisionable SVLAN DB Files (*.vfl)";
            this.fileSuffix = "vfl";
            this.dir = string4;
            this.helpID = cSHelpID;
        }

        public String getActionDir() {
            return this.dir;
        }

        public String getDlgTitle() {
            return this.dlgTitle;
        }

        public String getActionStr() {
            return this.actionStr;
        }

        public String getfileTypeDesc() {
            return this.fileTypeDesc;
        }

        public String getfileSuffix() {
            return this.fileSuffix;
        }

        public String getModelDesc() {
            return this.modelDesc;
        }

        public CSHelpID getHelpID() {
            return this.helpID;
        }
    }
}

