/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.Attribute;
import cerent.cms.model.DuplicateVlan;
import cerent.cms.model.VlanIdOutOfRange;
import cerent.cms.model.VlanNameTooLong;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.ITopology;
import cerent.cms.topo.Network;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VlanCreationDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Define New VLAN";
    public static final String NAME_LABEL = "VLAN Name";
    public static final String ID_LABEL = "VLAN Id";
    private static final String TOPO_LABEL = "Topology Host";
    JTextField nameTF;
    JTextField idTF;
    JComboBox topoCB;
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;
    private static VlanSetManager vsm = VlanSetManager.instance();
    private static final String UNKNOWN_TOPO_HOST_NAME = "";
    private static String currentTopoHost = "";

    public static VlanCreationDialog instance(Component component) {
        return VlanCreationDialog.instance(component, UNKNOWN_TOPO_HOST_NAME);
    }

    public static VlanCreationDialog instance(Component component, String string) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        VlanCreationDialog vlanCreationDialog = new VlanCreationDialog(frame);
        currentTopoHost = string;
        vlanCreationDialog.resetMainPanel();
        return vlanCreationDialog;
    }

    private VlanCreationDialog(Frame frame) {
        super(frame, TITLE, true);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.getMainPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    private JComponent getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 2));
        jPanel.add(new JLabel("VLAN Name: ", 4));
        this.nameTF = new JTextField(10);
        jPanel.add(this.nameTF);
        jPanel.add(new JLabel("VLAN Id: ", 4));
        this.idTF = new JTextField(10);
        jPanel.add(this.idTF);
        jPanel.add(new JLabel("Topology Host: ", 4));
        ArrayList arrayList = new ArrayList(Network.instance().getTopologyMap().keySet());
        arrayList.remove(new Integer(0));
        Iterator iterator = arrayList.iterator();
        TreeMap<String, Attribute> treeMap = new TreeMap<String, Attribute>();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            List list = vsm.getNodesWithTopoId(n);
            if (list.size() == 0) {
                iterator.remove();
                continue;
            }
            INetElement iNetElement = Network.instance().getTopoHost(n);
            if (iNetElement == null) continue;
            treeMap.put(iNetElement.getName(), new Attribute(iNetElement.getName(), n));
        }
        this.topoCB = new JComboBox<Object>(treeMap.values().toArray());
        jPanel.add(this.topoCB);
        return jPanel;
    }

    private void resetMainPanel() {
        this.nameTF.setText(UNKNOWN_TOPO_HOST_NAME);
        this.idTF.setText(UNKNOWN_TOPO_HOST_NAME);
        this.topoCB.setSelectedItem(currentTopoHost);
        this.nameTF.requestFocus();
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this.okButton) {
                this.apply();
                this.dispose();
            } else if (object == this.applyButton) {
                this.apply();
                this.resetMainPanel();
            } else if (object == this.cancelButton) {
                this.dispose();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            CerentDialog.errorDialog((Component)((Object)this), (String)exception.getMessage());
        }
    }

    private void apply() throws Exception {
        int n;
        String string = this.nameTF.getText();
        if (string.length() == 0) {
            throw new Exception("VLAN Name must not be empty.");
        }
        if (string.length() > VlanSetManager.MAX_VLAN_NAME_LEN) {
            throw new Exception("VLAN Name cannot exceed " + VlanSetManager.MAX_VLAN_NAME_LEN + " characters.");
        }
        try {
            n = Integer.parseInt(this.idTF.getText());
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("VLAN Id must be an integer.");
        }
        if (n <= 1) {
            throw new Exception("VLAN Id must be greater than 1.");
        }
        if (n > VlanSetManager.MAX_VLAN_ID) {
            throw new Exception("VLAN Id must be less than " + (VlanSetManager.MAX_VLAN_ID + 1) + ".");
        }
        try {
            Attribute attribute = (Attribute)this.topoCB.getSelectedItem();
            ITopology iTopology = (ITopology)Network.instance().getTopologyMap().get(attribute.getValue());
            vsm.createVlan((short)n, string, iTopology);
        }
        catch (DuplicateVlan duplicateVlan) {
            throw new Exception("The VLAN name or ID is already in use.");
        }
        catch (VlanIdOutOfRange vlanIdOutOfRange) {
            throw new Exception("VLAN Id must be between 1 and " + (VlanSetManager.MAX_VLAN_ID + 1) + ".");
        }
        catch (VlanNameTooLong vlanNameTooLong) {
            throw new Exception("VLAN Name cannot exceed " + VlanSetManager.MAX_VLAN_NAME_LEN + " characters.");
        }
    }
}

