/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.IVlanInfo;
import cerent.cms.model.VlanInfo;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VlanMergeDialog
extends JDialog
implements ActionListener {
    private static final String[] columnName = new String[]{"SVLAN ID", "Name", "Protection", "MAC Learning", "IGMP", "IGMP Fast Leave", "IGMP Suppression"};
    private static final int MARGIN = 6;
    private static final int CURRENT = 0;
    private static final int IMPORT = 1;
    private static final int COLUMN_MAX_id_Width = 35;
    private static final int COLUMN_MIN_id_Width = 35;
    private ArrayList<IVlanInfo> currentConflictList;
    private ArrayList<IVlanInfo> selectConflictList;
    private ArrayList<IVlanInfo> loadConflictList;
    private JLabel currentVlanLabel;
    private JLabel selectVlanLabel;
    private JLabel importVlanLabel;
    private JScrollPane currentVlanSP;
    private JTable currentVlanTable;
    private JScrollPane selectVlanSP;
    private JTable selectVlanTable;
    private JScrollPane importVlanSP;
    private JTable importVlanTable;
    private JButton fromCurrentButton;
    private JButton fromImportButton;
    private JButton okButton;
    private JButton cancelButton;
    private boolean pressedOk;
    private ColorTableRenderer colorTableRenderer;
    private static final SDebug db = new SDebug("VlanMergeDialog");

    public VlanMergeDialog(Frame frame, String string, boolean bl, ArrayList<IVlanInfo> arrayList, ArrayList<IVlanInfo> arrayList2) {
        super(frame, string, bl);
        this.currentConflictList = arrayList;
        this.loadConflictList = arrayList2;
        this.init();
        this.setSize(700, 350);
    }

    private void init() {
        this.colorTableRenderer = new ColorTableRenderer();
        this.currentVlanLabel = new JLabel();
        this.selectVlanLabel = new JLabel();
        this.importVlanLabel = new JLabel();
        this.currentVlanSP = new JScrollPane();
        this.currentVlanTable = this.createTable();
        this.selectVlanSP = new JScrollPane();
        this.selectVlanTable = this.createTable();
        this.importVlanSP = new JScrollPane();
        this.importVlanTable = this.createTable();
        this.fromCurrentButton = new JButton();
        this.fromImportButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 1.0E-4};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0E-4};
        jPanel2.setLayout(gridBagLayout);
        JPanel jPanel3 = new JPanel();
        this.currentVlanLabel.setText("Current VLAN ID");
        jPanel2.add((Component)this.currentVlanLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.selectVlanLabel.setText("Select VLAN ID");
        jPanel2.add((Component)this.selectVlanLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.importVlanLabel.setText("Import VLAN ID");
        jPanel2.add((Component)this.importVlanLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.currentVlanTable.setModel(new VlanTableModel(this.currentConflictList));
        this.currentVlanTable.setDefaultRenderer(Short.class, this.colorTableRenderer);
        this.currentVlanSP.setViewportBorder(new BevelBorder(1));
        this.currentVlanSP.setViewportView(this.currentVlanTable);
        jPanel2.add((Component)this.currentVlanSP, new GridBagConstraints(0, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.selectConflictList = this.createListOfVlan(this.currentConflictList.size());
        this.selectVlanTable.setModel(new VlanTableModel(this.selectConflictList));
        this.selectVlanSP.setViewportBorder(new BevelBorder(1));
        this.selectVlanSP.setViewportView(this.selectVlanTable);
        jPanel2.add((Component)this.selectVlanSP, new GridBagConstraints(2, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.importVlanTable.setModel(new VlanTableModel(this.loadConflictList));
        this.importVlanTable.setDefaultRenderer(Short.class, this.colorTableRenderer);
        this.importVlanSP.setViewportBorder(new BevelBorder(1));
        this.importVlanSP.setViewportView(this.importVlanTable);
        jPanel2.add((Component)this.importVlanSP, new GridBagConstraints(4, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.fromCurrentButton.setText(">>");
        this.fromCurrentButton.addActionListener(this);
        jPanel2.add((Component)this.fromCurrentButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.fromImportButton.setText("<<");
        this.fromImportButton.addActionListener(this);
        jPanel2.add((Component)this.fromImportButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        jPanel.add((Component)jPanel2, "Center");
        jPanel3.setBorder(new EmptyBorder(12, 0, 0, 0));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout2.columnWidths = new int[]{0, 85, 80};
        gridBagLayout2.columnWeights = new double[]{1.0, 0.0, 0.0};
        jPanel3.setLayout(gridBagLayout2);
        this.okButton.setText("OK");
        this.okButton.addActionListener(this);
        jPanel3.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        jPanel3.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel3, "South");
        container.add((Component)jPanel, "Center");
    }

    private JTable createTable() {
        JTable jTable = new JTable(){

            public void createDefaultColumnsFromModel() {
                if (db.on()) {
                    db.println("createDefaultColumnsFromModel() enter");
                }
                super.createDefaultColumnsFromModel();
                VlanMergeDialog.this.initColumns(this);
            }
        };
        jTable.setAutoResizeMode(0);
        return jTable;
    }

    private void initColumns(JTable jTable) {
        if (db.on()) {
            db.println("initColumns(" + jTable + ") enter");
        }
        if (jTable == null) {
            return;
        }
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        if (db.on()) {
            db.println("data model column count: " + n);
        }
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (db.on()) {
                Object object = tableColumn.getHeaderValue();
                db.println("fitColumnToHeader(" + object + ")");
            }
            this.fitColumnToHeader(jTable, tableColumn);
        }
    }

    private void fitColumnToHeader(JTable jTable, TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Object object = tableColumn.getHeaderValue();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, 0);
        int n = component.getPreferredSize().width;
        VlanMergeDialog.setPreferredWidth(tableColumn, n);
        if (db.on()) {
            db.println("column: '" + object + "' was set to pref. width: " + n);
        }
    }

    private static void setPreferredWidth(TableColumn tableColumn, int n) {
        tableColumn.setPreferredWidth(n + 12);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.pressedOk = true;
            int n = this.howManyVlanNotValid();
            if (n == 0) {
                this.setVisible(false);
                this.dispose();
            } else {
                ErrorMsg.displayError((Component)JOptionPane.getFrameForComponent(this), (EID)NEMC.EID_ERROR_MERGE_VLAN, (Object)(n + ""));
            }
        } else if (object == this.cancelButton) {
            this.pressedOk = false;
            this.setVisible(false);
            this.dispose();
        } else if (object == this.fromCurrentButton) {
            this.moveToSelect(0);
        } else if (object == this.fromImportButton) {
            this.moveToSelect(1);
        }
    }

    public ArrayList<IVlanInfo> getSelectConflictList() {
        return this.selectConflictList;
    }

    public boolean pressedOk() {
        return this.pressedOk;
    }

    private ArrayList<IVlanInfo> createListOfVlan(int n) {
        ArrayList<IVlanInfo> arrayList = new ArrayList<IVlanInfo>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new VlanInfo());
        }
        return arrayList;
    }

    private void moveToSelect(int n) {
        JTable jTable = null;
        JTable jTable2 = null;
        if (n == 0) {
            jTable = this.currentVlanTable;
            jTable2 = this.importVlanTable;
        } else {
            jTable = this.importVlanTable;
            jTable2 = this.currentVlanTable;
        }
        int[] nArray = jTable.getSelectedRows();
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            n2 = nArray[i];
            Object object = ((VlanTableModel)jTable.getModel()).getValueAt(n2);
            Object object2 = ((VlanTableModel)jTable2.getModel()).getValueAt(n2);
            IVlanInfo iVlanInfo = (IVlanInfo)object;
            IVlanInfo iVlanInfo2 = (IVlanInfo)object2;
            iVlanInfo.setVlanSelect(true);
            iVlanInfo2.setVlanSelect(false);
            ((VlanTableModel)this.selectVlanTable.getModel()).setValueAt(object, n2);
        }
        jTable.updateUI();
        jTable2.updateUI();
    }

    private int howManyVlanNotValid() {
        int n = 0;
        VlanInfo vlanInfo = null;
        for (int i = 0; i < this.selectConflictList.size(); ++i) {
            vlanInfo = (VlanInfo)this.selectConflictList.get(i);
            if (vlanInfo.isValid()) continue;
            ++n;
        }
        return n;
    }

    class ColorTableRenderer
    extends DefaultTableCellRenderer {
        public ColorTableRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Short && object != null) {
                JLabel jLabel;
                if (component instanceof JLabel) {
                    jLabel = (JLabel)component;
                    jLabel.setHorizontalAlignment(4);
                }
                if ((jLabel = (IVlanInfo)((VlanTableModel)jTable.getModel()).getValueAt(n)).isVlanSelect()) {
                    component.setBackground(Color.green);
                } else if (!bl) {
                    component.setBackground(Color.white);
                }
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VlanTableModel
    extends AbstractTableModel {
        private ArrayList<IVlanInfo> vlanList = null;

        public VlanTableModel(ArrayList<IVlanInfo> arrayList) {
            this.vlanList = new ArrayList<IVlanInfo>(arrayList);
        }

        @Override
        public String getColumnName(int n) {
            return columnName[n];
        }

        @Override
        public int getColumnCount() {
            return columnName.length;
        }

        @Override
        public int getRowCount() {
            return this.vlanList.size();
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Short.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return Boolean.class;
                }
                case 4: {
                    return Boolean.class;
                }
                case 5: {
                    return Boolean.class;
                }
            }
            return Boolean.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            IVlanInfo iVlanInfo = this.vlanList.get(n);
            switch (n2) {
                case 0: {
                    return new Short(iVlanInfo.getVlanId());
                }
                case 1: {
                    return iVlanInfo.getVlanName();
                }
                case 2: {
                    return new Boolean(iVlanInfo.isVlanProtected());
                }
                case 3: {
                    return new Boolean(iVlanInfo.isMacLearning());
                }
                case 4: {
                    return new Boolean(iVlanInfo.isIgmp());
                }
                case 5: {
                    return new Boolean(iVlanInfo.isIgmpFastLeave());
                }
            }
            return new Boolean(iVlanInfo.isIgmpSuppression());
        }

        public void setValueAt(Object object, int n) {
            IVlanInfo iVlanInfo = this.vlanList.get(n);
            IVlanInfo iVlanInfo2 = (IVlanInfo)object;
            iVlanInfo.setVlanId(iVlanInfo2.getVlanId());
            iVlanInfo.setVlanName(iVlanInfo2.getVlanName());
            iVlanInfo.setVlanProtection(iVlanInfo2.isVlanProtected());
            iVlanInfo.setMacLearning(iVlanInfo2.isMacLearning());
            iVlanInfo.setIgmp(iVlanInfo2.isIgmp());
            iVlanInfo.setIgmpFastLeave(iVlanInfo2.isIgmpFastLeave());
            iVlanInfo.setIgmpSuppression(iVlanInfo2.isIgmpSuppression());
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n) {
            return this.vlanList.get(n);
        }
    }
}

