/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import java.awt.Toolkit;
import javax.swing.JPasswordField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LetterOrDigitPasswordField
extends JPasswordField {
    private static String lettersString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTURVWXYZ";
    private static String digitsString = "0123456789";
    private String extraChars;
    private int documentMaxLength;

    public LetterOrDigitPasswordField(int n) {
        this(n, "", n);
    }

    protected LetterOrDigitPasswordField(int n, String string) {
        this(n, string, n);
    }

    protected LetterOrDigitPasswordField(int n, String string, int n2) {
        super(n);
        this.extraChars = string;
        this.documentMaxLength = n2;
    }

    protected Document createDefaultModel() {
        return new LetterOrDigitDocument();
    }

    class LetterOrDigitDocument
    extends PlainDocument {
        LetterOrDigitDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = true;
            if (string != null) {
                if (string.length() + this.getLength() > LetterOrDigitPasswordField.this.documentMaxLength) {
                    bl = false;
                } else {
                    for (int i = 0; bl && i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (-1 != lettersString.indexOf(c) || -1 != digitsString.indexOf(c) || -1 != LetterOrDigitPasswordField.this.extraChars.indexOf(c)) continue;
                        bl = false;
                    }
                }
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

