/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.cms.model.SVlanList;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.gui.AbstractPropertyEditor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SVlanListPropertyEditor
extends AbstractPropertyEditor
implements ActionListener,
FocusListener {
    public static final String SVLAN_LIST_PROP_NAME = "svanlist";
    public static final String SVLAN_LABEL_TXT = "Set of SVLANs: ";
    public static final int SVLAN_FIELD_LENGTH = 20;
    private JLabel lbl;
    private JTextField tf;
    private SVlanList slist;
    private boolean notifyOnFocusLost = false;

    public SVlanListPropertyEditor() {
        this(SVLAN_LABEL_TXT);
    }

    public SVlanListPropertyEditor(String string) {
        this(string, 20);
    }

    public SVlanListPropertyEditor(String string, int n) {
        this.setLayout(new FlowLayout(0));
        this.lbl = new JLabel(string);
        this.add(this.lbl);
        this.tf = new JTextField(n);
        this.add(this.tf);
        this.tf.addActionListener(this);
        this.tf.addFocusListener(this);
    }

    public SVlanListPropertyEditor(String string, int n, boolean bl) {
        this.setLayout(new FlowLayout(0));
        this.lbl = new JLabel(string);
        this.add(this.lbl);
        this.tf = new JTextField(n);
        this.add(this.tf);
        this.tf.addActionListener(this);
        this.tf.addFocusListener(this);
        this.notifyOnFocusLost = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this._handleTextChange();
    }

    private void _handleTextChange() {
        String string = this.tf.getText();
        SVlanList sVlanList = this.slist;
        try {
            this.slist = new SVlanList(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorMsg.displayError((Component)SwingUtilities.getWindowAncestor(this), (EID)CEMC.EID_SVLAN_OUT_OF_RANGE);
            this.tf.requestFocus();
        }
        this.firePropertyChange(SVLAN_LIST_PROP_NAME, sVlanList, this.slist);
    }

    public String getText() {
        return this.tf.getText();
    }

    public void setText(String string) {
        this.tf.setText(string);
        this._handleTextChange();
    }

    public SVlanList getSVlanList() {
        return this.slist;
    }

    public String toString() {
        return "SVlanListPropertyEditor list of svlans: " + (this.slist == null ? "-" : this.slist.toString());
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.notifyOnFocusLost) {
            this._handleTextChange();
        }
    }
}

