/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;

public class ServerTrailUtil {
    private static final SDebug db = new SDebug("ServerTrailUtil");

    private ServerTrailUtil() {
    }

    public static String getEndpointString(IPathDefModel iPathDefModel) {
        if (!(iPathDefModel instanceof IHoPathDefModel) && !(iPathDefModel instanceof ILoDefModel)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        if (iPathDefModel instanceof IHoPathDefModel) {
            IEntityModel iEntityModel;
            String string;
            IHoPathDefModel iHoPathDefModel;
            block11: {
                iHoPathDefModel = (IHoPathDefModel)iPathDefModel;
                string = iHoPathDefModel.getNodeModel().getName();
                iEntityModel = null;
                try {
                    iEntityModel = iHoPathDefModel.getPool().getEntityModel();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!ServerTrailUtil.db.on) break block11;
                    db.println("getEndpointString: Could not retrieve endpoint");
                }
            }
            IHoNum iHoNum = iHoPathDefModel.getStartingHo();
            ILoNum iLoNum = null;
            short s = iHoPathDefModel.getPathIdentifier();
            stringBuffer.append(string);
            stringBuffer.append("/");
            stringBuffer.append(CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel, iHoNum, iLoNum, s));
        } else if (iPathDefModel instanceof ILoDefModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)iPathDefModel;
            String string = iLoDefModel.getLoAdit().getNodeModel().getName();
            IEntityModel iEntityModel = null;
            try {
                iEntityModel = iLoDefModel.getLoAdit().getHo().getPool().getEntityModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (ServerTrailUtil.db.on) {
                    db.println("getEndpointString: Could not retrieve endpoint");
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (ServerTrailUtil.db.on) {
                    db.println("getEndpointString: Could not retrieve endpoint");
                }
                return "";
            }
            IHoNum iHoNum = iLoDefModel.getLoAdit().getHo().getStartingHo();
            ILoNum iLoNum = iLoDefModel.getLoNum();
            short s = iLoDefModel.getLoAdit().getHo().getPathIdentifier();
            stringBuffer.append(string);
            stringBuffer.append("/");
            stringBuffer.append(CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel, iHoNum, iLoNum, s));
        }
        return stringBuffer.toString();
    }
}

