/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISecurityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.MainPanel;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import com.cisco.ctc.CtcLockDialog;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

class CtcIdleTimer
implements AWTEventListener,
ActionListener,
IObserver {
    private SDebug db;
    private Timer timer;
    private boolean active;
    private int timeout;
    private long lastActivity;
    private boolean manualFire;
    private MainPanel mainPanel;
    private Network.NetElementCreationNotifier netNotifier;
    private INodeModel.AbstractConnectionNotifier nodeNotifier;
    private boolean locked;
    private static final int MS_PER_MINUTE = 60000;

    CtcIdleTimer(SDebug sDebug) {
        this.db = sDebug;
        this.timer = null;
        this.active = true;
        this.timeout = 0;
        this.lastActivity = 0L;
        this.manualFire = false;
        this.mainPanel = null;
        this.netNotifier = null;
        this.nodeNotifier = null;
        this.locked = false;
        if (this.db.on()) {
            this.db.println("<init>: timeout=" + this.timeout);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 88L);
    }

    void setActive(boolean bl) {
        this.active = bl;
    }

    void lockCtc() {
        if (!this.locked) {
            NetSecurityModel netSecurityModel = NetSecurityModel.instance();
            if (this.db.on()) {
                this.db.println("lockCtc: timeout=" + this.timeout);
            }
            this.locked = true;
            CtcLockDialog.instance(this.mainPanel, netSecurityModel.getUserName(), netSecurityModel.getPassword(), netSecurityModel.getAllowedUnlockAttempts(), this.timeout).show();
            this.locked = false;
        }
    }

    boolean isLocked() {
        return this.locked;
    }

    void unlockCtc() {
        if (this.locked) {
            CtcLockDialog.instance().hide();
        }
    }

    private void unobserveNetNotifier() {
        if (this.netNotifier != null) {
            this.netNotifier.deleteObserver(this);
        }
    }

    private void observeNetNotifier() {
        this.unobserveNetNotifier();
        this.netNotifier = Network.instance().getNetElementCreationNotifier();
        if (this.netNotifier != null) {
            this.netNotifier.addObserver(this);
        }
    }

    private void unobserveNodeNotifier() {
        if (this.nodeNotifier != null) {
            this.nodeNotifier.deleteObserver((IObserver)this);
        }
    }

    private void observeNodeNotifier(NodeModel nodeModel) {
        this.unobserveNodeNotifier();
        this.nodeNotifier = nodeModel.getConnectionNotifier();
        if (this.nodeNotifier != null) {
            this.nodeNotifier.addObserver((IObserver)this);
        }
    }

    private void unobserveSecurity(NodeModel nodeModel) {
        ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
        if (iSecurityModel != null) {
            iSecurityModel.deleteObserver((IObserver)this);
        }
    }

    private void observeSecurity(NodeModel nodeModel) {
        this.unobserveSecurity(nodeModel);
        ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
        if (iSecurityModel != null) {
            iSecurityModel.addObserver((IObserver)this);
        }
    }

    private void destroyTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    synchronized void start(MainPanel mainPanel) {
        if (this.timer == null && this.active) {
            NodeModel nodeModel = (NodeModel)NetworkModel.instance().getCmsHostModel();
            this.observeNetNotifier();
            this.observeNodeNotifier(nodeModel);
            this.observeSecurity(nodeModel);
            this.mainPanel = mainPanel;
            this.timeout = this.getIdleTimeout(nodeModel);
            if (this.db.on()) {
                this.db.println("<start>: timeout=" + this.timeout);
            }
            if (this.timeout > 0) {
                this.timer = new Timer(this.timeout, this);
                this.timer.start();
            }
        }
    }

    synchronized void restart() {
        if (this.timeout > 0) {
            if (this.timer == null) {
                this.timer = new Timer(this.timeout, this);
            } else {
                this.timer.stop();
            }
            long l = System.currentTimeMillis();
            long l2 = l - this.lastActivity;
            if (this.db.on()) {
                this.db.println("<restart>: now=" + l + " last=" + this.lastActivity + " used=" + l2 + " timeout=" + this.timeout + " delay=" + (int)((long)this.timeout - l2));
                this.db.println("<restart>: delay=" + this.timeout);
            }
            this.timer.setDelay(this.timeout);
            if (l2 > (long)this.timeout) {
                if (this.db.on()) {
                    this.db.println("<restart>: initial=0");
                }
                this.timer.setInitialDelay(0);
            } else {
                if (this.db.on()) {
                    this.db.println("<restart>: initial=" + (int)((long)this.timeout - l2));
                }
                this.timer.setInitialDelay((int)((long)this.timeout - l2));
            }
            this.timer.restart();
        } else {
            this.destroyTimer();
            if (this.db.on()) {
                this.db.println("<restart>: timeout=" + this.timeout);
            }
        }
    }

    synchronized void stop() {
        this.destroyTimer();
        if (this.db.on()) {
            this.db.println("<stop>: timeout=" + this.timeout);
        }
        this.unobserveNetNotifier();
        this.unobserveNodeNotifier();
        NodeModel nodeModel = (NodeModel)NetworkModel.instance().getCmsHostModel();
        this.unobserveSecurity(nodeModel);
    }

    synchronized void fire() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer.setInitialDelay(0);
            this.manualFire = true;
            this.timer.start();
        }
    }

    private boolean isTimedOut() {
        long l = System.currentTimeMillis() - this.lastActivity;
        if (this.db.on()) {
            this.db.println("isTimedOut: timeout=" + this.timeout + " idleTime=" + l + " manualFire=" + this.manualFire);
        }
        if (this.manualFire) {
            this.manualFire = false;
            return true;
        }
        return this.timeout > 0 && l > (long)this.timeout;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.db.on()) {
            this.db.println("actionPerformed");
        }
        if (this.isTimedOut()) {
            MainPanel mainPanel = this.mainPanel;
            this.stop();
            this.lockCtc();
            this.start(mainPanel);
        } else {
            this.restart();
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        this.lastActivity = System.currentTimeMillis();
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof Network.NetElementCreationNotifier && object instanceof NetElement) {
            NodeModel nodeModel = (NodeModel)((NetElement)object).getNodeModel();
            if (nodeModel.isCmsHost()) {
                if (this.db.on()) {
                    this.db.println("update: from net cms-host=" + nodeModel.getName());
                }
                nodeModel.getConnectionNotifier().addObserver((IObserver)this);
                nodeModel.getSecurityModel().addObserver((IObserver)this);
            }
        } else if (iObservable instanceof NodeModel.ConnectionNotifier) {
            NodeModel.ConnectionNotifier connectionNotifier = (NodeModel.ConnectionNotifier)iObservable;
            NodeModel nodeModel = connectionNotifier.getNodeModel();
            if (object == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("update: node deleted=" + nodeModel.getName());
                }
                connectionNotifier.deleteObserver(this);
            } else if (object == ModelUpdateType.CHANGED && nodeModel.isCmsHost()) {
                if (this.db.on()) {
                    this.db.println("update: from cn new cms-host=" + nodeModel.getName());
                }
                nodeModel.getConnectionNotifier().addObserver((IObserver)this);
                try {
                    ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                    if (iSecurityModel != null) {
                        iSecurityModel.addObserver((IObserver)this);
                    }
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    if (this.db.on()) {
                        this.db.println("update(): Caught " + (Object)((Object)abstractCmsCommFailException) + ", The delegate is null.  " + abstractCmsCommFailException.getMessage());
                    }
                }
                catch (Exception exception) {
                    if (this.db.on()) {
                        this.db.println("update(): Caught " + exception + ", The delegate is null.  " + exception.getMessage());
                    }
                }
            }
        } else if (iObservable instanceof ISecurityModel) {
            ISecurityModel iSecurityModel = (ISecurityModel)iObservable;
            INodeModel iNodeModel = iSecurityModel.getNodeModel();
            if (object == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("update: security deleted=" + iNodeModel.getName());
                }
                iSecurityModel.deleteObserver((IObserver)this);
            } else if (object == ModelUpdateType.CHANGED) {
                int n;
                if (this.db.on()) {
                    this.db.println("update: security changed=" + iNodeModel.getName());
                }
                if ((n = this.getIdleTimeout(iNodeModel)) != this.timeout) {
                    this.timeout = n;
                    this.restart();
                }
            }
        }
    }

    private int getIdleTimeout(INodeModel iNodeModel) {
        int n;
        block9: {
            n = 900000;
            try {
                int n2 = iNodeModel.getSecurityLevel().value();
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SECURITY_POLICY)) {
                    n = iNodeModel.getSecurityModel().getSecurityPolicy().getIdleTimeout(n2) * 60000;
                } else {
                    switch (n2) {
                        case 1: {
                            n = 3600000;
                            break;
                        }
                        case 2: {
                            n = 1800000;
                            break;
                        }
                        case 3: {
                            n = 900000;
                            break;
                        }
                        default: {
                            n = 0;
                        }
                    }
                }
            }
            catch (Exception exception) {
                this.db.println("Unable to obtain value for Idle Timeout, using " + n);
                if (!this.db.on()) break block9;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return n;
    }
}

