/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc;

import cerent.cms.ui.AbstractPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.StackTraceUtil;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UFrame;
import cerent.util.job.JobControllerFactory;
import com.cisco.ctc.CtcApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class CtcLockDialog
extends JDialog
implements ActionListener {
    private static final int MARGIN = 5;
    private static final String TITLE = "CTC Locked";
    private static final String LOCK_1 = "This session has been locked";
    private static final String LOCK_2 = "due to lack of activity";
    private static final String LOCK_3a = "over ";
    private static final String LOCK_3b = " minutes";
    private static final String LOCK_4 = "by user";
    private static final String PASSWORD = "Password: ";
    private static final String UNLOCK = "Unlock";
    private static final String EXIT = "Exit...";
    private static final int tdKeyCode = StackTraceUtil.getDefaultThreadDumpKeyCode();
    private static final int tdModifiers = StackTraceUtil.getDefaultThreadDumpModifiers();
    private JButton unlockButton;
    private JButton exitButton;
    private JLabel userNameLB;
    private JPasswordField passwordTF;
    private String password;
    private int _failedUnlockAttempts = 0;
    private int _allowedUnlockAttempts = 5;
    private int timeoutPeriod;
    private static UFrame _frame;
    private static CtcLockDialog instance_;
    private static final int DEFAULT_ALLOWED_UNLOCK_ATTEMPTS = 5;

    public static synchronized CtcLockDialog instance(UFrame uFrame, String string, String string2, int n, int n2) {
        if (instance_ == null) {
            instance_ = new CtcLockDialog(uFrame);
        }
        instance_.setLogin(string, string2, n, n2);
        _frame = uFrame;
        if (UFrame.isWindowsPlatform()) {
            _frame.setMinimizeStateForAll();
        } else {
            _frame.setVisibleStateForAll(false);
        }
        return instance_;
    }

    public static CtcLockDialog instance(UFrame uFrame, String string, String string2) {
        return CtcLockDialog.instance(uFrame, string, string2, 5, 0);
    }

    public static CtcLockDialog instance() {
        return instance_;
    }

    public static void exitCtc(JDialog jDialog) {
        CtcApplication ctcApplication = CtcApplication.instance();
        if (!JobControllerFactory.isDisposable()) {
            ctcApplication.exitCtc(true);
        } else if (CerentDialog.yesNoDialog((Component)jDialog, (String)"Do you really want to exit CTC?", (String)"Confirm Exit")) {
            ctcApplication.exitCtc(false);
        }
    }

    private CtcLockDialog(UFrame uFrame) {
        super(uFrame, TITLE, true);
        this.setDefaultCloseOperation(0);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)this.getMainPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(uFrame);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CtcLockDialog.exitCtc(CtcLockDialog.this);
            }
        });
    }

    private JPanel getMainPanel() {
        JPanel jPanel = AbstractPane.createVerticalPanel(null);
        JPanel jPanel2 = AbstractPane.createHorizontalPanel(null);
        this.addLabel(jPanel, LOCK_1);
        this.addLabel(jPanel, LOCK_2);
        if (this.timeoutPeriod > 0) {
            this.addLabel(jPanel, LOCK_3a + this.timeoutPeriod + LOCK_3b);
        }
        this.addLabel(jPanel, LOCK_4);
        this.userNameLB = this.addLabel(jPanel, null);
        this.addLabel(jPanel, " ");
        jPanel2.add(new JLabel(PASSWORD));
        this.passwordTF = new JPasswordField(20);
        this.passwordTF.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    CtcLockDialog.this.tryUnlock();
                } else if (keyEvent.getKeyCode() == tdKeyCode && keyEvent.getModifiers() == tdModifiers) {
                    StackTraceUtil.dumpThreads(System.out);
                }
            }
        });
        this.passwordTF.requestFocus();
        jPanel2.add(this.passwordTF);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JLabel addLabel(JPanel jPanel, String string) {
        JLabel jLabel = new JLabel(string);
        jPanel.add(jLabel);
        jLabel.setAlignmentX(0.5f);
        return jLabel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.unlockButton = this.makeActionButton(UNLOCK);
        jPanel.add(this.unlockButton);
        this.exitButton = this.makeActionButton(EXIT);
        jPanel.add(this.exitButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private void setLogin(String string, String string2, int n, int n2) {
        this.userNameLB.setText("\"" + string + "\"");
        this.password = string2;
        this._allowedUnlockAttempts = n;
        this.timeoutPeriod = n2;
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.unlockButton) {
            this.tryUnlock();
        } else if (object == this.exitButton) {
            CtcLockDialog.exitCtc(this);
        }
    }

    private void tryUnlock() {
        String string = new String(this.passwordTF.getPassword());
        if (string.equals(this.password)) {
            this._failedUnlockAttempts = 0;
            this.dispose();
            if (UFrame.isWindowsPlatform()) {
                _frame.setNormalStateForAll();
            } else {
                _frame.setVisibleStateForAll(true);
            }
        } else if (++this._failedUnlockAttempts > this._allowedUnlockAttempts) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ALLOWED_UNLOCK_ATTEMPTS_REACHED, (Object)new Integer(this._allowedUnlockAttempts));
            CtcApplication.instance().exitCtc(false);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        this.passwordTF.setText("");
    }

    static {
        instance_ = null;
    }
}

