/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui.sot;

import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import com.cisco.sot.Tl1Tunnel;
import com.cisco.sot.Tl1TunnelAddr;
import com.cisco.sot.Tl1TunnelAddrBook;
import com.cisco.sot.Tl1TunnelFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class SoTl1DataSource
extends AbstractRowDataSource {
    private static final SDebug db = new SDebug("SoTl1DataSource");
    private ArrayList rows = new ArrayList();

    public synchronized void reload() {
        this.unload();
        Tl1TunnelAddr[] tl1TunnelAddrArray = Tl1TunnelAddrBook.instance().getTunnels();
        Tl1TunnelFactory tl1TunnelFactory = Tl1TunnelFactory.instance();
        for (int i = 0; i < tl1TunnelAddrArray.length; ++i) {
            Tl1Tunnel tl1Tunnel = tl1TunnelFactory.getTunnel(tl1TunnelAddrArray[i]);
            TunnelEntry tunnelEntry = new TunnelEntry(tl1TunnelAddrArray[i], tl1Tunnel, i);
            this.rows.add(tunnelEntry);
        }
        this.changed();
    }

    public synchronized void unload() {
        for (int i = 0; i < this.rows.size(); ++i) {
            TunnelEntry tunnelEntry = (TunnelEntry)this.rows.get(i);
            tunnelEntry.dispose();
        }
        this.rows.clear();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rows.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection getAllObjects() {
        return new ArrayList(this.rows);
    }

    public void changed() {
        this.fireDataSourceChanged();
    }

    boolean isRowActive(int n) {
        boolean bl = false;
        try {
            TunnelEntry tunnelEntry = (TunnelEntry)this.rows.get(n);
            bl = tunnelEntry.tunnel != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public class TunnelEntry
    implements Observer {
        Tl1TunnelAddr addr;
        Tl1Tunnel tunnel;
        private int index;

        public TunnelEntry(Tl1TunnelAddr tl1TunnelAddr, Tl1Tunnel tl1Tunnel, int n) {
            this.addr = tl1TunnelAddr;
            this.setTunnel(tl1Tunnel);
            this.index = n;
        }

        public String getGneHost() {
            return this.addr.host;
        }

        public String getGneTid() {
            return this.addr.gneTid;
        }

        public String getPneTid() {
            return this.addr.pneTid;
        }

        public int getGnePort() {
            return this.addr.gneTl1Port;
        }

        public String getEncoding() {
            return this.addr.getEncoding();
        }

        public void setTunnel(Tl1Tunnel tl1Tunnel) {
            if (this.tunnel != null) {
                this.tunnel.deleteObserver((Observer)this);
            }
            this.tunnel = tl1Tunnel;
            if (tl1Tunnel != null) {
                tl1Tunnel.addObserver((Observer)this);
            }
        }

        public String getState() {
            String string = "";
            if (null != this.tunnel && null != this.tunnel.getState()) {
                string = this.tunnel.getState().toString();
            }
            return string;
        }

        public String getPneIp() {
            String string = "";
            if (null != this.tunnel && null != this.tunnel.getPneIp()) {
                string = this.tunnel.getPneIp().getHostAddress();
            }
            return string;
        }

        public int getSockets() {
            if (this.tunnel == null) {
                return 0;
            }
            return this.tunnel.getSocketCount();
        }

        public int getRetries() {
            if (this.tunnel == null) {
                return 0;
            }
            return this.tunnel.getRetries();
        }

        public long getRx() {
            if (this.tunnel == null) {
                return 0L;
            }
            return this.tunnel.getRx();
        }

        public long getTx() {
            if (this.tunnel == null) {
                return 0L;
            }
            return this.tunnel.getTx();
        }

        public void dispose() {
            if (this.tunnel != null) {
                this.tunnel.deleteObserver((Observer)this);
            }
        }

        public void update(Observable observable, Object object) {
            if (object == null) {
                if (null != this.tunnel && this.tunnel.getState() == Tl1Tunnel.CLOSED) {
                    this.setTunnel(null);
                }
                SoTl1DataSource.this.fireRowsUpdated(this.index, this.index);
            }
        }
    }
}

