/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.ExternalMapKey;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class ExternalMapNode
extends DetailedMapNode {
    protected ExternalMapKey extKey;

    public ExternalMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
        this.setColor(Color.GREEN);
        this.DEFAULT_HEIGHT = 20.0;
        this.DEFAULT_WIDTH = 20.0;
    }

    public void init(Object object, double d, double d2, Object object2) {
        super.init(object, d, d2, object2);
        if (this.getUserObject() instanceof ExternalMapKey) {
            this.extKey = (ExternalMapKey)this.getUserObject();
        }
        this.setCoordinates(0.0, 0.0);
    }

    protected int getContentObjectType() {
        return 1;
    }

    public void setPositionRelatedToNode(DetailedMapNode detailedMapNode) {
        if (detailedMapNode != null) {
            int n;
            double d = detailedMapNode.getCenterX();
            double d2 = detailedMapNode.getCenterY();
            double d3 = 2.0 * detailedMapNode.getWidth();
            double d4 = 2.0 * detailedMapNode.getHeight();
            double d5 = d;
            double d6 = d2 - d4;
            double d7 = d;
            double d8 = d2 + d4;
            double d9 = d + d3;
            double d10 = d2;
            double d11 = d - d3;
            double d12 = d2;
            boolean[] blArray = new boolean[4];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = false;
            }
            MapNode[] mapNodeArray = this.mtk.getMapNodes();
            if (mapNodeArray != null) {
                for (n = 0; n < mapNodeArray.length; ++n) {
                    if (mapNodeArray[n].contains(d5, d6)) {
                        blArray[0] = true;
                    }
                    if (mapNodeArray[n].contains(d7, d8)) {
                        blArray[1] = true;
                    }
                    if (mapNodeArray[n].contains(d9, d10)) {
                        blArray[2] = true;
                    }
                    if (!mapNodeArray[n].contains(d11, d12)) continue;
                    blArray[3] = true;
                }
            }
            n = detailedMapNode.leastPopulatedSide(blArray);
            switch (n) {
                case 1: {
                    this.setCoordinates(d5, d6);
                    break;
                }
                case -1: {
                    this.setCoordinates(d7, d8);
                    break;
                }
                case 2: {
                    this.setCoordinates(d9, d10);
                    break;
                }
                case -2: {
                    this.setCoordinates(d11, d12);
                }
            }
        }
    }

    public String getToolTipText() {
        if (this.extKey != null) {
            return this.extKey.getName();
        }
        return "An external node";
    }

    protected MapPort createMapPort(DetailedMapNode detailedMapNode, MapLink mapLink, MapLinkConnector mapLinkConnector) {
        MapPort mapPort = super.createMapPort(detailedMapNode, mapLink, mapLinkConnector);
        if (mapPort != null) {
            mapPort.setVisible(false);
        }
        return mapPort;
    }

    protected void doubleClicked() {
    }

    protected void clicked() {
    }

    void onInitPopupMenu(UPopupMenu uPopupMenu) {
    }

    protected void adjustNodeSize() {
        int n = this.getAdjustedNodeHeight();
        int n2 = this.getAdjustedNodeWidth();
        int n3 = Math.max(n, n2);
        this.setSize(n3, n3);
    }

    protected void drawMe(Graphics2D graphics2D, MapTransformer mapTransformer) {
        String string;
        super.drawMe(graphics2D, mapTransformer);
        Color color = graphics2D.getColor();
        Rectangle2D rectangle2D = this.getBounds(mapTransformer);
        int n = (int)rectangle2D.getX();
        int n2 = (int)rectangle2D.getY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        if (this.extKey != null && (string = this.extKey.getName()) != null && string.length() > 0) {
            char c = string.charAt(0);
            graphics2D.setColor(Color.black);
            MapGraphicsUtil.drawLetter(graphics2D, n, n2, n3, n4, c, true);
            graphics2D.setColor(color);
        }
    }

    public boolean canInsertToDomain() {
        return false;
    }
}

