/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;

public class MapGraphicsUtil {
    public static final int NO_DESIGN = 0;
    public static final int ADJACENT_LOOP_IN = 1;
    public static final int ADJACENT_LOOP_OUT = 2;
    public static final int ADJACENT_LOOP_OUT_LONG = 3;
    public static final int ALPHA_DIMMED = 100;
    private static final float CENTER_WIDTH = 2.0f;
    private static final float BORDER_WIDTH = 4.0f;
    private static final float DETAIL_WIDTH = 1.5f;
    private static final float INNERDETAIL_WIDTH = 0.5f;
    public static final float[] dash = new float[]{6.0f};
    public static final Stroke[] DETAILSTROKE = new Stroke[]{new BasicStroke(1.5f), new BasicStroke(1.5f, 2, 0, 10.0f, dash, 0.0f)};
    public static final Stroke[] INNERDETAILSTROKE = new Stroke[]{new BasicStroke(0.5f), new BasicStroke(0.5f, 2, 0, 10.0f, dash, 0.0f)};
    public static final Stroke[] CENTERSTROKE = new Stroke[]{new BasicStroke(1.0f), new BasicStroke(2.0f), new BasicStroke(1.0f, 2, 0, 10.0f, dash, 0.0f), new BasicStroke(2.0f, 2, 0, 10.0f, dash, 0.0f)};
    public static final Stroke[] BORDERSTROKE = new Stroke[]{new BasicStroke(2.0f), new BasicStroke(4.0f), new BasicStroke(2.0f, 2, 0, 10.0f, dash, 0.0f), new BasicStroke(4.0f, 2, 0, 10.0f, dash, 0.0f)};

    private MapGraphicsUtil() {
    }

    public static void drawDesign(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (int)((double)n3 * 0.25);
        int n8 = (int)((double)n4 * 0.25);
        double d = 0.15;
        if (n6 == 1 || n6 == 2 || n6 == 3) {
            double d2;
            double d3;
            double d4;
            double d5 = 180.0;
            double d6 = n3;
            double d7 = n4;
            Arc2D.Double double_ = new Arc2D.Double();
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            switch (n5) {
                case -2: {
                    d4 = n2;
                    if (n6 == 3) {
                        d6 = 3.0 * d6;
                        d3 = (double)n - 0.5 * (double)n3;
                        d2 = 270.0;
                        nArray[0] = (int)((double)(n + n3) + (double)n3 * 0.5);
                        nArray2[0] = (int)((double)n2 + (double)n4 * 0.75 - (double)n4 * d);
                        nArray[1] = n + n3;
                        nArray2[1] = n2 + n4;
                        nArray[2] = nArray[0];
                        nArray2[2] = (int)((double)n2 + (double)n4 * 1.25 - (double)n4 * d);
                        break;
                    }
                    if (n6 == 1) {
                        d3 = n + n3;
                        d2 = 90.0;
                        nArray[0] = (int)((double)n + (double)n3 * 1.5);
                        nArray2[0] = (int)((double)n2 - (double)n4 * 0.25);
                        nArray[1] = (int)((double)n + (double)n3 * 2.0);
                        nArray2[1] = n2;
                        nArray[2] = nArray[0];
                        nArray2[2] = (int)((double)n2 + (double)n4 * 0.25);
                        break;
                    }
                    d6 = 1.5 * d6;
                    d3 = n + n3 / 4;
                    d2 = 270.0;
                    nArray[0] = (int)((double)(n + n3) + (double)n3 * 0.5);
                    nArray2[0] = (int)((double)n2 + (double)n4 * 0.75 - (double)n4 * d);
                    nArray[1] = n + n3;
                    nArray2[1] = n2 + n4;
                    nArray[2] = nArray[0];
                    nArray2[2] = (int)((double)n2 + (double)n4 * 1.25 - (double)n4 * d);
                    break;
                }
                case 2: {
                    d4 = n2;
                    if (n6 == 3) {
                        d6 = 3.0 * d6;
                        d3 = (double)n - 1.5 * (double)n3;
                        d2 = 90.0;
                        nArray[0] = (int)((double)n - (double)n3 * 0.5);
                        nArray2[0] = (int)((double)n2 - (double)n4 * 0.25 + (double)n4 * d);
                        nArray[1] = n;
                        nArray2[1] = n2;
                        nArray[2] = nArray[0];
                        nArray2[2] = (int)((double)n2 + (double)n4 * 0.25 + (double)n4 * d);
                        break;
                    }
                    if (n6 == 1) {
                        d3 = (double)n - (double)n3;
                        d2 = 270.0;
                        nArray[0] = (int)((double)n - (double)n3 * 0.5);
                        nArray2[0] = (int)((double)n2 + (double)n4 * 0.75);
                        nArray[1] = (int)((double)n - (double)n3 * 1.0);
                        nArray2[1] = n2 + n4;
                        nArray[2] = nArray[0];
                        nArray2[2] = (int)((double)n2 + (double)n4 * 1.25);
                        break;
                    }
                    d6 = 1.5 * d6;
                    d3 = (double)n - (double)(3 * n3 / 4);
                    d2 = 90.0;
                    nArray[0] = (int)((double)n - (double)n3 * 0.5);
                    nArray2[0] = (int)((double)n2 - (double)n4 * 0.25 + (double)n4 * d);
                    nArray[1] = n;
                    nArray2[1] = n2;
                    nArray[2] = nArray[0];
                    nArray2[2] = (int)((double)n2 + (double)n4 * 0.25 + (double)n4 * d);
                    break;
                }
                case -1: {
                    d3 = n;
                    if (n6 == 3) {
                        d7 = 3.0 * d7;
                        d4 = (double)n2 - 1.5 * (double)n4;
                        d2 = 0.0;
                        nArray[0] = (int)((double)n + (double)n3 * 0.75 - (double)n3 * d);
                        nArray2[0] = (int)((double)n2 - 0.5 * (double)n4);
                        nArray[1] = n + n3;
                        nArray2[1] = n2;
                        nArray[2] = (int)((double)n + (double)n3 * 1.25 - (double)n3 * d);
                        nArray2[2] = nArray2[0];
                        break;
                    }
                    if (n6 == 1) {
                        d4 = n2 - n4;
                        d2 = 180.0;
                        nArray[0] = (int)((double)n - (double)n3 * 0.25);
                        nArray2[0] = (int)((double)n2 - 0.5 * (double)n4);
                        nArray[1] = n;
                        nArray2[1] = n2 - n4;
                        nArray[2] = (int)((double)n + (double)n3 * 0.25);
                        nArray2[2] = nArray2[0];
                        break;
                    }
                    d7 = 1.5 * d7;
                    d4 = n2 - 3 * n4 / 4;
                    d2 = 0.0;
                    nArray[0] = (int)((double)n + (double)n3 * 0.75 - (double)n3 * d);
                    nArray2[0] = (int)((double)n2 - 0.5 * (double)n4);
                    nArray[1] = n + n3;
                    nArray2[1] = n2;
                    nArray[2] = (int)((double)n + (double)n3 * 1.25 - (double)n3 * d);
                    nArray2[2] = nArray2[0];
                    break;
                }
                case 1: {
                    d3 = n;
                    if (n6 == 3) {
                        d7 = 3.0 * d7;
                        d4 = (double)n2 - 0.5 * (double)n4;
                        d2 = 180.0;
                        nArray[0] = (int)((double)n - (double)n3 * 0.25 + (double)n3 * d);
                        nArray2[0] = (int)((double)n2 + (double)n3 * 1.5);
                        nArray[1] = n;
                        nArray2[1] = n2 + n4;
                        nArray[2] = (int)((double)n + (double)n3 * 0.25 + (double)n3 * d);
                        nArray2[2] = nArray2[0];
                        break;
                    }
                    if (n6 == 1) {
                        d4 = n2 + n4;
                        d2 = 0.0;
                        nArray[0] = (int)((double)n + (double)n3 * 0.75);
                        nArray2[0] = (int)((double)n2 + (double)n4 * 1.5);
                        nArray[1] = n + n3;
                        nArray2[1] = (int)((double)n2 + (double)n4 * 2.0);
                        nArray[2] = (int)((double)n + (double)n3 * 1.25);
                        nArray2[2] = nArray2[0];
                        break;
                    }
                    d7 = 1.5 * d7;
                    d4 = n2 + n4 / 4;
                    d2 = 180.0;
                    nArray[0] = (int)((double)n - (double)n3 * 0.25 + (double)n3 * d);
                    nArray2[0] = (int)((double)n2 + (double)n3 * 1.5);
                    nArray[1] = n;
                    nArray2[1] = n2 + n4;
                    nArray[2] = (int)((double)n + (double)n3 * 0.25 + (double)n3 * d);
                    nArray2[2] = nArray2[0];
                    break;
                }
                default: {
                    d3 = -1.0;
                    d4 = -1.0;
                    d2 = -1.0;
                }
            }
            if (d3 != -1.0 && d4 != -1.0 && d2 != -1.0) {
                double_.setArc(d3, d4, d6, d7, d2, d5, 0);
                graphics2D.fillPolygon(nArray, nArray2, 3);
                graphics2D.draw(double_);
            }
        }
    }

    public static void drawLetter(Graphics2D graphics2D, int n, int n2, int n3, int n4, char c, boolean bl) {
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.0f));
        int n5 = (int)((double)n3 * 0.25);
        int n6 = (int)((double)n4 * 0.25);
        if (bl) {
            Font font = graphics2D.getFont();
            graphics2D.setFont(new Font("Arial", 1, 15));
            graphics2D.drawString(String.valueOf(c), (int)((double)n + 0.1 * (double)n3 + (double)n5), (int)((double)n2 + 0.5 * (double)n4 + (double)n6));
            graphics2D.setFont(font);
            graphics2D.setStroke(stroke);
            return;
        }
        if (c == 'S') {
            CubicCurve2D.Double double_ = new CubicCurve2D.Double();
            double d = n + n3 - n5 - 1;
            double d2 = n2 + n6;
            double d3 = n - n5 * 2;
            double d4 = (double)(n2 + n6) + 0.05 * (double)(n4 - 2 * n6);
            double d5 = n + n3 + n5 * 2;
            double d6 = (double)(n2 + n4 - n5) - 0.05 * (double)(n4 - 2 * n6);
            double d7 = n + n5 + 1;
            double d8 = n2 + n4 - n5;
            double_.setCurve(d, d2, d3, d4, d5, d6, d7, d8);
            graphics2D.draw(double_);
        } else if (c == 'D') {
            graphics2D.drawLine(n + n5, n2 + n6, n + n5, n2 + n4 - n6);
            Arc2D.Double double_ = new Arc2D.Double();
            double d = n + n5;
            double d9 = n2 + n6;
            double d10 = n3 - 2 * n5;
            double d11 = n4 - 2 * n6;
            double d12 = 270.0;
            double d13 = 180.0;
            double_.setArc(d, d9, d10, d11, d12, d13, 0);
            graphics2D.draw(double_);
            graphics2D.drawLine(n + n5, n2 + n6, (int)double_.getBounds2D().getX(), n2 + n6);
            graphics2D.drawLine(n + n5, n2 + n4 - n6, (int)double_.getBounds2D().getX(), n2 + n4 - n6);
        } else if (c == 'L') {
            graphics2D.drawLine(n + n5, n2 + n6, n + n5, n2 + n4 - n6);
            graphics2D.drawLine(n + n5, n2 + n4 - n6, n + n3 - n5, n2 + n4 - n6);
        } else if (c == 'F') {
            graphics2D.drawLine(n + n5, n2 + n6, n + n5, n2 + n4 - n6);
            graphics2D.drawLine(n + n5, n2 + n6, n + n3 - n5, n2 + n6);
            graphics2D.drawLine(n + n5, n2 + n4 / 2, n + n3 / 2, n2 + n4 / 2);
        } else if (c == 'T') {
            graphics2D.drawLine(n + n5, n2 + n6, n + n3 - n5, n2 + n6);
            graphics2D.drawLine(n + n3 / 2, n2 + n6, n + n3 / 2, n2 + n4 - n6);
        } else if (c == 'I') {
            graphics2D.drawLine(n + n5, n2 + n6, n + n3 - n5, n2 + n6);
            graphics2D.drawLine(n + n3 / 2, n2 + n6, n + n3 / 2, n2 + n4 - n6);
            graphics2D.drawLine(n + n5, n2 + n4 - n6, n + n3 - n5, n2 + n4 - n6);
        } else if (c == 'M') {
            graphics2D.drawLine(n + n5, n2 + n6, n + n5, n2 + n4 - n6);
            graphics2D.drawLine(n + n3 - n5, n2 + n6, n + n3 - n5, n2 + n4 - n6);
            graphics2D.drawLine(n + n5, n2 + n6, n + n3 / 2, n2 + n4 - n6);
            graphics2D.drawLine(n + n3 - n5, n2 + n6, n + n3 / 2, n2 + n4 - n6);
        } else if (c == 'W') {
            graphics2D.drawLine(n + n5, n2 + n6, n + n5, n2 + n4 - n6);
            graphics2D.drawLine(n + n3 - n5, n2 + n6, n + n3 - n5, n2 + n4 - n6);
            graphics2D.drawLine(n + n5, n2 + n4 - n6, n + n3 / 2, n2 + n6);
            graphics2D.drawLine(n + n3 / 2, n2 + n6, n + n3 - n5, n2 + n4 - n6);
        } else if (c == '?') {
            Arc2D.Double double_ = new Arc2D.Double();
            double d = n + n5;
            double d14 = n2 + n6;
            double d15 = n3 - 2 * n5;
            double d16 = n4 / 3;
            double d17 = 270.0;
            double d18 = 180.0;
            double_.setArc(d, d14, d15, d16, d17, d18, 0);
            graphics2D.draw(double_);
            graphics2D.drawLine(n + n3 - (int)d15, n2 + n6 + n4 / 3, n + n3 - (int)d15, n2 + n6 + (int)(0.4 * (double)n4));
            graphics2D.drawLine(n + n3 - (int)d15, n2 + n6 + 2 * n4 / 3, n + n3 - (int)d15, n2 + n6 + 2 * n4 / 3);
        } else if (c == 'O') {
            int n7 = n + n5;
            int n8 = n2 + n6;
            int n9 = n3 - 2 * n5;
            int n10 = n4 - 2 * n6;
            graphics2D.drawOval(n7, n8, n9, n10);
        } else if (c == 'E') {
            graphics2D.drawLine(n + n5, n2 + n6, n + n5, n2 + n4 - n6);
            graphics2D.drawLine(n + n5, n2 + n6, n + n3 - n5, n2 + n6);
            graphics2D.drawLine(n + n5, n2 + n4 / 2, n + n3 / 2, n2 + n4 / 2);
            graphics2D.drawLine(n + n5, n2 + n4 - n6, n + n3 - n5, n2 + n4 - n6);
        } else if (c == 'X') {
            graphics2D.drawLine(n + n5, n2 + n6, n + n3 - n5, n2 + n4 - n6);
            graphics2D.drawLine(n + n3 - n5, n2 + n6, n + n5, n2 + n4 - n6);
        } else if (c == 'A') {
            int n11 = n + n5;
            int n12 = n2 + n4 - n6;
            int n13 = n + n3 / 2;
            int n14 = n2 + n6;
            graphics2D.drawLine(n11, n12, n13, n14);
            n11 = n + n3 - n5;
            n12 = n2 + n4 - n6;
            graphics2D.drawLine(n13, n14, n11, n12);
            n11 = n + (n3 / 2 - n5) + n5 / 2;
            n13 = n + 3 * n3 / 2 / 2 - n5 / 2;
            n12 = n2 + n4 / 2;
            graphics2D.drawLine(n11, n12, n13, n12);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    public static void drawArrow(Graphics graphics, int n, int n2, int n3, int n4) {
        double d;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n5 = 6;
        int n6 = 3;
        nArray[2] = n3;
        nArray2[2] = n4;
        double d2 = Math.abs(n3 - n);
        double d3 = Math.abs(n4 - n2);
        double d4 = d = d2 != 0.0 ? d3 / d2 : d3 / 1.0E-7;
        if (d < 0.75 || d > 1.25) {
            n5 = 8;
            n6 = 4;
        }
        if (n > n3) {
            if (n2 > n4) {
                if (d > 1.0) {
                    int n7 = n4 + n5;
                    int n8 = n3 + (int)(1.0 / d * (double)n5);
                    double d5 = Math.max(n6, Math.abs(n3 - n8));
                    double d6 = Math.min((double)n6, 1.0 / d * d5);
                    nArray[0] = n8 + (int)d5;
                    nArray[1] = n8 - (int)d5;
                    nArray2[0] = n7 - (int)d6;
                    nArray2[1] = n7 + (int)d6;
                } else {
                    int n9 = n3 + n5;
                    int n10 = n4 + (int)(d * (double)n5);
                    double d7 = Math.max(n6, Math.abs(n4 - n10));
                    double d8 = Math.min((double)n6, d * d7);
                    nArray[0] = n9 + (int)d8;
                    nArray[1] = n9 - (int)d8;
                    nArray2[0] = n10 - (int)d7;
                    nArray2[1] = n10 + (int)d7;
                }
            } else if (n2 == n4) {
                nArray[0] = n3 + n5;
                nArray[1] = n3 + n5;
                nArray2[0] = n4 + n6;
                nArray2[1] = n4 - n6;
            } else if (d > 1.0) {
                int n11 = n4 - n5;
                int n12 = n3 + (int)(1.0 / d * (double)n5);
                double d9 = Math.max(n6, Math.abs(n3 - n12));
                double d10 = Math.min((double)n6, 1.0 / d * d9);
                nArray[0] = n12 + (int)d9;
                nArray[1] = n12 - (int)d9;
                nArray2[0] = n11 + (int)d10;
                nArray2[1] = n11 - (int)d10;
            } else {
                int n13 = n3 + n5;
                int n14 = n4 - (int)(d * (double)n5);
                double d11 = Math.max(n6, Math.abs(n4 - n14));
                double d12 = Math.min((double)n6, d * d11);
                nArray[0] = n13 + (int)d12;
                nArray[1] = n13 - (int)d12;
                nArray2[0] = n14 + (int)d11;
                nArray2[1] = n14 - (int)d11;
            }
        } else if (n == n3) {
            nArray[0] = n3 - n6;
            nArray[1] = n3 + n6;
            if (n2 > n4) {
                nArray2[0] = n4 + n5;
                nArray2[1] = n4 + n5;
            } else if (n2 == n4) {
                nArray2[0] = n4 + n6;
                nArray2[1] = n4 - n6;
            } else {
                nArray2[0] = n4 - n5;
                nArray2[1] = n4 - n5;
            }
        } else if (n2 > n4) {
            if (d > 1.0) {
                int n15 = n4 + n5;
                int n16 = n3 - (int)(1.0 / d * (double)n5);
                double d13 = Math.max(n6, Math.abs(n3 - n16));
                double d14 = Math.min((double)n6, 1.0 / d * d13);
                nArray[0] = n16 + (int)d13;
                nArray[1] = n16 - (int)d13;
                nArray2[0] = n15 + (int)d14;
                nArray2[1] = n15 - (int)d14;
            } else {
                int n17 = n3 - n5;
                int n18 = n4 + (int)(d * (double)n5);
                double d15 = Math.max(n6, Math.abs(n4 - n18));
                double d16 = Math.min((double)n6, d * d15);
                nArray[0] = n17 + (int)d16;
                nArray[1] = n17 - (int)d16;
                nArray2[0] = n18 + (int)d15;
                nArray2[1] = n18 - (int)d15;
            }
        } else if (n2 == n4) {
            nArray[0] = n3 - n5;
            nArray[1] = n3 - n6;
            nArray2[0] = n4 + n6;
            nArray2[1] = n4 - n6;
        } else if (d > 1.0) {
            int n19 = n4 - n5;
            int n20 = n3 - (int)(1.0 / d * (double)n5);
            double d17 = Math.max(n6, Math.abs(n3 - n20));
            double d18 = Math.min((double)n6, 1.0 / d * d17);
            nArray[0] = n20 + (int)d17;
            nArray[1] = n20 - (int)d17;
            nArray2[0] = n19 - (int)d18;
            nArray2[1] = n19 + (int)d18;
        } else {
            int n21 = n3 - n5;
            int n22 = n4 - (int)(d * (double)n5);
            double d19 = Math.max(n6, Math.abs(n4 - n22));
            double d20 = Math.min((double)n6, d * d19);
            nArray[0] = n21 + (int)d20;
            nArray[1] = n21 - (int)d20;
            nArray2[0] = n22 - (int)d19;
            nArray2[1] = n22 + (int)d19;
        }
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    public static Color getAlphaColor(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        return new Color(n2, n3, n4, n);
    }

    public static String getColorString(Color color) {
        String string = color.toString();
        if (color == Color.BLACK) {
            string = "black";
        } else if (color == Color.BLUE) {
            string = "blue";
        } else if (color == Color.CYAN) {
            string = "cyan";
        } else if (color == Color.DARK_GRAY) {
            string = "dark gray";
        } else if (color == Color.GRAY) {
            string = "gray";
        } else if (color == Color.GREEN) {
            string = "green";
        } else if (color == Color.LIGHT_GRAY) {
            string = "light gray";
        } else if (color == Color.MAGENTA) {
            string = "magenta";
        } else if (color == Color.ORANGE) {
            string = "orange";
        } else if (color == Color.PINK) {
            string = "pink";
        } else if (color == Color.RED) {
            string = "red";
        } else if (color == Color.WHITE) {
            string = "white";
        } else if (color == Color.YELLOW) {
            string = "yellow";
        }
        return string;
    }
}

