/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.AbstractInternalPG;
import com.cisco.ctc.util.map.DetailedMapLink;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.IMapLineEndpoint;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapRect;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import ilog.views.IlvGraphic;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;

public class MapPort
extends MapRect
implements IMapLineEndpoint,
Comparable,
ActionListener {
    public static final int INTERNAL_CENTER = 0;
    public static final int INTERNAL_LEFT = 1;
    public static final int INTERNAL_RIGHT = 2;
    public static final int INTERNAL_TOP = 3;
    public static final int INTERNAL_BOTTOM = 4;
    public static final int INTERNAL_LEFT_PLUS_HALF = 5;
    public static final int INTERNAL_RIGHT_PLUS_HALF = 6;
    public static final int INTERNAL_TOP_PLUS_HALF = 7;
    public static final int INTERNAL_BOTTOM_PLUS_HALF = 8;
    public static final double PORTWIDTH = 10.0;
    public static final double PORTHEIGHT = 10.0;
    protected DetailedMapNode parentNode = null;
    protected LinkedList connectors = new LinkedList();
    protected AbstractInternalPG internalPG;
    private char letter = (char)32;
    protected int side = 0;
    protected ActionOrganizer actOrg = null;
    protected double sideOffset = 0.0;
    protected String infoString = "";
    protected int design;
    protected int createOrder = -1;
    private static final SDebug db = new SDebug("MapPort");
    protected MapToolkit mtk;
    private Object userObject;
    private Object userCookie;

    public MapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector) {
        super((float)detailedMapNode.getCenterX(), (float)detailedMapNode.getCenterY(), 10.0f, 10.0f);
        this.mtk = detailedMapNode.getMTK();
        this.parentNode = detailedMapNode;
        this.addConnector(mapLinkConnector);
        this.graphicallyInitPort();
    }

    public MapPort(MapGraph mapGraph, MapLinkConnector mapLinkConnector) {
        super((float)((DetailedMapNode)mapGraph.getCollapsedGraphic()).getCenterX(), (float)((DetailedMapNode)mapGraph.getCollapsedGraphic()).getCenterY(), 10.0f, 10.0f);
        this.mtk = ((DetailedMapNode)mapGraph.getCollapsedGraphic()).getMTK();
        this.parentNode = (DetailedMapNode)mapGraph.getCollapsedGraphic();
        this.addConnector(mapLinkConnector);
        this.graphicallyInitPort();
    }

    protected void graphicallyInitPort() {
        this.setSize(10.0, 10.0);
        this.setColor(Color.lightGray);
    }

    public void init(Object object, Object object2) {
        this.setUserObject(object);
        this.setUserCookie(object2);
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserCookie(Object object) {
        this.userCookie = object;
    }

    public Object getUserCookie() {
        return this.userCookie;
    }

    public boolean isInternalPort() {
        return this.getInternalPG() == null && this.connectors.size() == 0;
    }

    public void setInternalPG(AbstractInternalPG abstractInternalPG) {
        this.internalPG = abstractInternalPG;
    }

    public AbstractInternalPG getInternalPG() {
        return this.internalPG;
    }

    public DetailedMapNode getParentNode() {
        return this.parentNode;
    }

    public MapLinkConnector[] getConnectors() {
        return this.connectors.toArray(new MapLinkConnector[0]);
    }

    public void addConnector(MapLinkConnector mapLinkConnector) {
        if (mapLinkConnector != null) {
            this.connectors.add(mapLinkConnector);
        }
    }

    public void removeConnector(MapLinkConnector mapLinkConnector) {
        if (this.connectors.contains((Object)mapLinkConnector)) {
            this.connectors.remove((Object)mapLinkConnector);
        } else {
            db.warning("Tryng to remove connector " + (Object)((Object)mapLinkConnector) + " not in this port: " + this);
        }
    }

    public void setColor(Color color) {
        super.setColor(color);
    }

    public Color getColor() {
        Color color = super.getColor();
        return new Color(color.getRGB());
    }

    public void setSide(int n) {
        this.side = n;
    }

    public int getSide() {
        return this.side;
    }

    public double getSideOffset() {
        return this.sideOffset;
    }

    public void setSideOffset(double d) {
        double d2;
        double d3;
        this.sideOffset = d;
        if (this.isInternalPort()) {
            if (db.on()) {
                db.println("Internal ports cannot setSideOffset()");
            }
            return;
        }
        switch (this.side) {
            case 1: {
                d3 = d;
                d2 = -0.5;
                break;
            }
            case -1: {
                d3 = d;
                d2 = 0.5;
                break;
            }
            case -2: {
                d3 = -0.5;
                d2 = d;
                break;
            }
            case 2: {
                d3 = 0.5;
                d2 = d;
                break;
            }
            default: {
                d3 = 0.0;
                d2 = 0.0;
            }
        }
        MapLinkConnector[] mapLinkConnectorArray = this.getConnectors();
        for (int i = 0; i < mapLinkConnectorArray.length; ++i) {
            mapLinkConnectorArray[i].setCenter(d3, d2);
        }
    }

    public int getDesign() {
        return this.design;
    }

    public void setDesign(int n) {
        this.design = n;
        if (this.parentNode != null) {
            this.parentNode.reDraw();
        } else {
            this.reDraw();
        }
    }

    public void setLetter(char c) {
        this.letter = c;
        this.reDraw();
    }

    public char getLetter() {
        return this.letter;
    }

    public void setInfoString(String string) {
        this.infoString = string;
    }

    public String getInfoString() {
        return this.infoString;
    }

    public void setCreateOrder(int n) {
        this.createOrder = n;
    }

    public int getCreateOrder() {
        return this.createOrder;
    }

    public String toString() {
        MapPort[] mapPortArray = this.isInternalPort() ? null : this.parentNode.getTargetPorts(this);
        String string = null;
        for (int i = 0; mapPortArray != null && i < mapPortArray.length; ++i) {
            string = string == null ? "" : string + ", ";
            string = string + mapPortArray[i].getParentNode().getName();
        }
        String string2 = this.isInternalPort() ? "Internal" : "";
        StringBuffer stringBuffer = new StringBuffer();
        MapLinkConnector[] mapLinkConnectorArray = this.getConnectors();
        if (mapLinkConnectorArray.length > 0) {
            for (int i = 0; i < mapLinkConnectorArray.length; ++i) {
                stringBuffer.append(", Conn#" + (i + 1) + " = " + mapLinkConnectorArray[i].getCenterX() + ", " + mapLinkConnectorArray[i].getCenterY());
            }
        } else {
            stringBuffer.append(" N/A conn info");
        }
        return string2 + "Map Port: " + this.infoString + "from node " + this.getParentNode().getName() + " connected to node(s) " + string + " on side " + this.side + " with offset " + this.sideOffset + " and order " + this.createOrder + " at " + this.getLocX() + ", " + this.getLocY() + stringBuffer.toString();
    }

    public int compareTo(Object object) {
        double d;
        double d2;
        int n;
        int n2;
        DetailedMapNode detailedMapNode;
        MapPort mapPort = (MapPort)object;
        MapPort[] mapPortArray = this.parentNode.getTargetPorts(this);
        DetailedMapNode detailedMapNode2 = mapPortArray.length > 0 ? mapPortArray[0].getParentNode() : null;
        MapPort[] mapPortArray2 = mapPort.getParentNode().getTargetPorts(mapPort);
        DetailedMapNode detailedMapNode3 = detailedMapNode = mapPortArray2.length > 0 ? mapPortArray2[0].getParentNode() : null;
        if (detailedMapNode2 == detailedMapNode && (n2 = this.createOrder) != (n = mapPort.getCreateOrder())) {
            return n2 - n;
        }
        if (this.side == 1 || this.side == -1) {
            d2 = detailedMapNode2 != null ? detailedMapNode2.getCenterX() : 0.0;
            d = detailedMapNode != null ? detailedMapNode.getCenterX() : 0.0;
        } else {
            d2 = detailedMapNode2 != null ? detailedMapNode2.getCenterY() : 0.0;
            d = detailedMapNode != null ? detailedMapNode.getCenterY() : 0.0;
        }
        return (int)(d2 - d);
    }

    protected void updateLinkText(String string) {
        if (this.parentNode != null) {
            DetailedMapLink[] detailedMapLinkArray = this.parentNode.getLinks(this);
            String string2 = string;
            String string3 = string;
            for (int i = 0; i < detailedMapLinkArray.length; ++i) {
                DetailedMapLink detailedMapLink = detailedMapLinkArray[i];
                if (detailedMapLink.getSourcePort() == this) {
                    detailedMapLink.setSrcLabel(string2);
                    string2 = "";
                    continue;
                }
                if (detailedMapLink.getTargetPort() != this) continue;
                detailedMapLink.setTargetLabel(string3);
                string3 = "";
            }
        }
    }

    public void setLocation(double d, double d2) {
        if (this.parentNode != null) {
            this.setLocation(d, d2, this.parentNode.getGraph());
        } else {
            super.setLocation(d, d2);
        }
    }

    protected void drawMe(Graphics2D graphics2D, MapTransformer mapTransformer) {
        super.drawMe(graphics2D, mapTransformer);
        Rectangle2D rectangle2D = this.getBounds(mapTransformer);
        MapGraphicsUtil.drawLetter(graphics2D, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), this.letter, false);
        MapGraphicsUtil.drawDesign(graphics2D, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), this.side, this.design);
    }

    public void updatePositionInNode() {
        if (this.isInternalPort()) {
            this.updateInternalPositionInNode();
        } else {
            this.updateNormalPositionInNode();
        }
    }

    protected void updateInternalPositionInNode() {
        double d = this.parentNode.getWidth();
        double d2 = this.parentNode.getHeight();
        double d3 = this.getHeight();
        double d4 = this.getWidth();
        double d5 = d * 0.5;
        double d6 = d2 * 0.5;
        double d7 = -0.5 * d4;
        double d8 = -0.5 * d3;
        switch (this.side) {
            case 0: {
                break;
            }
            case 1: {
                d7 = -1.0 * d4;
                d8 = -0.5 * d3;
                break;
            }
            case 2: {
                d7 = 0.0;
                d8 = -0.5 * d3;
                break;
            }
            case 3: {
                d7 = -0.5 * d4;
                d8 = -1.0 * d3;
                break;
            }
            case 4: {
                d7 = -0.5 * d4;
                d8 = 0.0;
                break;
            }
            case 5: {
                d7 = -1.5 * d4;
                d8 = -0.5 * d3;
                break;
            }
            case 6: {
                d7 = 0.5 * d4;
                d8 = -0.5 * d3;
                break;
            }
            case 7: {
                d7 = -0.5 * d4;
                d8 = -1.5 * d3;
                break;
            }
            case 8: {
                d7 = -0.5 * d4;
                d8 = 0.5 * d3;
                break;
            }
        }
        this.parentNode.setLocation((IlvGraphic)this, (float)(d5 + d7), (float)(d6 + d8));
    }

    protected void updateNormalPositionInNode() {
        double d = this.parentNode.getWidth();
        double d2 = this.parentNode.getHeight();
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.side == 1) {
            f = (float)(this.sideOffset * d);
            f2 = 0.0f;
        } else if (this.side == -1) {
            f = (float)(this.sideOffset * d);
            f2 = (float)(d2 - this.getHeight());
        } else if (this.side == -2) {
            f = 0.0f;
            f2 = (float)(this.sideOffset * d2);
        } else if (this.side == 2) {
            f = (float)(d - this.getWidth());
            f2 = (float)(this.sideOffset * d2);
        }
        this.parentNode.setLocation((IlvGraphic)this, f, f2);
        Point2D.Float float_ = new Point2D.Float((float)this.getCenterX(), (float)this.getCenterY());
        MapLinkConnector[] mapLinkConnectorArray = this.getConnectors();
        for (int i = 0; i < mapLinkConnectorArray.length; ++i) {
            Point2D point2D = mapLinkConnectorArray[i].translateWorldToLocal(float_);
            mapLinkConnectorArray[i].setCenter(point2D);
        }
    }

    public Point2D getEndpoint() {
        return new Point2D.Double(this.getCenterX(), this.getCenterY());
    }

    public void clicked() {
        this.mtk.clicked(this);
    }

    public void doubleClicked() {
        this.mtk.doubleClicked(this);
    }

    public String getToolTipText() {
        return this.toString();
    }

    protected String getToolTipText(double d, double d2) {
        return this.toString();
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
    }

    public void onInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenu(uPopupMenu);
        this.mtk.initPopupMenu(this, this.actOrg, uPopupMenu);
        this.actOrg = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mtk != null) {
            this.mtk.actionPerformed(actionEvent);
        }
    }
}

