/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.IMapLineEndpoint;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapPolygon;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import ilog.views.IlvGraphic;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.HashSet;

public class MapSelector
extends MapPolygon
implements IMapLineEndpoint,
ActionListener {
    protected static double SELECTOR_WIDTH = 10.0;
    protected static double SELECTOR_HEIGHT = 10.0;
    protected ActionOrganizer actOrg = null;
    public static final int CENTER = 0;
    public static final int LEFT_TO_CENTER = 1;
    public static final int RIGHT_TO_CENTER = 2;
    public static final int TOP_TO_CENTER = 3;
    public static final int BOTTOM_TO_CENTER = 4;
    public static final int LEFT_FROM_CENTER = 5;
    public static final int RIGHT_FROM_CENTER = 6;
    public static final int TOP_FROM_CENTER = 7;
    public static final int BOTTOM_FROM_CENTER = 8;
    public static final int LEFT_TO_CENTER_PLUS_HALF = 9;
    public static final int RIGHT_TO_CENTER_PLUS_HALF = 10;
    public static final int TOP_TO_CENTER_PLUS_HALF = 11;
    public static final int BOTTOM_TO_CENTER_PLUS_HALF = 12;
    public static final int LEFT_TO_CENTER_PLUS_ONE = 13;
    public static final int RIGHT_TO_CENTER_PLUS_ONE = 14;
    public static final int TOP_TO_CENTER_PLUS_ONE = 15;
    public static final int BOTTOM_TO_CENTER_PLUS_ONE = 16;
    protected DetailedMapNode parentNode = null;
    protected Collection ports;
    private char letter = (char)32;
    int side = 0;
    protected MapToolkit mtk;
    private Object userObject = null;
    private Object userCookie = null;

    public MapSelector(DetailedMapNode detailedMapNode) {
        this.mtk = detailedMapNode.getMTK();
        this.parentNode = detailedMapNode;
        this.ports = new HashSet();
        this.graphicallyInitSelector();
    }

    protected void graphicallyInitSelector() {
        this.resize((float)SELECTOR_WIDTH, (float)SELECTOR_HEIGHT);
    }

    public void init(Object object, Object object2) {
        this.setUserObject(object);
        this.setUserCookie(object2);
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserCookie(Object object) {
        this.userCookie = object;
    }

    public Object getUserCookie() {
        return this.userCookie;
    }

    protected DetailedMapNode getParentNode() {
        return this.parentNode;
    }

    public void setColor(Color color) {
        super.setColor(color);
    }

    public Color getColor() {
        Color color = super.getColor();
        return new Color(color.getRGB());
    }

    public int getSide() {
        return this.side;
    }

    public void setSide(int n) {
        this.side = n;
    }

    public Collection getPorts() {
        return this.ports;
    }

    public void addPort(MapPort mapPort) {
        if (mapPort != null) {
            this.ports.add(mapPort);
        }
    }

    public void setLetter(char c) {
        this.letter = c;
        this.reDraw();
    }

    public char getLetter() {
        return this.letter;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MapSelector: ");
        stringBuffer.append("parentNode = " + this.parentNode + ", side= " + this.side + ", connected to " + this.getPorts().size() + " ports.");
        return stringBuffer.toString();
    }

    public void updatePositionInNode() {
        double d;
        int n = this.getPointCount();
        double d2 = this.parentNode.getWidth();
        double d3 = this.parentNode.getHeight();
        double d4 = d = Math.min(SELECTOR_WIDTH, SELECTOR_HEIGHT);
        if (this.side == 1 || this.side == 5 || this.side == 9 || this.side == 13 || this.side == 2 || this.side == 6 || this.side == 10 || this.side == 14) {
            this.resize((float)(SELECTOR_WIDTH * 1.5), (float)SELECTOR_HEIGHT);
        } else {
            this.resize((float)SELECTOR_WIDTH, (float)(SELECTOR_HEIGHT * 1.5));
        }
        switch (this.side) {
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                this.addPoint(0.0, 0.0);
                this.addPoint(d, 0.0);
                this.addPoint(d * 1.5, d4 * 0.5);
                this.addPoint(d, d4);
                this.addPoint(0.0, d4);
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                this.addPoint(0.0, 0.5 * d4);
                this.addPoint(0.5 * d, 0.0);
                this.addPoint(1.5 * d, 0.0);
                this.addPoint(1.5 * d, d4);
                this.addPoint(0.5 * d, d4);
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                this.addPoint(0.0, 0.0);
                this.addPoint(d, 0.0);
                this.addPoint(d, d4);
                this.addPoint(d * 0.5, d4 * 1.5);
                this.addPoint(0.0, d4);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                this.addPoint(d * 0.5, 0.0);
                this.addPoint(d, d4 * 0.5);
                this.addPoint(d, 1.5 * d4);
                this.addPoint(0.0, d4 * 1.5);
                this.addPoint(0.0, d4 * 0.5);
                break;
            }
        }
        if (this.getPointCount() - n >= 2) {
            this.removePoints(n);
        }
        double d5 = d2 * 0.5;
        double d6 = d3 * 0.5;
        double d7 = 0.0;
        double d8 = 0.0;
        switch (this.side) {
            case 5: {
                d7 = -0.5 * d;
                d8 = -0.5 * d4;
                break;
            }
            case 6: {
                d7 = -1.0 * d;
                d8 = -0.5 * d4;
                break;
            }
            case 7: {
                d7 = -0.5 * d;
                d8 = -0.5 * d4;
                break;
            }
            case 8: {
                d7 = -0.5 * d;
                d8 = -1.0 * d4;
                break;
            }
            case 1: {
                d7 = -1.5 * d;
                d8 = -0.5 * d4;
                break;
            }
            case 2: {
                d7 = 0.0;
                d8 = -0.5 * d4;
                break;
            }
            case 3: {
                d7 = -0.5 * d;
                d8 = -1.5 * d4;
                break;
            }
            case 4: {
                d7 = -0.5 * d;
                d8 = 0.0;
                break;
            }
            case 9: {
                d7 = -2.0 * d;
                d8 = -0.5 * d4;
                break;
            }
            case 10: {
                d7 = 0.5 * d;
                d8 = -0.5 * d4;
                break;
            }
            case 11: {
                d7 = -0.5 * d;
                d8 = -2.0 * d4;
                break;
            }
            case 12: {
                d7 = -0.5 * d;
                d8 = 0.5 * d4;
                break;
            }
            case 13: {
                d7 = -2.5 * d;
                d8 = -0.5 * d4;
                break;
            }
            case 14: {
                d7 = d;
                d8 = -0.5 * d4;
                break;
            }
            case 15: {
                d7 = -0.5 * d;
                d8 = -2.5 * d4;
                break;
            }
            case 16: {
                d7 = -0.5 * d;
                d8 = d4;
            }
        }
        this.parentNode.setLocation((IlvGraphic)this, (float)(d5 + d7), (float)(d6 + d8));
    }

    public Point2D getEndpoint() {
        Rectangle2D.Float float_ = this.getBounds();
        double d = ((RectangularShape)float_).getX() + 0.5 * ((RectangularShape)float_).getWidth();
        double d2 = ((RectangularShape)float_).getY() + 0.5 * ((RectangularShape)float_).getHeight();
        return new Point2D.Double(d, d2);
    }

    public void clicked() {
    }

    public void doubleClicked() {
    }

    public String getToolTipText() {
        return this.toString();
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
    }

    public void onInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenu(uPopupMenu);
        this.mtk.initPopupMenu(this, this.actOrg, uPopupMenu);
        this.actOrg = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mtk != null) {
            this.mtk.actionPerformed(actionEvent);
        }
    }

    public void setLocation(double d, double d2) {
        if (this.parentNode != null) {
            this.setLocation(d, d2, this.parentNode.getGraph());
        } else {
            super.setLocation(d, d2);
        }
    }

    protected void drawMe(Graphics2D graphics2D, MapTransformer mapTransformer) {
        super.drawMe(graphics2D, mapTransformer);
        Rectangle2D.Float float_ = this.getBounds(mapTransformer);
        double d = 0.3333333333333333;
        double d2 = 0.6666666666666666;
        double d3 = float_.getX();
        double d4 = float_.getY();
        double d5 = float_.getWidth();
        double d6 = float_.getHeight();
        switch (this.side) {
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                d5 *= d2;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                d3 += d * d5;
                d5 *= d2;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                d6 *= d2;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                d4 += d * d6;
                d6 *= d2;
                break;
            }
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        MapGraphicsUtil.drawLetter(graphics2D, (int)double_.getX(), (int)double_.getY(), (int)double_.getWidth(), (int)double_.getHeight(), this.letter, false);
    }
}

