/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit;

import cerent.cms.model.INodeModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.Wavelength;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.TDMTerminology;
import cerent.util.view.fv.helper.FunctDebug;
import com.cisco.fv.circuit.FVSelectedCircuitPane;
import com.cisco.fv.circuit.model.FvCircuitModels;
import com.cisco.fv.circuit.model.FvSelectedCircuitModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;

public class FVSelCircuitInfoPane
extends JPanel
implements IObserver {
    private JPanel jNamePanel = null;
    private JPanel jServicePanel = null;
    private JPanel jPhisicalPanel = null;
    private JLabel sourceLabel = null;
    private JLabel destinationLabel = null;
    private JLabel protectionLabel = null;
    private JLabel stateLabel = null;
    private JLabel statusLabel = null;
    private JLabel dirLabel = null;
    private JLabel waveLengthLabel = null;
    private JLabel spanLabel = null;
    private JLabel typeLabel = null;
    private FvSelectedCircuitModel ckt;
    private FVSelectedCircuitPane parentSelectedPane;
    private final Dimension boxDimesion = new Dimension(328, 84);

    public FVSelCircuitInfoPane(FVSelectedCircuitPane fVSelectedCircuitPane) {
        this.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Circuit information", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getGeneralInfoPanel(), null);
        this.add((Component)this.getServicePanel(), null);
        this.add((Component)this.getPhisicalPanel(), null);
        this.parentSelectedPane = fVSelectedCircuitPane;
        FvCircuitModels.getInstance().addObserver(this);
    }

    private JPanel getGeneralInfoPanel() {
        if (this.jNamePanel == null) {
            this.jNamePanel = new JPanel();
            this.jNamePanel.setLayout(new GridBagLayout());
            this.jNamePanel.setBorder(BorderFactory.createTitledBorder(null, "General info", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jNamePanel.setPreferredSize(this.boxDimesion);
            this.typeLabel = new JLabel();
            this.typeLabel.setText("type");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            this.jNamePanel.add((Component)this.typeLabel, gridBagConstraints);
            this.sourceLabel = new JLabel();
            this.sourceLabel.setText("Source");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = 13;
            this.jNamePanel.add((Component)this.sourceLabel, gridBagConstraints2);
            this.destinationLabel = new JLabel();
            this.destinationLabel.setText("Dest");
            this.destinationLabel.setMaximumSize(new Dimension(40, this.destinationLabel.getMaximumSize().height));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.anchor = 13;
            this.jNamePanel.add((Component)this.destinationLabel, gridBagConstraints3);
            JLabel jLabel = new JLabel();
            jLabel.setText("Type :");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 17;
            this.jNamePanel.add((Component)jLabel, gridBagConstraints4);
            jLabel = new JLabel();
            jLabel.setText("Source :");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.anchor = 17;
            this.jNamePanel.add((Component)jLabel, gridBagConstraints5);
            jLabel = new JLabel();
            jLabel.setText("Destination :");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.anchor = 17;
            this.jNamePanel.add((Component)jLabel, gridBagConstraints6);
        }
        return this.jNamePanel;
    }

    private JPanel getServicePanel() {
        if (this.jServicePanel == null) {
            this.jServicePanel = new JPanel();
            this.jServicePanel.setLayout(new GridBagLayout());
            this.jServicePanel.setBorder(BorderFactory.createTitledBorder(null, "Status", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jServicePanel.setPreferredSize(this.boxDimesion);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = 17;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.anchor = 17;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 13;
            this.protectionLabel = new JLabel();
            this.protectionLabel.setText("prot");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.anchor = 13;
            this.stateLabel = new JLabel();
            this.stateLabel.setText("state");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.anchor = 13;
            this.statusLabel = new JLabel();
            this.statusLabel.setText("status");
            JLabel jLabel = new JLabel();
            jLabel.setText("Protection :");
            this.jServicePanel.add((Component)jLabel, gridBagConstraints);
            jLabel = new JLabel();
            jLabel.setText("State :");
            this.jServicePanel.add((Component)jLabel, gridBagConstraints2);
            jLabel = new JLabel();
            jLabel.setText("Status :");
            this.jServicePanel.add((Component)jLabel, gridBagConstraints3);
            this.jServicePanel.add((Component)this.protectionLabel, gridBagConstraints4);
            this.jServicePanel.add((Component)this.stateLabel, gridBagConstraints5);
            this.jServicePanel.add((Component)this.statusLabel, gridBagConstraints6);
        }
        return this.jServicePanel;
    }

    private JPanel getPhisicalPanel() {
        if (this.jPhisicalPanel == null) {
            this.jPhisicalPanel = new JPanel();
            this.jPhisicalPanel.setLayout(new GridBagLayout());
            this.jPhisicalPanel.setBorder(BorderFactory.createTitledBorder(null, "Physical", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jPhisicalPanel.setPreferredSize(this.boxDimesion);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = 13;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.anchor = 13;
            this.spanLabel = new JLabel();
            this.spanLabel.setText("span");
            this.waveLengthLabel = new JLabel();
            this.waveLengthLabel.setText("wave");
            this.dirLabel = new JLabel();
            this.dirLabel.setText("dir");
            JLabel jLabel = new JLabel();
            jLabel.setText("Wavelength :");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 17;
            this.jPhisicalPanel.add((Component)jLabel, gridBagConstraints4);
            jLabel = new JLabel();
            jLabel.setText("Direction :");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            this.jPhisicalPanel.add((Component)jLabel, gridBagConstraints5);
            jLabel = new JLabel();
            jLabel.setText("Span :");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            this.jPhisicalPanel.add((Component)jLabel, gridBagConstraints6);
            this.jPhisicalPanel.add((Component)this.dirLabel, gridBagConstraints2);
            this.jPhisicalPanel.add((Component)this.waveLengthLabel, gridBagConstraints);
            this.jPhisicalPanel.add((Component)this.spanLabel, gridBagConstraints3);
        }
        return this.jPhisicalPanel;
    }

    public void update(IObservable iObservable, Object object) {
        INetCircuit iNetCircuit;
        INetCircuit iNetCircuit2 = null;
        if (iObservable instanceof FvCircuitModels) {
            iNetCircuit2 = this.handleChanges((FvCircuitModels.NotifyCircuitModel)object);
        }
        if (iObservable instanceof INetCircuit) {
            iNetCircuit = (INetCircuit)iObservable;
            if (this.ckt.getCircuitId() != iNetCircuit.getCircuitId()) {
                return;
            }
            iNetCircuit2 = (INetCircuit)this.ckt.getCircuitModel(true);
        }
        if (iNetCircuit2 == null) {
            return;
        }
        if (this.ckt != null) {
            if (this.ckt.getSrcNode() == null || this.ckt.getSrcNode() == null) {
                return;
            }
            this.sourceLabel.setText(this.ckt.getSrcNode().getName());
            this.destinationLabel.setText(this.ckt.getDstNode().getName());
            iNetCircuit = this.getTerminology(iNetCircuit2);
            this.waveLengthLabel.setText(Wavelength.getWavelengthStringFromWavelength(this.ckt.getLambda()));
            if (iNetCircuit != null) {
                this.protectionLabel.setText(NetworkDefaults.circuitProtTypeToString(iNetCircuit2.getProtType(), (TDMTerminology)iNetCircuit));
            } else {
                this.protectionLabel.setText("");
            }
            this.dirLabel.setText(NetworkDefaults.circuitDirectionToString(iNetCircuit2.getCircuitDir()));
            this.statusLabel.setText(NetworkDefaults.circuitStateToString(iNetCircuit2.getState()));
            int n = iNetCircuit2.getCircuitSpanNum();
            if (n == -1) {
                this.spanLabel.setText("N/A");
            } else {
                if ((iNetCircuit2.getCircuitTypeObj().isOchncType() || iNetCircuit2.getCircuitTypeObj().isOchTrailTunnelCircuitType()) && iNetCircuit2.isBidirectional()) {
                    n = n % 2 != 0 ? n / 2 + 1 : (n /= 2);
                }
                this.spanLabel.setText(Integer.toString(n));
            }
            this.stateLabel.setText(NetworkDefaults.circuitServiceStateToString(this.getServiceState(iNetCircuit2)));
            if (iNetCircuit != null) {
                if ((iNetCircuit2.getCircuitTypeObj().isOchncType() || iNetCircuit2.getCircuitTypeObj().isOchTrailTunnelCircuitType()) && ((OchncCircuit)iNetCircuit2).isDCNCircuit()) {
                    String string = iNetCircuit.getCircuitTypeShortString(iNetCircuit2.getCircuitTypeObj());
                    this.typeLabel.setText(string + " DCN");
                } else {
                    this.typeLabel.setText(iNetCircuit.getCircuitTypeShortString(iNetCircuit2.getCircuitTypeObj()));
                }
            } else {
                this.typeLabel.setText("");
            }
        }
    }

    private INetCircuit handleChanges(FvCircuitModels.NotifyCircuitModel notifyCircuitModel) {
        INetCircuit iNetCircuit = null;
        switch (notifyCircuitModel.changes) {
            case 0: {
                if (this.ckt != null) {
                    ((INetCircuit)this.ckt.getCircuitModel(true)).deleteObserver(this);
                }
                this.ckt = (FvSelectedCircuitModel)FvCircuitModels.getInstance().getCircuit(notifyCircuitModel.id);
                iNetCircuit = (INetCircuit)this.ckt.getCircuitModel(true);
                iNetCircuit.addObserver(this);
                this.parentSelectedPane.getParent().setSelectedCircuitTabVisible(true, iNetCircuit.getCircuitName());
                break;
            }
            case 1: {
                if (this.ckt == null || this.ckt.getCircuitId() != notifyCircuitModel.id) break;
                ((INetCircuit)this.ckt.getCircuitModel(true)).deleteObserver(this);
                this.parentSelectedPane.getParent().setSelectedCircuitTabVisible(false, null);
                break;
            }
        }
        return iNetCircuit;
    }

    private int getServiceState(INetCircuit iNetCircuit) {
        int n = -1;
        try {
            n = iNetCircuit.getServiceState();
        }
        catch (Exception exception) {
            FunctDebug.printStackTrace((Throwable)exception);
        }
        return n;
    }

    private TDMTerminology getTerminology(INetCircuit iNetCircuit) {
        TDMTerminology tDMTerminology = null;
        INodeModel iNodeModel = null;
        if (iNetCircuit.getPrimarySource() != null) {
            iNodeModel = iNetCircuit.getPrimarySource().getNodeModel();
        } else {
            List list = iNetCircuit.getCircuitNodes();
            if (list.size() != 0) {
                iNodeModel = ((INetCircuitNode)list.get(0)).getNodeModel();
            }
        }
        if (iNodeModel != null) {
            tDMTerminology = iNodeModel.getTDMTerminology();
        }
        return tDMTerminology;
    }

    public void destroy() {
        if (this.ckt != null && (INetCircuit)this.ckt.getCircuitModel(true) != null) {
            ((INetCircuit)this.ckt.getCircuitModel(true)).deleteObserver(this);
        }
    }
}

