/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit;

import cerent.cms.fv.net.IFvNetNode;
import cerent.util.SDebug;
import com.cisco.fv.FunctObserverArgument;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.grapher.FunctNetMapNode;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;

public class FvPatchCordVerify
implements Observer {
    private SDebug db = new SDebug("FVPatchCordVerify");
    private LinkedList<FunctNetMapNode> openNodes = FunctViewManagerDelegate.getInstance().getAllOpenNodes();
    private boolean selected;
    private Boolean threadRunning = false;

    public FvPatchCordVerify() {
        FunctViewManagerDelegate.getInstance().addObserver(this);
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.print("Update of Circuit Received : ");
        }
        if (object instanceof FunctObserverArgument) {
            int n = ((FunctObserverArgument)object).getType();
            if (this.db.on()) {
                this.db.print("The Power table need to be open = " + (n == 0));
            }
            switch (n) {
                case 0: 
                case 1: {
                    this.verifyNodesPatchCord(n == 0, ((FunctObserverArgument)object).getNode());
                    break;
                }
                case 3: {
                    IFvNetNode iFvNetNode = ((FunctObserverArgument)object).getNode();
                    this.verifyNodesPatchCord(iFvNetNode.isFVActive(), iFvNetNode);
                }
            }
        }
    }

    private void verifyNodesPatchCord(boolean bl, IFvNetNode iFvNetNode) {
        for (FunctNetMapNode functNetMapNode : FunctViewManagerDelegate.getInstance().getAllOpenNodes()) {
            if (!functNetMapNode.getUserObject().equals(iFvNetNode)) continue;
            if (!this.openNodes.contains(functNetMapNode)) {
                this.openNodes.add(functNetMapNode);
            }
            if (!bl && this.selected) {
                this.selected = false;
            }
            new Thread((Runnable)new VerifyNodePatchCord(functNetMapNode, this.selected), "FvPatchCordVerify").start();
            if (bl) break;
            this.openNodes.remove(functNetMapNode);
            break;
        }
    }

    public void verifyPatchCord(boolean bl) {
        this.selected = bl;
        for (int i = 0; i < this.openNodes.size(); ++i) {
            FunctNetMapNode functNetMapNode = this.openNodes.get(i);
            if (functNetMapNode.getNodeFv() == null) continue;
            new Thread((Runnable)new VerifyNodePatchCord(functNetMapNode, bl), "FvPatchCordVerify").start();
        }
    }

    class VerifyNodePatchCord
    implements Runnable {
        private FunctNetMapNode node;
        private Object threadRunning = true;
        private boolean selected;

        public VerifyNodePatchCord(FunctNetMapNode functNetMapNode, boolean bl) {
            this.node = functNetMapNode;
            this.selected = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.threadRunning;
            synchronized (object) {
                this.threadRunning = true;
                this.node.getNodeFv().showVerifiedPatchcords(this.selected);
                this.threadRunning = false;
            }
        }
    }
}

