/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.gui;

import cerent.cms.ui.functional.FVActionListener;
import cerent.cms.ui.functional.FunctMenuBar;
import cerent.util.EID;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.view.fv.ViewMagnifier;
import cerent.util.view.fv.ViewPrintingHelper;
import com.cisco.ctc.ui.AboutDialog;
import com.cisco.fv.FunctExportTables;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.gui.FunctionalNetworkDialog;
import ilog.views.IlvManagerViewInteractor;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;

public class NfvMenuToolListener
extends FVActionListener {
    private FunctMenuBar menuBar;
    private FvNetworkMap view;
    private boolean magnPush = false;
    private boolean powerMenuClicked;
    private boolean spanLossMenuClicked;
    private FunctExportTables export;

    public NfvMenuToolListener(Frame frame) {
        this.container = frame;
        this.powerMenuClicked = false;
        this.spanLossMenuClicked = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "Fit to View") {
            this.view.fitView();
        } else if (actionEvent.getActionCommand() == "Magnifier") {
            this.doMagn();
        } else if (actionEvent.getActionCommand() == "Show Power") {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            boolean bl = abstractButton instanceof JMenuItem ? !this.powerMenuClicked : abstractButton.isSelected();
            this.powerMenuClicked = bl;
            FunctViewManagerDelegate.getInstance().powerButtonAction(bl, 1);
        } else if (actionEvent.getActionCommand() == "Show SpanLoss") {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            boolean bl = abstractButton instanceof JMenuItem ? !this.spanLossMenuClicked : abstractButton.isSelected();
            this.spanLossMenuClicked = bl;
            FunctViewManagerDelegate.getInstance().powerButtonAction(bl, 0);
        } else if (actionEvent.getActionCommand() == "About") {
            AboutDialog.instance((JFrame)this.container, "About CTC").show();
        } else if (actionEvent.getActionCommand() == "User Manuals") {
            String string = KErrorMsg.getString((EID)KEMC.EID_HELP_MANUAL_ERROR);
            JOptionPane.showMessageDialog(null, string, "Error", 0);
        } else if (actionEvent.getActionCommand() == "Verify Patchcords") {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            FunctViewManagerDelegate.getInstance().patchCordVerify(jToggleButton.isSelected());
        } else if (actionEvent.getActionCommand() == "Refresh Power Info") {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            FunctViewManagerDelegate.getInstance().refreshButtonAction();
            abstractButton.setSelected(false);
        } else if (actionEvent.getActionCommand() == "Export...") {
            this.export.setTable(((FunctionalNetworkDialog)this.container).getExportableTables());
            this.export.setTitle(((FunctionalNetworkDialog)this.container).getExportableTitle());
            this.export.export();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void doMagn() {
        if (!this.magnPush) {
            ViewMagnifier viewMagnifier = new ViewMagnifier();
            viewMagnifier.setMode((short)1);
            viewMagnifier.setPermanent(true);
            viewMagnifier.setFactor(3.0f);
            this.view.pushInteractor((IlvManagerViewInteractor)viewMagnifier);
            this.view.setZoomFactorRange(0.1, 10.0);
            this.magnPush = true;
        } else {
            this.view.popInteractor();
            this.magnPush = false;
        }
    }

    public void addMenu(FunctMenuBar functMenuBar) {
        this.menuBar = functMenuBar;
    }

    public FunctMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void addExecutor(FvNetworkMap fvNetworkMap, Component component) {
        this.view = fvNetworkMap;
        this.print = new ViewPrintingHelper(component);
        this.export = new FunctExportTables(((FunctionalNetworkDialog)this.container).getViewController(), this.print);
    }
}

