/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.power;

import cerent.cms.fv.IFVPowerModel;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.OchncFilterManager;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.DwdmSide;
import cerent.util.IFvDebug;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.view.fv.IPowerBallon;
import cerent.util.view.fv.helper.FunctDebug;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.circuit.model.FvCircuitModels;
import com.cisco.fv.grapher.FunctNetMapLink;
import com.cisco.fv.grapher.FvNetworkMap;
import java.util.ArrayList;
import java.util.List;

public class SpanLossBalloon {
    private static SpanLossBalloon instance;
    private Thread pwrThread;
    private ArrayList<IPowerBallon> sender = new ArrayList();
    private boolean isForCircuit;
    protected IFvDebug db = FunctDebug.instance().addChild("SpanLossBalloon", "Debug the SpanLossBalloon Thread");

    protected SpanLossBalloon() {
    }

    public static SpanLossBalloon getInstance() {
        if (instance == null) {
            instance = new SpanLossBalloon();
        }
        return instance;
    }

    private void calculatePower(IFVPowerModel iFVPowerModel) {
        FunctNetMapLink functNetMapLink;
        MapLink mapLink;
        boolean bl = true;
        if (iFVPowerModel == null) {
            return;
        }
        if (this.db.on()) {
            this.db.println("calculate for PowerModel " + iFVPowerModel.toString());
        }
        List list = iFVPowerModel.getCircuitLink();
        for (IFvNetLink iFvNetLink : list) {
            mapLink = FvNetworkMap.getInstance().getMapLink(iFvNetLink);
            if (!(mapLink instanceof FunctNetMapLink)) continue;
            functNetMapLink = (FunctNetMapLink)mapLink;
            functNetMapLink.resetBaloonPower();
        }
        for (IFvNetLink iFvNetLink : list) {
            IEntityModel iEntityModel;
            Object object;
            Object object2;
            String[] stringArray;
            VirtualNetLink virtualNetLink;
            mapLink = FvNetworkMap.getInstance().getMapLink(iFvNetLink);
            bl = true;
            if (!(mapLink instanceof FunctNetMapLink)) continue;
            functNetMapLink = (FunctNetMapLink)mapLink;
            if (iFvNetLink instanceof VirtualNetLink) {
                try {
                    virtualNetLink = (VirtualNetLink)iFvNetLink;
                    stringArray = virtualNetLink.getSrc().getNodeModel();
                    object2 = virtualNetLink.getDst().getNodeModel();
                    object = stringArray.getEntityTable().getEntityModelByIndex(virtualNetLink.getSrcEntityIndex());
                    iEntityModel = object2.getEntityTable().getEntityModelByIndex(virtualNetLink.getDstEntityIndex());
                    if (VirtualLinksDirector.shouldSwap((IEntityModel)object, iEntityModel)) {
                        iFvNetLink = OchncFilterManager.findLinkForReversePath((INetLink)iFvNetLink, new SDebug("calculatePower"));
                        bl = false;
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            } else {
                bl = true;
            }
            if ((stringArray = iFVPowerModel.getSpanLoss((IFvNetNode)(virtualNetLink = iFvNetLink.getSource().getNetworkNode()), iFvNetLink)) == null) continue;
            object2 = stringArray[2];
            if (iFvNetLink instanceof INetLink) {
                try {
                    object = (INetLink)iFvNetLink;
                    iEntityModel = object.getSrc().getNodeModel();
                    IEntityModel iEntityModel2 = iEntityModel.getEntityTable().getEntityModelByIndex(object.getSrcEntityIndex());
                    int n = iEntityModel2.getSide();
                    if (n != 0) {
                        object2 = DwdmSide.getSideFromOffset(n) + ": " + (String)object2;
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            if (stringArray == null) continue;
            functNetMapLink.setBalloonPower((String)object2, bl);
        }
    }

    public void startCalculation(IPowerBallon iPowerBallon) {
        if (this.sender.size() == 0) {
            if (this.db.on()) {
                this.db.println("Start with sender = " + iPowerBallon.toString());
            }
            this.sender.add(iPowerBallon);
            this.pwrThread = new Thread((Runnable)new SpanLossBallonThread(), "Power Balloon Calculation");
            this.pwrThread.start();
        } else if (this.db.on()) {
            this.db.println("Added sender = " + iPowerBallon.toString());
        }
    }

    public void setForCircuit(boolean bl) {
        this.isForCircuit = bl;
    }

    public boolean isForCircuit() {
        return this.isForCircuit;
    }

    public void dispose() {
        instance = null;
        this.isForCircuit = false;
        this.sender.clear();
    }

    private class SpanLossBallonThread
    implements Runnable {
        private SpanLossBallonThread() {
        }

        public void run() {
            block5: {
                FunctViewManagerDelegate.getInstance().circuitTableAndToolsButtonEnable(false);
                try {
                    IFVPowerModel iFVPowerModel = FvCircuitModels.getInstance().getAggregatedPower();
                    SpanLossBalloon.this.calculatePower(iFVPowerModel);
                    for (int i = 0; i < SpanLossBalloon.this.sender.size(); ++i) {
                        if (SpanLossBalloon.this.db.on()) {
                            SpanLossBalloon.this.db.println("inform sender = " + SpanLossBalloon.this.sender.toString());
                        }
                        ((IPowerBallon)SpanLossBalloon.this.sender.get(i)).spanLossIsReady();
                    }
                    SpanLossBalloon.this.sender.clear();
                    if (SpanLossBalloon.this.db.on()) {
                        SpanLossBalloon.this.db.println("clear all the senders");
                    }
                }
                catch (RuntimeException runtimeException) {
                    SpanLossBalloon.this.sender.clear();
                    if (!SpanLossBalloon.this.db.on()) break block5;
                    SpanLossBalloon.this.db.println("---- RuntimeException ----  clear all the senders");
                }
            }
            FunctViewManagerDelegate.getInstance().circuitTableAndToolsButtonEnable(true);
        }
    }
}

