/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.idl.Optics.PM_OPTICS_UNDEFINED;
import cerent.cms.idl.OpticsTopology.eParamType;
import cerent.cms.idl.OpticsTopology.eSpectrumGranularity;
import cerent.cms.idl.OpticsTopology.sParameterInfo;
import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.model.ANS.ANSElement;
import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.ANS.ANSSideInfo;
import cerent.cms.model.ANS.NeANSModel;
import cerent.cms.model.ANS.NodeANS;
import cerent.cms.model.AnsParamModel;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.nodesetup.AnpManager;
import cerent.cms.ui.nodesetup.AnsManager;
import cerent.cms.ui.nodesetup.NodeSetupParser;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.ParamsManager;
import cerent.cms.ui.nodesetup.PassiveUnitsManager;
import cerent.cms.ui.nodesetup.PatchcordsManager;
import cerent.cms.ui.nodesetup.PpmManager;
import cerent.cms.ui.nodesetup.SidesManager;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.cms.ui.nodesetup.WzTasksController;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANSManager
extends Model
implements PM_OPTICS_UNDEFINED {
    private static final String MY_DEBUG_KEY = "ANSManager";
    private boolean inited = false;
    public static final String[] ansParamOrigin = new String[]{"DEFAULT", "AUTOMATIC", "PROVISIONED", "IMPORTED"};
    public static final String[] ansParamInfo = new String[]{"", "Error during NE boards navigation: value not calculated", "Cannot send parameters request to far end node:  value not calculated", "No response from far end node:  value not calculated", "Configuration not supported: value not calculated", "Far end node configuration not supported: value not calculated", "OSC far end launch power not available: value not calculated", "Far end launch power not available: value not calculated", "Span loss value not available: value not calculated", "Fiber stage insertion loss not available: value not calculated", "Pre amplifier tilt not available: value not calculated", "Add & Drop out power not available: value not calculated", "NE node lanch power not available: value not calculated", "WXC degree not available: value not calculated", "Value out of range", "Readonly attribute: value not calculated"};
    private NodeModelDelegate node;
    private NeANSModel neANSModel;
    private ANSNode rootNode = null;
    private static NodeSingletonFactory<ANSManager> sfactory = new NodeSingletonFactory<ANSManager>(ANSManager.class);

    private ANSManager(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.node = nodeModelDelegate;
        this.index = 0;
        this.db = new ANSManagerDebug(nodeModelDelegate.getDebug());
    }

    public static ANSManager getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    public NeANSModel getNeANSModel() {
        return this.neANSModel;
    }

    private void makeElementPath(ANSNode aNSNode, String[] stringArray, int n, ANSElement aNSElement) {
        if (n == stringArray.length) {
            if (this.db.on()) {
                this.db.println("makeElementPath:end of line...added child " + aNSElement.getName());
            }
            aNSNode.addChild(aNSElement);
            aNSElement.setParent(aNSNode);
            return;
        }
        ANSNode aNSNode2 = aNSNode.getChildOfKey(stringArray[n]);
        if (aNSNode2 == null) {
            aNSNode2 = new ANSNode(stringArray[n]);
            if (this.db.on()) {
                this.db.println("makeElementPath:created new child " + stringArray[n]);
            }
            aNSNode.addChild(aNSNode2);
            aNSNode2.setInfo(aNSElement.getInfo());
            aNSNode2.setOrigin(aNSElement.getOrigin());
        }
        this.makeElementPath(aNSNode2, stringArray, n + 1, aNSElement);
    }

    private void makeTreeWithInfo(ANSNode aNSNode, ANSElement aNSElement) {
        this.makeElementPath(aNSNode, aNSElement.getFullPath(), 0, aNSElement);
    }

    public ANSNode getDefaultsTree() throws Exception {
        return this.getDefaultsAnsTree();
    }

    public ANSNode getDefaultsAnsTree() throws Exception {
        ANSNode aNSNode = new ANSNode(this.node.getName() + " (" + this.node.getNodeTypeStr() + ")");
        List<ANSElement> list = this.getSortedAnsElem();
        for (ANSElement aNSElement : list) {
            this.makeTreeWithInfo(aNSNode, aNSElement);
        }
        return aNSNode;
    }

    public ANSSideInfo[] getDefaultsAnsSideList() throws Exception {
        return new ANSSideInfo[0];
    }

    private List<ANSElement> getSortedAnsElem() {
        ArrayList<ANSElement> arrayList = new ArrayList<ANSElement>();
        List<AnsParamModel> list = Arrays.asList(this.neANSModel.getAnsParamList());
        for (AnsParamModel ansParamModel : list) {
            ANSElement aNSElement = this.makeElementWithInfo(ansParamModel.getParamInfo());
            if (aNSElement == null) continue;
            arrayList.add(aNSElement);
        }
        Collections.sort(arrayList, new KeyComparator());
        return arrayList;
    }

    public ANSElement makeElementWithInfo(String string, int n, int n2, String string2) throws ProvisionError {
        NodeANS.ANSParamDetails aNSParamDetails = NodeANS.getANSParamDetails(string);
        ANSElement aNSElement = null;
        if (aNSParamDetails != null) {
            sParameterKey sParameterKey2 = new sParameterKey();
            sParameterKey2.paramLocation = n;
            sParameterKey2.type = aNSParamDetails.getParamType();
            if (n2 != 174) {
                sParameterKey2.spectrum = eSpectrumGranularity.SP_OCH;
                sParameterKey2.spectrumIndex = n2;
            } else {
                sParameterKey2.spectrum = aNSParamDetails.getDefaultGranularity(this.node, n);
                sParameterKey2.spectrumIndex = aNSParamDetails.getDefaultSpectrumIndex(this.node, n);
            }
            aNSElement = new ANSElement(aNSParamDetails.getCTCFullPath(this.node, sParameterKey2), sParameterKey2, aNSParamDetails.getANSValue(string2));
        }
        return aNSElement;
    }

    public String makeFullPath(sParameterKey sParameterKey2) {
        return ANSElement.makeFullName(NodeANS.getANSParamDetails(sParameterKey2).getCTCFullPath(this.node, sParameterKey2));
    }

    private ANSElement makeElementWithInfo(sParameterInfo sParameterInfo2) {
        NodeANS.ANSParamDetails aNSParamDetails = NodeANS.getANSParamDetails(sParameterInfo2.key);
        ANSElement aNSElement = null;
        if (aNSParamDetails != null) {
            aNSElement = new ANSElement(aNSParamDetails.getCTCFullPath(this.node, sParameterInfo2.key), sParameterInfo2.key, aNSParamDetails.getANSValue(sParameterInfo2.value));
            aNSElement.setReadOnly(sParameterInfo2.value.isReadOnly);
            aNSElement.setOrigin(sParameterInfo2.value.origin);
            aNSElement.setInfo(sParameterInfo2.value.info);
        }
        return aNSElement;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.node;
    }

    @Override
    public void updateLocal() {
        super.updateLocal();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public void applyToNode(ANSNode aNSNode, ArrayList<String> arrayList) {
        ANSNode[] aNSNodeArray = aNSNode.getChildren();
        if (this.db.on()) {
            this.db.println("Starting applyToNode..children = " + aNSNodeArray.length);
        }
        for (int i = 0; i < aNSNodeArray.length; ++i) {
            try {
                if (aNSNodeArray[i] instanceof ANSElement) {
                    this.applyToDwdm((ANSElement)aNSNodeArray[i]);
                    continue;
                }
                this.applyToNode(aNSNodeArray[i], arrayList);
                continue;
            }
            catch (Exception exception) {
                arrayList.add(aNSNodeArray[i].getFullName() + " : " + exception);
            }
        }
    }

    public void importParameter(sParameterKey sParameterKey2, String string) {
        this.neANSModel.importParameter(sParameterKey2, string);
    }

    private void applyToDwdm(ANSElement aNSElement) throws Exception {
        if (aNSElement.isDirty()) {
            if (this.db.on()) {
                this.db.println("applyToDwdm: elem name = " + aNSElement.getName());
                this.db.println("applyToDwdm: value =" + aNSElement.getANSValue().getIntValue());
            }
            sParameterKey sParameterKey2 = aNSElement.getKey();
            this.neANSModel.setParam(sParameterKey2, aNSElement.getANSValue().getIntValue());
            aNSElement.makeClean();
        }
    }

    public void init() {
        if (this.db.on()) {
            this.db.info("Initing ANSManager " + this.toString());
        }
        if (!this.inited) {
            super.init0();
            this.neANSModel = new NeANSModel(this.node);
            this.neANSModel.init();
            this.neANSModel.addObserver(this);
            this.inited = true;
        }
    }

    public void delete() {
        if (this.db.on()) {
            this.db.info("Deleting ANSManager " + this.toString());
        }
        this.dispose();
    }

    @Override
    public void destroy() {
        if (this.inited) {
            if (this.db.on()) {
                this.db.info("Destroying ANSManager " + this.toString());
            }
            super.destroy();
            this.neANSModel.destroy();
        }
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.info("Disposing ANSManager " + this.toString());
        }
        if (this.inited) {
            this.neANSModel.deleteObserver(this);
            this.neANSModel.destroy();
            this.inited = false;
        }
        super.dispose();
    }

    public boolean ctmNodeSetup(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws CTCUserException {
        Vector<WzTask> vector = new Vector<WzTask>();
        Thread thread = null;
        String string4 = null;
        try {
            File file = new File(string);
            NodeSetupParser nodeSetupParser = new NodeSetupParser(this.node, this.db);
            Node node = nodeSetupParser.parse(file);
            File file2 = new File(string2);
            NsdWizardInfo nsdWizardInfo = new NsdWizardInfo(file2, true);
            nsdWizardInfo = nodeSetupParser.extractNodeInfo(string3, node, nsdWizardInfo);
            if (bl) {
                this.provisionAnp(nsdWizardInfo, vector);
            }
            if (bl7) {
                this.provisionPassiveUnits(nsdWizardInfo, vector);
            }
            if (bl3) {
                this.provisionPpms(nsdWizardInfo, vector);
            }
            if (bl2) {
                this.provisionParams(nsdWizardInfo, vector);
            }
            if (bl4) {
                this.provisionPatchcords(nsdWizardInfo, vector);
            }
            if (bl5) {
                this.provisionSides(nsdWizardInfo, vector);
            }
            if (bl6) {
                this.provisionAns(nsdWizardInfo, vector);
            }
            thread = new Thread(new WzTasksController(vector, nsdWizardInfo, true));
            thread.start();
            thread.join();
            return true;
        }
        catch (Exception exception) {
            if (exception instanceof SAXParseException) {
                String string5 = this.composeExceptionMsg((SAXParseException)exception, string4);
                this.db.println(string5);
                throw new CTCUserException(string5, (Throwable)exception);
            }
            if (this.db.on()) {
                this.db.println(exception.toString());
            }
            throw new CTCUserException(exception.toString(), (Throwable)exception);
        }
    }

    private void provisionAnp(NsdWizardInfo nsdWizardInfo, Vector vector) {
        AnpManager anpManager = null;
        for (int i = 0; i < nsdWizardInfo.getAnp().size(); ++i) {
            anpManager = new AnpManager(nsdWizardInfo, i, this.node);
            vector.addElement(anpManager);
        }
    }

    private void provisionPassiveUnits(NsdWizardInfo nsdWizardInfo, Vector vector) {
        PassiveUnitsManager passiveUnitsManager = null;
        passiveUnitsManager = new PassiveUnitsManager(nsdWizardInfo, this.node);
        vector.addElement(passiveUnitsManager);
    }

    private void provisionParams(NsdWizardInfo nsdWizardInfo, Vector vector) {
        ParamsManager paramsManager = null;
        paramsManager = new ParamsManager(nsdWizardInfo, this.node);
        vector.addElement(paramsManager);
    }

    private void provisionPpms(NsdWizardInfo nsdWizardInfo, Vector vector) {
        PpmManager ppmManager = null;
        ppmManager = new PpmManager(nsdWizardInfo, this.node);
        vector.addElement(ppmManager);
    }

    private void provisionPatchcords(NsdWizardInfo nsdWizardInfo, Vector vector) {
        PatchcordsManager patchcordsManager = null;
        patchcordsManager = new PatchcordsManager(nsdWizardInfo, this.node);
        vector.addElement(patchcordsManager);
    }

    private void provisionSides(NsdWizardInfo nsdWizardInfo, Vector vector) {
        SidesManager sidesManager = null;
        sidesManager = new SidesManager(nsdWizardInfo, this.node);
        vector.addElement(sidesManager);
    }

    private void provisionAns(NsdWizardInfo nsdWizardInfo, Vector vector) {
        AnsManager ansManager = null;
        ansManager = new AnsManager(nsdWizardInfo, this.node);
        vector.addElement(ansManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String composeExceptionMsg(SAXException sAXException, String string) {
        int n = ((SAXParseException)sAXException).getLineNumber();
        String string2 = sAXException.getMessage();
        String string3 = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            for (int i = 1; (string3 = bufferedReader.readLine()) != null && i != n; ++i) {
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.db.println("IO Exception in composeExceptionMsg: " + iOException);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (string2.endsWith("for type 'null'.")) {
            int n2 = string2.length();
            string2 = string2.substring(1, n2 - 16);
        }
        int n3 = 0;
        n3 = string2.indexOf(":");
        if (n3 != -1) {
            string2 = string2.substring(n3 + 2, string2.length());
        }
        string3 = string3 != null ? string3.trim() : "<empty file>";
        String string4 = "File: " + string + "\n" + "Line#: " + n + "\n" + "Line: " + string3 + "\n" + "Message: " + string2;
        return string4;
    }

    public boolean importDefaults(String string) throws CTCUserException {
        throw new CTCUserException("Deprecated. Use AnsParamModel\n");
    }

    public boolean importDefaults(String string, IValidity iValidity) throws CTCUserException {
        throw new CTCUserException("Deprecated. Use AnsParamModel\n");
    }

    public HashMap<String, ANSElement> importAnsDefaults(String string, IValidity iValidity) throws CTCUserException {
        throw new CTCUserException("Deprecated. Use AnsParamModel\n");
    }

    protected static String getWarningsText(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            stringBuffer.append(string + "; ");
        }
        return stringBuffer.toString();
    }

    public boolean exportDefaults(String string) throws CTCUserException {
        throw new CTCUserException("Deprecated. Use AnsParamModel\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyComparator
    implements Comparator<ANSElement> {
        private KeyComparator() {
        }

        @Override
        public int compare(ANSElement aNSElement, ANSElement aNSElement2) {
            return this.compareParamLoc(aNSElement, aNSElement2, aNSElement.getKey(), aNSElement2.getKey());
        }

        private int compareParamLoc(ANSElement aNSElement, ANSElement aNSElement2, sParameterKey sParameterKey2, sParameterKey sParameterKey3) {
            if (sParameterKey2.paramLocation == sParameterKey3.paramLocation) {
                return this.compareType(aNSElement, aNSElement2, sParameterKey2, sParameterKey3);
            }
            return sParameterKey2.paramLocation - sParameterKey3.paramLocation;
        }

        private int compareType(ANSElement aNSElement, ANSElement aNSElement2, sParameterKey sParameterKey2, sParameterKey sParameterKey3) {
            eParamType eParamType2 = sParameterKey2.type;
            eParamType eParamType3 = sParameterKey3.type;
            if (eParamType2.equals(eParamType3)) {
                return this.compareSpectrum(aNSElement, aNSElement2, sParameterKey2, sParameterKey3);
            }
            return eParamType2.value() - eParamType3.value();
        }

        private int compareSpectrum(ANSElement aNSElement, ANSElement aNSElement2, sParameterKey sParameterKey2, sParameterKey sParameterKey3) {
            if (sParameterKey2.spectrum.equals(sParameterKey3.spectrum)) {
                if (sParameterKey2.spectrumIndex > 0 && sParameterKey3.spectrumIndex > 0) {
                    int n = Wavelength.getWavelengthStringFromWavelength(sParameterKey2.spectrumIndex).compareTo(Wavelength.getWavelengthStringFromWavelength(sParameterKey3.spectrumIndex));
                    if (ANSManager.this.db.on()) {
                        ANSManager.this.db.println("compare " + sParameterKey2 + " and " + sParameterKey3 + "=" + n);
                    }
                    return n;
                }
                return aNSElement.getKeyStr().compareTo(aNSElement2.getKeyStr());
            }
            return sParameterKey2.spectrum.value() - sParameterKey3.spectrum.value();
        }
    }

    public class ANSManagerDebug
    extends SDebug {
        ANSManagerDebug(KDebug kDebug) {
            super(kDebug, ANSManager.MY_DEBUG_KEY);
        }

        public final void getTree() {
            try {
                ANSManager.this.getDefaultsTree();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }

        public final void setTree() throws Exception {
            ArrayList<String> arrayList = new ArrayList<String>();
            ANSManager.this.applyToNode(ANSManager.this.rootNode, arrayList);
            if (arrayList.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer("The following ANS parameters failed during the apply operation:\n");
                Iterator<String> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next() + "\n");
                }
                throw new Exception(stringBuffer.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IValidity {
        public boolean doCancel(List<String> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum enumSections {
        ANP,
        PARAMS,
        PPMS,
        PATCHCORDS,
        SIDES,
        ANS;

    }
}

