/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Alarm.eSeverity;
import cerent.cms.idl.Alarm.sAlarmMessage;
import cerent.cms.idl.Alarm.sAlarmMessageListHolder;
import cerent.cms.idl.Alarm.sOneNodeStatus;
import cerent.cms.idl.Alarm.tNodeStatusListHolder;
import cerent.cms.idl.Alarm.xInvalidData;
import cerent.cms.idl.Alarm.xObjectNotFound;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sNames;
import cerent.cms.idl.Equipment.eEnvAlrmType;
import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IAlarmModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IStringTag;
import cerent.cms.model.InvalidData;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OpenSlotProvisionError;
import cerent.cms.model.StringTag;
import cerent.cms.model.event.AlarmDecoder;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.LongHolder;
import org.omg.CORBA.UserException;

public class AlarmModel
extends Model
implements IAlarmModel {
    private static NodeSingletonFactory<AlarmModel> sfactory = new NodeSingletonFactory<AlarmModel>(AlarmModel.class);
    private NodeModelDelegate nodeModel;
    private Alarm alarm;
    private AlarmHistory alarmHistory;
    private NodeStatus nodeStatus;
    private AlarmableList alarmableList;
    private AlarmProfileList alarmProfileList;
    private AlarmProfile alarmProfile;
    private EventDispatcher dispatcher;
    private GetUserdefEnvAlrmList getUserdefEnvAlrmList;
    private AddUserDefEnvAlrm addUserDefEnvAlrm;
    private DeleteUserDefEnvAlrm deleteUserDefEnvAlrm;
    private GetEnvAlrmName getEnvAlrmName;
    private GetEnvAlrmType getEnvAlrmType;

    public sAlarmMessage[] getNodeAlarm(int n) throws AbstractCmsIOException {
        try {
            sAlarmMessageListHolder sAlarmMessageListHolder2 = new sAlarmMessageListHolder();
            LongHolder longHolder = new LongHolder();
            Object[] objectArray = new Object[]{new Integer(n), sAlarmMessageListHolder2, longHolder};
            this.alarm.set(objectArray);
            sAlarmMessage[] sAlarmMessageArray = sAlarmMessageListHolder2.value;
            if (this.db.on()) {
                if (this.db.on()) {
                    this.db.println("alarmlist.length: " + sAlarmMessageArray.length);
                }
                int n2 = 0;
                AlarmDecoder alarmDecoder = this.nodeModel.getAlarmDecoder();
                for (n2 = 0; n2 < sAlarmMessageArray.length; ++n2) {
                    this.db.println("ObjectType: " + alarmDecoder.getObjectTypeName(sAlarmMessageArray[n2].objectIdent.type.value()) + "; Index: " + Integer.toHexString(sAlarmMessageArray[n2].objectIdent.index) + "; cond: " + alarmDecoder.getConditionCode(sAlarmMessageArray[n2].alarmState.condition) + "; sev: " + EnumStrings.getStrings(eSeverity.class)[sAlarmMessageArray[n2].alarmState.severity.value()]);
                }
            }
            return sAlarmMessageArray;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sAlarmMessage[] getAlarmHistory() throws xInvalidData, AbstractCmsIOException {
        sAlarmMessageListHolder sAlarmMessageListHolder2 = new sAlarmMessageListHolder();
        try {
            Object[] objectArray = new Object[]{eSeverity.NOT_REPORTED, sAlarmMessageListHolder2};
            this.alarmHistory.set(objectArray);
            return sAlarmMessageListHolder2.value;
        }
        catch (xInvalidData xInvalidData2) {
            if (this.db.on()) {
                this.db.println("exception during getAlarmHistory/" + (Object)((Object)xInvalidData2));
                SDebug.printStackTrace((Throwable)((Object)xInvalidData2));
            }
            throw xInvalidData2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sOneNodeStatus[] getNodeStatusList() throws AbstractCmsIOException {
        try {
            return (sOneNodeStatus[])this.nodeStatus.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IStringTag[] getAlarmableList() {
        try {
            return (IStringTag[])this.alarmableList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IStringTag[] getAlarmProfileList() {
        try {
            return (IStringTag[])this.alarmProfileList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public String getAlarmSeveritiesFromProfile(String string) {
        IStringTag[] iStringTagArray = this.getAlarmProfileList();
        String string2 = null;
        String string3 = null;
        if (this.alarmProfileList == null) {
            string3 = null;
        } else {
            for (int i = 0; i < iStringTagArray.length; ++i) {
                string2 = iStringTagArray[i].getFirst();
                if (!string2.equals(string)) continue;
                string3 = iStringTagArray[i].getSecond();
                break;
            }
        }
        return string3;
    }

    public void setAlarmProfile(String string, String string2) throws InvalidData, ObjNotFound {
        try {
            Object[] objectArray = new Object[]{string, string2};
            this.alarmProfile.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new OpenSlotProvisionError((UserException)xProvisionError2);
        }
        catch (xInvalidData xInvalidData2) {
            throw new InvalidData((UserException)xInvalidData2);
        }
        catch (xObjectNotFound xObjectNotFound2) {
            throw new ObjNotFound((UserException)xObjectNotFound2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void addUserDefEnvAlrm(String string) throws Exception {
        try {
            this.addUserDefEnvAlrm.set(string.toUpperCase());
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nodeModel.getPlatform());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void deleteUserDefEnvAlrm(String string) throws Exception {
        try {
            this.deleteUserDefEnvAlrm.set(string);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nodeModel.getPlatform());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            this.db.println("Exception in Deleting User Defined Alarms" + userException.getMessage());
        }
    }

    public String[] getUserdefEnvAlrmList() throws Exception {
        String[] stringArray = null;
        try {
            stringArray = (String[])this.getUserdefEnvAlrmList.get();
        }
        catch (xProvisionError xProvisionError2) {
            this.db.println(" In getUserdefEnvAlrmList " + xProvisionError2.getMessage());
            eProvDataError eProvDataError2 = xProvisionError2.dataError;
            if (eProvDataError2.value() == 220) {
                stringArray = new String[]{""};
                this.clearChanged();
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            this.db.println("Exception in getUserdefEnvAlrmList -> " + userException.getMessage());
        }
        return stringArray;
    }

    public String getEnvAlrmName(eEnvAlrmType eEnvAlrmType2) {
        String string = "";
        try {
            string = (String)this.getEnvAlrmName.get(eEnvAlrmType2);
        }
        catch (xProvisionError xProvisionError2) {
            this.db.println(" In getEnvAlrmName " + xProvisionError2.getMessage());
            eProvDataError eProvDataError2 = xProvisionError2.dataError;
            if (eProvDataError2.value() == 220) {
                this.db.println(" Alarm Type " + eEnvAlrmType2.value() + " Not found");
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return string;
    }

    public eEnvAlrmType getEnvAlrmType(String string) {
        eEnvAlrmType eEnvAlrmType2 = null;
        try {
            eEnvAlrmType2 = (eEnvAlrmType)this.getEnvAlrmType.get(string);
        }
        catch (xProvisionError xProvisionError2) {
            this.db.println(" In getEnvAlrm Type " + xProvisionError2.getMessage());
            eProvDataError eProvDataError2 = xProvisionError2.dataError;
            if (eProvDataError2.value() == 220) {
                this.db.println("Alarm Name " + string + " Not found");
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return eEnvAlrmType2;
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public static AlarmModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private AlarmModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(AlarmModel.class));
        this.nodeModel = nodeModelDelegate;
        this.index = 0;
        this.alarm = new Alarm(nodeModelDelegate, "AlarmModel::alarm");
        this.alarmHistory = new AlarmHistory(nodeModelDelegate, "AlarmModel.alarmHistory");
        this.nodeStatus = new NodeStatus(nodeModelDelegate, "AlarmModel.nodeStatus");
        this.alarmableList = new AlarmableList(nodeModelDelegate, "AlarmModel.AlarmableList");
        this.alarmProfileList = new AlarmProfileList(nodeModelDelegate, "AlarmModel.AlarmProfileList");
        this.alarmProfile = new AlarmProfile(nodeModelDelegate, "AlarmModel.AlarmProfile");
        this.addUserDefEnvAlrm = new AddUserDefEnvAlrm(nodeModelDelegate, "AlarmModel.AddUserDefEnvAlrm");
        this.deleteUserDefEnvAlrm = new DeleteUserDefEnvAlrm(nodeModelDelegate, "AlarmModel.DeleteUserDefEnvAlrm");
        this.getUserdefEnvAlrmList = new GetUserdefEnvAlrmList(nodeModelDelegate, "AlarmModel.GetUserdefEnvAlrmList");
        this.getEnvAlrmName = new GetEnvAlrmName(nodeModelDelegate, "AlarmModel.GetEnvAlrmName");
        this.getEnvAlrmType = new GetEnvAlrmType(nodeModelDelegate, "AlarmModel.GetEnvAlrmType");
        this.dispatcher = null;
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nodeModel.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectAlarmManager, 0, (Observer)this);
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectAlarmManager, 0, (Observer)this);
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    if (this.db.on()) {
                        this.db.println("Making local changes.");
                    }
                    this.updateLocal();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("AlarmModel update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    protected void updateLocal() {
        this.getUserdefEnvAlrmList.update();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    class GetEnvAlrmName
    extends NonCachedValue {
        public GetEnvAlrmName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            eEnvAlrmType eEnvAlrmType2 = (eEnvAlrmType)object;
            String string = AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().getEnvAlrmName(eEnvAlrmType2);
            return string;
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }

    class GetEnvAlrmType
    extends NonCachedValue {
        public GetEnvAlrmType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            String string = (String)object;
            eEnvAlrmType eEnvAlrmType2 = AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().getEnvAlrmtype(string);
            return eEnvAlrmType2;
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }

    class GetUserdefEnvAlrmList
    extends CachedValue {
        public GetUserdefEnvAlrmList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            String[] stringArray = null;
            stringArray = AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().getUserdefEnvAlrmList();
            return stringArray;
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }

    class DeleteUserDefEnvAlrm
    extends NonCachedValue {
        public DeleteUserDefEnvAlrm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().deleteUserDefEnvAlrm((String)object);
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }

    class AddUserDefEnvAlrm
    extends NonCachedValue {
        public AddUserDefEnvAlrm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().addUserDefEnvAlrm((String)object);
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }

    class AlarmProfile
    extends NonCachedValue {
        public AlarmProfile(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().setAlarmProfile((String)objectArray[0], (String)objectArray[1]);
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }

    class AlarmProfileList
    extends NonCachedValue {
        public AlarmProfileList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sNames[] sNamesArray = AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().alarmProfileList();
            ArrayList<sNames> arrayList = new ArrayList<sNames>();
            for (int i = 0; i < sNamesArray.length; ++i) {
                if (sNamesArray[i].first.equals("~") && sNamesArray[i].second.equals("~")) continue;
                arrayList.add(sNamesArray[i]);
            }
            return StringTag.getStringTagArray(arrayList);
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }

    class AlarmableList
    extends CachedValue {
        public AlarmableList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sNames[] sNamesArray = AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().alarmableList();
            return StringTag.getStringTagArray(sNamesArray);
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }

    class NodeStatus
    extends NonCachedValue {
        public NodeStatus(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            tNodeStatusListHolder tNodeStatusListHolder2 = new tNodeStatusListHolder();
            AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().GetNodeStatusList(tNodeStatusListHolder2);
            return tNodeStatusListHolder2.value;
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }

    class AlarmHistory
    extends NonCachedValue {
        public AlarmHistory(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().GetAlarmHistory((eSeverity)objectArray[0], (sAlarmMessageListHolder)objectArray[1]);
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }

    class Alarm
    extends NonCachedValue {
        public Alarm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            if (n == 1) {
                AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().getAllReportedConditions((sAlarmMessageListHolder)objectArray[1]);
            } else {
                boolean bl = n != -1;
                AlarmModel.this.nodeModel.getIorRepository().getAlarmRef().getAllConditions(bl, (sAlarmMessageListHolder)objectArray[1]);
            }
        }

        public Object outer() {
            return AlarmModel.this;
        }
    }
}

