/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eTrafficDirection;
import cerent.cms.idl.SonetMedia.sStsPathDef;
import cerent.cms.idl.SonetTopology.StsVcatTerm;
import cerent.cms.idl.SonetTopology.eVcatMemStatus;
import cerent.cms.idl.SonetTopology.sStatusStsConn;
import cerent.cms.idl.SonetTopology.sStsVcatTermItem;
import cerent.cms.idl.SonetTopology.xInvalidParms;
import cerent.cms.idl.SonetTopology.xInvalidPath;
import cerent.cms.idl.SonetTopology.xInvalidStatus;
import cerent.cms.model.AbstractVcatTermsMap;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.HoPathDefModelFactory;
import cerent.cms.model.HoVcatTermsMap;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoVcatTermModel;
import cerent.cms.model.IVcatTermMember;
import cerent.cms.model.InvalidParms;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidStatus;
import cerent.cms.model.NoSuchVcat;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.VcatTermMember;
import cerent.cms.model.VcatTermMemberFactory;
import cerent.cms.model.VcatTermModel;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class HoVcatTermModel
extends VcatTermModel
implements IHoVcatTermModel {
    private int portIndex = -1;
    private StsVcatTermItemCV stsVcatTermItemCV = null;
    private MembersOfTheVcatTerm membersOfTheVcatTerm = null;
    private MemberStatus memberStatus = null;

    public HoVcatTermModel(NodeModelDelegate nodeModelDelegate, sStsVcatTermItem sStsVcatTermItem2, AbstractVcatTermsMap abstractVcatTermsMap) {
        super(nodeModelDelegate, sStsVcatTermItem2.vcatTerm, abstractVcatTermsMap, nodeModelDelegate.getChildDebug(HoVcatTermModel.class));
        this.index = sStsVcatTermItem2.objIndex;
        this.portIndex = sStsVcatTermItem2.portIndex;
        this.stsVcatTermItemCV = new StsVcatTermItemCV(nodeModelDelegate, "HoVcatTermModel.VtVcatTermItem");
        this.membersOfTheVcatTerm = new MembersOfTheVcatTerm(nodeModelDelegate, "HoVcatTermModel.MembersOfTheVcatTerm");
        this.memberStatus = new MemberStatus(nodeModelDelegate, "HoVcatTermModel.MemberStatus");
        this.setAttributes(sStsVcatTermItem2);
    }

    public void init() {
        super.init();
    }

    public void setAttributes(sStsVcatTermItem sStsVcatTermItem2) {
        this.stsVcatTermItemCV.setValueExternally(sStsVcatTermItem2);
    }

    public int getMemberStatus(IHoPathDefModel iHoPathDefModel) throws InvalidPath {
        sStsPathDef sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
        try {
            eVcatMemStatus eVcatMemStatus2 = (eVcatMemStatus)this.memberStatus.get(sStsPathDef2);
            return eVcatMemStatus2.value();
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (UserException userException) {
            this.db.println("HoVcatTermModel: user exception in MemberStatus");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public void setMemberStatus(IHoPathDefModel iHoPathDefModel, int n) throws InvalidPath, InvalidStatus {
        try {
            Object[] objectArray = new Object[2];
            objectArray[0] = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
            objectArray[2] = eVcatMemStatus.from_int(n);
            this.memberStatus.set(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xInvalidStatus xInvalidStatus2) {
            throw new InvalidStatus((UserException)xInvalidStatus2);
        }
        catch (UserException userException) {
            this.db.println("HoVcatTermModel: user exception in MemberStatus");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IVcatTermMember[] getMembersOfTheVcatTerm(int n) throws InvalidParms {
        try {
            sStatusStsConn[] sStatusStsConnArray = (sStatusStsConn[])this.membersOfTheVcatTerm.get(eTrafficDirection.from_int(n));
            return VcatTermMemberFactory.getIHoVcatTermMemberArray(this.nmd, sStatusStsConnArray);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParms((UserException)xInvalidParms2);
        }
        catch (UserException userException) {
            this.db.println("HoVcatTermModel: user exception in getMembersOfTheVcatTerm");
            SDebug.printStackTrace((Throwable)userException);
            return new VcatTermMember[0];
        }
    }

    public int getPortIndex() {
        return this.portIndex;
    }

    private sStsVcatTermItem getStsVcatTermItem() {
        try {
            return (sStsVcatTermItem)this.stsVcatTermItemCV.get();
        }
        catch (UserException userException) {
            this.db.println("HoVcatTermModel: user exception in getStsVcatTermItem");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public ICircuitId getCircuitId() {
        return CircuitIdFactory.getICircuitId(this.getStsVcatTermItem().vcatCirId);
    }

    public String getVcatName() {
        return this.getStsVcatTermItem().name;
    }

    public short getNumberOfMembers(int n) throws InvalidParms {
        if (n == 0) {
            return this.getStsVcatTermItem().vcatTermAttributes.numOfRxMems;
        }
        if (n == 1) {
            return this.getStsVcatTermItem().vcatTermAttributes.numOfTxMems;
        }
        if (n == 2) {
            return this.getStsVcatTermItem().vcatTermAttributes.numOfTxMems;
        }
        throw new InvalidParms("The traffic direction is invalid.");
    }

    public int getLcasMode() {
        return this.getStsVcatTermItem().vcatTermAttributes.mode.value();
    }

    public void setLcasMode(int n) throws CTCUserException {
        throw new CTCUserException("LCAS mode support has not been implemented.");
    }

    public int getDirection() {
        return this.getStsVcatTermItem().vcatTermAttributes.direction.value();
    }

    public boolean getExtBuffer() {
        return this.getStsVcatTermItem().vcatTermAttributes.extBuffer;
    }

    public short getHoPathWidth() {
        return this.getStsVcatTermItem().memPathWidth;
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectStsVcatTerm;
    }

    protected void updateLocal() {
        this.stsVcatTermItemCV.update();
        super.updateLocal();
    }

    public void dispose() {
        super.dispose();
    }

    private class MembersOfTheVcatTerm
    extends NonCachedValue {
        public MembersOfTheVcatTerm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ((StsVcatTerm)HoVcatTermModel.this.getVcatTermRef()).getMembersOfTheVcatTerm((eTrafficDirection)object);
        }
    }

    private class MemberStatus
    extends NonCachedValue {
        public MemberStatus(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ((StsVcatTerm)HoVcatTermModel.this.getVcatTermRef()).getMemberStatus((sStsPathDef)object);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            ((StsVcatTerm)HoVcatTermModel.this.getVcatTermRef()).setMemberStatus((sStsPathDef)objectArray[0], (eVcatMemStatus)objectArray[1]);
        }
    }

    private class StsVcatTermItemCV
    extends CachedValue {
        public StsVcatTermItemCV(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            try {
                return ((HoVcatTermsMap)HoVcatTermModel.this.parent).getStsVcatTermItemFromPort(new Integer(HoVcatTermModel.this.getPortIndex()));
            }
            catch (NoSuchVcat noSuchVcat) {
                throw new CmsObjectNotExistException("The VCAT termination for Port" + Integer.toHexString(HoVcatTermModel.this.getPortIndex()) + " does not exist.");
            }
        }

        protected void setValue(Object object) throws UserException {
        }
    }
}

