/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Epos.sRPRSpanStateInfo;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.EtherMedia.sL2scPosPortInfo;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.CachedValue;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.L2scPosLineModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class L2scPosPortModel
extends L2scPortModel {
    private L2scPosPortInfo l2scPosPortInfo;
    private RPRSpanStateInfo rprSpanStateInfo;

    public L2scPosPortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(L2scPosPortModel.class));
    }

    public L2scPosPortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, sDebug);
        this.l2scPosPortInfo = new L2scPosPortInfo(nodeModelDelegate, "L2scPosPortModel.L2scPosPortInfo");
        this.rprSpanStateInfo = new RPRSpanStateInfo(nodeModelDelegate, "L2scPosPortModel.RPRSpanStateInfo");
    }

    public void init() {
        super.init();
        this.l2scPosPortInfo.init();
        this.rprSpanStateInfo.init();
    }

    public L2scPosLineModel getL2scPosLineModel() {
        IInterfaceModel iInterfaceModel = this.getInterfaceModel();
        if (iInterfaceModel instanceof L2scPosLineModel) {
            return (L2scPosLineModel)iInterfaceModel;
        }
        if (this.db.on()) {
            this.db.println("\n\nThis is bad!\nL2scPosLineModel instance not returned for " + this);
            this.db.println("    instead got: " + iInterfaceModel);
        }
        return new L2scPosLineModel(this.node, this.index);
    }

    public String toString() {
        return "L2scPos" + super.toString();
    }

    public boolean isInLoopback() {
        return this.getL2scPosLineModel().getLoopbackAsInt() != 0;
    }

    private sL2scPosPortInfo debugOut(sL2scPosPortInfo sL2scPosPortInfo2) {
        if (this.db.isInfoEnabled()) {
            this.db.info(Integer.toHexString(this.getIndex()) + " " + this.getPort() + " state " + sL2scPosPortInfo2.adminState + " mtu " + sL2scPosPortInfo2.mtu + " framingType " + sL2scPosPortInfo2.framingType.value());
        }
        return sL2scPosPortInfo2;
    }

    public sRPRSpanStateInfo getRPRSpanStateInfo() throws ProvisionError {
        sRPRSpanStateInfo sRPRSpanStateInfo2 = null;
        if (this.db.on()) {
            this.db.println("getRPRSpanStateInfo");
        }
        try {
            if (this.inRPRMode()) {
                sRPRSpanStateInfo2 = (sRPRSpanStateInfo)this.rprSpanStateInfo.get();
            }
        }
        catch (xProvisionError xProvisionError2) {
            this.db.println("caught xProvisionError " + (Object)((Object)xProvisionError2));
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            this.db.println("caught UserException " + (Object)((Object)userException));
            throw this.doUnknown("getRPRSpanStateInfo", userException);
        }
        return sRPRSpanStateInfo2;
    }

    public sL2scPosPortInfo getL2scPosPortInfo() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ProvisionError {
        this.db.fine("getL2scPosPortInfo");
        try {
            if (!this.inRPRMode()) {
                return this.debugOut((sL2scPosPortInfo)this.l2scPosPortInfo.get());
            }
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPosPortInfo", userException);
        }
        return null;
    }

    public int getServiceStateType() throws NoSuchInterface {
        int n = 101;
        try {
            n = !this.inRPRMode() ? (this.getL2scPosPortInfo().linkProtocolState ? 100 : 101) : (this.getRPRSpanStateInfo().adminState ? 100 : 101);
        }
        catch (InternalCommError internalCommError) {
            this.db.severe(internalCommError.toString());
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            this.db.severe(wrongInterfaceType.toString());
        }
        catch (ProvisionError provisionError) {
            this.db.severe(provisionError.toString());
        }
        return n;
    }

    protected void updateLocal() {
        this.l2scPosPortInfo.update();
        this.rprSpanStateInfo.update();
        if (this.db.isInfoEnabled()) {
            this.db.info("L2scPosPortModel::updateLocal " + Integer.toHexString(this.getIndex()));
            try {
                if (!this.inRPRMode()) {
                    this.debugOut((sL2scPosPortInfo)this.l2scPosPortInfo.get());
                } else {
                    this.rprSpanStateInfo.get();
                }
            }
            catch (Exception exception) {
                this.db.severe(exception.toString());
            }
        }
        super.updateLocal();
    }

    public void dispose() {
        this.db.fine("L2scPosPortModel::dispose");
        this.l2scPosPortInfo.dispose();
        this.rprSpanStateInfo.dispose();
        super.dispose();
    }

    public void destroy() {
        this.db.fine("L2scPosPortModel::destroy()");
        super.destroy();
        this.l2scPosPortInfo = null;
        this.rprSpanStateInfo = null;
    }

    public int getPort() {
        int n = this.getPositionInParent();
        return n - 1;
    }

    private class RPRSpanStateInfo
    extends CachedValue {
        public RPRSpanStateInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xProvisionError {
            return L2scPosPortModel.this.getRPRRef().getRPRSpanStateInfo(L2scPosPortModel.this.getIndex());
        }

        public Object outer() {
            return L2scPosPortModel.this;
        }
    }

    private class L2scPosPortInfo
    extends CachedValue {
        public L2scPosPortInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xInternalCommError, xProvisionError {
            return L2scPosPortModel.this.getEtherMediaRef().getL2scPosPortInfo(L2scPosPortModel.this.getIndex());
        }

        public Object outer() {
            return L2scPosPortModel.this;
        }
    }
}

