/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Lmp.General;
import cerent.cms.idl.Lmp.sDataLinkAttrsEx;
import cerent.cms.idl.Lmp.xLmpException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractLmpException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.ILmpDataLinkModel;
import cerent.cms.model.ILmpDataLinkModels;
import cerent.cms.model.ILmpTeLinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LmpDataLinkModel;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModel;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LmpDataLinkModels
extends Model
implements ILmpDataLinkModels {
    private static NodeSingletonFactory<LmpDataLinkModels> sfactory = new NodeSingletonFactory<LmpDataLinkModels>(LmpDataLinkModels.class);
    private static final ObjectType _eventType = ObjectType.ObjectDataLinkList;
    private NodeModelDelegate _nmd;
    private EventDispatcher _dispatcher;
    private HashMap _models;
    private Create _create;
    private Get _get;
    private Delete _delete;
    private UserException _getException;

    private LmpDataLinkModels(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(LmpDataLinkModels.class));
        this._nmd = nodeModelDelegate;
        this._dispatcher = null;
        this._models = new HashMap();
        this._create = new Create(this._nmd, "Lmp::DataLinkManager::Create");
        this._get = new Get(this._nmd, "Lmp::DataLinkManager::Get");
        this._delete = new Delete(this._nmd, "Lmp::DataLinkManager::Delete");
        this._getException = null;
        this.index = 0;
    }

    General getLmpMgrRef() {
        return this._nmd.getIorRepository().getLmpMgrRef();
    }

    @Override
    public INodeModel getNodeModel() {
        return this._nmd;
    }

    public void init() {
        if (this._dispatcher == null) {
            this._dispatcher = this._nmd.getDispatcher();
        }
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(_eventType, 0, (Observer)this);
        }
        this.updateLocal();
        if (this.db.on()) {
            this.db.println("init(" + this + ")");
        }
        super.init0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() {
        ArrayList arrayList = new ArrayList();
        ArrayList<LmpDataLinkModel> arrayList2 = new ArrayList<LmpDataLinkModel>();
        Iterator iterator = this._models;
        synchronized (iterator) {
            try {
                this._get.update();
                int[] nArray = (int[])this._get.get();
                this._getException = null;
                HashSet hashSet = new HashSet(this._models.keySet());
                HashSet hashSet2 = new HashSet();
                for (int i = 0; i < nArray.length; ++i) {
                    Integer n = new Integer(nArray[i]);
                    if (hashSet.contains(n)) {
                        hashSet.remove(n);
                        continue;
                    }
                    hashSet2.add(n);
                }
                StringBuffer stringBuffer = null;
                if (this.db.on()) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append('-');
                }
                for (Integer n : hashSet) {
                    if (this.db.on()) {
                        stringBuffer.append(' ');
                        stringBuffer.append(n);
                    }
                    arrayList.add(this._models.remove(n));
                }
                if (this.db.on()) {
                    if (stringBuffer.length() > 1) {
                        this.db.println(stringBuffer.toString());
                    }
                    stringBuffer.setLength(0);
                    stringBuffer.append('+');
                }
                for (Integer n : hashSet2) {
                    LmpDataLinkModel lmpDataLinkModel = new LmpDataLinkModel(this._nmd, this, n);
                    if (this.db.on()) {
                        stringBuffer.append(' ');
                        stringBuffer.append(n);
                    }
                    arrayList2.add(lmpDataLinkModel);
                    this._models.put(n, lmpDataLinkModel);
                }
                if (this.db.on() && stringBuffer.length() > 1) {
                    this.db.println(stringBuffer.toString());
                }
            }
            catch (xLmpException xLmpException2) {
                this.db.println("Failed to get LMP data links: " + (Object)((Object)xLmpException2));
                this._getException = xLmpException2;
            }
            catch (UserException userException) {
                this.db.println("Failed to get LMP data links: " + (Object)((Object)userException));
                this._getException = userException;
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((LmpDataLinkModel)iterator.next()).destroy();
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ((LmpDataLinkModel)iterator.next()).init();
        }
        if (!arrayList2.isEmpty()) {
            this.setChanged();
            super.updateLocal();
        }
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(" + this + ")");
        }
        this.updateCache();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update(" + this + ", arg=" + object + ", from=" + observable + ")");
        }
        if (observable instanceof CmsObservable && object instanceof ObjectMessageInfo) {
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            switch (objectMessageInfo.getUpdateType()) {
                case 2: {
                    this.updateLocal();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(_eventType, 0, (Observer)this);
            this._dispatcher = null;
        }
        this._get.dispose();
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            this._models.clear();
        }
        if (this.db.on()) {
            this.db.println("dispose(" + this + ")");
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(" + this + ")");
        }
        super.destroy();
    }

    public int createDataLink(sDataLinkAttrsEx sDataLinkAttrsEx2) throws LmpException, WrongInterfaceType, NoSuchInterface {
        try {
            return (Integer)this._create.get(sDataLinkAttrsEx2);
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createDataLink", userException);
        }
    }

    public ILmpDataLinkModel[] getIDataLinks() throws LmpException {
        return this.getDataLinks();
    }

    public ILmpDataLinkModel[] getIDataLinksForTeLink(ILmpTeLinkModel iLmpTeLinkModel) throws AbstractLmpException {
        LmpDataLinkModel[] lmpDataLinkModelArray = this.getDataLinks();
        LinkedList<LmpDataLinkModel> linkedList = new LinkedList<LmpDataLinkModel>();
        for (LmpDataLinkModel lmpDataLinkModel : lmpDataLinkModelArray) {
            if (lmpDataLinkModel.getLocalTeLinkId() != iLmpTeLinkModel.getLocalTeLinkId()) continue;
            linkedList.add(lmpDataLinkModel);
        }
        return linkedList.toArray(new ILmpDataLinkModel[linkedList.size()]);
    }

    public LmpDataLinkModel[] getDataLinksForTeLink(LmpTeLinkModel lmpTeLinkModel) throws LmpException {
        LmpDataLinkModel[] lmpDataLinkModelArray = this.getDataLinks();
        LinkedList<LmpDataLinkModel> linkedList = new LinkedList<LmpDataLinkModel>();
        for (LmpDataLinkModel lmpDataLinkModel : lmpDataLinkModelArray) {
            if (lmpDataLinkModel.getLocalTeLinkId() != lmpTeLinkModel.getLocalTeLinkId()) continue;
            linkedList.add(lmpDataLinkModel);
        }
        return linkedList.toArray(new LmpDataLinkModel[linkedList.size()]);
    }

    public LmpDataLinkModel[] getDataLinks() throws LmpException {
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            if (this._getException != null) {
                this.updateCache();
            }
            if (this._getException == null) {
                LmpDataLinkModel[] lmpDataLinkModelArray = this._models.values().toArray(new LmpDataLinkModel[this._models.size()]);
                if (this.db.on()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('=');
                    for (int i = 0; i < lmpDataLinkModelArray.length; ++i) {
                        stringBuffer.append(' ');
                        stringBuffer.append(lmpDataLinkModelArray[i].getIndex());
                    }
                    this.db.println(stringBuffer.toString());
                }
                return lmpDataLinkModelArray;
            }
            if (this._getException instanceof xLmpException) {
                throw new LmpException((xLmpException)this._getException);
            }
            throw NodeModelDelegate.doUnknown(this.db, "getDataLinks", this._getException);
        }
    }

    public void deleteDataLink(int n) throws LmpException {
        try {
            this._delete.set(new Integer(n));
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "deleteDataLink", userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataLink(int n) throws LmpException {
        boolean bl = false;
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            for (LmpDataLinkModel lmpDataLinkModel : this._models.values()) {
                if (lmpDataLinkModel.getLocalPortId() != n) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean isChanRx(IPortModel iPortModel) throws NoSuchInterface, WrongInterfaceType {
        return iPortModel instanceof OpticsPortModel && ((OpticsPortModel)iPortModel).isOchncAddPort();
    }

    public static boolean isChanTx(IPortModel iPortModel) throws NoSuchInterface, WrongInterfaceType {
        return iPortModel instanceof OpticsPortModel && ((OpticsPortModel)iPortModel).isOchncDropPort();
    }

    public int getTxPortByRx2(int n) throws AbstractCmsNoSuchEntityException, WrongInterfaceType, NoSuchInterface {
        IPortModel iPortModel = (IPortModel)this._nmd.getEntityTable().getEntityModelByIndex(n);
        if (iPortModel instanceof OpticsPortModel) {
            try {
                int n2 = ((OpticsPortModel)iPortModel).getReversePortList()[0];
                return n2;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                return 0;
            }
        }
        IInterfaceModel iInterfaceModel = iPortModel.getInterfaceModel();
        if (iInterfaceModel instanceof IOpticsModel) {
            try {
                int n3 = ((IOpticsModel)iInterfaceModel).getReversePort();
                return n3;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                return 0;
            }
        }
        return 0;
    }

    public void getTxPortByRxBulk(HashMap<Integer, Integer> hashMap) {
        for (Integer n : hashMap.keySet()) {
            try {
                IInterfaceModel iInterfaceModel;
                IPortModel iPortModel = (IPortModel)this._nmd.getEntityTable().getEntityModelByIndex(n.intValue());
                if (!LmpDataLinkModels.isChanRx(iPortModel) || !((iInterfaceModel = iPortModel.getInterfaceModel()) instanceof IOpticsModel)) continue;
                try {
                    int n2 = ((IOpticsModel)iInterfaceModel).getReversePort();
                    hashMap.put(n, n2);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            catch (Exception exception) {}
        }
    }

    public int[] getCandidates() throws LmpException {
        int n;
        Object object;
        int n2;
        Object object2;
        Object object32;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ElementModelsDelegate elementModelsDelegate = this._nmd.getElementModelsDelegate();
        for (Object object32 : elementModelsDelegate.getNonProtectDwdmEntities()) {
            int n3;
            if (!(object32 instanceof DwdmPortModel) || this.isDataLink(n3 = ((EntityModel)(object2 = (DwdmPortModel)object32)).getIndex())) continue;
            arrayList.add(new Integer(n3));
        }
        EntityTableModel entityTableModel = this._nmd.getEntityTableModel();
        object32 = entityTableModel.getEntityModelsByClass(eClass.PORT);
        try {
            object2 = object32.iterator();
            while (object2.hasNext()) {
                PortModel portModel = (PortModel)object2.next();
                if (portModel instanceof OpticsPortModel && ((OpticsPortModel)portModel).isPassivePort() && !this.isDataLink(portModel.getIndex()) && ((OpticsPortModel)portModel).isOptPortTypeRX() && ((OpticsPortModel)portModel).isChannelPort()) {
                    arrayList.add(new Integer(portModel.getIndex()));
                }
                if (this.isDataLink(portModel.getIndex()) || !LmpDataLinkModels.isChanRx(portModel) || portModel.getModuleModel().getEqType() == 295 || portModel.getModuleModel().getEqType() == 296 || portModel.getModuleModel().getEqType() == 294) continue;
                arrayList.add(new Integer(portModel.getIndex()));
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (this.db.on()) {
                this.db.println("getCandidates failed: No such interface");
            }
            return new int[0];
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (this.db.on()) {
                this.db.println("getCandidates failed: Wrong interface type");
            }
            return new int[0];
        }
        object2 = this._nmd.getIOpticalPatchCordModel();
        int[] nArray = new int[]{};
        try {
            IOptLinkModel[] iOptLinkModelArray = object2.getIOptLinkModels();
            nArray = new int[iOptLinkModelArray.length * 2];
            int n4 = 0;
            for (n2 = 0; n2 < iOptLinkModelArray.length; ++n2) {
                object = iOptLinkModelArray[n2];
                nArray[n4++] = object.getFrom();
                nArray[n4++] = object.getTo();
            }
            Arrays.sort(nArray);
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        int[] nArray2 = new int[arrayList.size()];
        n2 = 0;
        object = arrayList.iterator();
        while (object.hasNext()) {
            n = (Integer)object.next();
            if (Arrays.binarySearch(nArray, n) >= 0) continue;
            nArray2[n2++] = n;
        }
        object = new int[n2];
        for (n = 0; n < n2; ++n) {
            object[n] = (IOptLinkModel)nArray2[n];
        }
        return object;
    }

    void deleted(LmpDataLinkModel lmpDataLinkModel) {
        this.updateCache();
    }

    public static LmpDataLinkModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    public String toString() {
        return "LmpDataLinks#" + this.index;
    }

    private class Delete
    extends NonCachedValue {
        public Delete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xLmpException {
            LmpDataLinkModels.this.getLmpMgrRef().deleteDataLink((Integer)object);
        }

        public Object outer() {
            return LmpDataLinkModels.this;
        }
    }

    private class Get
    extends CachedValue {
        public Get(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xLmpException {
            return LmpDataLinkModels.this.getLmpMgrRef().getDataLinks();
        }

        public Object outer() {
            return LmpDataLinkModels.this;
        }
    }

    private class Create
    extends NonCachedValue {
        public Create(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xLmpException, xWrongInterfaceType, xNoSuchInterface {
            return new Integer(LmpDataLinkModels.this.getLmpMgrRef().createDataLinkEx((sDataLinkAttrsEx)object));
        }

        public Object outer() {
            return LmpDataLinkModels.this;
        }
    }
}

