/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.SonetMedia.eVtPathWidth;
import cerent.cms.idl.SonetMedia.sStsPathDef;
import cerent.cms.idl.SonetTopology.StsCircuitPart;
import cerent.cms.idl.SonetTopology.VtAdit;
import cerent.cms.idl.SonetTopology.sVtAditItem;
import cerent.cms.idl.SonetTopology.sVtDef;
import cerent.cms.idl.SonetTopology.sVtPathInfo;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.HoCircuitPartModel;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.HoPathDefModelFactory;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.LoDefModelFactory;
import cerent.cms.model.LoPathInfo;
import cerent.cms.model.LoPathInfoFactory;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PoolModel;
import cerent.cms.model.PoolModelsDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.UnsupportedOperation;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class LoAditModel
extends HoCircuitPartModel
implements ILoAditModel {
    private VtAdit vtAditRef = null;
    private Sts sts = null;
    private Destroy destroy = null;
    private GetAvailableVts getAvailableVts = null;
    private GetConnectedPaths getConnectedPaths = null;
    private InUse inUse = null;
    private RemoveConnectedPath removeConnectedPath = null;
    private int cachedWidth = -1;
    private ILoPathInfo[] availPaths = null;
    private int entityIndex = -1;
    private boolean reservedForPortGroup;
    private boolean reservedForPortGroupChecked = false;

    public LoAditModel(NodeModelDelegate nodeModelDelegate, sVtAditItem sVtAditItem2, Connections connections) {
        this(nodeModelDelegate, sVtAditItem2.adit, connections);
        this.setAttributes(sVtAditItem2);
    }

    public LoAditModel(NodeModelDelegate nodeModelDelegate, VtAdit vtAdit, Connections connections) {
        super(nodeModelDelegate, connections);
        this.vtAditRef = vtAdit;
        this.sts = new Sts(nodeModelDelegate, "LoAditModel.Sts");
        this.destroy = new Destroy(nodeModelDelegate, "LoAditModel.destroy");
        this.getAvailableVts = new GetAvailableVts(nodeModelDelegate, "LoAditModel.getAvailableSts");
        this.getConnectedPaths = new GetConnectedPaths(nodeModelDelegate, "LoAditModel.getConnectedPaths");
        this.inUse = new InUse(nodeModelDelegate, "LoAditModel.inUse");
        this.removeConnectedPath = new RemoveConnectedPath(nodeModelDelegate, "LoAditModel.removeConnectedPath");
    }

    public VtAdit getVtAditRef() {
        if (this.vtAditRef == null) {
            throw new CmsObjectNotExistException("An attempt was made to access a VT adit that has been destroyed.");
        }
        return this.vtAditRef;
    }

    protected StsCircuitPart getCircuitPart() {
        if (this.vtAditRef == null) {
            throw new CmsObjectNotExistException("An attempt was made to access a VT adit that has been destroyed.");
        }
        return this.vtAditRef;
    }

    public boolean inRoll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        LoAditModel loAditModel = this;
        synchronized (loAditModel) {
            this.availPaths = null;
            this.cachedWidth = -1;
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocal() {
        if (this.db.on) {
            this.db.println("LoAdit Update Local called:" + Integer.toHexString(this.index));
        }
        LoAditModel loAditModel = this;
        synchronized (loAditModel) {
            this.availPaths = null;
            this.cachedWidth = -1;
        }
        this.sts.update();
        this.inUse.update();
        super.updateLocal();
    }

    public void dispose() {
        this.sts.dispose();
        this.inUse.dispose();
        this.availPaths = null;
        this.cachedWidth = -1;
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        this.vtAditRef = null;
    }

    public IHoPathDefModel getHo() {
        try {
            return (HoPathDefModel)this.sts.get();
        }
        catch (UserException userException) {
            if (this.db.on()) {
                this.db.println("LoAditModel: user exception in getHo");
                SDebug.printStackTrace((Throwable)userException);
            }
            return null;
        }
    }

    public void localDestroy() throws Busy {
        block3: {
            try {
                this.destroy.get();
            }
            catch (xBusy xBusy2) {
                throw new Busy((UserException)xBusy2);
            }
            catch (UserException userException) {
                if (!this.db.on()) break block3;
                this.db.println("LoAditModel: user exception in destroy");
                SDebug.printStackTrace((Throwable)userException);
            }
        }
    }

    public synchronized ILoPathInfo[] getAvailableLos(int n) {
        if (this.cachedWidth != n || this.availPaths == null) {
            try {
                Object[] objectArray = new Object[1];
                eVtPathWidth eVtPathWidth2 = eVtPathWidth.from_int(n);
                objectArray[0] = eVtPathWidth2;
                sVtPathInfo[] sVtPathInfoArray = (sVtPathInfo[])this.getAvailableVts.get(objectArray);
                sVtPathInfoArray = LoDefModelFactory.applyPathWidth2VtPathInfoArray(sVtPathInfoArray, eVtPathWidth2);
                int n2 = this.getFramingType();
                this.availPaths = LoPathInfoFactory.getILoPathInfoArray(sVtPathInfoArray, n2);
                this.cachedWidth = n;
            }
            catch (UserException userException) {
                if (this.db.on()) {
                    this.db.println("LoAditModel: user exception in getAvailableVts");
                    SDebug.printStackTrace((Throwable)userException);
                }
                return null;
            }
            catch (RuntimeException runtimeException) {
                this.availPaths = null;
                this.cachedWidth = -1;
                throw runtimeException;
            }
        }
        return this.availPaths;
    }

    public ILoPathInfo[] getConnectedPaths(int n) {
        try {
            Object[] objectArray = new Object[1];
            INodeModel iNodeModel = this.getNodeModel();
            sVtPathInfo[] sVtPathInfoArray = (sVtPathInfo[])this.getConnectedPaths.get();
            ArrayList<sVtPathInfo> arrayList = new ArrayList<sVtPathInfo>();
            for (int i = 0; i < sVtPathInfoArray.length; ++i) {
                if (sVtPathInfoArray[i].pathWidth.value() != n) continue;
                arrayList.add(sVtPathInfoArray[i]);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            sVtPathInfo[] sVtPathInfoArray2 = null;
            sVtPathInfoArray2 = new sVtPathInfo[arrayList.size()];
            System.arraycopy(arrayList.toArray(), 0, sVtPathInfoArray2, 0, arrayList.size());
            return LoPathInfoFactory.getILoPathInfoArray(sVtPathInfoArray, this.getFramingType());
        }
        catch (UserException userException) {
            if (this.db.on()) {
                this.db.println("LoAditModel: user exception in getConnectedPaths");
                SDebug.printStackTrace((Throwable)userException);
            }
            return null;
        }
    }

    public ILoPathInfo[] getConnectedLoPaths(int n) {
        try {
            sVtPathInfo[] sVtPathInfoArray = (sVtPathInfo[])this.getConnectedPaths.get();
            ArrayList<sVtPathInfo> arrayList = new ArrayList<sVtPathInfo>();
            for (int i = 0; i < sVtPathInfoArray.length; ++i) {
                if (sVtPathInfoArray[i].pathWidth.value() != n) continue;
                arrayList.add(sVtPathInfoArray[i]);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            sVtPathInfo[] sVtPathInfoArray2 = null;
            sVtPathInfoArray2 = new sVtPathInfo[arrayList.size()];
            System.arraycopy(arrayList.toArray(), 0, sVtPathInfoArray2, 0, arrayList.size());
            return LoPathInfoFactory.getILoPathInfoArray(sVtPathInfoArray2, this.getFramingType());
        }
        catch (UserException userException) {
            if (this.db.on()) {
                this.db.println("LoAditModel: user exception in getConnectedTug3Paths");
                SDebug.printStackTrace((Throwable)userException);
            }
            return null;
        }
    }

    protected List getConnectionsList() {
        LinkedList<ILoPathInfo> linkedList = new LinkedList<ILoPathInfo>();
        LinkedList<ConnectionModel> linkedList2 = new LinkedList<ConnectionModel>();
        if (this.getCircuitPart().pathWidth() == 0) {
            linkedList.addAll(Arrays.asList(this.getConnectedPaths(0)));
        } else if (this.getCircuitPart().pathWidth() == 1) {
            linkedList.addAll(Arrays.asList(this.getConnectedPaths(1)));
        }
        if (linkedList.size() != 0) {
            for (LoPathInfo loPathInfo : linkedList) {
                ConnectionModel connectionModel;
                ILoNum iLoNum = loPathInfo.getLoNum();
                LoDefModel loDefModel = new LoDefModel(this.nmd, this, iLoNum, -1, 0, 0);
                try {
                    connectionModel = (ConnectionModel)this.nmd.getConnectionModels().getLoConnection((ILoDefModel)loDefModel);
                }
                catch (NoSuchConnection noSuchConnection) {
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)noSuchConnection);
                    continue;
                }
                if (connectionModel == null) continue;
                linkedList2.add(connectionModel);
            }
        }
        return linkedList2;
    }

    protected void markPoolDirty() {
        PoolModel poolModel = (PoolModel)this.getHo().getPool();
        if (poolModel != null) {
            poolModel.updateLocal();
        } else if (this.db.on) {
            this.db.println("Pool null in markPool Dirty ");
        }
        if (poolModel != null) {
            PoolModel poolModel2 = poolModel.getSharedPool();
            if (poolModel2 != null) {
                poolModel2.updateLocal();
            } else if (this.db.on) {
                this.db.println("sharedPool null in markPoolDirty ");
            }
        }
    }

    public boolean inUse() {
        try {
            return (Boolean)this.inUse.get();
        }
        catch (UserException userException) {
            if (this.db.on()) {
                this.db.println("LoAditModel: user exception in inUse");
                SDebug.printStackTrace((Throwable)userException);
            }
            return false;
        }
    }

    public void removeConnectedPath(sVtDef sVtDef2) {
        block2: {
            try {
                Object[] objectArray = new Object[]{sVtDef2};
                this.removeConnectedPath.get(objectArray);
            }
            catch (UserException userException) {
                if (!this.db.on()) break block2;
                this.db.println("LoAditModel: user exception in removeConnectedPath");
                SDebug.printStackTrace((Throwable)userException);
            }
        }
    }

    public int getEntityIndex() {
        this.entityIndex = this.getHo().getPool().getEntityIndex();
        return this.entityIndex;
    }

    public boolean findStsPath(sStsPathDef sStsPathDef2) {
        sStsPathDef sStsPathDef3 = HoPathDefModelFactory.getStsPathDef(this.getHo());
        if (sStsPathDef3 == null || sStsPathDef2 == null) {
            return false;
        }
        PoolModel poolModel = ((PoolModelsDelegate)this.nmd.getPoolModels()).find(sStsPathDef3.stsPool);
        PoolModel poolModel2 = ((PoolModelsDelegate)this.nmd.getPoolModels()).find(sStsPathDef2.stsPool);
        if (poolModel == null || poolModel2 == null) {
            return false;
        }
        return poolModel.getEntityIndex() == poolModel2.getEntityIndex() && sStsPathDef3.startingSts == sStsPathDef2.startingSts && sStsPathDef3.stsPool.includedPath().startingSts == sStsPathDef2.stsPool.includedPath().startingSts;
    }

    public List getPortModels() {
        block3: {
            try {
                IHoPathDefModel iHoPathDefModel = this.getHo();
                if (iHoPathDefModel != null && iHoPathDefModel.getPool() != null) {
                    return ((PoolModel)iHoPathDefModel.getPool()).getPortModels();
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return new LinkedList();
    }

    public void setAttributes(sVtAditItem sVtAditItem2) {
        this.inUse.setValueExternally(new Boolean(sVtAditItem2.inUse));
        this.sts.setValueExternally(sVtAditItem2.a);
        super.setAttributes(sVtAditItem2);
    }

    private boolean isValidPGEntity(IEntityModel iEntityModel) {
        return iEntityModel instanceof IPortModel && ((IPortModel)iEntityModel).isOptical() || iEntityModel instanceof IModuleModel && ((IModuleModel)iEntityModel).isValidPGElectricalCard();
    }

    public void checkPortGroupState() {
        block13: {
            IHoNum iHoNum;
            this.reservedForPortGroup = false;
            int n = this.getFramingType();
            if (n != 1) {
                return;
            }
            IHoPathDefModel iHoPathDefModel = this.getHo();
            IPoolModel iPoolModel = iHoPathDefModel.getPool();
            IEntityModel iEntityModel = null;
            try {
                iEntityModel = iPoolModel.getEntityModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.severe(abstractCmsNoSuchEntityException.getMessage());
            }
            if (iEntityModel == null) {
                return;
            }
            if (!this.isValidPGEntity(iEntityModel)) {
                return;
            }
            IEntityModel iEntityModel2 = iEntityModel;
            while (!(iEntityModel2 instanceof IModuleModel)) {
                iEntityModel2 = iEntityModel2.getParent();
            }
            IModuleModel iModuleModel = (IModuleModel)iEntityModel2;
            IHoNum iHoNum2 = HoPathDefModel.physicalHo(iHoPathDefModel);
            if (iEntityModel instanceof IModuleModel) {
                iHoNum = iHoNum2;
            } else {
                int s = iPoolModel.getStsCount();
                int unsupportedOperation = iEntityModel.getPositionInParent();
                int n2 = (unsupportedOperation - 1) * s + 1;
                IHoNum iHoNum3 = HoLoFactory.idlSts2HoNum(n, n2);
                iHoNum = HoLoFactory.addOffset(iHoNum3, iHoNum2.getHoNum() - 1);
            }
            short s = iHoNum.getHoNum();
            try {
                this.reservedForPortGroup = iModuleModel.isPortGroupStateClosed(s);
                if (this.db.on()) {
                    this.db.println("reservedForPortGroup: " + this.reservedForPortGroup);
                }
            }
            catch (UnsupportedOperation provisionError) {
                if (this.db.on()) {
                    this.db.fine("UnsupportedOperation: " + provisionError.getMessage());
                }
            }
            catch (ProvisionError provisionError) {
                if (!this.db.on()) break block13;
                this.db.fine("ProvisionError: " + provisionError.getMessage());
            }
        }
    }

    public boolean isReservedForPortGroup() {
        if (!this.reservedForPortGroupChecked) {
            this.checkPortGroupState();
            this.reservedForPortGroupChecked = true;
        }
        return this.reservedForPortGroup;
    }

    protected void printString(SDebug sDebug) {
        super.printString(sDebug);
        IHoPathDefModel iHoPathDefModel = this.getHo();
        PoolModel poolModel = (PoolModel)iHoPathDefModel.getPool();
        IHoNum iHoNum = iHoPathDefModel.getStartingHo();
        sDebug.println("LoAditModel[Pool index=" + Integer.toHexString(poolModel.getIndex()) + " : " + poolModel + "; Port index=" + Integer.toHexString(poolModel.getEntityIndex()) + "/" + Integer.toHexString(poolModel.getProtectEntityIndex()) + "]; HoNum=" + iHoNum);
    }

    private int getFramingType() {
        if (this.getNodeModel().getTdmProtocolTypeObj().isSonet()) {
            return 0;
        }
        return 1;
    }

    public String getConnectionName() {
        if (this.vtAditRef == null) {
            throw new CmsObjectNotExistException("An attempt was made to access a VT adit that has been destroyed.");
        }
        return this.vtAditRef.getConnectionName();
    }

    private class RemoveConnectedPath
    extends NonCachedValue {
        public RemoveConnectedPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            LoAditModel.this.getVtAditRef().removeConnectedPath((sVtDef)objectArray[0]);
            return null;
        }
    }

    private class GetConnectedPaths
    extends NonCachedValue {
        public GetConnectedPaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sVtPathInfo[] sVtPathInfoArray = LoAditModel.this.getVtAditRef().getConnectedPaths();
            return sVtPathInfoArray;
        }
    }

    private class GetAvailableVts
    extends NonCachedValue {
        public GetAvailableVts(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            eVtPathWidth eVtPathWidth2 = (eVtPathWidth)objectArray[0];
            sVtPathInfo[] sVtPathInfoArray = LoAditModel.this.getVtAditRef().getAvailableVts(eVtPathWidth2);
            return sVtPathInfoArray;
        }
    }

    private class Destroy
    extends NonCachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            LoAditModel.this.getVtAditRef().destroy();
            return null;
        }
    }

    private class InUse
    extends CachedValue {
        public InUse(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            boolean bl = LoAditModel.this.getVtAditRef().inUse();
            return new Boolean(bl);
        }

        protected void setValue(Object object) throws UserException {
        }
    }

    private class Sts
    extends CachedValue {
        public Sts(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoPathDefModelFactory.getIHoPathDef(this.node, LoAditModel.this.getVtAditRef().a());
        }

        protected void setValue(Object object) throws UserException {
        }

        public void setValueExternally(Object object) {
            super.setValueExternally(HoPathDefModelFactory.getIHoPathDef(this.node, (sStsPathDef)object));
        }

        protected Object cloneValue() {
            return CloneHelper.clone((IHoPathDefModel)this.value);
        }
    }
}

