/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.OpticsTopology.OchncCircuits;
import cerent.cms.idl.SonetTopology.OchCcConnection;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.sOchCcConnectionItem;
import cerent.cms.idl.SonetTopology.xNoSuchConnection;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.Connections;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OchccConnectionModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class OchccConnections
extends Connections
implements Observer {
    ConnectionModelsDelegate container;
    NodeModelDelegate node;
    GetOchccConnectionsFromPort getOchccConnectionsFromPort;
    GetConnectionObjIndex getConnectionObjIndex;
    GetOchccConnectionsList getOchccConnectionsList;
    GetOchccConnectionIndexes getOchccConnectionIndexes;
    GetOchccConnectionItem getOchccConnectionItem;
    private boolean isInitedRealState;
    private EventDispatcher dispatcher;
    private OchccConnDebug db;
    private static final String MY_DEBUG_KEY = "OchccConnections";

    public OchccConnections(ConnectionModelsDelegate connectionModelsDelegate) {
        this.container = connectionModelsDelegate;
        this.node = connectionModelsDelegate.node;
        this.db = new OchccConnDebug(this.node.db);
        this.getOchccConnectionsFromPort = new GetOchccConnectionsFromPort(this.node, "OchccConnections.GetOchccConnectionsFromPort");
        this.getConnectionObjIndex = new GetConnectionObjIndex(this.node, "OchccConnections.getConnectionObjIndex");
        this.getOchccConnectionsList = new GetOchccConnectionsList(this.node, "OchccConnections.getOchccConnectionsList");
        this.getOchccConnectionIndexes = new GetOchccConnectionIndexes(this.node, "OchccConnections.getOchccConnectionIndexes");
        this.getOchccConnectionItem = new GetOchccConnectionItem(this.node, "OchccConnections.getOchccConnectionItem");
        this.dispatcher = null;
    }

    private SonetFactory getSonetFactoryRef() {
        return this.container.getSonetFactoryRef();
    }

    private OchncCircuits getOchncCircuitsRef() {
        return this.container.getOchncCircuitsRef();
    }

    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectOchCcConnectionList, 0, (Observer)this);
        }
    }

    private synchronized void initReal() {
        this.isInitedRealState = true;
        this.discover(this.connectionModels);
        Iterator iterator = this.connectionModels.values().iterator();
        while (iterator.hasNext()) {
            ((OchccConnectionModel)iterator.next()).init();
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectOchCcConnectionList, 0, (Observer)this);
        }
        this.isInitedRealState = false;
        super.dispose();
    }

    public Collection getConnectionModels() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.connectionModels.values();
    }

    public List getConnectionModels(int n) throws NoSuchConnection, NoSuchEquipment {
        ArrayList<OchccConnectionModel> arrayList = new ArrayList<OchccConnectionModel>();
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            OchCcConnection[] ochCcConnectionArray = new OchCcConnection[]{};
            ochCcConnectionArray = (OchCcConnection[])this.getOchccConnectionsFromPort.get(new Integer(n));
            block4: for (int i = 0; i < ochCcConnectionArray.length; ++i) {
                Iterator iterator = this.connectionModels.values().iterator();
                if (ochCcConnectionArray[i] == null) continue;
                while (iterator.hasNext()) {
                    OchccConnectionModel ochccConnectionModel = (OchccConnectionModel)iterator.next();
                    if (ochccConnectionModel.getObjIndex() != ochCcConnectionArray[i].objIndex()) continue;
                    arrayList.add(ochccConnectionModel);
                    continue block4;
                }
            }
        }
        catch (xNoSuchConnection xNoSuchConnection2) {
            throw new NoSuchConnection((UserException)xNoSuchConnection2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getConnectionModels", userException);
        }
        return arrayList;
    }

    protected boolean updateStructure() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.updateOchccStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OchccConnectionModel add(OchCcConnection ochCcConnection) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        OchccConnectionModel ochccConnectionModel = null;
        if (ochCcConnection == null) {
            return null;
        }
        OchccConnections ochccConnections = this;
        synchronized (ochccConnections) {
            block12: {
                ochccConnectionModel = this.findOchccConnectionModel(ochCcConnection);
                if (ochccConnectionModel == null) {
                    try {
                        Integer n;
                        block11: {
                            ochccConnectionModel = new OchccConnectionModel(this.node, ochCcConnection, (Connections)this);
                            n = new Integer(ochccConnectionModel.getObjIndex());
                            try {
                                ochccConnectionModel.setAttributes(this.getOchccConnectionItem(n));
                            }
                            catch (xNoSuchConnection xNoSuchConnection2) {
                                if (!this.db.on) break block11;
                                this.db.println("Caught noSuchConnection for index " + n);
                                OchccConnDebug.printStackTrace((Throwable)((Object)xNoSuchConnection2));
                            }
                        }
                        ochccConnectionModel.init();
                        this.connectionModels.put(n, ochccConnectionModel);
                        this.setChanged();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (this.db.on()) {
                            this.db.println("Exception in add-OchccConn " + (Object)((Object)abstractCmsIOException));
                            this.printStackTrace((Exception)((Object)abstractCmsIOException));
                        }
                        if (ochccConnectionModel == null) break block12;
                        ochccConnectionModel.dispose();
                        ochccConnectionModel = null;
                    }
                }
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return ochccConnectionModel;
    }

    public synchronized OchccConnectionModel findOchccConnectionModel(sCircuitId sCircuitId2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return (OchccConnectionModel)this.findConnectionModel(this.connectionModels.values(), sCircuitId2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OchccConnectionModel findOchccConnectionModel(OchCcConnection ochCcConnection) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        Object var2_2 = null;
        if (ochCcConnection != null) {
            OchccConnections ochccConnections = this;
            synchronized (ochccConnections) {
                var2_2 = this.connectionModels.get(new Integer(ochCcConnection.objIndex()));
                try {
                    Integer n = (Integer)this.getConnectionObjIndex.get(ochCcConnection);
                    var2_2 = this.connectionModels.get(n);
                }
                catch (UserException userException) {
                    throw NodeModelDelegate.doUnknown(this.db, "findOchccConnectionModel", userException);
                }
            }
        }
        if (var2_2 == null && this.db.on()) {
            this.db.println("Could not find the OchccConnection in the cache ");
        }
        return var2_2;
    }

    private synchronized void discover(Map map) {
        sOchCcConnectionItem[] sOchCcConnectionItemArray = null;
        sOchCcConnectionItemArray = this.getOchccConnectionItems();
        if (sOchCcConnectionItemArray == null) {
            this.db.println("Error in getting OchccConnections (null) OchccConnections::discover");
            return;
        }
        for (int i = 0; i < sOchCcConnectionItemArray.length; ++i) {
            if (sOchCcConnectionItemArray[i] == null) continue;
            Integer n = new Integer(sOchCcConnectionItemArray[i].objIndex);
            map.put(n, new OchccConnectionModel(this.node, sOchCcConnectionItemArray[i], (Connections)this));
        }
    }

    private sOchCcConnectionItem[] getOchccConnectionItems() {
        sOchCcConnectionItem[] sOchCcConnectionItemArray = new sOchCcConnectionItem[]{};
        try {
            sOchCcConnectionItemArray = (sOchCcConnectionItem[])this.getOchccConnectionsList.get();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("Error in getting OchccConnections " + (Object)((Object)abstractCmsIOException));
            OchccConnDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getOchccConnectionItems", userException);
        }
        return sOchCcConnectionItemArray;
    }

    private void discoverOchccConnectionItems(HashMap hashMap) {
        sOchCcConnectionItem[] sOchCcConnectionItemArray = this.getOchccConnectionItems();
        if (sOchCcConnectionItemArray == null) {
            return;
        }
        for (int i = 0; i < sOchCcConnectionItemArray.length; ++i) {
            hashMap.put(new Integer(sOchCcConnectionItemArray[i].objIndex), sOchCcConnectionItemArray[i]);
        }
    }

    private synchronized boolean updateOchccStructure() {
        OchccConnectionModel ochccConnectionModel;
        Object object;
        Object object2;
        Collection collection;
        boolean bl = false;
        if (this.db.on()) {
            this.db.println("Entry:: ConnectionModels::updateOchccStructure()");
        }
        if ((collection = this.getOchccConnectionIndexes()) == null) {
            this.db.println("Cannot get OchccConnections from NE cannot process updateOchccStructure");
            return bl;
        }
        Collection collection2 = OchccConnections.getAddedObjects(collection, this.connectionModels.keySet());
        Iterator iterator = collection2.iterator();
        if (collection2.size() > 0) {
            if (this.db.on()) {
                this.db.println("New OchccConnection found # " + collection2.size());
            }
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                if (this.db.on()) {
                    this.db.println(" Ochcc # " + object2);
                }
                try {
                    object = this.getOchccConnectionItem((Integer)object2);
                }
                catch (xNoSuchConnection xNoSuchConnection2) {
                    if (!this.db.on) continue;
                    this.db.println("Caught NoSuch Connection for Ochcc " + object2);
                    this.db.println("Continuing ...");
                    continue;
                }
                ochccConnectionModel = new OchccConnectionModel(this.node, (sOchCcConnectionItem)object, (Connections)this);
                this.connectionModels.put(object2, ochccConnectionModel);
                ochccConnectionModel.init();
            }
            bl = true;
        }
        if ((object2 = OchccConnections.getDeletedObjects(collection, this.connectionModels.keySet())).size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                if (this.db.on()) {
                    this.db.println("Deleted OchccConnection found # " + object2.size());
                }
                if (this.db.on()) {
                    this.db.println("Deleted OchccConnection index " + object);
                }
                if ((ochccConnectionModel = (OchccConnectionModel)this.connectionModels.get(object)) == null) continue;
                ochccConnectionModel.delete();
            }
        }
        if (this.db.on()) {
            this.db.println("Exit:: ConnectionModels::updateOchccStructure()");
        }
        return bl;
    }

    public void update(Observable observable, Object object) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        int n = ((IObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 1: {
                if (this.db.on) {
                    this.db.println("Got a changed Message for OchccConnection");
                }
                this.container.updateLocal();
                break;
            }
            case 2: {
                if (this.db.on) {
                    this.db.println("Got an update Structure Message");
                }
                if (!this.updateOchccStructure()) break;
                if (this.db.on) {
                    this.db.println("Going to notify about update");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
                break;
            }
            case 0: {
                break;
            }
            default: {
                String string = "Unknown update message (" + n + ") on OchccConnections";
                this.db.println(string);
                OchccConnDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
            }
        }
    }

    private Collection getOchccConnectionIndexes() {
        try {
            return this.toCollection((int[])this.getOchccConnectionIndexes.get());
        }
        catch (UserException userException) {
            OchccConnDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private sOchCcConnectionItem getOchccConnectionItem(Integer n) throws xNoSuchConnection {
        try {
            return (sOchCcConnectionItem)this.getOchccConnectionItem.get(n);
        }
        catch (xNoSuchConnection xNoSuchConnection2) {
            throw xNoSuchConnection2;
        }
        catch (UserException userException) {
            OchccConnDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public class OchccConnDebug
    extends SDebug {
        OchccConnDebug(KDebug kDebug) {
            super(kDebug, OchccConnections.MY_DEBUG_KEY);
        }

        public final void update() throws NoSuchConnection {
            OchccConnections.this.updateOchccStructure();
        }

        public final void printConnections() {
            OchccConnections.this.db.println("Printing List of OCHCC Connections \n");
            OchccConnections.this.printConnectionString(this);
        }
    }

    private class GetConnectionObjIndex
    extends NonCachedValue {
        public GetConnectionObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) {
            int n = ((OchCcConnection)object).objIndex();
            return new Integer(n);
        }
    }

    private class GetOchccConnectionsList
    extends NonCachedValue {
        public GetOchccConnectionsList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            return OchccConnections.this.getSonetFactoryRef().getOchCcConnectionList();
        }
    }

    private class GetOchccConnectionItem
    extends NonCachedValue {
        public GetOchccConnectionItem(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchConnection {
            return OchccConnections.this.getSonetFactoryRef().getOchCcConnectionItem((Integer)object);
        }
    }

    private class GetOchccConnectionIndexes
    extends NonCachedValue {
        public GetOchccConnectionIndexes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            return OchccConnections.this.getSonetFactoryRef().getOchCcConnectionIndexes();
        }
    }

    private class GetOchccConnectionsFromPort
    extends NonCachedValue {
        public GetOchccConnectionsFromPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchConnection, xNoSuchEquipment {
            return OchccConnections.this.getOchncCircuitsRef().getAllOchCcConnectionListFromPort((Integer)object);
        }

        public Object outer() {
            return OchccConnections.this;
        }
    }
}

