/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Optics.OpticalMultiplexSection;
import cerent.cms.idl.Optics.eBand;
import cerent.cms.idl.Optics.sOpticalMultiplexSectionAttributes;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import org.omg.CORBA.UserException;

public class OpticsMultiplexSectionModel
extends AbstractOpticsLineModel {
    private OpticalMultiplexSection opticalMultiplexSection;
    private ActualBand actBand;
    private ExpectedBand expBand;

    protected OpticsMultiplexSectionModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, (sInterface)null);
    }

    public OpticsMultiplexSectionModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2, nodeModelDelegate.getIorRepository().getOpticsMuxRef());
        this.opticalMultiplexSection = nodeModelDelegate.getIorRepository().getOpticsMuxRef();
        this.actBand = new ActualBand(nodeModelDelegate, "ActualBand");
        this.expBand = new ExpectedBand(nodeModelDelegate, "ExpectedBand");
    }

    public void destroy() {
        super.destroy();
    }

    public void dispose() {
        this.actBand.dispose();
        this.expBand.dispose();
        super.dispose();
    }

    protected void updateLocal(long l) {
        this.actBand.update();
        this.expBand.update();
        super.updateLocal(l);
    }

    public void setAttributes(sOpticalMultiplexSectionAttributes sOpticalMultiplexSectionAttributes2, long l) {
        super.setAttributes(sOpticalMultiplexSectionAttributes2.general, l);
        this.expBand.setValueExternally(sOpticalMultiplexSectionAttributes2.expectedBand);
        this.actBand.setValueExternally(sOpticalMultiplexSectionAttributes2.actualBand);
    }

    public eBand getActualBand() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eBand)this.actBand.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GETACTUAL_BAND), userException);
        }
    }

    public eBand getExpectedBand() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eBand)this.expBand.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GETEXPECTED_BAND), userException);
        }
    }

    public void setExpectedBand(eBand eBand2) throws NoSuchInterface, WrongInterfaceType, ConfigError, InternalCommError {
        try {
            this.expBand.set(eBand2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_SETEXPECTED_BAND), userException);
        }
    }

    public String toString() {
        return "OpticsMultiplexSectionModel" + super.toString();
    }

    private class ExpectedBand
    extends CachedValue {
        private ExpectedBand(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OpticsMultiplexSectionModel.this.opticalMultiplexSection.getExpectedBand(OpticsMultiplexSectionModel.this.getIndex());
        }

        protected void setValue(Object object) throws UserException {
            OpticsMultiplexSectionModel.this.opticalMultiplexSection.setExpectedBand(OpticsMultiplexSectionModel.this.getIndex(), (eBand)object);
        }
    }

    private class ActualBand
    extends CachedValue {
        private ActualBand(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OpticsMultiplexSectionModel.this.opticalMultiplexSection.getActualBand(OpticsMultiplexSectionModel.this.getIndex());
        }
    }
}

