/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.SonetMedia.ePathState;
import cerent.cms.idl.SonetMedia.sPathStateInfo;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathStateInfo;
import cerent.cms.model.PathStateInfo;
import cerent.util.HoLoFactory;
import cerent.util.HoLoNum;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import java.util.ArrayList;

public class PathStateInfoFactory {
    private PathStateInfoFactory() {
    }

    public static sPathStateInfo getPathStateInfo(IPathStateInfo iPathStateInfo) {
        if (iPathStateInfo != null) {
            ILoNum iLoNum = iPathStateInfo.getLoNum();
            IHoNum iHoNum = iPathStateInfo.getHoNum();
            short s = 0;
            if (iHoNum != null) {
                s = iHoNum.getIdlHoNum();
            }
            short s2 = 0;
            short s3 = 0;
            if (iLoNum != null) {
                s2 = iLoNum.getIdlGroupNum();
                s3 = iLoNum.getIdlNumInGroup();
            }
            ePathState ePathState2 = ePathState.from_int(iPathStateInfo.getPathState());
            return new sPathStateInfo(s, s2, s3, ePathState2);
        }
        return null;
    }

    public static IHoLoNum getHoLoNum(sPathStateInfo sPathStateInfo2, int n, int n2) {
        IHoNum iHoNum = null;
        try {
            iHoNum = HoLoFactory.idlSts2HoNum(n, sPathStateInfo2.stsNumber);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CircuitSize circuitSize = null;
        if (n2 != CircuitSize.UNDEFINED_SIZE) {
            circuitSize = (CircuitSize)CircuitSize.getCircuitSize((int)n2);
        }
        if (iHoNum != null) {
            ILoNum iLoNum = null;
            if (circuitSize != null && circuitSize.isLo(n)) {
                iLoNum = PathStateInfoFactory.getLoNum(n, n2, sPathStateInfo2.vtGroupNumber, sPathStateInfo2.vtNumber);
            }
            return new HoLoNum(iHoNum, iLoNum);
        }
        return null;
    }

    public static IPathStateInfo getPathStateInfo(sPathStateInfo sPathStateInfo2, int n, int n2) {
        IHoNum iHoNum = null;
        try {
            iHoNum = HoLoFactory.idlSts2HoNum(n, sPathStateInfo2.stsNumber);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CircuitSize circuitSize = null;
        if (n2 != CircuitSize.UNDEFINED_SIZE) {
            circuitSize = (CircuitSize)CircuitSize.getCircuitSize((int)n2);
        }
        if (iHoNum != null) {
            ILoNum iLoNum = null;
            int n3 = sPathStateInfo2.state.value();
            if (circuitSize != null && circuitSize.isLo(n)) {
                iLoNum = PathStateInfoFactory.getLoNum(n, n2, sPathStateInfo2.vtGroupNumber, sPathStateInfo2.vtNumber);
            }
            return new PathStateInfo(iHoNum, iLoNum, n3);
        }
        return null;
    }

    private static ILoNum getLoNum(int n, int n2, int n3, int n4) {
        ILoNum iLoNum = null;
        try {
            iLoNum = HoLoFactory.idlVtStruct2LoNum(n, n2, n3, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return iLoNum;
    }

    public static IPathStateInfo getPathStateInfoFromNum(IHoLoNum iHoLoNum) {
        IHoNum iHoNum = iHoLoNum.getHoNum();
        ILoNum iLoNum = iHoLoNum.getLoNum();
        int n = 1;
        return new PathStateInfo(iHoNum, iLoNum, n);
    }

    public static IPathStateInfo[] getPathStateInfoInfoArray(sPathStateInfo[] sPathStateInfoArray, int n, INodeModel iNodeModel) {
        int n2 = iNodeModel.getTdmProtocolTypeObj().isSonet() ? 0 : 1;
        ArrayList<IPathStateInfo> arrayList = new ArrayList<IPathStateInfo>();
        if (sPathStateInfoArray != null) {
            for (int i = 0; i < sPathStateInfoArray.length; ++i) {
                IPathStateInfo iPathStateInfo = PathStateInfoFactory.getPathStateInfo(sPathStateInfoArray[i], n2, n);
                if (iPathStateInfo == null) continue;
                arrayList.add(iPathStateInfo);
            }
        }
        PathStateInfo[] pathStateInfoArray = arrayList.toArray(new PathStateInfo[0]);
        return pathStateInfoArray;
    }

    public static IHoLoNum[] getHoLoNumArray(sPathStateInfo[] sPathStateInfoArray, int n, INodeModel iNodeModel) {
        int n2 = iNodeModel.getTdmProtocolTypeObj().isSonet() ? 0 : 1;
        ArrayList<IHoLoNum> arrayList = new ArrayList<IHoLoNum>();
        if (sPathStateInfoArray != null) {
            for (int i = 0; i < sPathStateInfoArray.length; ++i) {
                IHoLoNum iHoLoNum = PathStateInfoFactory.getHoLoNum(sPathStateInfoArray[i], n2, n);
                if (iHoLoNum == null) continue;
                arrayList.add(iHoLoNum);
            }
        }
        IHoLoNum[] iHoLoNumArray = arrayList.toArray(new HoLoNum[0]);
        return iHoLoNumArray;
    }

    public static IPathStateInfo[] getPathStateInfoArrayFromNum(IHoLoNum[] iHoLoNumArray, INodeModel iNodeModel) {
        PathStateInfo[] pathStateInfoArray = new PathStateInfo[iHoLoNumArray.length];
        if (iHoLoNumArray != null) {
            for (int i = 0; i < iHoLoNumArray.length; ++i) {
                IPathStateInfo iPathStateInfo = PathStateInfoFactory.getPathStateInfoFromNum(iHoLoNumArray[i]);
                if (iPathStateInfo == null) continue;
                pathStateInfoArray[i] = iPathStateInfo;
            }
        }
        return pathStateInfoArray;
    }

    public static sPathStateInfo[] getPathStateInfoArray(IPathStateInfo[] iPathStateInfoArray, INodeModel iNodeModel) {
        if (iPathStateInfoArray != null) {
            sPathStateInfo[] sPathStateInfoArray = new sPathStateInfo[iPathStateInfoArray.length];
            for (int i = 0; i < iPathStateInfoArray.length; ++i) {
                sPathStateInfoArray[i] = PathStateInfoFactory.getPathStateInfo(iPathStateInfoArray[i]);
            }
            return sPathStateInfoArray;
        }
        return new sPathStateInfo[0];
    }
}

