/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.SonetMedia.Pool;
import cerent.cms.idl.SonetMedia.eVtPathWidth;
import cerent.cms.idl.SonetMedia.sBundleInfo;
import cerent.cms.idl.SonetMedia.sPathInfo;
import cerent.cms.idl.SonetMedia.sPathStateInfo;
import cerent.cms.idl.SonetMedia.sPoolAttributes;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.BundleInfoFactory;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IBundleInfo;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPathStateInfo;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPoolModels;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.LoConnectionModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PathInfoFactory;
import cerent.cms.model.PathStateInfo;
import cerent.cms.model.PathStateInfoFactory;
import cerent.cms.model.PoolModelsDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoNum;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class PoolModel
extends Model
implements IPoolModel {
    private static final short UNIT_HO_WIDTH = 1;
    private static final short STS1_WIDTH = 1;
    private static final short STS3C_WIDTH = 3;
    private static final int[] sts6cRemovals = new int[]{10, 22, 34, 46, 58, 70, 82, 94, 106, 118, 130, 142, 154, 166, 178, 190};
    private static final int[] sts9cRemovals = new int[]{7, 10, 19, 22, 31, 34, 43, 46, 55, 58, 67, 70, 79, 82, 91, 94, 103, 106, 115, 118, 127, 130, 139, 142, 151, 154, 163, 166, 175, 178, 187, 190};
    private static final int[] sts9c192Removals = new int[]{7, 22, 31, 34, 43, 58, 67, 70, 79, 94, 103, 106, 115, 130, 139, 142, 151, 166, 175, 178, 187, 190};
    private static final int[] sts24cRemovals = new int[]{28, 31, 34, 37, 40, 43, 46, 76, 79, 82, 85, 88, 91, 94, 124, 127, 130, 133, 136, 139, 142, 172, 175, 178, 181, 184, 187, 190};
    protected static final Integer[] integerArrayTemplate = new Integer[0];
    protected static final HoLoComparator holoComp = HoLoComparator.instance();
    private ContainerName containerName;
    private Bundle1 bundle1;
    private BundleOnePlusOne bundleOnePlusOne;
    private ObjIndex objIndex = null;
    private ConnectedPaths connectedPaths;
    private BiggestPathAvailable biggestPathAvailable;
    private IncludedPath includedPath;
    private AvailablePaths availablePaths;
    private AvailableVcatPaths availableVcatPaths;
    private AvailableVcatPathsForLO availableVcatPathsForLO;
    private AllStsInfo allStsInfo;
    private AutoSelectStsVcatPaths autoSelectStsVcatPaths;
    private AllVtInfo allVtInfo;
    private AutoSelectVtVcatPaths autoSelectVtVcatPaths;
    private AddConnectedPath addConnectedPath;
    private RemoveConnectedPath removeConnectedPath;
    private NodeModelDelegate node;
    private Pool poolRef;
    private EventDispatcher dispatcher;
    private EntityModel protectEntity = null;
    private ElementModel container = null;
    private ILoAditModel[] aditModels = null;
    private IPathInfo[] availPaths = null;
    private short cachedWidth = (short)-1;
    private List portsList = new LinkedList();
    private boolean isInitedRealState;

    public PoolModel(NodeModelDelegate nodeModelDelegate, sPoolAttributes sPoolAttributes2, ElementModel elementModel) {
        super(nodeModelDelegate.getChildDebug(PoolModel.class));
        this.node = nodeModelDelegate;
        this.poolRef = sPoolAttributes2.poolRef;
        this.setContainer(elementModel);
        this.containerName = new ContainerName(nodeModelDelegate, "PoolModel.containerName");
        this.bundle1 = new Bundle1(nodeModelDelegate, "PoolModel.bundle1");
        this.bundleOnePlusOne = new BundleOnePlusOne(nodeModelDelegate, "PoolModel.bundleOnePlusOne");
        this.connectedPaths = new ConnectedPaths(nodeModelDelegate, "PoolModel.connectedPaths");
        this.biggestPathAvailable = new BiggestPathAvailable(nodeModelDelegate, "PoolModel.biggestPathAvailable");
        this.includedPath = new IncludedPath(nodeModelDelegate, "PoolModel.includedPath");
        this.availablePaths = new AvailablePaths(nodeModelDelegate, "PoolModel.availablePaths");
        this.availableVcatPaths = new AvailableVcatPaths(nodeModelDelegate, "PoolModel.AvailableVcatPaths");
        this.availableVcatPathsForLO = new AvailableVcatPathsForLO(nodeModelDelegate, "PoolModel.AvailableVcatPathsForLO");
        this.allStsInfo = new AllStsInfo(nodeModelDelegate, "PoolModel.AllStsInfo");
        this.autoSelectStsVcatPaths = new AutoSelectStsVcatPaths(nodeModelDelegate, "PoolModel.AutoSelectStsVcatPaths");
        this.allVtInfo = new AllVtInfo(nodeModelDelegate, "PoolModel.AllVtInfo");
        this.autoSelectVtVcatPaths = new AutoSelectVtVcatPaths(nodeModelDelegate, "PoolModel.AutoSelectVtVcatPaths");
        this.addConnectedPath = new AddConnectedPath(nodeModelDelegate, "PoolModel.addConnectedPath");
        this.removeConnectedPath = new RemoveConnectedPath(nodeModelDelegate, "PoolModel.removeConnectedPath");
        this.objIndex = new ObjIndex(nodeModelDelegate, "PoolModel.ObjIndex");
        this.setAttributes(sPoolAttributes2);
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReal() {
        block8: {
            if (this.db.on()) {
                this.db.println("PoolModel::init() Entry");
            }
            this.isInitedRealState = true;
            this.dispatcher = this.node.getDispatcher();
            PoolModel poolModel = this;
            synchronized (poolModel) {
                this.setContainer(null);
                this.aditModels = null;
                this.availPaths = null;
                this.cachedWidth = (short)-1;
            }
            this.index = this.getObjIndex();
            this.init0();
            try {
                if (this.dispatcher != null) {
                    this.dispatcher.addObserver(ObjectType.ObjectSonetPool, this.getObjIndex(), (Observer)this);
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) break block8;
                this.db.println("IO Exception while initializing Pool " + (Object)((Object)abstractCmsIOException));
            }
        }
        if (this.db.on()) {
            this.db.println("PoolModel::init() Exit");
        }
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocal() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.db.on) {
            this.db.println("PoolModel Update Local called:" + Integer.toHexString(this.index));
        }
        PoolModel poolModel = this;
        synchronized (poolModel) {
            this.setContainer(null);
            this.aditModels = null;
            this.availPaths = null;
            this.cachedWidth = (short)-1;
            this.protectEntity = null;
        }
        this.biggestPathAvailable.update();
        this.bundle1.update();
        this.bundleOnePlusOne.update();
        this.connectedPaths.update();
        this.containerName.update();
        this.includedPath.update();
    }

    private ElementModel getContainer() throws AbstractCmsNoSuchElementException {
        if (this.db.on) {
            this.db.println("[" + Integer.toHexString(this.index) + "] calling getContainer");
        }
        if (this.container == null) {
            this.setContainer(this.node.getElementModelsDelegate().getElementModel(this));
            if (this.db.on) {
                this.db.println("found container " + this.container);
            }
        } else if (this.db.on) {
            this.db.println("Using cached container: " + this.container);
        }
        return this.container;
    }

    public Pool getPoolRef() throws CmsObjectNotExistException {
        if (this.poolRef == null) {
            throw new CmsObjectNotExistException("The pool reference is null.");
        }
        return this.poolRef;
    }

    public void setPoolRef(Pool pool) {
        this.poolRef = pool;
    }

    public IBundleInfo bundle1() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            sBundleInfo sBundleInfo2 = (sBundleInfo)this.bundle1.get();
            return BundleInfoFactory.getIBundleInfo(sBundleInfo2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IBundleInfo bundleOnePlusOne() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            sBundleInfo sBundleInfo2 = (sBundleInfo)this.bundleOnePlusOne.get();
            return BundleInfoFactory.getIBundleInfo(sBundleInfo2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IEntityModel getEntityModel() throws AbstractCmsNoSuchEntityException {
        ElementModel elementModel;
        try {
            elementModel = this.getContainer();
            if (elementModel == null) {
                elementModel = this.getContainer();
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            throw new CmsNoSuchEntityException("The entity does not exist because its container could not be found.\n" + abstractCmsNoSuchElementException.toString());
        }
        EntityModel entityModel = elementModel instanceof BlsrModel ? ((BlsrModel)elementModel).getEntityModelForPool(this) : (EntityModel)elementModel.getEntityModel();
        this.updatePortsList(entityModel);
        return entityModel;
    }

    public int getEntityIndex() {
        int n = -1;
        try {
            IEntityModel iEntityModel = this.getEntityModel();
            if (iEntityModel != null) {
                return iEntityModel.getIndex();
            }
            return n;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                this.db.println("Cannot find Entity Index for pool" + this);
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return n;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.db.on) {
                this.db.println("Cannot find Entity Index for pool" + this);
                SDebug.printStackTrace((Throwable)illegalArgumentException);
            }
            return n;
        }
    }

    public IEntityModel getProtectEntity() throws AbstractCmsNoSuchEntityException {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.protectEntity == null && this.bundleOnePlusOne() != null) {
            this.protectEntity = (EntityModel)this.node.getEntityTableModel().getEntityModelByIndex(this.bundleOnePlusOne().getIndex());
        }
        return this.protectEntity;
    }

    public int getProtectEntityIndex() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.bundleOnePlusOne() != null) {
            return this.bundleOnePlusOne().getIndex();
        }
        return -1;
    }

    public boolean containsEntity(int n) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.getEntityIndex() == n || this.getProtectEntityIndex() == n;
    }

    public int getObjIndex() throws AbstractCmsIOException {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            return (Integer)this.objIndex.get();
        }
        catch (UserException userException) {
            this.db.println("user exception in getObjIndex");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    private synchronized void setContainer(ElementModel elementModel) {
        if (this.db.on) {
            this.db.println("[" + Integer.toHexString(this.index) + "] setContainer(" + elementModel + ")");
        }
        if (this.container != null) {
            this.container.deleteObserver(this);
        }
        this.container = elementModel;
        if (this.container != null) {
            this.container.addObserver(this);
        }
    }

    public void setAttributes(sPoolAttributes sPoolAttributes2) {
        this.objIndex.setValueExternally(new Integer(sPoolAttributes2.objIndex));
        if (!this.isInitedRealState) {
            this.initReal();
        }
        this.biggestPathAvailable.setValueExternally(new Short(sPoolAttributes2.biggestPathAvailable));
        this.bundle1.setValueExternally(sPoolAttributes2.bundle1);
        this.bundleOnePlusOne.setValueExternally(sPoolAttributes2.bundleOnePlusOne);
        this.includedPath.setValueExternally(sPoolAttributes2.includedPath);
        this.connectedPaths.setValueExternally(sPoolAttributes2.connectedPaths);
        this.poolRef = sPoolAttributes2.poolRef;
    }

    public IPathInfo[] connectedPaths() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            sPathInfo[] sPathInfoArray = (sPathInfo[])this.connectedPaths.get();
            return PathInfoFactory.getIPathInfoArray(sPathInfoArray, this.getNodeModel());
        }
        catch (UserException userException) {
            return null;
        }
    }

    public IPathStateInfo[] getAllPathStateInfo(int n, int n2) throws ProvisionError {
        sPathStateInfo[] sPathStateInfoArray;
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        if (iCircuitType.isHoVcatCircuitType()) {
            short s = ((CircuitSize)iCircuitSize).size2widthOfHoCircuit();
            int n3 = 4;
            sPathStateInfoArray = this.getAllHoPathStateInfo(s, n3);
        } else {
            short s = ((CircuitSize)iCircuitSize).size2widthOfLoCircuit();
            sPathStateInfoArray = this.getAllLoPathStateInfo(s);
        }
        return PathStateInfoFactory.getPathStateInfoInfoArray(sPathStateInfoArray, n2, this.getNodeModel());
    }

    public sPathStateInfo[] getAllHoPathStateInfo(short s, int n) throws ProvisionError {
        block11: {
            if (!this.isInitedRealState) {
                this.initReal();
            }
            if (this.db.on()) {
                this.db.println("getAllHoInfo; entry");
            }
            try {
                Object[] objectArray = new Object[]{new Short(s), eVtPathWidth.from_int(n)};
                sPathStateInfo[] sPathStateInfoArray = (sPathStateInfo[])this.allStsInfo.get(objectArray);
                if (this.db.on()) {
                    if (sPathStateInfoArray != null) {
                        this.db.println("getAllHoInfo returned paths: " + sPathStateInfoArray.length);
                    } else {
                        this.db.println("getAllHoInfo returned 0 paths ");
                    }
                }
                return sPathStateInfoArray;
            }
            catch (xProvisionError xProvisionError2) {
                throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
            }
            catch (UserException userException) {
                if (this.db.on()) {
                    this.db.println("getAllHoInfo; " + (Object)((Object)userException));
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block11;
                this.db.println("getAllHoInfo; " + exception);
            }
        }
        if (this.db.on()) {
            this.db.println("getAllHoInfo; exit");
        }
        return null;
    }

    public IHoLoNum[] getAutoSelectVcatPaths(int n, int n2, short s, IHoLoNum[] iHoLoNumArray) throws ProvisionError {
        sPathStateInfo[] sPathStateInfoArray;
        IPathStateInfo[] iPathStateInfoArray = PathStateInfoFactory.getPathStateInfoArrayFromNum(iHoLoNumArray, this.getNodeModel());
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        short s2 = 0;
        short s3 = 0;
        if (iCircuitType.isHoVcatCircuitType()) {
            s2 = ((CircuitSize)iCircuitSize).size2widthOfHoCircuit();
            sPathStateInfoArray = this.getAutoSelectHoVcatPaths(s2, s, iPathStateInfoArray);
            if (this.db.on()) {
                this.db.println("stateInfo: " + sPathStateInfoArray.length);
            }
        } else {
            s3 = ((CircuitSize)iCircuitSize).size2widthOfLoCircuit();
            sPathStateInfoArray = this.getAutoSelectLoVcatPaths(s3, s, iPathStateInfoArray);
            if (this.db.on()) {
                this.db.println("stateInfo: " + sPathStateInfoArray.length);
            }
        }
        return PathStateInfoFactory.getHoLoNumArray(sPathStateInfoArray, n2, this.getNodeModel());
    }

    public sPathStateInfo[] getAutoSelectHoVcatPaths(short s, short s2, IPathStateInfo[] iPathStateInfoArray) throws ProvisionError {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.db.on()) {
            this.db.println("getAutoSelect; entry");
        }
        try {
            sPathStateInfo[] sPathStateInfoArray = PathStateInfoFactory.getPathStateInfoArray(iPathStateInfoArray, this.getNodeModel());
            Object[] objectArray = new Object[]{new Short(s), new Short(s2), sPathStateInfoArray};
            sPathStateInfo[] sPathStateInfoArray2 = (sPathStateInfo[])this.autoSelectStsVcatPaths.get(objectArray);
            if (this.db.on()) {
                this.db.println("paths.length: " + sPathStateInfoArray2.length);
            }
            return sPathStateInfoArray2;
        }
        catch (xProvisionError xProvisionError2) {
            this.db.println("getAutoSelect; Provision Error");
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            this.db.println("getAutoSelect; user exception");
            return null;
        }
    }

    public sPathStateInfo[] getAllLoPathStateInfo(int n) throws ProvisionError {
        block11: {
            if (!this.isInitedRealState) {
                this.initReal();
            }
            if (this.db.on()) {
                this.db.println("getAllLoInfo; entry");
            }
            try {
                Object[] objectArray = new Object[]{eVtPathWidth.from_int(n)};
                sPathStateInfo[] sPathStateInfoArray = (sPathStateInfo[])this.allVtInfo.get(objectArray);
                if (this.db.on()) {
                    if (sPathStateInfoArray != null) {
                        this.db.println("getAllVt returned paths: " + sPathStateInfoArray.length);
                    } else {
                        this.db.println("getAllVt returned 0 paths ");
                    }
                }
                return sPathStateInfoArray;
            }
            catch (xProvisionError xProvisionError2) {
                this.db.println("getAllVt threw XProvError ");
                throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
            }
            catch (UserException userException) {
                if (this.db.on()) {
                    this.db.println("getAllLo: " + (Object)((Object)userException));
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block11;
                this.db.println("getAllLo: " + exception);
            }
        }
        if (this.db.on()) {
            this.db.println("getAllLoInfo: exit");
        }
        return null;
    }

    public sPathStateInfo[] getAutoSelectLoVcatPaths(int n, short s, IPathStateInfo[] iPathStateInfoArray) throws ProvisionError {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.db.on()) {
            this.db.println("getAutoSelect; entry");
        }
        try {
            sPathStateInfo[] sPathStateInfoArray;
            Object[] objectArray = new Object[]{eVtPathWidth.from_int(n), new Short(s), sPathStateInfoArray = PathStateInfoFactory.getPathStateInfoArray(iPathStateInfoArray, this.getNodeModel())};
            sPathStateInfo[] sPathStateInfoArray2 = (sPathStateInfo[])this.autoSelectVtVcatPaths.get(objectArray);
            if (this.db.on()) {
                this.db.println("getAutoSelect; paths" + sPathStateInfoArray2.length);
            }
            return sPathStateInfoArray2;
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            this.db.println("getAutoSelect; user exception");
            return null;
        }
    }

    protected List getConnectionsList(IPortModel iPortModel) {
        int n;
        this.db.info("getConns on Port = " + iPortModel);
        if (!this.isInitedRealState) {
            this.initReal();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        IConnectionModels iConnectionModels = this.node.getConnectionModels();
        IHoConnectionModel[] iHoConnectionModelArray = iConnectionModels.getHoConnectionModels();
        int n2 = iHoConnectionModelArray.length;
        for (int i = 0; i < n2; ++i) {
            try {
                IHoPathDefModel[] iHoPathDefModelArray = iHoConnectionModelArray[i].getPaths();
                n = iHoPathDefModelArray.length;
                for (int j = 0; j < n; ++j) {
                    IPoolModel iPoolModel = iHoPathDefModelArray[j].getPool();
                    if (!this.equals(iPoolModel)) continue;
                    hashSet.add(iHoConnectionModelArray[i]);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.db.info("Found " + hashSet.size() + " STS Conns");
        ILoConnectionModel[] iLoConnectionModelArray = iConnectionModels.getLoConnectionModels();
        int n3 = iLoConnectionModelArray.length;
        block10: for (n = 0; n < n3; ++n) {
            if (iPortModel == null) {
                ILoDefModel[] iLoDefModelArray;
                try {
                    iLoDefModelArray = iLoConnectionModelArray[n].getPaths();
                }
                catch (Exception exception) {
                    continue;
                }
                int n4 = iLoDefModelArray.length;
                for (int i = 0; i < n4; ++i) {
                    try {
                        ILoAditModel iLoAditModel = iLoDefModelArray[i].getLoAdit();
                        IHoPathDefModel iHoPathDefModel = iLoAditModel.getHo();
                        IPoolModel iPoolModel = iHoPathDefModel.getPool();
                        if (!this.equals(iPoolModel) && this.getEntityIndex() != iLoDefModelArray[i].getPortIndex()) continue;
                        if (iPortModel == null) {
                            hashSet.add(iLoConnectionModelArray[n]);
                            continue block10;
                        }
                        PortModel portModel = null;
                        try {
                            portModel = (PortModel)this.node.getEntityTableModel().getEntityModelByIndex(iLoDefModelArray[i].getPortIndex());
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            hashSet.add(iLoConnectionModelArray[n]);
                            continue block10;
                        }
                        if (portModel == null) {
                            hashSet.add(iLoConnectionModelArray[n]);
                            continue block10;
                        }
                        if (!iPortModel.getPortNum().equals(portModel.getPortNum())) continue;
                        hashSet.add(iLoConnectionModelArray[n]);
                        continue block10;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                continue;
            }
            List list = ((LoConnectionModel)iLoConnectionModelArray[n]).getPortModels();
            if (!list.contains(iPortModel)) continue;
            this.db.info("VtConn contains actualPort");
            hashSet.add(iLoConnectionModelArray[n]);
        }
        this.db.info("getConnectionsList returned " + hashSet.size());
        return new LinkedList(hashSet);
    }

    protected List getConnectionsList() {
        return this.getConnectionsList(null);
    }

    public short biggestPathAvailable() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            return (Short)this.biggestPathAvailable.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public IPathInfo includedPath() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            sPathInfo sPathInfo2 = (sPathInfo)this.includedPath.get();
            sPathInfo2.startingSts = (short)(sPathInfo2.startingSts + 1);
            return PathInfoFactory.getIPathInfo(sPathInfo2, this.getNodeModel());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public synchronized IPathInfo[] getAvailablePaths(short s) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.db.on) {
            this.db.println("GetAvailablePaths called for width " + s + " for Pool with Index " + Integer.toHexString(this.getEntityIndex()));
        }
        if (s != this.cachedWidth || this.availPaths == null) {
            try {
                sPathInfo[] sPathInfoArray = (sPathInfo[])this.availablePaths.get(new Short(s));
                if (this.db.on) {
                    this.db.println("sPathInfo[] size = " + sPathInfoArray.length);
                }
                this.availPaths = PathInfoFactory.getIPathInfoArray(sPathInfoArray, this.getNodeModel());
                this.cachedWidth = s;
            }
            catch (UserException userException) {
                SDebug.printStackTrace((Throwable)userException);
                this.cachedWidth = (short)-1;
                this.availPaths = null;
            }
            catch (RuntimeException runtimeException) {
                this.cachedWidth = (short)-1;
                this.availPaths = null;
                throw runtimeException;
            }
        }
        return this.availPaths;
    }

    public synchronized IPathInfo[] getAvailableVcatPathsForLO(short s, short s2, short s3) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.db.on) {
            this.db.println("GetAvailableVcatPathsForLO called for width " + s + " and numOfMems " + s2 + " pathWidth " + s3 + " for Pool with Index " + Integer.toHexString(this.getEntityIndex()));
        }
        IPathInfo[] iPathInfoArray = null;
        try {
            Object[] objectArray = new Object[]{new Short(s), new Short(s2), eVtPathWidth.from_int(s3)};
            sPathInfo[] sPathInfoArray = (sPathInfo[])this.availableVcatPathsForLO.get(objectArray);
            if (this.db.on) {
                this.db.println("sPathInfo[] size = " + sPathInfoArray.length);
            }
            iPathInfoArray = PathInfoFactory.getIPathInfoArray(sPathInfoArray, this.getNodeModel());
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        return iPathInfoArray;
    }

    public synchronized IPathInfo[] getAvailableVcatPaths(short s, short s2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.db.on) {
            this.db.println("GetAvailableVcatPaths called for width " + s + " and numOfMems " + s2 + " for Pool with Index " + Integer.toHexString(this.getEntityIndex()));
        }
        IPathInfo[] iPathInfoArray = null;
        try {
            Object[] objectArray = new Object[]{new Short(s), new Short(s2)};
            sPathInfo[] sPathInfoArray = (sPathInfo[])this.availableVcatPaths.get(objectArray);
            if (this.db.on) {
                this.db.println("sPathInfo[] size = " + sPathInfoArray.length);
            }
            iPathInfoArray = PathInfoFactory.getIPathInfoArray(sPathInfoArray, this.getNodeModel());
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        return iPathInfoArray;
    }

    protected ICircuitSize width2Size(int n) {
        ITdmProtocolType iTdmProtocolType = this.getNodeModel().getTdmProtocolTypeObj();
        return CircuitSize.width2sizeOfHoCircuit((int)n, (ITdmProtocolType)iTdmProtocolType);
    }

    public IHoNum getLUBHoSize() {
        throw new DeprecatedMethodCalled("SDH_AU3 deprecated PoolModel.getLUBHoSize()");
    }

    public int getMaxStsSize() {
        throw new DeprecatedMethodCalled("FTG deprecated IPoolModel.getMaxStsSize()");
    }

    public Integer[] getSizeArray() {
        throw new DeprecatedMethodCalled("SDH_AU3 deprecated PoolModel.getSizeArray()");
    }

    public IPathInfo[] getUcpAvailablePaths(short s) {
        throw new DeprecatedMethodCalled("SDH_AU3 deprecated PoolModel.getUcpAvailablePaths(short)");
    }

    public int getStsCount() {
        return this.bundle1().getStsCount();
    }

    public boolean addConnectedPath(short s, short s2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            Object[] objectArray = new Object[]{new Short(s), new Short(s2)};
            return (Boolean)this.addConnectedPath.get(objectArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void removeConnectedPath(short s, short s2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            Object[] objectArray = new Object[]{new Short(s), new Short(s2)};
            this.removeConnectedPath.set(objectArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void update(Observable var1_1, Object var2_2) {
        block16: {
            block17: {
                block15: {
                    if (!this.isInitedRealState) {
                        this.initReal();
                    }
                    var5_3 = null;
                    if (!(var1_1 instanceof ElementModel)) break block15;
                    this.setContainer(null);
                    break block16;
                }
                if (!(var1_1 instanceof CmsObservable)) break block17;
                var3_4 = ((IObjectMessageInfo)var2_2).getUpdateType();
                if (this.db.on()) {
                    this.db.println("PoolModel::update(): Observable = " + var1_1 + ", arg = " + EnumStrings.getStrings(eUpdateType.class)[var3_4]);
                }
                switch (var3_4) {
                    case 1: {
                        try {
                            var6_5 = ((IObjectMessageInfo)var2_2).getIndex() / 256;
                            var5_3 = this.node.getEntityTableModel().getEntityModelByIndex(var6_5);
                            if (var5_3 instanceof PortModel && ((ModuleModel)var5_3.getModuleModel()).isSharedPoolCard()) {
                                if (this.db.on()) {
                                    this.db.println("PoolModel::updateAllPosPorts() called.");
                                }
                                this.updateAllPosPorts(var5_3);
                            }
                        }
                        catch (AbstractCmsNoSuchEntityException var6_6) {
                            if (this.db.on()) {
                                SDebug.printStackTrace((Throwable)var6_6);
                            }
                        }
                        catch (AbstractCmsIOException var6_7) {
                            if (!this.db.on()) ** GOTO lbl31
                            SDebug.printStackTrace((Throwable)var6_7);
                        }
lbl31:
                        // 4 sources

                        this.updateLocal();
                        break;
                    }
                    case 0: {
                        if (this.db.on) {
                            this.db.println("Deleting the Pool from parent's list " + this);
                        }
                        ((PoolModelsDelegate)this.node.getPoolModels()).remove(this);
                        this.dispose();
                        break;
                    }
                    case 2: {
                        this.updateLocal();
                        break;
                    }
                    default: {
                        var4_8 = "Unknown update message (" + var3_4 + ") on a pool";
                        this.db.println(var4_8);
                        SDebug.printStackTrace((Throwable)new IllegalArgumentException(var4_8));
                        break;
                    }
                }
                break block16;
            }
            if (this.db.on()) {
                this.db.println("update(): Unrecognized Observable = " + var1_1 + ", arg = " + var2_2);
            }
        }
    }

    private void updateAllPosPorts(IEntityModel iEntityModel) {
        block5: {
            if (iEntityModel != null) {
                IPoolModels iPoolModels = this.node.getPoolModels();
                try {
                    IModuleModel iModuleModel = iEntityModel.getModuleModel();
                    PortModel portModel2 = null;
                    if (iModuleModel != null) {
                        for (PortModel portModel2 : ((ModuleModel)iModuleModel).getPortModels()) {
                            int n;
                            PoolModel poolModel;
                            if (portModel2 == null || (poolModel = (PoolModel)iPoolModels.getPoolModel(n = portModel2.getEntityIndex())) == null) continue;
                            poolModel.updateLocal();
                        }
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.db.on()) break block5;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
    }

    public synchronized ILoAditModel[] getLoAdits() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        if (this.aditModels == null) {
            this.aditModels = ((ConnectionModelsDelegate)this.node.getConnectionModels()).loAdits.getAditsInPool(this);
        }
        if (this.aditModels != null) {
            if (this.db.on()) {
                this.db.println("getLoAdits(): Returning " + this.aditModels.length + " LoAdits for Pool:" + Integer.toHexString(this.index));
            }
        } else if (this.db.on()) {
            this.db.println("getLoAdits(): Returning  NULL  LoAdits for Pool:" + Integer.toHexString(this.index));
        }
        return this.aditModels;
    }

    public void dispose() {
        block5: {
            if (this.db.on()) {
                this.db.println("dispose(): entered");
            }
            if (this.dispatcher != null) {
                try {
                    this.dispatcher.deleteObserver(ObjectType.ObjectSonetPool, this.getObjIndex(), (Observer)this);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.db.on()) break block5;
                    this.db.println("Exception in disposing of Pool " + (Object)((Object)abstractCmsIOException));
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
        this.containerName.dispose();
        this.bundle1.dispose();
        this.bundleOnePlusOne.dispose();
        this.connectedPaths.dispose();
        this.biggestPathAvailable.dispose();
        this.includedPath.dispose();
        this.aditModels = null;
        this.availPaths = null;
        this.cachedWidth = (short)-1;
        this.isInitedRealState = false;
        super.dispose();
        if (this.db.on()) {
            this.db.println("dispose(): exited");
        }
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(): entered");
        }
        super.destroy();
        this.poolRef = null;
        if (this.db.on()) {
            this.db.println("destroy(): exited");
        }
    }

    public boolean isSharedPool(IPoolModel iPoolModel) {
        return !this.equals(iPoolModel) && ((PoolModel)iPoolModel).bundle1().getIndex() == this.bundle1().getIndex() && ((PoolModel)iPoolModel).includedPath().getStartingIdlHo() == this.includedPath().getStartingIdlHo();
    }

    public PoolModel getSharedPool() {
        for (PoolModel poolModel : ((PoolModelsDelegate)this.node.getPoolModels()).getPoolModels()) {
            if (!this.isSharedPool(poolModel)) continue;
            if (this.db.on()) {
                this.db.println("getSharedPool(): Returning Shared Pool:" + Integer.toHexString(poolModel.getIndex()) + " for Original Pool:" + Integer.toHexString(this.index));
            }
            return poolModel;
        }
        if (this.db.on()) {
            this.db.println("getSharedPool(): Found no shared pool for Pool:" + Integer.toHexString(this.index));
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof PoolModel) {
            PoolModel poolModel = (PoolModel)object;
            return poolModel.getObjIndex() == this.getObjIndex();
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        block3: {
            try {
                if (this.container != null) {
                    return "Pool[" + this.container.getName() + "]" + "Entity " + Integer.toHexString(this.getEntityIndex());
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return "Pool[deleted/inaccessible]:" + Integer.toHexString(this.index);
    }

    public List getPortModels() throws AbstractCmsNoSuchEntityException {
        this.getEntityModel();
        return this.portsList;
    }

    private void updatePortsList(EntityModel entityModel) {
        EntityModel entityModel2 = entityModel;
        if (entityModel2 == null) {
            return;
        }
        boolean bl = false;
        this.portsList = new LinkedList();
        if (entityModel2 instanceof IPortModel) {
            boolean bl2 = bl = entityModel2.getEqType() == 34;
            if (bl) {
                entityModel2 = entityModel2.getModuleModel();
            } else {
                this.portsList.add(entityModel2);
            }
        }
        if (entityModel2 instanceof IModuleModel) {
            if (bl) {
                int n;
                List list = entityModel2.getDescendantsOfEqType(34);
                int n2 = list.indexOf(entityModel);
                if (list.size() > n && n2 != -1) {
                    ListIterator listIterator = list.listIterator(n2);
                    for (n = 28; listIterator.hasNext() && n > 0; --n) {
                        this.portsList.add(listIterator.next());
                    }
                } else {
                    this.portsList.addAll(list);
                }
            } else {
                this.portsList.addAll(entityModel2.getDescendantsOfClassType(7));
            }
        }
    }

    public final void dumpAllSts(short s, int n, int n2) {
        try {
            IPathStateInfo[] iPathStateInfoArray = this.getAllPathStateInfo(n2, s);
            if (iPathStateInfoArray != null) {
                this.db.println("States: " + iPathStateInfoArray.length);
                for (int i = 0; i < iPathStateInfoArray.length; ++i) {
                    PathStateInfo pathStateInfo = (PathStateInfo)iPathStateInfoArray[i];
                    IHoNum iHoNum = pathStateInfo.getHoNum();
                    ILoNum iLoNum = pathStateInfo.getLoNum();
                    this.db.println("Ho Num: " + pathStateInfo.getHoNum() + " LoGroupNum: " + pathStateInfo.getLoNum() + "State: " + pathStateInfo.getPathStateString());
                }
            }
        }
        catch (ProvisionError provisionError) {
            this.db.println(" dumpAllSts caught provisionError");
        }
    }

    public final void dumpAutoSelectStsVcatPath(int n, short s, int n2) {
        try {
            IHoLoNum[] iHoLoNumArray = new IHoLoNum[]{new HoLoNum(null, null)};
            this.db.println("Ho Num: " + n + "Mems: " + s);
            IHoLoNum[] iHoLoNumArray2 = this.getAutoSelectVcatPaths(n2, n, s, iHoLoNumArray);
            if (iHoLoNumArray2 != null) {
                this.db.println("States: " + iHoLoNumArray2.length);
                for (int i = 0; i < iHoLoNumArray2.length; ++i) {
                    HoLoNum hoLoNum = (HoLoNum)iHoLoNumArray2[i];
                    this.db.println("Ho Num: " + hoLoNum.getHoNum() + " LoNum: " + hoLoNum.getLoNum());
                }
            }
        }
        catch (ProvisionError provisionError) {
            this.db.println(" dumpAllSts caught provisionError");
        }
    }

    public final void dumpAllVts(int n, int n2) {
        try {
            IPathStateInfo[] iPathStateInfoArray = this.getAllPathStateInfo(n2, n);
            this.db.println("States: " + iPathStateInfoArray.length);
            if (iPathStateInfoArray != null) {
                for (int i = 0; i < iPathStateInfoArray.length; ++i) {
                    PathStateInfo pathStateInfo = (PathStateInfo)iPathStateInfoArray[i];
                    this.db.println("Ho Num: " + pathStateInfo.getHoNum() + " LoNum: " + pathStateInfo.getLoNum() + " State: " + pathStateInfo.getPathStateString());
                }
            }
        }
        catch (ProvisionError provisionError) {
            this.db.println(" dumpAllSts caught provisionError");
        }
    }

    public final void dumpAutoSelectVtVcatPath(int n, short s, int n2) {
        try {
            IHoLoNum[] iHoLoNumArray = new IHoLoNum[]{new HoLoNum(null, null)};
            this.db.println("Vt Num: " + n + "Mems: " + s);
            IHoLoNum[] iHoLoNumArray2 = this.getAutoSelectVcatPaths(n2, n, s, iHoLoNumArray);
            if (iHoLoNumArray2 != null) {
                this.db.println("dumpAutoSelectVtVcatPath returned " + iHoLoNumArray2.length);
                for (int i = 0; i < iHoLoNumArray2.length; ++i) {
                    HoLoNum hoLoNum = (HoLoNum)iHoLoNumArray2[i];
                    this.db.println("Ho Num: " + hoLoNum.getHoNum() + " LoNum: " + hoLoNum.getLoNum());
                }
            }
        }
        catch (ProvisionError provisionError) {
            this.db.println(" dumpAllSts caught provisionError");
        }
    }

    class RemoveConnectedPath
    extends NonCachedValue {
        public RemoveConnectedPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            PoolModel.this.getPoolRef().removeConnectedPath((Short)objectArray[0], (Short)objectArray[1]);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AddConnectedPath
    extends NonCachedValue {
        public AddConnectedPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return null;
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AvailableVcatPathsForLO
    extends NonCachedValue {
        public AvailableVcatPathsForLO(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return PoolModel.this.getPoolRef().getAvailableVcatPathsForLO((Short)objectArray[0], (Short)objectArray[1], (eVtPathWidth)objectArray[2]);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AvailableVcatPaths
    extends NonCachedValue {
        public AvailableVcatPaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return PoolModel.this.getPoolRef().getAvailableVcatPaths((Short)objectArray[0], (Short)objectArray[1]);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AutoSelectVtVcatPaths
    extends NonCachedValue {
        public AutoSelectVtVcatPaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xProvisionError, UserException {
            Object[] objectArray = (Object[])object;
            sPathStateInfo[] sPathStateInfoArray = (sPathStateInfo[])objectArray[2];
            return PoolModel.this.getPoolRef().getAutoSelectVtPaths((eVtPathWidth)objectArray[0], (Short)objectArray[1], sPathStateInfoArray);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AllVtInfo
    extends NonCachedValue {
        public AllVtInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xProvisionError, UserException {
            Object[] objectArray = (Object[])object;
            return PoolModel.this.getPoolRef().getAllVtInfoList((eVtPathWidth)objectArray[0]);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AutoSelectStsVcatPaths
    extends NonCachedValue {
        public AutoSelectStsVcatPaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xProvisionError, UserException {
            Object[] objectArray = (Object[])object;
            sPathStateInfo[] sPathStateInfoArray = (sPathStateInfo[])objectArray[2];
            return PoolModel.this.getPoolRef().getAutoSelectStsPaths((Short)objectArray[0], (Short)objectArray[1], sPathStateInfoArray);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AllStsInfo
    extends NonCachedValue {
        public AllStsInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xProvisionError, UserException {
            Object[] objectArray = (Object[])object;
            return PoolModel.this.getPoolRef().getAllStsInfoList((Short)objectArray[0], (eVtPathWidth)objectArray[1]);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class AvailablePaths
    extends NonCachedValue {
        public AvailablePaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return PoolModel.this.getPoolRef().getAvailablePaths((Short)object);
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class IncludedPath
    extends CachedValue {
        public IncludedPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return PoolModel.this.getPoolRef().includedPath();
        }

        protected Object cloneValue() {
            sPathInfo sPathInfo2 = (sPathInfo)this.value;
            sPathInfo sPathInfo3 = new sPathInfo(sPathInfo2.pathWidth, sPathInfo2.startingSts);
            return sPathInfo3;
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class BiggestPathAvailable
    extends CachedValue {
        public BiggestPathAvailable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return new Short(PoolModel.this.getPoolRef().biggestPathAvailable());
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class ConnectedPaths
    extends CachedValue {
        public ConnectedPaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return PoolModel.this.getPoolRef().connectedPaths();
        }

        protected Object cloneValue() {
            sPathInfo[] sPathInfoArray = (sPathInfo[])this.value;
            sPathInfo[] sPathInfoArray2 = new sPathInfo[sPathInfoArray.length];
            for (int i = 0; i < sPathInfoArray.length; ++i) {
                sPathInfoArray2[i] = new sPathInfo(sPathInfoArray[i].pathWidth, sPathInfoArray[i].startingSts);
            }
            return sPathInfoArray2;
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class BundleOnePlusOne
    extends CachedValue {
        public BundleOnePlusOne(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return PoolModel.this.getPoolRef().bundleOnePlusOne();
        }

        protected Object cloneValue() {
            sBundleInfo sBundleInfo2 = (sBundleInfo)this.value;
            sBundleInfo sBundleInfo3 = new sBundleInfo(sBundleInfo2.index, sBundleInfo2.stsCount, sBundleInfo2.bundleType);
            return sBundleInfo3;
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class Bundle1
    extends CachedValue {
        public Bundle1(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return PoolModel.this.getPoolRef().bundle1();
        }

        protected Object cloneValue() {
            sBundleInfo sBundleInfo2 = (sBundleInfo)this.value;
            sBundleInfo sBundleInfo3 = new sBundleInfo(sBundleInfo2.index, sBundleInfo2.stsCount, sBundleInfo2.bundleType);
            return sBundleInfo3;
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class ObjIndex
    extends CachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return new Integer(PoolModel.this.getPoolRef().objIndex());
        }

        protected Object cloneValue() {
            return CloneHelper.clone((Integer)this.value);
        }

        public void update() {
        }

        public void dispose() {
        }

        public Object outer() {
            return PoolModel.this;
        }
    }

    class ContainerName
    extends CachedValue {
        public ContainerName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return PoolModel.this.getPoolRef().containerName();
        }

        public Object outer() {
            return PoolModel.this;
        }
    }
}

