/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.OpticsTopology.sSpanLossInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ISpanCheckModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RamanModel;
import cerent.cms.model.RamanModuleModel;
import cerent.cms.model.RamanOpticsLineModel;
import cerent.cms.model.SpanCheckModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.DwdmSide;
import cerent.util.SDebug;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class RamanSpanCheckModel
extends SpanCheckModel
implements ISpanCheckModel {
    private static final String LATEST = "Last Span Measure with Raman OFF";
    private static final String INSTALLATION = "Wizard Span Measure with Raman Off";
    public static final int FC_INDEX = 32768;
    public static final int WZ_INDEX = 16384;
    private ISideModel sideModel;
    String sideValue;
    String spanLoss;
    String calcType;
    private ISpanCheckModel spanCheckModel;

    RamanSpanCheckModel(NodeModelDelegate nodeModelDelegate, sSpanLossInfo sSpanLossInfo2, ISideModel iSideModel) {
        super(nodeModelDelegate);
        this.sideModel = iSideModel;
        this.nmd = nodeModelDelegate;
        this.sideValue = "N/A";
        this.spanLoss = "N/A";
        this.calcType = "N/A";
        this.index = this.sideModel.getId();
        ISpanCheckModel[] iSpanCheckModelArray = nodeModelDelegate.getSpanCheckModels().getSpanCheckModel();
        for (int i = 0; i < iSpanCheckModelArray.length; ++i) {
            if (iSpanCheckModelArray[i] instanceof RamanSpanCheckModel || iSpanCheckModelArray[i].getIndex() != this.index) continue;
            iSpanCheckModelArray[i].addObserver(this);
        }
    }

    public void init(ISpanCheckModel iSpanCheckModel, boolean bl) {
        this.dispatcher = this.nmd.getDispatcher();
        this.spanCheckModel = iSpanCheckModel;
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSpanCheck, this.index, (Observer)this);
        }
        EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
        try {
            IEntityModel iEntityModel = entityTableModel.getEntityModelByIndex(this.sideModel.getLineIn()).getParent();
            if (iEntityModel instanceof RamanModuleModel) {
                RamanModuleModel ramanModuleModel = (RamanModuleModel)iEntityModel;
                RamanOpticsLineModel ramanOpticsLineModel = (RamanOpticsLineModel)ramanModuleModel.getOpticsRamanLineModels(true)[0];
                if (bl) {
                    this.addFCValues(ramanOpticsLineModel);
                } else {
                    this.addDay0Values((RamanModel)this.nmd.getRamanModels(), ramanOpticsLineModel);
                }
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        catch (InternalCommError internalCommError) {
            SDebug.printStackTrace((Throwable)internalCommError);
        }
        super.init0();
    }

    public String getMinExpectedSpanLoss() {
        if (this.spanCheckModel == null) {
            return "N/A";
        }
        return this.spanCheckModel.getMinExpectedSpanLoss();
    }

    public String getMaxExpectedSpanLoss() {
        if (this.spanCheckModel == null) {
            return "N/A";
        }
        return this.spanCheckModel.getMaxExpectedSpanLoss();
    }

    public String getSide() {
        return this.sideValue;
    }

    public String getMeasuredSpanLoss() {
        return this.spanLoss;
    }

    public String getCalcType() {
        return this.calcType;
    }

    public String getResolution() {
        if (this.spanCheckModel == null) {
            return "N/A";
        }
        return this.spanCheckModel.getResolution();
    }

    private void addFCValues(RamanOpticsLineModel ramanOpticsLineModel) throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException, InternalCommError {
        this.spanLoss = ramanOpticsLineModel.getFCspanLoss();
        this.sideValue = DwdmSide.getSideLabelFromOffset(ramanOpticsLineModel.getSide());
        this.calcType = LATEST;
        this.index += 32768;
    }

    private void addDay0Values(RamanModel ramanModel, RamanOpticsLineModel ramanOpticsLineModel) throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported, UserException {
        this.spanLoss = ramanModel.getSpanLoss(ramanOpticsLineModel.getIndex());
        this.sideValue = DwdmSide.getSideLabelFromOffset(ramanOpticsLineModel.getSide());
        this.calcType = INSTALLATION;
        this.index += 16384;
    }

    public static boolean hasFC(RamanOpticsLineModel ramanOpticsLineModel) {
        try {
            String string = ramanOpticsLineModel.getFCResult();
            return string.compareTo("Executed") == 0;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            return false;
        }
        catch (FeatureUnsupported featureUnsupported) {
            return false;
        }
        catch (NoSuchInterface noSuchInterface) {
            return false;
        }
        catch (UserException userException) {
            return false;
        }
    }

    public int getSideId() {
        return this.sideModel.getId();
    }

    public void calculateSpanLoss() throws CannotPerform {
    }

    public boolean isCalcSuccessful() {
        return true;
    }
}

