/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.Roll;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.xConnectionInRoll;
import cerent.cms.idl.SonetTopology.xNoRollCondition;
import cerent.cms.idl.SonetTopology.xNoRollValidSignal;
import cerent.cms.idl.SonetTopology.xRollNotConnected;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.InvalidRollMode;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoRollCondition;
import cerent.cms.model.NoRollValidSignal;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.RollNotConnected;
import cerent.cms.model.Rolls;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public abstract class RollModel
extends Model
implements IRollModel {
    protected NodeModelDelegate node;
    protected int connectionIndex;
    protected Rolls container;
    protected RollComplete rollComplete;
    protected RollCancel rollCancel;
    protected RollDestroy rollDestroy;
    protected RollAcknowledge rollAcknowledge;
    private EventDispatcher dispatcher;

    public abstract ObjectType getObjectType();

    public abstract int getRollMode();

    public abstract int getConnectionIndex();

    protected abstract Roll getRollReference();

    public RollModel(NodeModelDelegate nodeModelDelegate, Rolls rolls, SDebug sDebug) {
        super(sDebug);
        this.node = nodeModelDelegate;
        this.container = rolls;
        this.rollComplete = new RollComplete(nodeModelDelegate, "RollModel::rollComplete");
        this.rollDestroy = new RollDestroy(nodeModelDelegate, "RollModel::rollDestroy");
        this.rollCancel = new RollCancel(nodeModelDelegate, "RollModel::rollCancel");
        this.rollAcknowledge = new RollAcknowledge(nodeModelDelegate, "RollModel::rollAcknowledge");
        this.dispatcher = null;
    }

    public SonetFactory getSonetFactoryRef() {
        return this.node.getIorRepository().getSonetFactoryRef();
    }

    public void rollComplete() throws InvalidRollMode, NoRollValidSignal, RollNotConnected, NoRollCondition {
        block8: {
            try {
                this.rollComplete.set();
            }
            catch (xNoRollCondition xNoRollCondition2) {
                if (this.db.on()) {
                    this.db.println("RollModel.rollComplete(): caught NoRollCondition Exception");
                    SDebug.printStackTrace((Throwable)((Object)xNoRollCondition2));
                }
                throw new NoRollCondition((UserException)xNoRollCondition2);
            }
            catch (xNoRollValidSignal xNoRollValidSignal2) {
                if (this.db.on()) {
                    this.db.println("RollModel.rollComplete(): caught No Roll Valid Signal Exception");
                    SDebug.printStackTrace((Throwable)((Object)xNoRollValidSignal2));
                }
                throw new NoRollValidSignal((UserException)xNoRollValidSignal2);
            }
            catch (xRollNotConnected xRollNotConnected2) {
                if (this.db.on()) {
                    this.db.println("RollModel.rollComplete(): roll not connected");
                    SDebug.printStackTrace((Throwable)((Object)xRollNotConnected2));
                }
                throw new RollNotConnected((UserException)xRollNotConnected2);
            }
            catch (UserException userException) {
                if (!this.db.on()) break block8;
                this.db.println("RollModel.rollComplete(): caught CORBA UserException");
                SDebug.printStackTrace((Throwable)userException);
            }
        }
    }

    public void rollCancel() throws RollNotConnected {
        block4: {
            try {
                this.rollCancel.set();
            }
            catch (xRollNotConnected xRollNotConnected2) {
                if (this.db.on()) {
                    this.db.println("RollModel.rollCancel(): roll is not connected");
                    SDebug.printStackTrace((Throwable)((Object)xRollNotConnected2));
                }
                throw new RollNotConnected((UserException)xRollNotConnected2);
            }
            catch (UserException userException) {
                if (!this.db.on()) break block4;
                this.db.println("RollModel.rollCancel(): caught CORBA UserException");
                SDebug.printStackTrace((Throwable)userException);
            }
        }
    }

    public boolean acknowledgeRoll() {
        try {
            return (Boolean)this.rollAcknowledge.get();
        }
        catch (UserException userException) {
            if (this.db.on()) {
                this.db.println("RollModel.acknowledgeRoll(): caught CORBA UserException");
                SDebug.printStackTrace((Throwable)userException);
            }
            return false;
        }
    }

    public void rollDestroy() throws ConnectionInRoll {
        block5: {
            try {
                this.rollDestroy.set();
            }
            catch (xConnectionInRoll xConnectionInRoll2) {
                if (this.db.on()) {
                    this.db.println("RollModel.rollDestroy(): caught xConnectionInRoll Exception");
                    SDebug.printStackTrace((Throwable)((Object)xConnectionInRoll2));
                }
                throw new ConnectionInRoll((UserException)xConnectionInRoll2);
            }
            catch (xRollNotConnected xRollNotConnected2) {
                SDebug.printStackTrace((Throwable)((Object)xRollNotConnected2));
            }
            catch (UserException userException) {
                if (!this.db.on()) break block5;
                this.db.println("RollModel.rollDestroy(): caught CORBA UserException");
                SDebug.printStackTrace((Throwable)userException);
            }
        }
    }

    protected void updateLocal() {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public void init() {
        super.init0();
        if (this.db.on) {
            this.db.println("Adding observer for " + this);
        }
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(this.getObjectType(), this.getIndex(), (Observer)this);
        }
    }

    public void dispose() {
        if (this.db.on) {
            this.db.println("Dispose called ");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(this.getObjectType(), this.getIndex(), (Observer)this);
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public int getIndex() {
        return this.getConnectionIndex();
    }

    public Rolls getContainer() {
        return this.container;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + "::update():    this DELETED");
                    }
                    this.delete();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("Connection Model update():    this CHANGED");
                    }
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (!this.db.on()) break;
                    this.db.println("RollModel update():    STRUCTURE CHANGED");
                    break;
                }
                default: {
                    if (!this.db.on()) break;
                    this.db.println("RollModel update():    UNKNOWN NE UPDATE TYPE" + n);
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof RollModel) {
            RollModel rollModel = (RollModel)object;
            return rollModel.getObjectType() == this.getObjectType() && rollModel.getIndex() == this.getIndex() && rollModel.getNodeModel().getNodeId() == this.getNodeModel().getNodeId();
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.getObjectType().value();
        n = 37 * n + this.getIndex();
        return n;
    }

    protected void delete() {
        this.container.delete(this);
        this.dispose();
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    protected class RollDestroy
    extends NonCachedValue {
        public RollDestroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            RollModel.this.getRollReference().destroyRoll();
        }
    }

    private class RollAcknowledge
    extends CachedValue {
        public RollAcknowledge(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(RollModel.this.getRollReference().setRollControlled());
        }

        protected void setValue(Object object) throws UserException {
        }
    }

    protected class RollCancel
    extends NonCachedValue {
        public RollCancel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            RollModel.this.getRollReference().rollCancel();
        }
    }

    protected class RollComplete
    extends NonCachedValue {
        public RollComplete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            RollModel.this.getRollReference().rollComplete();
        }
    }
}

