/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.eGccRate;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IDccConnectionTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchTerm;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhTermModel;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Observer;

public class SdccTermConnectionModel
extends AbstractTermConnectionModel
implements IDccConnectionTableModel {
    private static final OhChannelType DCC_TERM_CHANNEL = OhChannelType.SDCC_OBJ;
    private static final OhChannelType SDCC_IPTUNNEL_CHANNEL = OhChannelType.SDCC_IPTUNNEL_OBJ;
    private static NodeSingletonFactory<SdccTermConnectionModel> sfactory = new NodeSingletonFactory<SdccTermConnectionModel>(SdccTermConnectionModel.class);

    public static SdccTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private SdccTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        SdccTermConnectionModel sdccTermConnectionModel = (SdccTermConnectionModel)nodeModelDelegate.getDccTermConnectionModel();
        sdccTermConnectionModel.init();
    }

    public void addSdccObserver(int n, Observer observer) throws NoSuchTerm {
        this.addTermObserver(n, observer);
    }

    public void deleteSdccObserver(int n, Observer observer) {
        this.deleteTermObserver(n, observer);
    }

    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return this.getTermModel(iEntityModel.getIndex()) != null;
    }

    public IEntityModel[] getTermCandidates() {
        Object object;
        Object object2;
        HashSet<EntityModel> hashSet = new HashSet<EntityModel>();
        ElementModelsDelegate elementModelsDelegate = this.nmd.getElementModelsDelegate();
        OhConnectionModelsDelegate ohConnectionModelsDelegate = (OhConnectionModelsDelegate)this.nmd.getOhConnectionModels();
        if (this.nmd.getTdmProtocolTypeObj().isSonet()) {
            object2 = elementModelsDelegate.getNonProtectOpticalEntities();
            object = object2.iterator();
            while (object.hasNext()) {
                try {
                    EntityModel entityModel = (EntityModel)object.next();
                    if (entityModel.getMediumType() != 1) continue;
                    if (this.db.on()) {
                        this.db.println("Found a Sonet port " + entityModel + " adding ...");
                    }
                    hashSet.add(entityModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        } else {
            hashSet.addAll(elementModelsDelegate.getNonProtectOpticalEntities());
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (IPortModel)object2.next();
            if (object.getModuleModel().getEqType() != 273 || object.getPortNum()[0] != 17) continue;
            object2.remove();
        }
        hashSet.removeAll(ohConnectionModelsDelegate.getUsedOpticalPorts(DCC_TERM_CHANNEL));
        hashSet.removeAll(ohConnectionModelsDelegate.getUsedOpticalPorts(SDCC_IPTUNNEL_CHANNEL));
        hashSet.removeAll(this.dwdmNotAllowedPorts(hashSet, 0));
        object = this.excludeUcpTerms(hashSet);
        return object.toArray(new IEntityModel[0]);
    }

    protected String getTypeName() {
        return this.nmd.getTDMTerminology().getGeneralTerms(8);
    }

    public OhChannelType getChannelType(eGccRate eGccRate2) {
        return DCC_TERM_CHANNEL;
    }

    protected boolean termQualifies(OhTermModel ohTermModel) {
        return ohTermModel.getChannelType() == 0 && !this.isGccTerm(ohTermModel) && !this.isOscTerm(ohTermModel);
    }
}

